/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.FontResources;
import com.izforge.izpack.gui.GridBagConstraintsFactory;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.gui.UiResources;
import com.izforge.izpack.gui.patternfly.PatternflyProgressBarUI;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class InstallPanel
extends IzPanel
implements AbstractUIProgressHandler {
    private static final long serialVersionUID = 3257282547959410992L;
    protected JLabel packOpLabel;
    protected String packOpLabelPrefix;
    protected JLabel overallOpLabel;
    protected String iconName = "preferences";
    protected JProgressBar packProgressBar;
    protected List<PackProgressPanel> packProgressPanels;
    private int curPackNo = 0;
    private boolean useMultiProgress;
    protected JProgressBar overallProgressBar;
    private volatile boolean validated = false;
    private int noOfPacks = 0;

    public InstallPanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata, new GridBagLayout());
        this.add((Component)this.createTitle(), GridBagConstraintsFactory.getTitleConstraints());
        GridBagConstraints frameConstraints = GridBagConstraintsFactory.getBasicConstraints();
        frameConstraints.gridy = 1;
        frameConstraints.fill = 2;
        this.add((Component)this.createInstallingPanel(), frameConstraints);
        ++frameConstraints.gridy;
        boolean bl = this.useMultiProgress = idata.guiPrefs.modifier.containsKey("useMultiProgressBar") && "yes".equals(idata.guiPrefs.modifier.get("useMultiProgressBar"));
        if (this.useMultiProgress) {
            this.add((Component)this.createMultiProgressBarPanel(), frameConstraints);
        } else {
            this.add((Component)this.createProgressBarPanel(), frameConstraints);
        }
        ++frameConstraints.gridy;
        frameConstraints.weighty = 1.0;
        frameConstraints.weightx = 1.0;
        frameConstraints.fill = 1;
        this.add(Box.createGlue(), frameConstraints);
    }

    private JPanel createProgressBarPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = GridBagConstraintsFactory.getBasicNoInsetsConstraints();
        constraints.fill = 2;
        this.packProgressBar = new JProgressBar();
        this.packProgressBar.setStringPainted(true);
        this.packProgressBar.setString(this.parent.langpack.getString("InstallPanel.begin"));
        this.packProgressBar.setValue(0);
        panel.add((Component)this.packProgressBar, constraints);
        panel.add(IzPanelLayout.createVerticalStrut(5));
        this.overallOpLabel = LabelFactory.create(this.parent.langpack.getString("InstallPanel.progress"), this.parent.icons.getImageIcon(this.iconName), 10);
        ++constraints.gridy;
        panel.add((Component)this.overallOpLabel, constraints);
        this.overallProgressBar = new JProgressBar();
        this.overallProgressBar.setStringPainted(true);
        if (this.noOfPacks == 1) {
            this.overallProgressBar.setIndeterminate(true);
        }
        this.overallProgressBar.setString("");
        this.overallProgressBar.setValue(0);
        ++constraints.gridy;
        panel.add((Component)this.overallProgressBar, constraints);
        return panel;
    }

    private JPanel createMultiProgressBarPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = GridBagConstraintsFactory.getBasicNoInsetsConstraints();
        constraints.fill = 1;
        this.noOfPacks = this.idata.availablePacks.size();
        this.packProgressPanels = new ArrayList<PackProgressPanel>();
        for (int i = 0; i < this.noOfPacks; ++i) {
            constraints.insets = new Insets(3, 0, 0, 0);
            PackProgressPanel toAdd = new PackProgressPanel();
            this.packProgressPanels.add(toAdd);
            panel.add((Component)toAdd, constraints);
            ++constraints.gridy;
            toAdd.setVisible(false);
        }
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        panel.add(Box.createGlue(), constraints);
        return panel;
    }

    private JLabel createTitle() {
        return LabelFactory.createTitleLabel(this.idata.langpack.getString("InstallPanel.title"), !this.parent.hasBackground);
    }

    private JPanel createInstallingPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.packOpLabelPrefix = this.idata.langpack.getString("InstallPanel.currentlyInstalling") + "%s";
        this.packOpLabel = LabelFactory.create(String.format(this.packOpLabelPrefix, ""), 10);
        this.packOpLabel.setFont(FontResources.getOpenSansRegular());
        GridBagConstraints constraints = GridBagConstraintsFactory.getBasicNoInsetsConstraints();
        constraints.weightx = 1.0;
        constraints.fill = 1;
        panel.add((Component)this.packOpLabel, constraints);
        return panel;
    }

    @Override
    public boolean isValidated() {
        return this.validated;
    }

    @Override
    public void startAction(String name, int noOfJobs) {
        this.noOfPacks = noOfJobs;
        for (IzPanel panel : this.idata.panels) {
            if (panel.getSummaryBody() == null) continue;
            panel.setView();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InstallPanel.this.parent.blockGUI();
                if (!InstallPanel.this.useMultiProgress) {
                    InstallPanel.this.overallProgressBar.setMinimum(0);
                    InstallPanel.this.overallProgressBar.setMaximum(InstallPanel.this.noOfPacks);
                    InstallPanel.this.overallProgressBar.setString("0 / " + Integer.toString(InstallPanel.this.noOfPacks));
                }
            }
        });
    }

    @Override
    public void emitError(String title, String error) {
        this.packOpLabel.setText(error);
        this.idata.installSuccess = false;
        super.emitError(title, error);
    }

    @Override
    public void stopAction() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InstallPanel.this.parent.releaseGUI();
                InstallPanel.this.parent.lockPrevButton();
                if (InstallPanel.this.useMultiProgress) {
                    for (PackProgressPanel packProgressPanel : InstallPanel.this.packProgressPanels) {
                    }
                } else {
                    InstallPanel.this.overallProgressBar.setValue(InstallPanel.this.overallProgressBar.getMaximum());
                    int ppbMax = InstallPanel.this.packProgressBar.getMaximum();
                    if (ppbMax < 1) {
                        ppbMax = 1;
                        InstallPanel.this.packProgressBar.setMaximum(ppbMax);
                    }
                    InstallPanel.this.packProgressBar.setValue(ppbMax);
                    InstallPanel.this.packProgressBar.setString(((InstallPanel)InstallPanel.this).parent.langpack.getString("InstallPanel.finished"));
                    InstallPanel.this.packProgressBar.setEnabled(false);
                    String no_of_packs = Integer.toString(InstallPanel.this.noOfPacks);
                    if (InstallPanel.this.noOfPacks == 1) {
                        InstallPanel.this.overallProgressBar.setIndeterminate(false);
                    }
                    InstallPanel.this.overallProgressBar.setString(no_of_packs + " / " + no_of_packs);
                    InstallPanel.this.overallProgressBar.setEnabled(false);
                    InstallPanel.this.packOpLabel.setText(String.format(InstallPanel.this.packOpLabelPrefix, " "));
                    InstallPanel.this.packOpLabel.setEnabled(false);
                }
                ((InstallPanel)InstallPanel.this).idata.canClose = true;
                InstallPanel.this.validated = true;
                if (((InstallPanel)InstallPanel.this).idata.panels.indexOf(this) != ((InstallPanel)InstallPanel.this).idata.panels.size() - 1) {
                    InstallPanel.this.parent.unlockNextButton();
                }
            }
        });
    }

    public String wrapText(String packName, int size) {
        return "<html><div style=\"width:" + size + "px;\">" + packName + "</div></html>";
    }

    @Override
    public void progress(final int val, final String msg) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (InstallPanel.this.useMultiProgress) {
                    if (InstallPanel.this.curPackNo < InstallPanel.this.packProgressPanels.size()) {
                        PackProgressPanel panel = InstallPanel.this.packProgressPanels.get(InstallPanel.this.curPackNo);
                        JProgressBar bar = panel.getProgressBar();
                        bar.setValue(val + 1);
                        JLabel percentage = panel.getPercentLabel();
                        int percentComplete = (int)(bar.getPercentComplete() * 100.0);
                        percentage.setForeground(Color.BLACK);
                        percentage.setText(percentComplete + "%");
                        if (percentComplete == 100) {
                            panel.setComplete();
                        }
                    }
                } else {
                    InstallPanel.this.packProgressBar.setValue(val + 1);
                }
                String installPath = InstallPanel.this.idata.getInstallPath() + File.separator;
                String finalMsg = "";
                if (msg.startsWith(installPath)) {
                    finalMsg = msg.replace(installPath, "");
                }
                InstallPanel.this.packOpLabel.setText(String.format(InstallPanel.this.packOpLabelPrefix, finalMsg));
            }
        });
    }

    @Override
    public void nextStep(final String packName, final int stepno, final int max) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (InstallPanel.this.useMultiProgress) {
                    InstallPanel.this.curPackNo = stepno - 1;
                    if (InstallPanel.this.curPackNo < InstallPanel.this.packProgressPanels.size()) {
                        PackProgressPanel panel = InstallPanel.this.packProgressPanels.get(InstallPanel.this.curPackNo);
                        panel.getPackLabel().setText(InstallPanel.this.wrapText(packName, 150));
                        JProgressBar bar = panel.getProgressBar();
                        if (max == 0) {
                            panel.setComplete();
                        }
                        bar.setMaximum(max);
                        bar.setValue(0);
                    }
                } else {
                    InstallPanel.this.packProgressBar.setValue(0);
                    InstallPanel.this.packProgressBar.setMinimum(0);
                    InstallPanel.this.packProgressBar.setMaximum(max);
                    InstallPanel.this.packProgressBar.setString(packName);
                    InstallPanel.this.overallProgressBar.setValue(stepno - 1);
                    InstallPanel.this.overallProgressBar.setString(Integer.toString(stepno) + " / " + Integer.toString(InstallPanel.this.noOfPacks));
                }
            }
        });
    }

    @Override
    public void setSubStepNo(final int no_of_substeps) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (InstallPanel.this.useMultiProgress) {
                    PackProgressPanel panel = InstallPanel.this.packProgressPanels.get(InstallPanel.this.curPackNo);
                    panel.getProgressBar().setMaximum(no_of_substeps);
                } else {
                    InstallPanel.this.packProgressBar.setMaximum(no_of_substeps);
                }
            }
        });
    }

    @Override
    public void panelActivate() {
        this.noOfPacks = this.idata.selectedPacks.size();
        if (this.useMultiProgress) {
            for (int i = 0; i < this.noOfPacks; ++i) {
                this.packProgressPanels.get(i).setVisible(true);
            }
        } else {
            this.packProgressBar.setVisible(true);
        }
        Dimension dim = this.parent.getCenterPanelSize();
        dim.width -= dim.width / 4;
        dim.height = 150;
        this.setMinimumSize(dim);
        this.setMaximumSize(dim);
        this.setPreferredSize(dim);
        this.parent.lockNextButton();
        this.parent.lockPrevButton();
        this.parent.install(this);
    }

    private class PackProgressPanel
    extends JPanel {
        JLabel packLabel;
        JProgressBar progressBar;
        JLabel percentLabel;
        JLabel finishLabel;

        public PackProgressPanel() {
            super.setLayout(new GridBagLayout());
            this.setOpaque(false);
            this.addPackLabel();
            this.addProgressBar();
            this.addFinishLabel();
            this.addPercentLabel();
        }

        private void addFinishLabel() {
            JLabel finishLabel = new JLabel("\uf00c");
            finishLabel.setFont(FontResources.getFontAwesome().deriveFont(16.0f));
            finishLabel.setForeground(UiResources.checkMarkGreen);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.weightx = 0.65;
            gbc.gridy = 0;
            gbc.anchor = 21;
            gbc.fill = 1;
            finishLabel.setVisible(false);
            this.add((Component)finishLabel, gbc);
            this.finishLabel = finishLabel;
        }

        public JLabel getPackLabel() {
            return this.packLabel;
        }

        public void addPackLabel() {
            String waitingLabel = ((InstallPanel)InstallPanel.this).idata.langpack.getString("InstallPanel.waiting");
            waitingLabel = waitingLabel != null ? waitingLabel : "Waiting...";
            JLabel packLabel = new JLabel(waitingLabel);
            packLabel.setFont(FontResources.getOpenSansRegular());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.weightx = 0.5;
            gbc.gridy = 0;
            gbc.anchor = 21;
            gbc.fill = 1;
            this.add((Component)packLabel, gbc);
            this.packLabel = packLabel;
        }

        public void addProgressBar() {
            JProgressBar bar = new JProgressBar();
            bar.setUI(new PatternflyProgressBarUI());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.weightx = 5.0;
            gbc.anchor = 21;
            gbc.fill = 2;
            this.add((Component)bar, gbc);
            this.progressBar = bar;
        }

        public JProgressBar getProgressBar() {
            return this.progressBar;
        }

        public JLabel getPercentLabel() {
            return this.percentLabel;
        }

        public void addPercentLabel() {
            JLabel percentLabel = new JLabel();
            percentLabel.setFont(FontResources.getOpenSansRegular().deriveFont(12.0f));
            percentLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            percentLabel.setText("00%");
            percentLabel.setForeground(new Color(-1));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 0;
            gbc.fill = 2;
            gbc.anchor = 21;
            this.add((Component)percentLabel, gbc);
            this.percentLabel = percentLabel;
        }

        public void setComplete() {
            this.progressBar.setVisible(false);
            this.percentLabel.setVisible(false);
            this.finishLabel.setVisible(true);
        }
    }
}

