/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.ConsoleInstaller;
import com.izforge.izpack.installer.IUnpacker;
import com.izforge.izpack.installer.PanelConsole;
import com.izforge.izpack.installer.PanelConsoleHelper;
import com.izforge.izpack.installer.UnpackerFactory;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import java.io.PrintWriter;
import java.util.Properties;

public class InstallPanelConsoleHelper
extends PanelConsoleHelper
implements PanelConsole,
AbstractUIProgressHandler {
    private int noOfPacks = 0;

    @Override
    public boolean runGeneratePropertiesFile(AutomatedInstallData installData, PrintWriter printWriter) {
        return true;
    }

    @Override
    public boolean runConsoleFromPropertiesFile(AutomatedInstallData installData, Properties p) {
        return this.runConsole(installData, null);
    }

    @Override
    public boolean runConsole(AutomatedInstallData idata, ConsoleInstaller parent) {
        IUnpacker unpacker = UnpackerFactory.getUnpacker(idata.info.getUnpackerClassName(), idata, this);
        Thread unpackerthread = new Thread((Runnable)unpacker, "IzPack - Unpacker thread");
        unpacker.setRules(idata.getRules());
        unpackerthread.start();
        boolean done = false;
        while (!done && unpackerthread.isAlive()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return unpacker.getResult();
    }

    @Override
    public void emitNotification(String message) {
        System.out.println(message);
    }

    @Override
    public boolean emitWarning(String title, String message) {
        String warning = AutomatedInstallData.getInstance().langpack.getString("installer.warning");
        System.err.println(String.format("[ %s: %s ]", warning, message));
        return true;
    }

    @Override
    public void emitError(String title, String message) {
        System.err.println("[ ERROR: " + message + " ]");
    }

    @Override
    public void emitErrorAndBlockNext(String title, String message) {
        String error = AutomatedInstallData.getInstance().langpack.getString("installer.error");
        System.err.println(String.format("[ %s: %s ]", error, message));
    }

    @Override
    public int askQuestion(String title, String question, int choices) {
        return 45;
    }

    @Override
    public int askQuestion(String title, String question, int choices, int default_choice) {
        return default_choice;
    }

    @Override
    public void startAction(String name, int no_of_steps) {
        String message = AutomatedInstallData.getInstance().langpack.getString("InstallPanel.unpack.start");
        System.out.println(String.format("[ %s ]", message));
        this.noOfPacks = no_of_steps;
    }

    @Override
    public void stopAction() {
        String message = AutomatedInstallData.getInstance().langpack.getString("InstallPanel.unpack.finish");
        System.out.println(String.format("[ %s ]", message));
        System.out.println();
    }

    @Override
    public void progress(int val, String msg) {
    }

    @Override
    public void nextStep(String packName, int stepno, int stepsize) {
        String processingMessage = AutomatedInstallData.getInstance().langpack.getString("InstallPanel.pack.process");
        System.out.println(String.format("[ %s: %s (%d/%d) ]", processingMessage, packName, stepno, this.noOfPacks));
    }

    @Override
    public void setSubStepNo(int no_of_substeps) {
    }
}

