/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.CorrectWidthJTextArea;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;

public class JTextMessagePane
extends CorrectWidthJTextArea {
    private int width;
    private FontMetrics fm;

    public JTextMessagePane(String msg, int maxWidth, FontMetrics fm) {
        this.fm = fm;
        this.setEditable(false);
        this.setFocusable(false);
        this.setBackground(null);
        this.setWrapStyleWord(true);
        this.setLineWrap(true);
        this.setMargin(new Insets(2, 0, 2, 0));
        int textWidth = this.getMessageWidth(msg);
        this.width = textWidth < maxWidth ? textWidth : maxWidth;
        this.setPreferredSize(new Dimension(this.width, this.getPreferredSize().height * this.rowCountWrapLine(msg)));
        this.setText(msg);
    }

    private int getMessageWidth(String msg) {
        int max = 0;
        String[] lines = msg.split("\\n");
        if (lines.length == 1) {
            return this.fm.stringWidth(msg);
        }
        for (String line : lines) {
            max = max < this.fm.stringWidth(line) ? this.fm.stringWidth(line) : max;
        }
        return max + this.fm.stringWidth("\\n");
    }

    private int rowCountWrapLine(String text) {
        int rowCount = 1;
        int widthCount = 0;
        String[] words = text.split("(?<=\\s)");
        if (words.length == 1) {
            return rowCount + this.rowCountWrapWord(words[0]);
        }
        for (int i = 0; i < words.length - 1; ++i) {
            String word = words[i];
            String nextWord = words[i + 1];
            if (this.fm.stringWidth(word) > this.width) {
                rowCount += this.rowCountWrapWord(word);
                widthCount = this.fm.stringWidth(word) % this.width;
                continue;
            }
            int remainder = this.width - (widthCount += this.fm.stringWidth(word));
            if (remainder >= this.fm.stringWidth(nextWord) && !word.contains("\n")) continue;
            ++rowCount;
            widthCount = 0;
        }
        String finalWord = words[words.length - 1];
        if (this.fm.stringWidth(finalWord) > this.width) {
            rowCount += this.rowCountWrapWord(finalWord);
        }
        return rowCount;
    }

    private int rowCountWrapWord(String word) {
        int additionalRows = 0;
        int widthCount = 0;
        char[] letters = word.toCharArray();
        for (int i = 0; i < letters.length - 1; ++i) {
            char curChar = letters[i];
            char nextChar = letters[i + 1];
            int remainder = this.width - (widthCount += this.fm.charWidth(curChar));
            if (remainder >= this.fm.charWidth(nextChar)) continue;
            ++additionalRows;
            widthCount = 0;
        }
        return additionalRows;
    }
}

