/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.CorrectWidthJTextArea;
import com.izforge.izpack.gui.FlowLayout;
import com.izforge.izpack.gui.FocusListenerAutoScroll;
import com.izforge.izpack.gui.FocusListenerRepaint;
import com.izforge.izpack.panels.HyperlinkAction;
import com.izforge.izpack.util.Debug;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class JTextUrlPane
extends CorrectWidthJTextArea {
    private ArrayList<JTextPane> focusableFields;

    public JTextUrlPane() {
        this.setLayout(new FlowLayout(3, 0, 2));
        this.focusableFields = new ArrayList();
    }

    private void setHtml(JTextPane p, String style, String text) {
        HTMLEditorKit htmlEditorKit = new HTMLEditorKit();
        HTMLDocument htmlDocument = (HTMLDocument)htmlEditorKit.createDefaultDocument();
        p.setEditorKit(htmlEditorKit);
        p.setDocument(htmlDocument);
        Element e = htmlDocument.getRootElements()[0];
        Element bodyElement = e.getElement(0);
        StringBuffer sbHtml = new StringBuffer();
        sbHtml.append(style + text + "</p>");
        StyleSheet ss = htmlDocument.getStyleSheet();
        try {
            htmlDocument.insertAfterStart(bodyElement, sbHtml.toString());
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        ss.addRule("p {margin-top:0;}\n");
    }

    private JTextPane createTextPane(String text, String style, boolean isHyperlink) {
        JTextPane p = new JTextPane();
        p.setEditable(false);
        this.setHtml(p, style, text);
        if (isHyperlink) {
            p.addFocusListener(new FocusListenerRepaint());
            p.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && Desktop.isDesktopSupported()) {
                        try {
                            Desktop.getDesktop().browse(e.getURL().toURI());
                        }
                        catch (IOException e1) {
                            Debug.trace(e1);
                        }
                        catch (URISyntaxException e1) {
                            Debug.trace(e1);
                        }
                    }
                }
            });
            p.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "Hyperlink");
            p.getActionMap().put("Hyperlink", new HyperlinkAction());
        } else {
            p.setFocusable(false);
        }
        return p;
    }

    @Override
    public void setText(String text) {
        String[] inputText;
        boolean first = true;
        Pattern p = Pattern.compile("<p style=(.*?)>");
        Matcher m = p.matcher(text);
        String style = m.find() ? m.group() : "";
        p = Pattern.compile("<a href=(.*?)</a>");
        m = p.matcher(text);
        boolean matchFound = m.find();
        for (String normalText : inputText = text.split("<a href=(.*?)</a>")) {
            String cleanedText = normalText.replaceAll("<[^>]*>", "");
            JTextPane preHyperlink = cleanedText.isEmpty() ? null : this.createTextPane(cleanedText, style, false);
            JTextPane hyperlink = null;
            if (matchFound) {
                hyperlink = this.createTextPane(m.group(), style, true);
            }
            if (first) {
                first = false;
                JTextPane firstComp = preHyperlink == null ? hyperlink : preHyperlink;
                firstComp.setMargin(new Insets(3, 0, 3, 3));
            }
            if (preHyperlink != null) {
                this.add(preHyperlink);
            }
            if (hyperlink != null) {
                hyperlink.addFocusListener(new FocusListenerAutoScroll());
                this.add(hyperlink);
            }
            this.focusableFields.add(hyperlink);
            matchFound = m.find();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int totalWidth = 0;
        for (Component comp : this.getComponents()) {
            totalWidth += comp.getPreferredSize().width;
        }
        return new Dimension(totalWidth, super.getPreferredSize().height + 3);
    }

    public ArrayList<JTextPane> getFocusableFields() {
        return this.focusableFields;
    }
}

