/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.panels.DynamicPackSelector;
import com.izforge.izpack.panels.PacksPanelInterface;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.Debug;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.table.AbstractTableModel;

class PacksModel
extends AbstractTableModel {
    private static final long serialVersionUID = 3258128076746733110L;
    private static final String INITAL_PACKSELECTION = "initial.pack.selection";
    private static final int ON_SELECT = 0;
    private static final int ON_DESELECT = 1;
    private ArrayList<Pack> packs;
    private List<Pack> hiddenPacks;
    private List packsToInstall;
    private Map<String, Pack> installedpacks;
    private boolean modifyinstallation;
    private PacksPanelInterface panel;
    private LocaleDatabase langpack;
    private int[] checkValues;
    Map<String, Pack> namesObj;
    Map<String, Integer> namesPos;
    Map<String, Integer> idPos;
    private RulesEngine rules;
    private Properties variables;
    private InstallData idata;
    private DynamicPackSelector dPackSelector;

    public PacksModel(PacksPanelInterface panel, InstallData idata, RulesEngine rules) {
        this.idata = idata;
        this.modifyinstallation = Boolean.valueOf(idata.getVariable("modify.izpack.install"));
        this.installedpacks = new HashMap<String, Pack>();
        if (this.modifyinstallation) {
            try {
                FileInputStream fin = new FileInputStream(new File(idata.getInstallPath() + File.separator + ".installationinformation"));
                ObjectInputStream oin = new ObjectInputStream(fin);
                List packsinstalled = (List)oin.readObject();
                for (Object aPacksinstalled : packsinstalled) {
                    Pack installedpack = (Pack)aPacksinstalled;
                    if (installedpack.id != null && installedpack.id.length() > 0) {
                        this.installedpacks.put(installedpack.id, installedpack);
                        continue;
                    }
                    this.installedpacks.put(installedpack.name, installedpack);
                }
                this.removeAlreadyInstalledPacks(idata.selectedPacks);
                Debug.trace("Found " + packsinstalled.size() + " installed packs");
                Properties variables = (Properties)oin.readObject();
                for (Object key : variables.keySet()) {
                    idata.setVariable((String)key, (String)variables.get(key));
                }
                fin.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        this.rules = rules;
        this.packs = new ArrayList();
        this.hiddenPacks = new ArrayList<Pack>();
        for (Pack availablePack : idata.availablePacks) {
            if (!availablePack.isHidden()) {
                this.packs.add(availablePack);
                continue;
            }
            this.hiddenPacks.add(availablePack);
        }
        this.packsToInstall = idata.selectedPacks;
        this.panel = panel;
        this.variables = idata.getVariables();
        this.variables.setProperty(INITAL_PACKSELECTION, Boolean.toString(true));
        this.langpack = panel.getLangpack();
        this.checkValues = new int[this.packs.size()];
        this.reverseDeps();
        this.initvalues();
        this.dPackSelector = new DynamicPackSelector(this.checkValues, this.packs, this.idPos);
        this.updateConditions(true);
        this.refreshPacksToInstall();
        this.variables.setProperty(INITAL_PACKSELECTION, Boolean.toString(false));
    }

    public Pack getPackAtRow(int row) {
        return this.packs.get(row);
    }

    private void removeAlreadyInstalledPacks(List selectedpacks) {
        ArrayList<Pack> removepacks = new ArrayList<Pack>();
        for (Object selectedpack1 : selectedpacks) {
            Pack selectedpack = (Pack)selectedpack1;
            String key = "";
            key = selectedpack.id != null && selectedpack.id.length() > 0 ? selectedpack.id : selectedpack.name;
            if (!this.installedpacks.containsKey(key)) continue;
            removepacks.add(selectedpack);
        }
        for (Pack removepack : removepacks) {
            selectedpacks.remove(removepack);
        }
    }

    public void updateConditions() {
        this.updateConditions(false);
    }

    public void updateConditions(boolean initial) {
        boolean changes = true;
        while (changes) {
            changes = false;
            Iterator<Pack> iterator = this.packs.iterator();
            while (iterator.hasNext()) {
                Pack pack1;
                Pack pack = pack1 = iterator.next();
                int pos = this.getPos(pack.name);
                Debug.trace("Conditions fulfilled for: " + pack.name + "?");
                if (this.rules.canInstallPack(pack.id, this.variables)) {
                    if (initial) {
                        if (this.checkValues[pos] >= 0) continue;
                        this.checkValues[pos] = -1;
                        if (pack.preselected) continue;
                        this.checkValues[pos] = 0;
                        continue;
                    }
                    if (!pack.required) continue;
                    this.checkValues[pos] = -1;
                    continue;
                }
                Debug.trace("no");
                if (this.rules.canInstallPackOptional(pack.id, this.variables)) {
                    Debug.trace("optional");
                    Debug.trace(pack.id + " can be installed optionally.");
                    if (!initial || this.checkValues[pos] == 0) continue;
                    this.checkValues[pos] = 0;
                    changes = true;
                    break;
                }
                Debug.trace(pack.id + " can not be installed.");
                if (this.checkValues[pos] == -2) continue;
                this.checkValues[pos] = -2;
                changes = true;
                break;
            }
            this.refreshPacksToInstall();
        }
    }

    private void reverseDeps() {
        Pack pack;
        this.namesObj = new HashMap<String, Pack>();
        Iterator<Pack> iterator = this.packs.iterator();
        while (iterator.hasNext()) {
            Pack pack2;
            pack = pack2 = iterator.next();
            this.namesObj.put(pack.name, pack);
        }
        iterator = this.packs.iterator();
        while (iterator.hasNext()) {
            Pack pack1;
            pack = pack1 = iterator.next();
            List<String> deps = pack.dependencies;
            for (int j = 0; deps != null && j < deps.size(); ++j) {
                String name = deps.get(j);
                Pack parent = this.namesObj.get(name);
                parent.addRevDep(pack.name);
            }
        }
    }

    private void initvalues() {
        Pack pack;
        int i;
        this.namesPos = new HashMap<String, Integer>();
        this.idPos = new HashMap<String, Integer>();
        for (i = 0; i < this.packs.size(); ++i) {
            pack = this.packs.get(i);
            this.namesPos.put(pack.name, i);
            this.idPos.put(pack.id, i);
        }
        for (i = 0; i < this.packs.size(); ++i) {
            pack = this.packs.get(i);
            if (!this.packsToInstall.contains(pack)) continue;
            this.checkValues[i] = 1;
        }
        for (i = 0; i < this.packs.size(); ++i) {
            pack = this.packs.get(i);
            if (this.checkValues[i] == 0) {
                List<String> deps = pack.revDependencies;
                for (int j = 0; deps != null && j < deps.size(); ++j) {
                    String name = deps.get(j);
                    int pos = this.getPos(name);
                    this.checkValues[pos] = -2;
                }
            }
            if (this.checkValues[i] <= 0 || pack.excludeGroup == null) continue;
            for (int q = 0; q < this.packs.size(); ++q) {
                if (q == i) continue;
                Pack otherpack = this.packs.get(q);
                if (!pack.excludeGroup.equals(otherpack.excludeGroup) || this.checkValues[q] != 1) continue;
                this.checkValues[q] = 0;
            }
        }
        Iterator<Pack> iterator = this.packs.iterator();
        while (iterator.hasNext()) {
            Pack pack1;
            Pack pack2 = pack1 = iterator.next();
            if (!pack2.required) continue;
            this.propRequirement(pack2.name);
        }
        this.refreshPacksToInstall();
    }

    private void propRequirement(String name) {
        int pos = this.getPos(name);
        this.checkValues[pos] = -1;
        List<String> deps = this.packs.get((int)pos).dependencies;
        for (int i = 0; deps != null && i < deps.size(); ++i) {
            String s = deps.get(i);
            this.propRequirement(s);
        }
    }

    private int getPos(String name) {
        return this.namesPos.get(name);
    }

    private int getPosFromId(String id) {
        return this.idPos.get(id);
    }

    @Override
    public int getRowCount() {
        return this.packs.size();
    }

    @Override
    public int getColumnCount() {
        boolean doNotShowPackSize = Boolean.parseBoolean(this.idata.guiPrefs.modifier.get("doNotShowPackSizeColumn"));
        int result = 0;
        result = !doNotShowPackSize ? 3 : 2;
        return result;
    }

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Integer.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.checkValues[rowIndex] < 0) {
            return false;
        }
        return columnIndex == 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Pack pack = this.packs.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return this.checkValues[rowIndex];
            }
            case 1: {
                String name = null;
                if (this.langpack != null && pack.id != null && !pack.id.equals("")) {
                    name = this.langpack.get(pack.id);
                }
                if (name == null || "".equals(name)) {
                    name = pack.name;
                }
                return name;
            }
            case 2: {
                return Pack.toByteUnitsString(pack.nbytes);
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 0 && aValue instanceof Integer) {
            Pack pack = this.packs.get(rowIndex);
            boolean packadded = false;
            if ((Integer)aValue == 1) {
                packadded = true;
                String packid = pack.id;
                if (packid != null) {
                    if (this.rules.canInstallPack(packid, this.variables) || this.rules.canInstallPackOptional(packid, this.variables)) {
                        this.checkValues[rowIndex] = pack.required ? -1 : 1;
                    }
                } else {
                    this.checkValues[rowIndex] = pack.required ? -1 : 1;
                }
            } else {
                packadded = false;
                this.checkValues[rowIndex] = 0;
            }
            this.updateDeps();
            this.dPackSelector.onSelectionUpdate(rowIndex);
            if (packadded) {
                if (this.panel.getDebugger() != null) {
                    this.panel.getDebugger().packSelectionChanged("after adding pack " + pack.id);
                }
                this.packsToInstall.add(pack);
            } else {
                if (this.panel.getDebugger() != null) {
                    this.panel.getDebugger().packSelectionChanged("after removing pack " + pack.id);
                }
                this.packsToInstall.remove(pack);
            }
            this.updateConditions();
            if (packadded) {
                this.packsToInstall.remove(pack);
            } else {
                this.packsToInstall.add(pack);
            }
            this.refreshPacksToInstall();
            this.updateBytes();
            this.fireTableDataChanged();
            this.panel.showSpaceRequired();
        }
    }

    private void refreshPacksToInstall() {
        String key;
        Pack pack;
        int i;
        this.packsToInstall.clear();
        for (i = 0; i < this.packs.size(); ++i) {
            pack = this.packs.get(i);
            key = "";
            key = pack.id != null && pack.id.length() > 0 ? pack.id : pack.name;
            if (Math.abs(this.checkValues[i]) != 1 || this.installedpacks.containsKey(key)) continue;
            this.packsToInstall.add(pack);
        }
        for (i = 0; i < this.packs.size(); ++i) {
            pack = this.packs.get(i);
            key = "";
            key = pack.id != null && pack.id.length() > 0 ? pack.id : pack.name;
            if (!this.installedpacks.containsKey(key)) continue;
            this.checkValues[i] = -3;
        }
        for (Pack hiddenpack : this.hiddenPacks) {
            if (!this.rules.canInstallPack(hiddenpack.id, this.variables)) continue;
            this.packsToInstall.add(hiddenpack);
        }
    }

    private void updateDeps() {
        int i;
        int[] statusArray = new int[this.packs.size()];
        for (i = 0; i < statusArray.length; ++i) {
            statusArray[i] = 0;
        }
        this.dfs(statusArray);
        for (i = 0; i < statusArray.length; ++i) {
            if (statusArray[i] == 0 && this.checkValues[i] < 0) {
                int n = i;
                this.checkValues[n] = this.checkValues[n] + 2;
            }
            if (statusArray[i] != 1 || this.checkValues[i] < 0) continue;
            this.checkValues[i] = -2;
        }
        Iterator<Pack> iterator = this.packs.iterator();
        while (iterator.hasNext()) {
            Pack pack1;
            Pack pack = pack1 = iterator.next();
            if (!pack.required) continue;
            String packid = pack.id;
            if (packid != null) {
                if (!this.rules.canInstallPack(packid, this.variables) && this.rules.canInstallPackOptional(packid, this.variables)) continue;
                this.propRequirement(pack.name);
                continue;
            }
            this.propRequirement(pack.name);
        }
    }

    private void updateExcludes(int rowindex) {
        int value = this.checkValues[rowindex];
        Pack pack = this.packs.get(rowindex);
        if (value > 0 && pack.excludeGroup != null) {
            for (int q = 0; q < this.packs.size(); ++q) {
                if (rowindex == q) continue;
                Pack otherpack = this.packs.get(q);
                String name2 = pack.excludeGroup;
                String name1 = otherpack.excludeGroup;
                if (!name2.equals(name1) || this.checkValues[q] != 1) continue;
                this.checkValues[q] = 0;
            }
        }
    }

    private void updateBytes() {
        long bytes = 0L;
        for (int q = 0; q < this.packs.size(); ++q) {
            if (Math.abs(this.checkValues[q]) != 1) continue;
            Pack pack = this.packs.get(q);
            bytes += pack.nbytes;
        }
        for (Pack hidden : this.hiddenPacks) {
            if (!this.rules.canInstallPack(hidden.id, this.variables)) continue;
            bytes += hidden.nbytes;
        }
        this.panel.setBytes(bytes);
    }

    private int dfs(int[] status) {
        for (int i = 0; i < this.packs.size(); ++i) {
            boolean wipe;
            for (Pack pack1 : this.packs) {
                pack1.color = 0;
            }
            Pack pack = this.packs.get(i);
            if (this.dfsVisit(pack, status, wipe = false) == 0) continue;
            return -1;
        }
        return 0;
    }

    private int dfsVisit(Pack u, int[] status, boolean wipe) {
        List<String> deps;
        u.color = 1;
        int check = this.checkValues[this.getPos(u.name)];
        if (Math.abs(check) != 1) {
            wipe = true;
        }
        if ((deps = u.revDependencies) != null) {
            for (String name : deps) {
                int result;
                Pack v = this.namesObj.get(name);
                if (wipe) {
                    status[this.getPos((String)v.name)] = 1;
                }
                if (v.color != 0 || (result = this.dfsVisit(v, status, wipe)) == 0) continue;
                return result;
            }
        }
        u.color = 2;
        return 0;
    }

    public Map getInstalledpacks() {
        return this.installedpacks;
    }

    public boolean isModifyinstallation() {
        return this.modifyinstallation;
    }
}

