/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.Pack;
import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.PanelAutomation;
import java.util.ArrayList;
import java.util.Vector;

public class PacksPanelAutomationHelper
implements PanelAutomation {
    @Override
    public void makeXMLData(AutomatedInstallData idata, IXMLElement panelRoot) {
        for (int i = 0; i < idata.availablePacks.size(); ++i) {
            Pack pack = idata.availablePacks.get(i);
            if (pack.isHidden()) continue;
            XMLElementImpl el = new XMLElementImpl("pack", panelRoot);
            el.setAttribute("index", Integer.toString(i));
            el.setAttribute("name", pack.name);
            Boolean selected = idata.selectedPacks.contains(pack);
            el.setAttribute("selected", selected.toString());
            panelRoot.addChild(el);
        }
    }

    @Override
    public void runAutomated(AutomatedInstallData idata, IXMLElement panelRoot) {
        final class PInfo {
            private boolean _selected;
            private int _index;
            private String _name = "";

            PInfo(boolean selected, String index, String name) {
                this._selected = selected;
                try {
                    this._index = Integer.valueOf(index);
                }
                catch (NumberFormatException e) {
                    this._index = -100;
                }
                if (name != null) {
                    this._name = name;
                }
            }

            public boolean isSelected() {
                return this._selected;
            }

            public boolean equals(int index) {
                return this._index == index && this._name.equals("");
            }

            public boolean equals(String name) {
                return this._name.equals(name);
            }

            public String toString() {
                String retVal = "";
                if (!this._name.equals("")) {
                    retVal = "Name: " + this._name + " and ";
                }
                retVal = retVal + "Index: " + String.valueOf(this._index);
                return retVal;
            }
        }
        ArrayList<PInfo> autoinstallPackInfoList = new ArrayList<PInfo>();
        Vector<IXMLElement> packList = panelRoot.getChildrenNamed("pack");
        System.out.println("Read pack list from xml definition.");
        int numberOfPacks = packList.size();
        for (int packIndex = 0; packIndex < numberOfPacks; ++packIndex) {
            IXMLElement iXMLElement = packList.get(packIndex);
            String index = iXMLElement.getAttribute("index");
            String name = iXMLElement.getAttribute("name");
            String selectedString = iXMLElement.getAttribute("selected");
            boolean selected = selectedString.equalsIgnoreCase("true") || selectedString.equalsIgnoreCase("on");
            PInfo packInfo = new PInfo(selected, index, name);
            autoinstallPackInfoList.add(packInfo);
            System.out.println("Try to " + (selected ? "add to" : "remove from") + " selection [" + packInfo.toString() + "]");
        }
        System.out.println("Modify pack selection.");
        block1: for (Pack pack : idata.availablePacks) {
            if (pack.isHidden()) {
                idata.selectedPacks.remove(pack);
            }
            int indexOfAvailablePack = idata.availablePacks.indexOf(pack);
            for (PInfo packInfo : autoinstallPackInfoList) {
                if (!packInfo.equals(pack.name) && !packInfo.equals(indexOfAvailablePack)) continue;
                if (pack.required) {
                    if (packInfo.isSelected()) continue block1;
                    System.out.println("Pack [" + packInfo.toString() + "] must be installed because it is required!");
                    continue block1;
                }
                if (packInfo.isSelected()) {
                    if (idata.selectedPacks.indexOf(pack) >= 0 || pack.id == null || !idata.getRules().canInstallPack(pack.id, idata.getVariables())) continue block1;
                    idata.selectedPacks.add(pack);
                    System.out.println("Pack [" + packInfo.toString() + "] added to selection.");
                    continue block1;
                }
                idata.selectedPacks.remove(pack);
                System.out.println("Pack [" + packInfo.toString() + "] removed from selection.");
                continue block1;
            }
        }
        for (int counter = panelRoot.getChildrenCount(); counter > 0; --counter) {
            panelRoot.removeChild(panelRoot.getChildAtIndex(0));
        }
        this.makeXMLData(idata, panelRoot);
    }
}

