/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.ConsoleInstaller;
import com.izforge.izpack.installer.PanelConsole;
import com.izforge.izpack.installer.PanelConsoleHelper;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.util.AeshReadlineConsole;
import com.izforge.izpack.util.Debug;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.Properties;

public class PacksPanelConsoleHelper
extends PanelConsoleHelper
implements PanelConsole {
    private static boolean askSelected(boolean defaultValue) {
        boolean selected = defaultValue;
        boolean bKeepAsking = true;
        while (bKeepAsking) {
            PacksPanelConsoleHelper.out("input 1 to select, 0 to deselect:");
            String strIn = AeshReadlineConsole.readLine();
            if (strIn.trim().equals("")) {
                bKeepAsking = false;
            }
            int j = -1;
            try {
                j = Integer.valueOf(strIn);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (j != 0 && j != 1) continue;
            selected = j == 1;
            bKeepAsking = false;
        }
        return selected;
    }

    private static void out(String message) {
        System.out.println(message);
    }

    private String getI18n(LocaleDatabase langpack, String key, String defaultValue) {
        String text = langpack.getString(key);
        return text != null && !text.equals(key) ? text : defaultValue;
    }

    @Override
    public boolean runConsole(AutomatedInstallData installData, ConsoleInstaller parent) {
        LocaleDatabase langpack = installData.langpack;
        try {
            InputStream inputStream = ResourceManager.getInstance().getInputStream("packsLang.xml");
            langpack.add(inputStream);
        }
        catch (Exception e) {
            Debug.trace(e);
        }
        LinkedList<Pack> selectedPacks = new LinkedList<Pack>();
        PacksPanelConsoleHelper.out("");
        PacksPanelConsoleHelper.out(langpack.getString("PacksPanel.info"));
        PacksPanelConsoleHelper.out("");
        for (Pack pack : installData.availablePacks) {
            StringBuilder option = new StringBuilder(64);
            option.append("[").append(pack.required ? "<required>" : (pack.preselected ? "x" : " ")).append("] ").append(this.getI18n(langpack, pack.id, pack.name));
            String descr = this.getI18n(langpack, pack.id + ".description", pack.description);
            if (descr != null && descr.length() > 0) {
                option.append(" (" + descr + ")");
            }
            PacksPanelConsoleHelper.out(option.toString());
            if (!pack.required && !PacksPanelConsoleHelper.askSelected(pack.preselected)) continue;
            selectedPacks.add(pack);
        }
        PacksPanelConsoleHelper.out("");
        PacksPanelConsoleHelper.out("...pack selection done.");
        installData.selectedPacks = selectedPacks;
        int i = PacksPanelConsoleHelper.askEndOfConsolePanel(installData);
        if (i == 1) {
            return true;
        }
        if (i == 2) {
            return false;
        }
        return this.runConsole(installData, parent);
    }

    @Override
    public boolean runConsoleFromPropertiesFile(AutomatedInstallData installData, Properties p) {
        return false;
    }

    @Override
    public boolean runGeneratePropertiesFile(AutomatedInstallData installData, PrintWriter printWriter) {
        return false;
    }
}

