/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.plaf.metal.MetalLookAndFeel;

class PartialIcon
implements Icon {
    PartialIcon() {
    }

    protected int getControlSize() {
        return 13;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        int controlSize = this.getControlSize();
        g.setColor(MetalLookAndFeel.getControlShadow());
        g.fillRect(x, y, controlSize - 1, controlSize - 1);
        this.drawBorder(g, x, y, controlSize, controlSize);
        g.setColor(Color.green);
        this.drawCheck(c, g, x, y);
    }

    private void drawBorder(Graphics g, int x, int y, int w, int h) {
        g.translate(x, y);
        g.setColor(MetalLookAndFeel.getControlDarkShadow());
        g.setColor(new Color(0.4f, 0.4f, 0.4f));
        g.drawRect(0, 0, w - 2, h - 2);
        g.setColor(MetalLookAndFeel.getControlHighlight());
        g.setColor(new Color(0.6f, 0.6f, 0.6f));
        g.drawRect(1, 1, w - 2, h - 2);
        g.setColor(new Color(0.99f, 0.99f, 0.99f));
        g.fillRect(2, 2, w - 3, h - 3);
        g.setColor(MetalLookAndFeel.getControl());
        g.drawLine(0, h - 1, 1, h - 2);
        g.drawLine(w - 1, 0, w - 2, 1);
        g.translate(-x, -y);
    }

    protected void drawCheck(Component c, Graphics g, int x, int y) {
        int controlSize = this.getControlSize();
        g.setColor(new Color(0.0f, 0.7f, 0.0f));
        g.fillOval(x + controlSize / 2 - 2, y + controlSize / 2 - 2, 6, 6);
    }

    @Override
    public int getIconWidth() {
        return this.getControlSize();
    }

    @Override
    public int getIconHeight() {
        return this.getControlSize();
    }
}

