/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.GridBagConstraintsFactory;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ResourceNotFoundException;
import com.izforge.izpack.panels.PathSelectionPanel;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.ErrorIzpackPathException;
import com.izforge.izpack.util.FileUtil;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.VariableSubstitutor;
import com.izforge.izpack.util.WarningIzpackPathException;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PathInputPanel
extends IzPanel
implements ActionListener {
    private static final long serialVersionUID = 3257566217698292531L;
    protected boolean mustExist = false;
    protected String[] existFiles = null;
    protected PathSelectionPanel pathSelectionPanel;
    protected String emptyTargetMsg = this.getI18nStringForClass("empty_target", "TargetPanel");
    protected String warnMsg = this.getI18nStringForClass("warn", "TargetPanel");
    protected static String defaultInstallDir = null;

    public PathInputPanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata, new GridBagLayout());
        this.buildUI();
    }

    private void buildUI() {
        this.addTitle();
        this.addContentPanel();
    }

    private void addContentPanel() {
        JPanel contentPanel = new JPanel(new GridBagLayout());
        String introText = this.getIntroText();
        GridBagConstraints gbc = GridBagConstraintsFactory.getBasicConstraints();
        JLabel label = LabelFactory.create(introText);
        contentPanel.add((Component)label, gbc);
        JLabel info = LabelFactory.create(this.idata.langpack.getString("TargetPanel.info"));
        ++gbc.gridy;
        contentPanel.add((Component)info, gbc);
        this.pathSelectionPanel = new PathSelectionPanel(this, this.idata);
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        contentPanel.add((Component)this.pathSelectionPanel, gbc);
        this.add((Component)contentPanel, GridBagConstraintsFactory.getContentPanelConstraints());
    }

    private String getIntroText() {
        String returnValue = this.getI18nStringForClass("extendedIntro", "PathInputPanel");
        if ((returnValue == null || returnValue.endsWith("extendedIntro") || returnValue.indexOf(36) > -1) && ((returnValue = this.getI18nStringForClass("intro", "PathInputPanel")) == null || returnValue.endsWith("intro"))) {
            returnValue = "";
        }
        return returnValue;
    }

    private void addTitle() {
        JLabel title = LabelFactory.createTitleLabel(this.idata.langpack.getString("PathInputPanel.title"), !this.parent.hasBackground);
        this.add((Component)title, GridBagConstraintsFactory.getTitleConstraints());
    }

    public void createLayoutBottom() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.pathSelectionPanel.getPathInputField()) {
            this.parent.navigateNext();
        }
    }

    @Override
    public boolean isValidated() {
        String chosenPath = this.pathSelectionPanel.getPath();
        boolean ok = true;
        boolean modifyinstallation = Boolean.valueOf(this.idata.getVariable("modify.izpack.install"));
        if (modifyinstallation) {
            this.mustExist = true;
            File installationinformation = new File(this.pathSelectionPanel.getPath() + File.separator + ".installationinformation");
            if (!installationinformation.exists()) {
                this.emitError(this.parent.langpack.getString("installer.error"), this.parent.langpack.getString("PathInputPanel.required.forModificationInstallation"));
                return false;
            }
        }
        if (chosenPath.length() == 0) {
            if (this.isMustExist()) {
                this.emitError(this.parent.langpack.getString("installer.error"), this.parent.langpack.getString("PathInputPanel.required"));
                return false;
            }
            ok = this.emitWarning(this.parent.langpack.getString("installer.warning"), this.emptyTargetMsg);
        }
        try {
            if (!FileUtil.isPathValid(chosenPath)) {
                this.emitError(this.parent.langpack.getString("installer.error"), this.getI18nStringForClass("notwritable", "TargetPanel"));
                return false;
            }
        }
        catch (WarningIzpackPathException wipe) {
            ok = this.emitWarning(this.parent.langpack.getString("installer.warning"), wipe.getMessage());
        }
        catch (ErrorIzpackPathException ipe) {
            this.emitError(this.parent.langpack.getString("installer.error"), ipe.getMessage());
            return false;
        }
        if (!ok) {
            return ok;
        }
        File path = new File(chosenPath).getAbsoluteFile();
        chosenPath = path.toString();
        File newDir = null;
        String subDir = null;
        String vString = this.idata.getVariable("ShowCreateDirectoryMessage");
        boolean vStr = vString != null ? Boolean.parseBoolean(vString) : true;
        subDir = this.idata.getVariable("INSTALL_SUBPATH");
        if (subDir != null) {
            newDir = new File(chosenPath + File.separator + subDir);
        }
        this.pathSelectionPanel.setPath(chosenPath);
        if (this.isMustExist()) {
            if (!path.exists()) {
                this.emitError(this.parent.langpack.getString("installer.error"), this.parent.langpack.getString(this.getI18nStringForClass("required", "PathInputPanel")));
                return false;
            }
            if (!this.pathIsValid()) {
                this.emitError(this.parent.langpack.getString("installer.error"), this.parent.langpack.getString(this.getI18nStringForClass("notValid", "PathInputPanel")));
                return false;
            }
        } else {
            if (!this.isWriteable()) {
                this.emitError(this.parent.langpack.getString("installer.error"), this.getI18nStringForClass("notwritable", "TargetPanel"));
                return false;
            }
            if (path.exists()) {
                if (newDir != null && !newDir.exists() && vStr) {
                    ok = this.emitNotificationFeedback(this.getI18nStringForClass("createdir", "TargetPanel") + "\n" + chosenPath + File.separator + this.idata.getVariable("INSTALL_SUBPATH"));
                }
            } else if (vStr) {
                ok = newDir != null ? this.emitNotificationFeedback(this.getI18nStringForClass("createdir", "TargetPanel") + "\n" + chosenPath + File.separator + this.idata.getVariable("INSTALL_SUBPATH")) : this.emitNotificationFeedback(this.getI18nStringForClass("createdir", "TargetPanel") + "\n" + chosenPath);
            }
        }
        return ok;
    }

    protected boolean pathIsValid() {
        if (this.existFiles == null) {
            return true;
        }
        for (String existFile : this.existFiles) {
            File path = new File(this.pathSelectionPanel.getPath(), existFile).getAbsoluteFile();
            if (path.exists()) continue;
            return false;
        }
        return true;
    }

    public boolean isMustExist() {
        return this.mustExist;
    }

    public void setMustExist(boolean b) {
        this.mustExist = b;
    }

    public String[] getExistFiles() {
        return this.existFiles;
    }

    public void setExistFiles(String[] strings) {
        this.existFiles = strings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadDefaultInstallDir(InstallerFrame parentFrame, InstallData idata) {
        if (PathInputPanel.getDefaultInstallDir() != null) {
            return;
        }
        BufferedReader br = null;
        try {
            InputStream in = null;
            String os = System.getProperty("os.name");
            os = os.replace(' ', '_');
            os = os.toLowerCase();
            try {
                in = parentFrame.getResource("TargetPanel.dir.".concat(os));
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
                // empty catch block
            }
            if (in == null) {
                if (OsVersion.IS_WINDOWS) {
                    try {
                        in = parentFrame.getResource("TargetPanel.dir.windows");
                    }
                    catch (ResourceNotFoundException resourceNotFoundException) {}
                } else if (OsVersion.IS_OSX) {
                    try {
                        in = parentFrame.getResource("TargetPanel.dir.macosx");
                    }
                    catch (ResourceNotFoundException resourceNotFoundException) {}
                } else {
                    try {
                        in = parentFrame.getResource("TargetPanel.dir.unix");
                    }
                    catch (ResourceNotFoundException resourceNotFoundException) {
                        // empty catch block
                    }
                }
            }
            if (in == null) {
                try {
                    in = parentFrame.getResource("TargetPanel.dir");
                }
                catch (ResourceNotFoundException resourceNotFoundException) {
                    // empty catch block
                }
            }
            if (in != null) {
                String line;
                InputStreamReader isr = new InputStreamReader(in);
                br = new BufferedReader(isr);
                while ((line = br.readLine()) != null && "".equals(line = line.trim())) {
                }
                defaultInstallDir = line;
                VariableSubstitutor vs = new VariableSubstitutor(idata.getVariables());
                defaultInstallDir = vs.substitute(defaultInstallDir, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            defaultInstallDir = null;
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public boolean isWriteable() {
        File existParent = IoHelper.existingParent(new File(this.pathSelectionPanel.getPath()));
        if (existParent == null) {
            return false;
        }
        if (existParent.isFile()) {
            return true;
        }
        if (OsVersion.IS_WINDOWS) {
            try {
                File tmpFile = File.createTempFile("izWrTe", ".tmp", existParent);
                tmpFile.deleteOnExit();
            }
            catch (IOException e) {
                Debug.log(e);
                return false;
            }
            return true;
        }
        return existParent.canWrite();
    }

    public static String getDefaultInstallDir() {
        return defaultInstallDir;
    }

    public static void setDefaultInstallDir(String string) {
        defaultInstallDir = string;
    }
}

