/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.CorrectWidthJTextField;
import com.izforge.izpack.gui.FocusListenerAutoScroll;
import com.izforge.izpack.gui.FocusListenerRepaint;
import com.izforge.izpack.gui.IzPanelConstraints;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LayoutConstants;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.LayoutHelper;
import com.izforge.izpack.panels.JFocusPanel;
import com.izforge.izpack.panels.UserInputFileFilter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class PathSelectionPanel
extends JPanel
implements ActionListener,
LayoutConstants {
    private static final long serialVersionUID = 3618700794577105718L;
    private JTextField textField;
    private JButton browseButton;
    private IzPanel parent;
    private InstallData idata;
    private boolean allFiles = false;
    private boolean multiSelection = false;
    private String fileExtension;
    private String fileExtensionDescription;

    public PathSelectionPanel() {
        this.allFiles = true;
    }

    public PathSelectionPanel(IzPanel parent, InstallData idata) {
        this.parent = parent;
        this.idata = idata;
        this.allFiles = false;
        this.createLayout();
    }

    public void createLayout() {
        LayoutHelper layoutHelper = new LayoutHelper(this);
        layoutHelper.startLayout(new IzPanelLayout());
        IzPanelConstraints ipc = IzPanelLayout.getDefaultConstraint(1);
        ipc.setXStretch(1.0);
        String panelId = ((IzPanel)this.idata.panels.get(this.idata.curPanelNumber)).getMetadata().getPanelid();
        this.textField = panelId.equals("JDBC Setup Panel") ? new CorrectWidthJTextField(System.getProperty("user.home"), 10) : new CorrectWidthJTextField(this.idata.getInstallPath(), 10);
        this.textField.addFocusListener(new FocusListenerAutoScroll());
        this.textField.addActionListener(this);
        this.parent.setInitialFocus(this.textField);
        JFocusPanel focusBorder = new JFocusPanel(this.textField);
        this.textField.addFocusListener(new FocusListenerRepaint());
        this.add((Component)focusBorder, ipc);
        this.add(IzPanelLayout.createHorizontalFiller(5));
        this.browseButton = ButtonFactory.createButton(this.parent.getInstallerFrame().langpack.getString("TargetPanel.browse"));
        this.browseButton.addFocusListener(new FocusListenerAutoScroll());
        this.browseButton.addActionListener(this);
        this.add(this.browseButton);
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension ss = super.getPreferredSize();
        Dimension retval = this.parent.getSize();
        retval.height = ss.height;
        return retval;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.browseButton) {
            JFileChooser fc = new JFileChooser();
            this.parent.loadFileChooserLang();
            SwingUtilities.updateComponentTreeUI(fc);
            fc.setCurrentDirectory(new File(this.textField.getText()));
            fc.setMultiSelectionEnabled(false);
            if (this.allFiles) {
                fc.setFileSelectionMode(2);
            } else {
                fc.setFileSelectionMode(1);
            }
            if (this.multiSelection) {
                fc.setMultiSelectionEnabled(true);
            }
            fc.addChoosableFileFilter(fc.getAcceptAllFileFilter());
            UserInputFileFilter fileFilter = new UserInputFileFilter();
            if (this.fileExtension != null && this.fileExtensionDescription != null) {
                fileFilter.setFileExt(this.fileExtension);
                fileFilter.setFileExtDesc(this.fileExtensionDescription);
                fc.setFileFilter(fileFilter);
            }
            if (fc.showSaveDialog(this) == 0) {
                if (!this.multiSelection) {
                    String path = fc.getSelectedFile().getAbsolutePath();
                    this.textField.setText(path);
                } else if (this.multiSelection) {
                    File[] files = fc.getSelectedFiles();
                    String finalPath = "";
                    for (File f : files) {
                        finalPath = finalPath + f.getAbsolutePath() + ";";
                    }
                    this.textField.setText(finalPath);
                }
            } else if (this.parent instanceof ActionListener) {
                ((ActionListener)((Object)this.parent)).actionPerformed(e);
            }
        }
    }

    public boolean getAllFiles() {
        return this.allFiles;
    }

    public void setAllFiles(boolean a) {
        this.allFiles = a;
    }

    public boolean getMultiSelection() {
        return this.multiSelection;
    }

    public void setMultiSelection(boolean a) {
        this.multiSelection = a;
    }

    public String getPath() {
        String os = this.idata.getVariable("SYSTEM_os_name");
        String path = this.textField.getText().trim();
        if (!os.contains("Windows")) {
            path = path.replaceFirst("^~", System.getProperty("user.home"));
        }
        if (os.contains("Windows")) {
            path = path.replaceAll("\\\\\\\\", "\\\\");
        }
        this.setPath(path);
        return path;
    }

    public void setPath(String path) {
        this.textField.setText(path);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.textField.setEnabled(isEnabled);
        this.textField.setEditable(isEnabled);
        this.browseButton.setEnabled(isEnabled);
    }

    public JTextField getPathInputField() {
        return this.textField;
    }

    public IzPanel getIzPanel() {
        return this.parent;
    }

    public void setIzPanel(IzPanel parent) {
        this.parent = parent;
    }

    public InstallData getIdata() {
        return this.idata;
    }

    public void setIdata(InstallData idata) {
        this.idata = idata;
    }

    public JButton getBrowseButton() {
        return this.browseButton;
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public void setFileExtensionDescription(String fileExtensionDescription) {
        this.fileExtensionDescription = fileExtensionDescription;
    }
}

