/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.gui.FontResources;
import com.izforge.izpack.gui.GridBagConstraintsFactory;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.gui.ScrollPaneFactory;
import com.izforge.izpack.gui.patternfly.PatternflyProgressBarUI;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ProcessPanelWorker;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.IOException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class ProcessPanel
extends IzPanel
implements AbstractUIProcessHandler {
    private static final long serialVersionUID = 3258417209583155251L;
    private static final String ERROR_STYLE = "error";
    private static final String NORMAL_STYLE = "normal";
    protected JLabel processLabel;
    protected JLabel heading;
    protected JProgressBar overallProgressBar;
    private boolean validated = false;
    private ProcessPanelWorker worker;
    private int noOfJobs = 0;
    private int currentJob = 0;
    private JTextPane outputPane;
    private StyledDocument styleDoc;
    private static boolean finishedWork = false;

    public ProcessPanel(InstallerFrame parent, InstallData idata) throws IOException {
        super(parent, idata);
        this.setLayout(new GridBagLayout());
        this.worker = new ProcessPanelWorker(idata, this);
        this.heading = LabelFactory.createTitleLabel(parent.langpack.getString("ProcessPanel.heading"), !parent.hasBackground);
        this.add((Component)this.heading, GridBagConstraintsFactory.getTitleConstraints());
        GridBagConstraints frameConstraints = GridBagConstraintsFactory.getBasicConstraints();
        frameConstraints.gridy = 1;
        frameConstraints.weightx = 1.0;
        frameConstraints.weighty = 1.0;
        frameConstraints.fill = 1;
        this.add((Component)this.createOutputPanel(), frameConstraints);
    }

    private JPanel createOutputPanel() {
        JPanel subPanel = new JPanel(new GridBagLayout());
        if (this.parent.hasBackground) {
            subPanel.setOpaque(false);
        }
        GridBagConstraints constraints = GridBagConstraintsFactory.getBasicNoInsetsConstraints();
        constraints.fill = 0;
        this.processLabel = new JLabel();
        this.processLabel.setAlignmentX(0.5f);
        this.processLabel.setText(" ");
        this.processLabel.setFont(FontResources.getOpenSansRegular());
        subPanel.add((Component)this.processLabel, constraints);
        constraints.fill = 1;
        ++constraints.gridy;
        this.overallProgressBar = new JProgressBar();
        this.overallProgressBar.setAlignmentX(0.5f);
        this.overallProgressBar.setStringPainted(false);
        this.overallProgressBar.setUI(new PatternflyProgressBarUI());
        constraints.insets.top = 6;
        constraints.insets.bottom = 6;
        subPanel.add((Component)this.overallProgressBar, constraints);
        this.outputPane = new JTextPane();
        this.outputPane.setFont(FontResources.getOpenSansRegular());
        this.outputPane.setEditable(false);
        this.outputPane.setFocusable(false);
        this.styleDoc = this.outputPane.getStyledDocument();
        Style error = this.outputPane.addStyle(ERROR_STYLE, null);
        StyleConstants.setForeground(error, Color.red);
        Style normal = this.outputPane.addStyle(NORMAL_STYLE, null);
        StyleConstants.setForeground(normal, Color.black);
        if (this.parent.hasBackground) {
            this.outputPane.setOpaque(false);
        }
        JScrollPane outputScrollPane = ScrollPaneFactory.createScroller(this.outputPane);
        if (this.parent.hasBackground) {
            outputScrollPane.getViewport().setOpaque(false);
        }
        if (this.parent.hasBackground) {
            outputScrollPane.setOpaque(false);
        }
        ++constraints.gridy;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        subPanel.add((Component)outputScrollPane, constraints);
        return subPanel;
    }

    @Override
    public boolean isValidated() {
        return this.validated;
    }

    @Override
    public void startProcessing(int no_of_jobs) {
        this.noOfJobs = no_of_jobs;
        this.overallProgressBar.setMaximum(no_of_jobs);
        this.overallProgressBar.setIndeterminate(true);
        this.parent.lockPrevButton();
    }

    @Override
    public void finishProcessing(boolean unlockPrev, boolean unlockNext) {
        this.overallProgressBar.setIndeterminate(false);
        String no_of_jobs = Integer.toString(this.noOfJobs);
        this.overallProgressBar.setString(no_of_jobs + " / " + no_of_jobs);
        this.processLabel.setText(" ");
        this.processLabel.setEnabled(false);
        this.validated = true;
        this.idata.installSuccess = this.worker.getSuccessfulInstall();
        this.setHeadingMessage();
        String installResult = this.idata.installSuccess ? "true" : "false";
        this.idata.setVariable("successful.install", installResult);
        if (this.idata.panels.indexOf(this) != this.idata.panels.size() - 1 && unlockNext) {
            this.parent.unlockNextButton();
        }
        if (unlockPrev) {
            this.parent.unlockPrevButton();
        }
        finishedWork = this.idata.installSuccess;
    }

    private void setHeadingMessage() {
        String finishMessage = this.parent.langpack.getString("ProcessPanel.finish.processing");
        String failedMessage = this.parent.langpack.getString("ProcessPanel.failed.processing");
        if (this.idata.installSuccess && finishMessage != null) {
            this.heading.setText(finishMessage);
        } else if (!this.idata.installSuccess && failedMessage != null) {
            this.heading.setText(failedMessage);
        }
    }

    @Override
    public void logOutput(String message, boolean stderr) {
        if (stderr) {
            try {
                this.styleDoc.insertString(this.styleDoc.getLength(), message + '\n', this.outputPane.getStyle(ERROR_STYLE));
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        } else {
            try {
                this.styleDoc.insertString(this.styleDoc.getLength(), message + '\n', this.outputPane.getStyle(NORMAL_STYLE));
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ProcessPanel.this.outputPane.setCaretPosition(Math.max(0, ProcessPanel.this.outputPane.getDocument().getLength() - 1));
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public void startProcess(String jobName) {
        this.processLabel.setText(jobName);
        ++this.currentJob;
        this.overallProgressBar.setValue(this.currentJob);
        this.overallProgressBar.setString(Integer.toString(this.currentJob) + " / " + Integer.toString(this.noOfJobs));
    }

    @Override
    public void finishProcess() {
    }

    @Override
    public void panelActivate() {
        Dimension dim = this.parent.getCenterPanelSize();
        dim.width -= dim.width / 4;
        dim.height = 150;
        this.setMinimumSize(dim);
        this.setMaximumSize(dim);
        this.setPreferredSize(dim);
        this.parent.lockNextButton();
        this.currentJob = 0;
        if (!finishedWork) {
            this.worker.startThread();
        }
    }

    @Override
    public void makeXMLData(IXMLElement panelRoot) {
    }
}

