/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.InstallerException;
import com.izforge.izpack.installer.PanelAutomation;
import com.izforge.izpack.installer.PanelAutomationHelper;
import com.izforge.izpack.installer.ProcessPanelWorker;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import java.io.IOException;

public class ProcessPanelAutomationHelper
extends PanelAutomationHelper
implements PanelAutomation,
AbstractUIProcessHandler {
    private int noOfJobs = 0;
    private int currentJob = 0;

    @Override
    public void makeXMLData(AutomatedInstallData installData, IXMLElement panelRoot) {
    }

    @Override
    public void runAutomated(AutomatedInstallData idata, IXMLElement panelRoot) throws InstallerException {
        try {
            ProcessPanelWorker worker = new ProcessPanelWorker(idata, this);
            worker.run();
            idata.installSuccess = worker.getSuccessfulInstall();
            String installResult = idata.installSuccess ? "true" : "false";
            idata.setVariable("successful.install", installResult);
            if (!worker.getResult()) {
                throw new InstallerException("The work done by the ProcessPanel (line " + panelRoot.getLineNr() + ") failed");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new InstallerException("The work done by the ProcessPanel (line " + panelRoot.getLineNr() + ") failed", e);
        }
    }

    @Override
    public void logOutput(String message, boolean stderr) {
        if (stderr) {
            System.err.println(message);
        } else {
            System.out.println(message);
        }
    }

    @Override
    public void startProcessing(int noOfJobs) {
        System.out.println("[ Starting processing ]");
        this.noOfJobs = noOfJobs;
    }

    @Override
    public void finishProcessing(boolean unlockPrev, boolean unlockNext) {
        System.out.println("[ Processing finished ]");
    }

    @Override
    public void startProcess(String name) {
        ++this.currentJob;
        System.out.println("Starting process " + name + " (" + Integer.toString(this.currentJob) + "/" + Integer.toString(this.noOfJobs) + ")");
    }

    @Override
    public void finishProcess() {
    }
}

