/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.adaptator.impl.XMLParser;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.CorrectWidthJTextField;
import com.izforge.izpack.gui.FontResources;
import com.izforge.izpack.gui.GridBagConstraintsFactory;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.gui.ScrollPaneFactory;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.installer.ResourceNotFoundException;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.panels.ShortcutData;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.ReversePathSubstitutor;
import com.izforge.izpack.util.StringTool;
import com.izforge.izpack.util.TargetFactory;
import com.izforge.izpack.util.UtilityUnpacker;
import com.izforge.izpack.util.VariableSubstitutor;
import com.izforge.izpack.util.os.Shortcut;
import com.izforge.izpack.util.os.Unix_Shortcut;
import com.izforge.izpack.util.os.unix.UnixHelper;
import com.izforge.izpack.util.xml.XMLHelper;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ShortcutPanel
extends IzPanel
implements ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = 3256722870838112311L;
    public static final String SPEC_ATTRIBUTE_CONDITION = "condition";
    public static final String SPEC_ATTRIBUTE_KDE_USERNAME = "KdeUsername";
    public static final String SPEC_ATTRIBUTE_KDE_SUBST_UID = "KdeSubstUID";
    public static final String SPEC_ATTRIBUTE_URL = "url";
    public static final String SPEC_ATTRIBUTE_TYPE = "type";
    public static final String SPEC_ATTRIBUTE_TERMINAL_OPTIONS = "terminalOptions";
    public static final String SPEC_ATTRIBUTE_TERMINAL = "terminal";
    public static final String SPEC_ATTRIBUTE_MIMETYPE = "mimetype";
    public static final String SPEC_ATTRIBUTE_ENCODING = "encoding";
    protected static final String LOCATION_APPLICATIONS = "applications";
    protected static final String LOCATION_START_MENU = "startMenu";
    public static final String SPEC_CATEGORIES = "categories";
    public static final String SPEC_TRYEXEC = "tryexec";
    private static final String SEPARATOR_LINE = "--------------------------------------------------------------------------------";
    private static final String ICONS_PACK_ID = "Icons";
    protected static final String TEXT_FILE_NAME = "Shortcuts.txt";
    protected static final String SPEC_FILE_NAME = "shortcutSpec.xml";
    protected static final String SPEC_KEY_SKIP_IFNOT_SUPPORTED = "skipIfNotSupported";
    protected static final String SPEC_KEY_NOT_SUPPORTED = "notSupported";
    protected static final String SPEC_KEY_DEF_CUR_USER = "defaultCurrentUser";
    protected static final String SPEC_KEY_PROGRAM_GROUP = "programGroup";
    protected static final String SPEC_KEY_SHORTCUT = "shortcut";
    protected static final String SPEC_KEY_PACKS = "createForPack";
    protected static final String SPEC_ATTRIBUTE_DEFAULT_GROUP = "defaultName";
    protected static final String SPEC_ATTRIBUTE_INSTALLGROUP = "installGroup";
    protected static final String SPEC_ATTRIBUTE_LOCATION = "location";
    protected static final String SPEC_ATTRIBUTE_NAME = "name";
    protected static final String SPEC_ATTRIBUTE_SUBGROUP = "subgroup";
    protected static final String SPEC_ATTRIBUTE_DESCRIPTION = "description";
    protected static final String SPEC_ATTRIBUTE_TARGET = "target";
    protected static final String SPEC_ATTRIBUTE_COMMAND = "commandLine";
    protected static final String SPEC_ATTRIBUTE_ICON = "iconFile";
    protected static final String SPEC_ATTRIBUTE_ICON_INDEX = "iconIndex";
    protected static final String SPEC_ATTRIBUTE_WORKING_DIR = "workingDirectory";
    protected static final String SPEC_ATTRIBUTE_INITIAL_STATE = "initialState";
    protected static final String SPEC_ATTRIBUTE_DESKTOP = "desktop";
    protected static final String SPEC_ATTRIBUTE_APPLICATIONS = "applications";
    protected static final String SPEC_ATTRIBUTE_START_MENU = "startMenu";
    protected static final String SPEC_ATTRIBUTE_STARTUP = "startup";
    protected static final String SPEC_ATTRIBUTE_PROGRAM_GROUP = "programGroup";
    protected static final String SPEC_VALUE_APPLICATIONS = "applications";
    protected static final String SPEC_VALUE_START_MENU = "startMenu";
    protected static final String SPEC_VALUE_NO_SHOW = "noShow";
    protected static final String SPEC_VALUE_NORMAL = "normal";
    protected static final String SPEC_VALUE_MAXIMIZED = "maximized";
    protected static final String SPEC_VALUE_MINIMIZED = "minimized";
    public static final String AUTO_KEY_PROGRAM_GROUP = "programGroup";
    public static final String AUTO_KEY_SHORTCUT = "shortcut";
    public static final String AUTO_ATTRIBUTE_NAME = "name";
    public static final String AUTO_ATTRIBUTE_GROUP = "group";
    public static final String AUTO_ATTRIBUTE_TYPE = "type";
    public static final String AUTO_ATTRIBUTE_COMMAND = "commandLine";
    public static final String AUTO_ATTRIBUTE_DESCRIPTION = "description";
    public static final String AUTO_ATTRIBUTE_ICON = "icon";
    public static final String AUTO_ATTRIBUTE_ICON_INDEX = "iconIndex";
    public static final String AUTO_ATTRIBUTE_INITIAL_STATE = "initialState";
    public static final String AUTO_ATTRIBUTE_TARGET = "target";
    public static final String AUTO_ATTRIBUTE_WORKING_DIR = "workingDirectory";
    public static final String CREATE_FOR_ALL = "createForAll";
    public static final String EXCLUDE_OS = "excludeOS";
    public static final String[] invalidWindowsChars = new String[]{"<", ">", ":", "\"", "|", "?", "*", "\\ "};
    public static final String[] invalidUnixChars = new String[]{"\\0", "//", ";", "\\", "/"};
    protected static ShortcutPanel self = null;
    protected static boolean firstTime = true;
    static boolean create;
    public static boolean createImmediately;
    protected static boolean isRootUser;
    protected static Vector<ExecutableFile> execFiles;
    private JList groupList;
    private JTextField programGroup;
    private JButton defaultButton;
    private JButton saveButton;
    private JCheckBox allowDesktopShortcut;
    private JCheckBox createShortcuts;
    private JRadioButton currentUser;
    private JRadioButton allUsers;
    protected static String suggestedProgramGroup;
    protected static String groupName;
    protected static String programGroupIconFile;
    protected static String programGroupComment;
    protected static int groupLocation;
    protected static IXMLElement spec;
    protected static boolean hasDesktopShortcuts;
    protected static boolean skipIfNotSupported;
    protected static boolean defaultCurrentUserFlag;
    protected static Shortcut shortcut;
    protected static Vector shortcuts;
    protected static Vector<String> files;
    protected static boolean shortcutsToCreate;
    protected static boolean haveShortcutSpec;
    protected static boolean simulteNotSupported;
    private File itsProgramFolder;
    protected static int itsUserType;
    public static final String USER_TYPE = "usertype";
    protected static Vector<String> shortCuts;
    private JLabel listLabel;

    public ShortcutPanel(InstallerFrame parent, InstallData installData) {
        super(parent, installData, "link16x16");
        Object con = this.getLayoutHelper().getDefaultConstraints();
        if (!(con instanceof GridBagConstraints)) {
            con = new GridBagConstraints();
        }
        this.setLayout(super.getLayout());
        if (self != null) {
            throw new RuntimeException(this.getClass().getName() + " is not allowed to instantiate more than once!");
        }
        self = this;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object eventSource = event.getSource();
        if (eventSource.equals(this.currentUser)) {
            if (this.groupList != null) {
                this.groupList.setListData(shortcut.getProgramGroups(1));
            }
            this.programGroup.setText(suggestedProgramGroup);
            itsUserType = 1;
            shortcut.setUserType(1);
        } else if (eventSource.equals(this.allUsers)) {
            if (this.groupList != null) {
                this.groupList.setListData(shortcut.getProgramGroups(2));
            }
            this.programGroup.setText(suggestedProgramGroup);
            itsUserType = 2;
            shortcut.setUserType(2);
        } else if (eventSource.equals(this.defaultButton)) {
            if (this.groupList != null && this.groupList.getSelectionModel() != null) {
                this.groupList.getSelectionModel().clearSelection();
            }
            this.programGroup.setText(suggestedProgramGroup);
        } else if (eventSource.equals(this.saveButton)) {
            this.saveToFile();
            ShortcutPanel.addToUninstaller();
        } else if (eventSource.equals(this.createShortcuts)) {
            create = this.createShortcuts.isSelected();
            if (this.groupList != null) {
                this.groupList.setEnabled(create);
            }
            this.programGroup.setEnabled(create);
            this.currentUser.setEnabled(create);
            this.defaultButton.setEnabled(create);
            if (this.allowDesktopShortcut != null) {
                this.allowDesktopShortcut.setEnabled(create);
            }
            if (isRootUser) {
                this.allUsers.setEnabled(create);
            }
        }
    }

    @Override
    public boolean isValidated() {
        if (!this.createShortcuts.isSelected()) {
            return true;
        }
        try {
            groupName = this.programGroup.getText().trim();
        }
        catch (Throwable exception) {
            this.emitError("Error", String.format(this.idata.langpack.getString("ShortcutPanel.group.error"), new Object[0]));
            return false;
        }
        if (groupName.isEmpty()) {
            this.emitError("Error", String.format(this.idata.langpack.getString("ShortcutPanel.group.error"), new Object[0]));
            return false;
        }
        String firstInvalidChar = ShortcutPanel.findFirstInvalidCharInProgramGroup(groupName);
        create = this.createShortcuts.isSelected();
        if (firstInvalidChar != null) {
            this.emitError("Error", String.format(this.idata.langpack.getString("ShortcutPanel.group.character.error"), firstInvalidChar));
            return false;
        }
        this.createAndRegisterShortcuts();
        return true;
    }

    protected static String findFirstInvalidCharInProgramGroup(String groupName) {
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            for (String invalidChar : invalidWindowsChars) {
                if (!groupName.contains(invalidChar)) continue;
                return invalidChar;
            }
        } else {
            for (String invalidChar : invalidUnixChars) {
                if (!groupName.contains(invalidChar)) continue;
                return invalidChar;
            }
        }
        return null;
    }

    @Override
    public void panelActivate() {
        ShortcutPanel.panelActivate(this);
    }

    public static void panelActivate(ShortcutPanel shortcutPan) {
        try {
            ShortcutPanel.readShortcutSpec();
        }
        catch (Throwable exception) {
            System.out.println("could not read shortcut spec!");
            exception.printStackTrace();
        }
        try {
            shortcut = (Shortcut)TargetFactory.getInstance().makeObject("com.izforge.izpack.util.os.Shortcut");
            shortcut.initialize(1, "-");
        }
        catch (Throwable exception) {
            System.out.println("could not create shortcut instance");
            exception.printStackTrace();
        }
        ShortcutPanel.analyzeShortcutSpec();
        if (shortcutsToCreate && !OsVersion.IS_OSX) {
            if (shortcut.supported() && !simulteNotSupported) {
                boolean rUserFlag;
                File allUsersProgramsFolder = ShortcutPanel.getProgramsFolder(2);
                Debug.log("All UsersProgramsFolder: '" + allUsersProgramsFolder + "'");
                File forceTest = new File(allUsersProgramsFolder + File.separator + System.getProperty("user.name") + System.currentTimeMillis());
                try {
                    isRootUser = forceTest.createNewFile();
                }
                catch (Exception e) {
                    isRootUser = false;
                    Debug.log("IOException: '" + e.getLocalizedMessage() + "'");
                    Debug.log("You cannot create '" + forceTest + "'");
                }
                if (forceTest.exists()) {
                    Debug.log("Delete temporary File: '" + forceTest + "'");
                    forceTest.delete();
                }
                String perm = isRootUser ? "can" : "cannot";
                Debug.log("You " + perm + " write into '" + allUsersProgramsFolder + "'");
                if (defaultCurrentUserFlag) {
                    rUserFlag = false;
                    Debug.log("Element 'defaultCurrentUser' was specified");
                } else {
                    rUserFlag = isRootUser;
                }
                itsUserType = rUserFlag ? 2 : 1;
                if (firstTime && shortcutPan != null) {
                    shortcutPan.buildUI(ShortcutPanel.getProgramsFolder(rUserFlag ? 2 : 1));
                }
            } else if (!firstTime || shortcutPan != null) {
                // empty if block
            }
            firstTime = false;
        } else if (shortcutPan != null) {
            shortcutPan.parent.skipPanel();
        }
    }

    protected static File getProgramsFolder(int userType) {
        String path = shortcut.getProgramsFolder(userType);
        return new File(path);
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        if (this.programGroup == null) {
            return;
        }
        String value = "";
        try {
            value = (String)this.groupList.getSelectedValue();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (value == null) {
            value = "";
        }
        this.programGroup.setText(value + File.separator + suggestedProgramGroup);
    }

    protected static void readShortcutSpec() throws Exception {
        InputStream input = null;
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        try {
            input = ResourceManager.getInstance().getInputStream(TargetFactory.getCurrentOSPrefix() + SPEC_FILE_NAME);
        }
        catch (ResourceNotFoundException rnfE) {
            input = ResourceManager.getInstance().getInputStream(SPEC_FILE_NAME);
        }
        if (input == null) {
            haveShortcutSpec = false;
            return;
        }
        VariableSubstitutor substitutor = new VariableSubstitutor(idata.getVariables());
        String substitutedSpec = substitutor.substitute(input, "xml");
        XMLParser parser = new XMLParser();
        spec = parser.parse(substitutedSpec);
        input.close();
        haveShortcutSpec = true;
    }

    protected static void analyzeShortcutSpec() {
        if (!haveShortcutSpec) {
            shortcutsToCreate = false;
            return;
        }
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        IXMLElement skipper = spec.getFirstChildNamed(SPEC_KEY_SKIP_IFNOT_SUPPORTED);
        skipIfNotSupported = skipper != null;
        defaultCurrentUserFlag = spec.getFirstChildNamed(SPEC_KEY_DEF_CUR_USER) != null;
        IXMLElement support = spec.getFirstChildNamed(SPEC_KEY_NOT_SUPPORTED);
        if (support != null) {
            simulteNotSupported = true;
        }
        IXMLElement group = null;
        Vector<IXMLElement> groupSpecs = spec.getChildrenNamed("programGroup");
        String selectedInstallGroup = idata.getVariable("INSTALL_GROUP");
        if (selectedInstallGroup != null) {
            for (IXMLElement g : groupSpecs) {
                String instGrp = g.getAttribute(SPEC_ATTRIBUTE_INSTALLGROUP);
                if (instGrp == null || !selectedInstallGroup.equalsIgnoreCase(instGrp)) continue;
                group = g;
                break;
            }
        }
        if (group == null) {
            group = spec.getFirstChildNamed("programGroup");
        }
        String location = null;
        hasDesktopShortcuts = false;
        if (group != null) {
            suggestedProgramGroup = group.getAttribute(SPEC_ATTRIBUTE_DEFAULT_GROUP, "");
            programGroupIconFile = group.getAttribute(SPEC_ATTRIBUTE_ICON, "");
            programGroupComment = group.getAttribute("comment", "");
            location = group.getAttribute(SPEC_ATTRIBUTE_LOCATION, "applications");
        } else {
            suggestedProgramGroup = "";
            location = "applications";
        }
        if (location.equals("applications")) {
            groupLocation = 1;
        } else if (location.equals("startMenu")) {
            groupLocation = 2;
        }
        Vector<IXMLElement> shortcutSpecs = spec.getChildrenNamed("shortcut");
        shortCuts = new Vector();
        for (int i = 0; i < shortcutSpecs.size(); ++i) {
            Vector<IXMLElement> forPacks;
            IXMLElement shortcutSpec = shortcutSpecs.elementAt(i);
            if (!OsConstraint.oneMatchesCurrentSystem(shortcutSpec)) continue;
            Debug.log("Checking Condition for " + shortcutSpec.getAttribute("name"));
            if (!ShortcutPanel.checkConditions(shortcutSpec)) continue;
            Debug.log("Checked Condition for " + shortcutSpec.getAttribute("name"));
            ShortcutData data = new ShortcutData();
            data.name = shortcutSpec.getAttribute("name");
            data.subgroup = shortcutSpec.getAttribute(SPEC_ATTRIBUTE_SUBGROUP, "");
            data.description = shortcutSpec.getAttribute("description", "");
            data.deskTopEntryLinux_Encoding = shortcutSpec.getAttribute(SPEC_ATTRIBUTE_ENCODING, "");
            data.deskTopEntryLinux_MimeType = shortcutSpec.getAttribute(SPEC_ATTRIBUTE_MIMETYPE, "");
            data.deskTopEntryLinux_Terminal = shortcutSpec.getAttribute(SPEC_ATTRIBUTE_TERMINAL, "");
            data.deskTopEntryLinux_TerminalOptions = shortcutSpec.getAttribute(SPEC_ATTRIBUTE_TERMINAL_OPTIONS, "");
            data.deskTopEntryLinux_Type = shortcutSpec.getAttribute("type", "");
            data.deskTopEntryLinux_URL = shortcutSpec.getAttribute(SPEC_ATTRIBUTE_URL, "");
            data.deskTopEntryLinux_X_KDE_SubstituteUID = shortcutSpec.getAttribute(SPEC_ATTRIBUTE_KDE_SUBST_UID, "false");
            data.deskTopEntryLinux_X_KDE_UserName = shortcutSpec.getAttribute(SPEC_ATTRIBUTE_KDE_USERNAME, "root");
            data.Categories = shortcutSpec.getAttribute(SPEC_CATEGORIES, "");
            data.TryExec = shortcutSpec.getAttribute(SPEC_TRYEXEC, "");
            data.createForAll = Boolean.valueOf(shortcutSpec.getAttribute(CREATE_FOR_ALL, "false"));
            data.excludeOS = shortcutSpec.getAttribute(EXCLUDE_OS, "");
            data.target = ShortcutPanel.fixSeparatorChar(shortcutSpec.getAttribute("target", ""));
            data.commandLine = shortcutSpec.getAttribute("commandLine", "");
            data.iconFile = ShortcutPanel.fixSeparatorChar(shortcutSpec.getAttribute(SPEC_ATTRIBUTE_ICON, ""));
            data.iconIndex = Integer.parseInt(shortcutSpec.getAttribute("iconIndex", "0"));
            data.workingDirectory = ShortcutPanel.fixSeparatorChar(shortcutSpec.getAttribute("workingDirectory", ""));
            String initialState = shortcutSpec.getAttribute("initialState", "");
            data.initialState = initialState.equals(SPEC_VALUE_NO_SHOW) ? 0 : (initialState.equals(SPEC_VALUE_NORMAL) ? 1 : (initialState.equals(SPEC_VALUE_MAXIMIZED) ? 3 : (initialState.equals(SPEC_VALUE_MINIMIZED) ? 2 : 1)));
            if (data.name == null) continue;
            if (data.target == null) {
                data.target = "";
            }
            if (!ShortcutPanel.shortcutRequiredFor(forPacks = shortcutSpec.getChildrenNamed(SPEC_KEY_PACKS))) continue;
            if (XMLHelper.attributeIsTrue(shortcutSpec, SPEC_ATTRIBUTE_DESKTOP)) {
                hasDesktopShortcuts = true;
                data.addToGroup = false;
                data.type = 3;
                shortcuts.add(data.clone());
            }
            if (XMLHelper.attributeIsTrue(shortcutSpec, "applications")) {
                data.addToGroup = false;
                data.type = 1;
                shortcuts.add(data.clone());
            }
            if (XMLHelper.attributeIsTrue(shortcutSpec, "startMenu")) {
                data.addToGroup = false;
                data.type = 2;
                shortcuts.add(data.clone());
            }
            if (XMLHelper.attributeIsTrue(shortcutSpec, SPEC_ATTRIBUTE_STARTUP)) {
                data.addToGroup = false;
                data.type = 4;
                shortcuts.add(data.clone());
            }
            if (XMLHelper.attributeIsTrue(shortcutSpec, "programGroup")) {
                data.addToGroup = true;
                data.type = 1;
                shortcuts.add(data.clone());
            }
            shortCuts.add(data.name == null ? "" : data.name);
        }
        if (shortcuts.size() > 0) {
            shortcutsToCreate = true;
        }
    }

    protected static boolean checkConditions(IXMLElement shortcutSpec) {
        boolean result = true;
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        String conditionid = shortcutSpec.getAttribute(SPEC_ATTRIBUTE_CONDITION);
        if (conditionid != null) {
            result = idata.getRules().isConditionTrue(conditionid);
        }
        return result;
    }

    public void createAndRegisterShortcuts() {
        this.parent.lockNextButton();
        ShortcutPanel.createShortcuts(this);
        this.parent.unlockNextButton();
        ShortcutPanel.addToUninstaller();
    }

    protected static String createXDGMenu(ArrayList shortcuts, String menuName) {
        String menuConfigText = "<Menu>\n<Name>Applications</Name>\n<Menu>\n<Directory>" + menuName.replaceAll(" ", "-") + "-izpack.directory</Directory>\n<Name>" + menuName + "</Name>\n<Include>\n";
        for (Object shortcut1 : shortcuts) {
            String shortcutFile = (String)shortcut1;
            menuConfigText = menuConfigText + "<Filename>" + shortcutFile + "</Filename>\n";
        }
        menuConfigText = menuConfigText + "</Include>\n</Menu>\n</Menu>";
        return menuConfigText;
    }

    protected static String createXDGDirectory(String menuName, String icon, String comment) {
        String menuDirectoryDescriptor = "[Desktop Entry]\nName=$Name\nComment=$Comment\nIcon=$Icon\nType=Directory\nEncoding=UTF-8";
        menuDirectoryDescriptor = StringTool.replace(menuDirectoryDescriptor, "$Name", menuName);
        menuDirectoryDescriptor = StringTool.replace(menuDirectoryDescriptor, "$Comment", comment);
        menuDirectoryDescriptor = StringTool.replace(menuDirectoryDescriptor, "$Icon", icon);
        return menuDirectoryDescriptor;
    }

    protected static void writeXDGMenuFile(ArrayList desktopFileNames, String groupName, String icon, String comment) {
        if ("".equals(suggestedProgramGroup) || suggestedProgramGroup == null) {
            return;
        }
        if (OsVersion.IS_UNIX) {
            String directoryFolder;
            String gnome3MenuFolder;
            String menuFolder;
            String menuFile = ShortcutPanel.createXDGMenu(desktopFileNames, groupName);
            String dirFile = ShortcutPanel.createXDGDirectory(groupName, icon, comment);
            if (itsUserType == 2) {
                menuFolder = "/etc/xdg/menus/applications-merged/";
                gnome3MenuFolder = "/etc/xdg/menus/applications-gnome-merged/";
                directoryFolder = "/usr/share/desktop-directories/";
            } else {
                menuFolder = System.getProperty("user.home") + File.separator + ".config/menus/applications-merged/";
                gnome3MenuFolder = System.getProperty("user.home") + File.separator + ".config/menus/applications-gnome-merged/";
                directoryFolder = System.getProperty("user.home") + File.separator + ".local/share/desktop-directories/";
            }
            File menuFolderFile = new File(menuFolder);
            File gnome3MenuFolderFile = new File(gnome3MenuFolder);
            File directoryFolderFile = new File(directoryFolder);
            String menuFilePath = menuFolder + groupName + ".menu";
            String menuFilePathGnome3 = gnome3MenuFolder + groupName + ".menu";
            String dirFilePath = directoryFolder + groupName.replaceAll(" ", "-") + "-izpack.directory";
            menuFolderFile.mkdirs();
            gnome3MenuFolderFile.mkdirs();
            directoryFolderFile.mkdirs();
            ShortcutPanel.writeString(menuFile, menuFilePath);
            ShortcutPanel.writeString(menuFile, menuFilePathGnome3);
            ShortcutPanel.writeString(dirFile, dirFilePath);
        }
    }

    protected static void writeString(String str, String file) {
        boolean failed = false;
        try {
            FileWriter writer = new FileWriter(file);
            writer.write(str);
            writer.close();
        }
        catch (Exception ignore) {
            failed = true;
            Debug.log("Failed to create menu for gnome.");
        }
        if (!failed) {
            UninstallData.getInstance().addFile(file, true);
        }
    }

    public static void createShortcuts(ShortcutPanel shortPanel) {
        if (!create) {
            return;
        }
        UtilityUnpacker.unpack(ICONS_PACK_ID);
        String gn = groupName;
        if (shortPanel != null) {
            shortPanel.setCursor(Cursor.getPredefinedCursor(3));
        }
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        ArrayList<String> startMenuShortcuts = new ArrayList<String>();
        if (shortPanel == null) {
            System.out.print("[ Creating shortcuts ");
        }
        for (int i = 0; i < shortcuts.size(); ++i) {
            ShortcutData data = (ShortcutData)shortcuts.elementAt(i);
            if (shortPanel == null) {
                System.out.print(".");
            }
            VariableSubstitutor vs = new VariableSubstitutor(idata.getVariables());
            try {
                gn = groupName + data.subgroup;
                shortcut.setUserType(itsUserType);
                shortcut.setLinkName(data.name);
                shortcut.setLinkType(data.type);
                shortcut.setArguments(vs.substitute(data.commandLine, null));
                shortcut.setDescription(data.description);
                shortcut.setIconLocation(data.iconFile, data.iconIndex);
                shortcut.setShowCommand(data.initialState);
                shortcut.setTargetPath(data.target);
                shortcut.setWorkingDirectory(data.workingDirectory);
                shortcut.setEncoding(data.deskTopEntryLinux_Encoding);
                shortcut.setMimetype(data.deskTopEntryLinux_MimeType);
                shortcut.setTerminal(data.deskTopEntryLinux_Terminal);
                shortcut.setTerminalOptions(data.deskTopEntryLinux_TerminalOptions);
                shortcut.setType(data.deskTopEntryLinux_Type);
                shortcut.setKdeSubstUID(data.deskTopEntryLinux_X_KDE_SubstituteUID);
                shortcut.setKdeUserName(data.deskTopEntryLinux_X_KDE_UserName);
                shortcut.setURL(data.deskTopEntryLinux_URL);
                shortcut.setTryExec(data.TryExec);
                shortcut.setCategories(data.Categories);
                shortcut.setCreateForAll(data.createForAll);
                shortcut.setExcludeOS(data.excludeOS);
                shortcut.setUninstaller(UninstallData.getInstance());
                if (data.addToGroup) {
                    shortcut.setProgramGroup(gn);
                } else {
                    shortcut.setProgramGroup("");
                }
                List<String> ExcludeOsArray = Arrays.asList(shortcut.getExcludeOS().split(","));
                String OS = System.getProperty("os.name");
                if (ExcludeOsArray.contains(OS)) continue;
                try {
                    Unix_Shortcut unixcut;
                    String f;
                    if (data.type == 3 && (data.type != 3 || shortPanel == null || !shortPanel.allowDesktopShortcut.isSelected())) continue;
                    shortcut.save();
                    if ((data.type == 1 || data.addToGroup) && shortcut instanceof Unix_Shortcut && (f = (unixcut = (Unix_Shortcut)shortcut).getWrittenFileName()) != null) {
                        startMenuShortcuts.add(f);
                    }
                    String fileName = shortcut.getFileName();
                    files.add(fileName);
                    File file = new File(fileName);
                    File base = new File(shortcut.getBasePath());
                    Vector<File> intermediates = new Vector<File>();
                    execFiles.add(new ExecutableFile(fileName, 2, 3, new ArrayList<OsConstraint>(), false));
                    while ((file = file.getParentFile()) != null && !file.equals(base)) {
                        intermediates.add(file);
                    }
                    if (file == null) continue;
                    Enumeration filesEnum = intermediates.elements();
                    while (filesEnum.hasMoreElements()) {
                        files.add(0, ((File)filesEnum.nextElement()).toString());
                    }
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    continue;
                }
            }
            catch (Throwable exception) {
                exception.printStackTrace();
            }
        }
        if (OsVersion.IS_UNIX) {
            ShortcutPanel.writeXDGMenuFile(startMenuShortcuts, groupName, programGroupIconFile, programGroupComment);
        }
        shortcut.execPostAction();
        shortcut.cleanUp();
        if (shortPanel != null) {
            shortPanel.setCursor(Cursor.getDefaultCursor());
        } else {
            System.out.print(" ]\n");
        }
    }

    protected static boolean shortcutRequiredFor(Vector<IXMLElement> packs) {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        if (packs.size() == 0) {
            return true;
        }
        for (int i = 0; i < idata.selectedPacks.size(); ++i) {
            String selected = idata.selectedPacks.get((int)i).name;
            for (int k = 0; k < packs.size(); ++k) {
                String required = packs.elementAt(k).getAttribute("name", "");
                if (!selected.equals(required)) continue;
                return true;
            }
        }
        return false;
    }

    protected static String fixSeparatorChar(String path) {
        String newPath = path.replace('/', File.separatorChar);
        newPath = newPath.replace('\\', File.separatorChar);
        return newPath;
    }

    private void buildUI(File groups) {
        JLabel title = LabelFactory.createTitleLabel(this.parent.langpack.getString("ShortcutPanel.title"), false);
        this.add((Component)title, GridBagConstraintsFactory.getTitleConstraints());
        GridBagConstraints frameConstraints = GridBagConstraintsFactory.getBasicConstraints();
        frameConstraints.fill = 2;
        frameConstraints.gridy = 1;
        this.add((Component)this.createStartMenuCheckBoxPanel(), frameConstraints);
        frameConstraints.gridy = 2;
        this.add((Component)this.createDesktopShortcutsCheckBoxPanel(), frameConstraints);
        frameConstraints.gridy = 3;
        this.add((Component)this.createListLabel(), frameConstraints);
        frameConstraints.gridy = 4;
        frameConstraints.weightx = 1.0;
        frameConstraints.weighty = 1.0;
        frameConstraints.fill = 1;
        this.add((Component)this.createListComponentPanel(groups), frameConstraints);
        frameConstraints.fill = 2;
        frameConstraints.weightx = 0.0;
        frameConstraints.weighty = 0.0;
        frameConstraints.gridy = 5;
        this.add((Component)this.createUserRadioButtonsPanel(), frameConstraints);
        frameConstraints.gridy = 6;
        this.add((Component)this.createSuggestedProgramGroupPanel(), frameConstraints);
        frameConstraints.gridy = 7;
        frameConstraints.weightx = 1.0;
        frameConstraints.weighty = 1.0;
        frameConstraints.fill = 1;
        this.add(Box.createGlue(), frameConstraints);
        this.createShortcuts.getRootPane().grabFocus();
    }

    private JPanel createStartMenuCheckBoxPanel() {
        JPanel startMenuCheckBoxPanel = new JPanel(new GridBagLayout());
        String menuKind = this.parent.langpack.getString("ShortcutPanel.regular.StartMenu:Start-Menu");
        if (OsVersion.IS_UNIX && UnixHelper.kdeIsInstalled()) {
            menuKind = this.parent.langpack.getString("ShortcutPanel.regular.StartMenu:K-Menu");
        }
        this.createShortcuts = new JCheckBox(StringTool.replace(this.parent.langpack.getString("ShortcutPanel.regular.create"), "StartMenu", menuKind), true);
        if (this.parent.hasBackground) {
            this.createShortcuts.setOpaque(false);
        }
        this.createShortcuts.addActionListener(this);
        this.parent.setFocus(this.createShortcuts);
        this.setInitialFocus(this.createShortcuts);
        GridBagConstraints constraints = GridBagConstraintsFactory.getBasicNoInsetsConstraints();
        constraints.fill = 1;
        constraints.anchor = 18;
        startMenuCheckBoxPanel.add((Component)this.createShortcuts, constraints);
        ++constraints.gridx;
        constraints.weightx = 1.0;
        startMenuCheckBoxPanel.add(Box.createGlue(), constraints);
        return startMenuCheckBoxPanel;
    }

    private JPanel createDesktopShortcutsCheckBoxPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        if (hasDesktopShortcuts) {
            String initialAllowedValue = this.idata.getVariable("DesktopShortcutCheckboxEnabled");
            boolean initialAllowedFlag = false;
            if (initialAllowedValue == null) {
                initialAllowedFlag = false;
            } else if (Boolean.TRUE.toString().equals(initialAllowedValue)) {
                initialAllowedFlag = true;
            }
            this.allowDesktopShortcut = new JCheckBox(this.parent.langpack.getString("ShortcutPanel.regular.desktop"), initialAllowedFlag);
            if (this.parent.hasBackground) {
                this.allowDesktopShortcut.setOpaque(false);
            }
            this.allowDesktopShortcut.setActionCommand("Checked = create desktop shortcuts");
            AccessibleContext ac = this.allowDesktopShortcut.getAccessibleContext();
            ac.setAccessibleDescription("This JCheckBox indicates whether or not desktop shortcuts should be created");
            GridBagConstraints constraints = GridBagConstraintsFactory.getBasicNoInsetsConstraints();
            panel.add((Component)this.allowDesktopShortcut, constraints);
        }
        return panel;
    }

    private JLabel createListLabel() {
        this.listLabel = LabelFactory.create(this.parent.langpack.getString("ShortcutPanel.regular.list"));
        this.listLabel.setFont(FontResources.getOpenSansRegular());
        if (!OsVersion.IS_WINDOWS) {
            this.listLabel.setVisible(false);
        }
        return this.listLabel;
    }

    private JPanel createListComponentPanel(File groups) {
        JPanel panel = new JPanel(new GridBagLayout());
        Vector<String> dirEntries = new Vector<String>();
        File[] entries = groups.listFiles();
        if (entries != null && !OsVersion.IS_UNIX) {
            for (File entry : entries) {
                if (!entry.isDirectory()) continue;
                dirEntries.add(entry.getName());
            }
        }
        if (OsVersion.IS_WINDOWS) {
            if (this.groupList == null) {
                this.groupList = new JList();
                this.groupList.setFont(FontResources.getOpenSansRegular());
            }
            GridBagConstraints constraints = GridBagConstraintsFactory.getBasicNoInsetsConstraints();
            constraints.fill = 1;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            panel.add((Component)this.getListComponent(dirEntries, 0, this.groupList), constraints);
        } else {
            panel.setVisible(false);
        }
        return panel;
    }

    private JPanel createUserRadioButtonsPanel() {
        JPanel usersPanel = new JPanel(new GridLayout(2, 1));
        if (shortcut.multipleUsers()) {
            boolean rUserFlag;
            boolean bl = rUserFlag = defaultCurrentUserFlag ? false : isRootUser;
            if (this.parent.hasBackground) {
                usersPanel.setOpaque(false);
            }
            ButtonGroup usersGroup = new ButtonGroup();
            this.currentUser = new JRadioButton(this.parent.langpack.getString("ShortcutPanel.regular.currentUser"), !rUserFlag);
            this.currentUser.setFont(FontResources.getOpenSansRegular());
            if (this.parent.hasBackground) {
                this.currentUser.setOpaque(false);
            }
            this.currentUser.addActionListener(this);
            usersGroup.add(this.currentUser);
            usersPanel.add(this.currentUser);
            this.allUsers = new JRadioButton(this.parent.langpack.getString("ShortcutPanel.regular.allUsers"), rUserFlag);
            Debug.log("allUsers.setEnabled(), I'm Root: " + isRootUser);
            this.allUsers.setEnabled(isRootUser);
            if (this.parent.hasBackground) {
                this.allUsers.setOpaque(false);
            }
            this.allUsers.addActionListener(this);
            usersGroup.add(this.allUsers);
            usersPanel.add(this.allUsers);
            TitledBorder border = new TitledBorder(new EmptyBorder(2, 2, 2, 2), this.parent.langpack.getString("ShortcutPanel.regular.userIntro"));
            usersPanel.setBorder(border);
        }
        return usersPanel;
    }

    private JPanel createSuggestedProgramGroupPanel() {
        JPanel programGroupPanel = new JPanel(new GridBagLayout());
        this.programGroup = new CorrectWidthJTextField(suggestedProgramGroup);
        GridBagConstraints panelConstraints = GridBagConstraintsFactory.getBasicNoInsetsConstraints();
        panelConstraints.fill = 1;
        panelConstraints.weightx = 1.0;
        programGroupPanel.add((Component)this.programGroup, panelConstraints);
        this.defaultButton = ButtonFactory.createButton(this.parent.langpack.getString("ShortcutPanel.regular.default"));
        this.defaultButton.addActionListener(this);
        ++panelConstraints.gridx;
        panelConstraints.weightx = 0.0;
        panelConstraints.fill = 0;
        panelConstraints.insets = new Insets(0, 5, 0, 0);
        programGroupPanel.add((Component)this.defaultButton, panelConstraints);
        if (suggestedProgramGroup == null || "".equals(suggestedProgramGroup)) {
            this.programGroup.setVisible(false);
            this.defaultButton.setVisible(false);
            this.listLabel.setVisible(false);
        }
        return programGroupPanel;
    }

    private void addFrameSpaceFiller() {
        GridBagConstraints frameConstraints = GridBagConstraintsFactory.getBasicConstraints();
        frameConstraints.gridy = 7;
        frameConstraints.fill = 1;
        frameConstraints.weightx = 1.0;
        frameConstraints.weighty = 1.0;
        this.add(Box.createGlue(), frameConstraints);
    }

    private JScrollPane getListComponent(Vector<String> Entries, int ListModel2, JList aJList) {
        if (aJList == null) {
            aJList = new JList<String>(Entries);
        } else {
            aJList.setListData(Entries);
        }
        aJList.setSelectionMode(ListModel2);
        aJList.getSelectionModel().addListSelectionListener(this);
        if (this.parent.hasBackground) {
            aJList.setOpaque(false);
        }
        JScrollPane scrollPane = ScrollPaneFactory.createScroller(aJList);
        if (this.parent.hasBackground) {
            scrollPane.getViewport().setOpaque(false);
        }
        if (this.parent.hasBackground) {
            scrollPane.setOpaque(false);
        }
        return scrollPane;
    }

    private void buildAlternateUI() {
    }

    @Override
    public Dimension getSize() {
        Dimension size = this.getParent().getSize();
        Insets insets = this.getInsets();
        Border border = this.getBorder();
        Insets borderInsets = new Insets(0, 0, 0, 0);
        if (border != null) {
            borderInsets = border.getBorderInsets(this);
        }
        size.height = size.height - insets.top - insets.bottom - borderInsets.top - borderInsets.bottom - 50;
        size.width = size.width - insets.left - insets.right - borderInsets.left - borderInsets.right - 50;
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToFile() {
        File file = null;
        JFileChooser fileDialog = new JFileChooser(this.idata.getInstallPath());
        fileDialog.setSelectedFile(new File(TEXT_FILE_NAME));
        if (fileDialog.showSaveDialog(this) != 0) {
            return;
        }
        file = fileDialog.getSelectedFile();
        FileWriter output = null;
        StringBuffer buffer = new StringBuffer();
        String header = this.parent.langpack.getString("ShortcutPanel.textFile.header");
        String newline = System.getProperty("line.separator", "\n");
        try {
            output = new FileWriter(file);
        }
        catch (Throwable exception) {
            return;
        }
        int nextIndex = 0;
        int currentIndex = 0;
        do {
            if ((nextIndex = header.indexOf("\\n", currentIndex)) > -1) {
                buffer.append(header.substring(currentIndex, nextIndex));
                buffer.append(newline);
                currentIndex = nextIndex + 2;
                continue;
            }
            buffer.append(header.substring(currentIndex, header.length()));
            buffer.append(newline);
        } while (nextIndex > -1);
        buffer.append(SEPARATOR_LINE);
        buffer.append(newline);
        buffer.append(newline);
        for (int i = 0; i < shortcuts.size(); ++i) {
            ShortcutData data = (ShortcutData)shortcuts.elementAt(i);
            buffer.append(this.parent.langpack.getString("ShortcutPanel.textFile.name"));
            buffer.append(data.name);
            buffer.append(newline);
            buffer.append(this.parent.langpack.getString("ShortcutPanel.textFile.location"));
            switch (data.type) {
                case 3: {
                    buffer.append(this.parent.langpack.getString("ShortcutPanel.location.desktop"));
                    break;
                }
                case 1: {
                    buffer.append(this.parent.langpack.getString("ShortcutPanel.location.applications"));
                    break;
                }
                case 2: {
                    buffer.append(this.parent.langpack.getString("ShortcutPanel.location.startMenu"));
                    break;
                }
                case 4: {
                    buffer.append(this.parent.langpack.getString("ShortcutPanel.location.startup"));
                }
            }
            buffer.append(newline);
            buffer.append(this.parent.langpack.getString("ShortcutPanel.textFile.description"));
            buffer.append(data.description);
            buffer.append(newline);
            buffer.append(this.parent.langpack.getString("ShortcutPanel.textFile.target"));
            buffer.append(data.target);
            buffer.append(newline);
            buffer.append(this.parent.langpack.getString("ShortcutPanel.textFile.command"));
            buffer.append(data.commandLine);
            buffer.append(newline);
            buffer.append(this.parent.langpack.getString("ShortcutPanel.textFile.iconName"));
            buffer.append(data.iconFile);
            buffer.append(newline);
            buffer.append(this.parent.langpack.getString("ShortcutPanel.textFile.iconIndex"));
            buffer.append(data.iconIndex);
            buffer.append(newline);
            buffer.append(this.parent.langpack.getString("ShortcutPanel.textFile.work"));
            buffer.append(data.workingDirectory);
            buffer.append(newline);
            buffer.append(newline);
            buffer.append(SEPARATOR_LINE);
            buffer.append(newline);
            buffer.append(newline);
        }
        try {
            output.write(buffer.toString());
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                output.flush();
                output.close();
                files.add(file.getPath());
            }
            catch (Throwable throwable) {}
        }
    }

    protected static void addToUninstaller() {
        UninstallData uninstallData = UninstallData.getInstance();
        for (int i = 0; i < files.size(); ++i) {
            uninstallData.addFile(files.elementAt(i), true);
        }
    }

    public static ShortcutPanel getInstance() {
        return self;
    }

    @Override
    public void makeXMLData(IXMLElement panelRoot) {
        ShortcutPanel.xmlShortcut(panelRoot, this);
    }

    protected static void xmlShortcut(IXMLElement panelRoot, ShortcutPanel shortcutPanel) {
        Debug.log("entering makeXMLData");
        if (!shortcutsToCreate || !shortcut.supported() || groupName == null || simulteNotSupported || !create) {
            Debug.log("abort makeXMLData!");
            return;
        }
        String installPathVariable = "INSTALL_PATH";
        XMLElementImpl dataElement = new XMLElementImpl("programGroup", panelRoot);
        dataElement.setAttribute("name", groupName);
        panelRoot.addChild(dataElement);
        for (int i = 0; i < shortcuts.size(); ++i) {
            Debug.log("entering makeXMLData");
            ShortcutData data = (ShortcutData)shortcuts.elementAt(i);
            dataElement = new XMLElementImpl("shortcut", panelRoot);
            dataElement.setAttribute("name", data.name);
            dataElement.setAttribute(AUTO_ATTRIBUTE_GROUP, (data.addToGroup ? Boolean.TRUE : Boolean.FALSE).toString());
            if (OsVersion.IS_WINDOWS) {
                dataElement.setAttribute("type", Integer.toString(data.type));
            }
            dataElement.setAttribute("commandLine", ReversePathSubstitutor.substitute(installPathVariable, data.commandLine));
            dataElement.setAttribute("description", data.description);
            dataElement.setAttribute(AUTO_ATTRIBUTE_ICON, ReversePathSubstitutor.substitute(installPathVariable, data.iconFile));
            dataElement.setAttribute("iconIndex", Integer.toString(data.iconIndex));
            dataElement.setAttribute("initialState", Integer.toString(data.initialState));
            dataElement.setAttribute("target", ReversePathSubstitutor.substitute(installPathVariable, data.target));
            dataElement.setAttribute("workingDirectory", data.workingDirectory);
            dataElement.setAttribute(SPEC_ATTRIBUTE_ENCODING, data.deskTopEntryLinux_Encoding);
            dataElement.setAttribute(SPEC_ATTRIBUTE_MIMETYPE, data.deskTopEntryLinux_MimeType);
            dataElement.setAttribute(SPEC_ATTRIBUTE_TERMINAL, data.deskTopEntryLinux_Terminal);
            dataElement.setAttribute(SPEC_ATTRIBUTE_TERMINAL_OPTIONS, data.deskTopEntryLinux_TerminalOptions);
            if (!OsVersion.IS_WINDOWS) {
                dataElement.setAttribute("type", data.deskTopEntryLinux_Type);
            }
            dataElement.setAttribute(SPEC_ATTRIBUTE_URL, data.deskTopEntryLinux_URL);
            dataElement.setAttribute(SPEC_ATTRIBUTE_KDE_SUBST_UID, data.deskTopEntryLinux_X_KDE_SubstituteUID);
            dataElement.setAttribute(SPEC_CATEGORIES, data.Categories);
            dataElement.setAttribute(SPEC_TRYEXEC, data.TryExec);
            dataElement.setAttribute(CREATE_FOR_ALL, data.createForAll.toString());
            dataElement.setAttribute(USER_TYPE, Integer.toString(data.userType));
            dataElement.setAttribute(EXCLUDE_OS, data.excludeOS);
            if (data.type == 3 && (data.type != 3 || shortcutPanel == null || !shortcutPanel.allowDesktopShortcut.isSelected())) continue;
            panelRoot.addChild(dataElement);
        }
    }

    protected static boolean verifyProgramGroup(String groupName) {
        boolean validationFailed = false;
        if (groupName.isEmpty()) {
            validationFailed = true;
        }
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            for (String invalidChar : invalidWindowsChars) {
                if (!groupName.contains(invalidChar)) continue;
                validationFailed = true;
                break;
            }
        } else {
            for (String invalidChar : invalidUnixChars) {
                if (!groupName.contains(invalidChar)) continue;
                validationFailed = true;
                break;
            }
        }
        return !validationFailed;
    }

    static {
        createImmediately = true;
        execFiles = new Vector();
        hasDesktopShortcuts = false;
        skipIfNotSupported = false;
        defaultCurrentUserFlag = false;
        shortcuts = new Vector();
        files = new Vector();
        shortcutsToCreate = false;
        haveShortcutSpec = false;
        simulteNotSupported = false;
    }
}

