/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.PanelAutomation;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.panels.ShortcutData;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.StringTool;
import com.izforge.izpack.util.TargetFactory;
import com.izforge.izpack.util.UtilityUnpacker;
import com.izforge.izpack.util.VariableSubstitutor;
import com.izforge.izpack.util.os.Shortcut;
import com.izforge.izpack.util.os.Unix_Shortcut;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

public class ShortcutPanelAutomationHelper
implements PanelAutomation {
    @Override
    public void makeXMLData(AutomatedInstallData idata, IXMLElement panelRoot) {
        Debug.log(this.getClass().getName() + "::entering makeXMLData()");
    }

    @Override
    public void runAutomated(AutomatedInstallData installData, IXMLElement panelRoot) {
        ShortcutData data;
        Shortcut shortcut;
        Vector<ShortcutData> shortcuts = new Vector<ShortcutData>();
        Vector<ExecutableFile> execFiles = new Vector<ExecutableFile>();
        Vector<String> files = new Vector<String>();
        Debug.log(this.getClass().getName() + " Entered runAutomated()");
        try {
            shortcut = (Shortcut)TargetFactory.getInstance().makeObject("com.izforge.izpack.util.os.Shortcut");
            shortcut.initialize(1, "-");
        }
        catch (Throwable exception) {
            Debug.log("Could not create shortcut instance");
            exception.printStackTrace();
            return;
        }
        if (!shortcut.supported()) {
            Debug.log("shortcuts not supported here");
            return;
        }
        if (!OsConstraint.oneMatchesCurrentSystem(panelRoot)) {
            Debug.log("Shortcuts Not oneMatchesCurrentSystem");
            return;
        }
        shortcuts = new Vector();
        IXMLElement dataElement = panelRoot.getFirstChildNamed("programGroup");
        String groupName = null;
        if (dataElement != null) {
            groupName = dataElement.getAttribute("name");
        }
        if (groupName == null) {
            groupName = "";
        }
        Vector<IXMLElement> shortcutElements = panelRoot.getChildrenNamed("shortcut");
        VariableSubstitutor vs = new VariableSubstitutor(installData.getVariables());
        for (int i = 0; i < shortcutElements.size(); ++i) {
            Debug.log(this.getClass().getName() + "runAutomated:shortcutElements " + i);
            data = new ShortcutData();
            dataElement = shortcutElements.elementAt(i);
            data.name = dataElement.getAttribute("name");
            data.addToGroup = Boolean.valueOf(dataElement.getAttribute("group"));
            if (OsVersion.IS_WINDOWS) {
                data.type = Integer.valueOf(dataElement.getAttribute("type"));
            } else {
                Debug.log("WARN: On Linux data.type is NOT an int. Ignored.");
            }
            data.commandLine = vs.substitute(dataElement.getAttribute("commandLine"));
            data.description = dataElement.getAttribute("description");
            data.iconFile = vs.substitute(dataElement.getAttribute("icon"));
            data.iconIndex = Integer.valueOf(dataElement.getAttribute("iconIndex"));
            data.initialState = Integer.valueOf(dataElement.getAttribute("initialState"));
            data.target = vs.substitute(dataElement.getAttribute("target"));
            data.workingDirectory = dataElement.getAttribute("workingDirectory");
            data.excludeOS = dataElement.getAttribute("excludeOS", "");
            data.deskTopEntryLinux_Encoding = dataElement.getAttribute("encoding", "");
            data.deskTopEntryLinux_MimeType = dataElement.getAttribute("mimetype", "");
            data.deskTopEntryLinux_Terminal = dataElement.getAttribute("terminal", "");
            data.deskTopEntryLinux_TerminalOptions = dataElement.getAttribute("terminalOptions", "");
            data.deskTopEntryLinux_Type = dataElement.getAttribute("type", "");
            data.deskTopEntryLinux_URL = dataElement.getAttribute("url", "");
            data.deskTopEntryLinux_X_KDE_SubstituteUID = dataElement.getAttribute("KdeSubstUID", "false");
            data.deskTopEntryLinux_X_KDE_UserName = dataElement.getAttribute("KdeUsername", "root");
            data.Categories = dataElement.getAttribute("categories", "Application;Development");
            data.TryExec = dataElement.getAttribute("tryexec", "");
            data.createForAll = Boolean.valueOf(dataElement.getAttribute("createForAll", "false"));
            data.userType = Integer.valueOf(dataElement.getAttribute("usertype", Integer.toString(1)));
            shortcuts.add(data);
        }
        if (!shortcuts.isEmpty()) {
            System.out.print("[ Creating shortcuts ");
        }
        ArrayList<String> startMenuShortcuts = new ArrayList<String>();
        for (int i = 0; i < shortcuts.size(); ++i) {
            data = (ShortcutData)shortcuts.elementAt(i);
            try {
                if (data.subgroup != null) {
                    groupName = groupName + data.subgroup;
                }
                shortcut.setUserType(data.userType);
                shortcut.setLinkName(data.name);
                if (OsVersion.IS_WINDOWS) {
                    shortcut.setLinkType(data.type);
                }
                shortcut.setArguments(data.commandLine);
                shortcut.setDescription(data.description);
                shortcut.setIconLocation(data.iconFile, data.iconIndex);
                shortcut.setShowCommand(data.initialState);
                shortcut.setTargetPath(data.target);
                shortcut.setWorkingDirectory(data.workingDirectory);
                shortcut.setEncoding(data.deskTopEntryLinux_Encoding);
                shortcut.setMimetype(data.deskTopEntryLinux_MimeType);
                shortcut.setTerminal(data.deskTopEntryLinux_Terminal);
                shortcut.setTerminalOptions(data.deskTopEntryLinux_TerminalOptions);
                shortcut.setExcludeOS(data.excludeOS);
                if (!OsVersion.IS_WINDOWS) {
                    shortcut.setType(data.deskTopEntryLinux_Type);
                }
                shortcut.setKdeSubstUID(data.deskTopEntryLinux_X_KDE_SubstituteUID);
                shortcut.setURL(data.deskTopEntryLinux_URL);
                shortcut.setCreateForAll(data.createForAll);
                shortcut.setUninstaller(UninstallData.getInstance());
                if (data.addToGroup) {
                    shortcut.setProgramGroup(groupName);
                } else {
                    shortcut.setProgramGroup("");
                }
                List<String> ExcludeOsArray = Arrays.asList(shortcut.getExcludeOS().split(","));
                String OS = System.getProperty("os.name");
                if (ExcludeOsArray.contains(OS)) continue;
                try {
                    Unix_Shortcut unixcut;
                    String f;
                    System.out.print(".");
                    System.out.flush();
                    shortcut.save();
                    if (OsVersion.IS_UNIX && shortcut instanceof Unix_Shortcut && (f = (unixcut = (Unix_Shortcut)shortcut).getWrittenFileName()) != null) {
                        startMenuShortcuts.add(f);
                    }
                    String fileName = shortcut.getFileName();
                    files.add(0, fileName);
                    File file = new File(fileName);
                    File base = new File(shortcut.getBasePath());
                    Vector<File> intermediates = new Vector<File>();
                    execFiles.add(new ExecutableFile(fileName, 2, 3, new ArrayList<OsConstraint>(), false));
                    files.add(fileName);
                    while ((file = file.getParentFile()) != null && !file.equals(base)) {
                        intermediates.add(file);
                    }
                    if (file == null) continue;
                    Enumeration filesEnum = intermediates.elements();
                    while (filesEnum.hasMoreElements()) {
                        files.add(0, ((File)filesEnum.nextElement()).toString());
                    }
                    continue;
                }
                catch (Exception exception) {
                    continue;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (OsVersion.IS_UNIX) {
            int shortcutsDestinationSelection = shortcut.getUserType() == 2 ? 2 : 1;
            String[] stringArray = this.writeXDGMenuFile(startMenuShortcuts, groupName, "", "", shortcutsDestinationSelection);
        }
        try {
            if (execFiles != null) {
                FileExecutor shortcutsDestinationSelection = new FileExecutor(execFiles);
            }
        }
        catch (RuntimeException cannot) {
            cannot.printStackTrace();
        }
        if (!shortcuts.isEmpty()) {
            System.out.println(" done. ]");
            UtilityUnpacker.unpack("Icons");
            this.addToUninstaller(files);
        }
    }

    private void addToUninstaller(Vector<String> files) {
        System.out.print("[ Add shortcuts to uninstaller ");
        UninstallData uninstallData = UninstallData.getInstance();
        for (int i = 0; i < files.size(); ++i) {
            uninstallData.addFile(files.elementAt(i), true);
            System.out.print(".");
            System.out.flush();
        }
        System.out.println(" done. ]");
    }

    private String createXDGMenu(ArrayList shortcuts, String menuName) {
        String menuConfigText = "<Menu>\n<Name>Applications</Name>\n<Menu>\n<Directory>" + menuName.replaceAll(" ", "-") + "-izpack.directory</Directory>\n<Name>" + menuName + "</Name>\n<Include>\n";
        for (Object shortcut1 : shortcuts) {
            String shortcutFile = (String)shortcut1;
            menuConfigText = menuConfigText + "<Filename>" + shortcutFile + "</Filename>\n";
        }
        menuConfigText = menuConfigText + "</Include>\n</Menu>\n</Menu>";
        return menuConfigText;
    }

    private String createXDGDirectory(String menuName, String icon, String comment) {
        String menuDirectoryDescriptor = "[Desktop Entry]\nName=$Name\nComment=$Comment\nIcon=$Icon\nType=Directory\nEncoding=UTF-8";
        menuDirectoryDescriptor = StringTool.replace(menuDirectoryDescriptor, "$Name", menuName);
        menuDirectoryDescriptor = StringTool.replace(menuDirectoryDescriptor, "$Comment", comment);
        menuDirectoryDescriptor = StringTool.replace(menuDirectoryDescriptor, "$Icon", icon);
        return menuDirectoryDescriptor;
    }

    private String[] writeXDGMenuFile(ArrayList desktopFileNames, String groupName, String icon, String comment, int shortcutsDestinationSelection) {
        String directoryFolder;
        String gnome3MenuFolder;
        String menuFolder;
        String menuFile = this.createXDGMenu(desktopFileNames, groupName);
        String dirFile = this.createXDGDirectory(groupName, icon, comment);
        if (shortcutsDestinationSelection == 2) {
            menuFolder = "/etc/xdg/menus/applications-merged/";
            gnome3MenuFolder = "/etc/xdg/menus/applications-gnome-merged/";
            directoryFolder = "/usr/share/desktop-directories/";
        } else {
            menuFolder = System.getProperty("user.home") + File.separator + ".config/menus/applications-merged/";
            gnome3MenuFolder = System.getProperty("user.home") + File.separator + ".config/menus/applications-gnome-merged/";
            directoryFolder = System.getProperty("user.home") + File.separator + ".local/share/desktop-directories/";
        }
        File menuFolderFile = new File(menuFolder);
        File gnome3MenuFolderFile = new File(gnome3MenuFolder);
        File directoryFolderFile = new File(directoryFolder);
        String menuFilePath = menuFolder + groupName + ".menu";
        String menuFilePathGnome3 = gnome3MenuFolder + groupName + ".menu";
        String dirFilePath = directoryFolder + groupName.replaceAll(" ", "-") + "-izpack.directory";
        menuFolderFile.mkdirs();
        gnome3MenuFolderFile.mkdirs();
        directoryFolderFile.mkdirs();
        this.writeString(menuFile, menuFilePath);
        this.writeString(menuFile, menuFilePathGnome3);
        this.writeString(dirFile, dirFilePath);
        return new String[]{menuFilePath, dirFilePath};
    }

    private void writeString(String str, String file) {
        boolean failed = false;
        try {
            FileWriter writer = new FileWriter(file);
            writer.write(str);
            writer.close();
        }
        catch (Exception ignore) {
            failed = true;
            Debug.log("Failed to create menu for gnome.");
        }
        if (!failed) {
            UninstallData.getInstance().addFile(file, true);
        }
    }
}

