/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.ConsoleInstaller;
import com.izforge.izpack.installer.PanelConsole;
import com.izforge.izpack.installer.PanelConsoleHelper;
import com.izforge.izpack.panels.ShortcutPanel;
import com.izforge.izpack.util.AeshReadlineConsole;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.StringTool;
import com.izforge.izpack.util.os.unix.UnixHelper;
import java.io.PrintWriter;
import java.util.Properties;

public class ShortcutPanelConsoleHelper
extends PanelConsoleHelper
implements PanelConsole {
    @Override
    public void makeXMLData(IXMLElement panelRoot, AutomatedInstallData idata) {
        ShortcutPanel.xmlShortcut(panelRoot, null);
    }

    @Override
    public boolean runGeneratePropertiesFile(AutomatedInstallData installData, PrintWriter printWriter) {
        return false;
    }

    @Override
    public boolean runConsoleFromPropertiesFile(AutomatedInstallData installData, Properties p) {
        return false;
    }

    private String read() throws Exception {
        byte[] byteArray = new byte[]{(byte)System.in.read()};
        return new String(byteArray);
    }

    private String readln() throws Exception {
        String input = AeshReadlineConsole.readLine();
        return input.trim();
    }

    @Override
    public boolean runConsole(AutomatedInstallData installData, ConsoleInstaller parent) {
        if (OsVersion.IS_OSX) {
            return true;
        }
        ShortcutPanel.panelActivate(null);
        String menuKind = installData.langpack.getString("ShortcutPanel.regular.StartMenu:Start-Menu");
        if (OsVersion.IS_UNIX && UnixHelper.kdeIsInstalled()) {
            menuKind = installData.langpack.getString("ShortcutPanel.regular.StartMenu:K-Menu");
        }
        System.out.println();
        String q1 = StringTool.replace(installData.langpack.getString("ShortcutPanel.regular.create"), "StartMenu", menuKind);
        boolean bl = ShortcutPanel.create = PanelConsoleHelper.askYesNo(q1, true) == 47;
        while (ShortcutPanel.create) {
            System.out.println(installData.langpack.getString("ShortcutPanel.regular.list") + " [" + ShortcutPanel.suggestedProgramGroup + "]:");
            try {
                ShortcutPanel.groupName = this.readln();
            }
            catch (Exception e) {
                Debug.log(e);
            }
            if (ShortcutPanel.groupName == null || ShortcutPanel.groupName.isEmpty()) {
                ShortcutPanel.groupName = ShortcutPanel.suggestedProgramGroup;
            } else {
                String firstInvalidChar = ShortcutPanel.findFirstInvalidCharInProgramGroup(ShortcutPanel.groupName);
                if (firstInvalidChar != null) {
                    System.out.println(String.format(installData.langpack.getString("ShortcutPanel.group.character.error"), firstInvalidChar));
                    continue;
                }
            }
            if (!ShortcutPanel.createImmediately) break;
            this.createAndRegisterShortcuts();
            break;
        }
        return true;
    }

    public void createAndRegisterShortcuts() {
        ShortcutPanel.createShortcuts(null);
        ShortcutPanel.addToUninstaller();
    }
}

