/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Validator;
import com.izforge.izpack.panels.ValidatorContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class StringInputProcessingClient
implements ProcessingClient {
    private String input;
    private List<ValidatorContainer> validators;
    private ValidatorContainer currentValidator;
    private List<String> messages = new ArrayList<String>();
    private int numFields = 1;

    public StringInputProcessingClient(String input, List<ValidatorContainer> validators) {
        this.input = input;
        this.validators = validators;
    }

    @Override
    public String getFieldContents(int index) {
        return this.input;
    }

    @Override
    public int getNumFields() {
        return this.numFields;
    }

    public void setNumFields(int i) {
        this.numFields = i;
    }

    @Override
    public String getText() {
        return this.input;
    }

    @Override
    public Map<String, String> getValidatorParams() {
        return this.currentValidator != null ? this.currentValidator.getValidatorParams() : new HashMap();
    }

    @Override
    public boolean hasParams() {
        return this.currentValidator != null ? this.currentValidator.hasParams() : false;
    }

    public List<Validator.Status> validate() {
        ArrayList<Validator.Status> results = new ArrayList<Validator.Status>();
        Validator.Status success = Validator.Status.OK;
        if (this.validators != null) {
            Iterator<ValidatorContainer> iterator = this.validators.iterator();
            while (iterator.hasNext()) {
                ValidatorContainer validator;
                this.currentValidator = validator = iterator.next();
                Validator validatorInstance = this.currentValidator.getValidator();
                if (validatorInstance != null) {
                    success = validatorInstance.validate(this);
                    if (success == Validator.Status.ERROR) {
                        this.messages.add(this.currentValidator.getMessage());
                        results.add(success);
                        break;
                    }
                    if (success == Validator.Status.WARNING) {
                        this.messages.add(this.currentValidator.getMessage());
                    }
                }
                results.add(success);
            }
        }
        return results;
    }

    public List<String> getValidationMessage() {
        return this.messages;
    }
}

