/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.FontResources;
import com.izforge.izpack.gui.GridBagConstraintsFactory;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.gui.ScrollPaneFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.util.MultiLineLabel;
import com.izforge.izpack.util.SummaryProcessor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class SummaryPanel
extends IzPanel {
    private static final long serialVersionUID = 3832626166401282361L;
    private JEditorPane textArea;

    public SummaryPanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata, new GridBagLayout());
        this.addTitle();
        this.addInfoLabel();
        this.addTextArea();
    }

    private void addTitle() {
        JLabel title = LabelFactory.createTitleLabel(this.idata.langpack.getString("sidenav.summary"), !this.parent.hasBackground);
        this.add((Component)title, GridBagConstraintsFactory.getTitleConstraints());
    }

    private void addTextArea() {
        GridBagConstraints gbc = GridBagConstraintsFactory.getBasicConstraints();
        gbc.gridy = 2;
        gbc.weightx = 0.5;
        gbc.weighty = 0.5;
        gbc.fill = 1;
        this.textArea = new JEditorPane();
        this.textArea.setContentType("text/html");
        this.textArea.setEditable(false);
        this.textArea.setFocusable(false);
        this.textArea.setFont(FontResources.getOpenSansRegular());
        JScrollPane scroller = ScrollPaneFactory.createScroller(this.textArea);
        this.add((Component)scroller, gbc);
    }

    private void addInfoLabel() {
        MultiLineLabel component = this.createMultiLineLabelLang("SummaryPanel.info");
        GridBagConstraints gbc = GridBagConstraintsFactory.getBasicConstraints();
        gbc.gridy = 1;
        this.add((Component)component, gbc);
    }

    @Override
    public void panelActivate() {
        super.panelActivate();
        this.textArea.setText(SummaryProcessor.getPanelSummary(this.idata, true));
        this.textArea.setCaretPosition(0);
        this.setInitialFocus(this.getInstallerFrame().getNextButton());
    }
}

