/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.InstallerException;
import com.izforge.izpack.installer.PanelAutomation;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.File;
import java.io.IOException;

public class TargetPanelAutomationHelper
implements PanelAutomation {
    private boolean mustExist = false;

    @Override
    public void makeXMLData(AutomatedInstallData idata, IXMLElement panelRoot) {
        XMLElementImpl ipath = new XMLElementImpl("installpath", panelRoot);
        ipath.setContent(idata.getInstallPath());
        IXMLElement prev = panelRoot.getFirstChildNamed("installpath");
        if (prev != null) {
            panelRoot.removeChild(prev);
        }
        panelRoot.addChild(ipath);
    }

    @Override
    public void runAutomated(AutomatedInstallData idata, IXMLElement panelRoot) throws InstallerException {
        File selectedDir;
        String finalPath;
        IXMLElement ipath = panelRoot.getFirstChildNamed("installpath");
        this.setMustExist(Boolean.valueOf(idata.getVariable("TargetPanel.mustExist")));
        VariableSubstitutor vs = new VariableSubstitutor(idata.getVariables());
        String path = ipath.getContent();
        if (path.startsWith("./") || path.startsWith(".\\")) {
            path = path.substring(2);
        }
        File relativeCheck = new File(path);
        try {
            finalPath = relativeCheck.getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
            finalPath = path;
        }
        finalPath = vs.substitute(finalPath, null);
        if (this.isMustExist() && !(selectedDir = new File(finalPath)).exists()) {
            System.out.println(vs.substitute(idata.langpack.getString("PathInputPanel.required")));
            throw new InstallerException("Install Path must exists data for this installer");
        }
        idata.setInstallPath(finalPath);
    }

    private void setMustExist(boolean mustExist) {
        this.mustExist = mustExist;
    }

    private boolean isMustExist() {
        return this.mustExist;
    }
}

