/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.ConsoleInstaller;
import com.izforge.izpack.installer.PanelConsole;
import com.izforge.izpack.installer.PanelConsoleHelper;
import com.izforge.izpack.panels.TargetPanel;
import com.izforge.izpack.panels.TargetPanelAutomationHelper;
import com.izforge.izpack.util.AeshReadlineConsole;
import com.izforge.izpack.util.ErrorIzpackPathException;
import com.izforge.izpack.util.FileUtil;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.VariableSubstitutor;
import com.izforge.izpack.util.WarningIzpackPathException;
import java.io.File;
import java.io.PrintWriter;
import java.util.Properties;
import java.util.regex.Pattern;

public class TargetPanelConsoleHelper
extends PanelConsoleHelper
implements PanelConsole {
    private static final String PATH_NOT_VALID = "TargetPanel.nodir";
    private static final String PATH_ALREADY_EXISTS = "TargetPanel.warn";
    private static final String PATH_INFO = "TargetPanel.info";
    private static boolean FIRST_ITERATION = true;
    private boolean mustExist = false;

    private static String getTranslation(AutomatedInstallData idata, String text) {
        return idata.langpack.getString(text);
    }

    @Override
    public boolean runGeneratePropertiesFile(AutomatedInstallData installData, PrintWriter printWriter) {
        printWriter.println("INSTALL_PATH=");
        return true;
    }

    @Override
    public boolean runConsoleFromPropertiesFile(AutomatedInstallData installData, Properties p) {
        String strTargetPath = p.getProperty("INSTALL_PATH");
        if (strTargetPath == null || "".equals(strTargetPath.trim())) {
            System.err.println(TargetPanelConsoleHelper.getTranslation(installData, PATH_NOT_VALID));
            return false;
        }
        VariableSubstitutor vs = new VariableSubstitutor(installData.getVariables());
        strTargetPath = vs.substitute(strTargetPath, null);
        installData.setInstallPath(strTargetPath);
        return true;
    }

    @Override
    public String getSummaryBody(AutomatedInstallData idata) {
        return idata.getInstallPath();
    }

    @Override
    public void makeXMLData(IXMLElement panelRoot, AutomatedInstallData idata) {
        new TargetPanelAutomationHelper().makeXMLData(idata, panelRoot);
    }

    @Override
    public boolean runConsole(AutomatedInstallData idata, ConsoleInstaller parent) {
        int i;
        this.setMustExist(Boolean.valueOf(idata.getVariable("TargetPanel.mustExist")));
        String strTargetPath = "";
        if (FIRST_ITERATION) {
            String path = TargetPanel.loadDefaultDirFromVariables(idata.getVariables());
            if (path != null) {
                idata.setInstallPath(path);
            }
            FIRST_ITERATION = false;
        }
        String strDefaultPath = idata.getInstallPath();
        System.out.println(TargetPanelConsoleHelper.getTranslation(idata, PATH_INFO) + " [" + strDefaultPath + "] ");
        String strIn = AeshReadlineConsole.readFile(true);
        strTargetPath = !strIn.trim().equals("") ? strIn : strDefaultPath;
        strTargetPath = new File(strTargetPath).getAbsolutePath();
        VariableSubstitutor vs = new VariableSubstitutor(idata.getVariables());
        strTargetPath = vs.substitute(strTargetPath, null);
        strTargetPath = IoHelper.expandHomePath(strTargetPath);
        if (System.getProperty("os.name").toLowerCase().contains("window")) {
            String windowPathValidator;
            if (!strTargetPath.endsWith("\\")) {
                strTargetPath = strTargetPath + "\\";
            }
            if (!Pattern.matches(windowPathValidator = "[a-zA-Z]:.*", strTargetPath)) {
                strTargetPath = System.getProperty("user.dir") + File.separator + strTargetPath;
                strTargetPath = strTargetPath.replaceAll("/", "\\\\");
            }
        } else if (!strTargetPath.startsWith(File.separator)) {
            strTargetPath = System.getProperty("user.dir") + File.separator + strTargetPath;
        }
        try {
            if (!FileUtil.isPathValid(strTargetPath)) {
                System.out.println(idata.langpack.getString("TargetPanel.notwritable"));
                return this.runConsole(idata, parent);
            }
        }
        catch (WarningIzpackPathException wipe) {
            int proceed = TargetPanelConsoleHelper.askYesNo(wipe.getMessage(), false);
            if (proceed == 49) {
                return this.runConsole(idata, parent);
            }
        }
        catch (ErrorIzpackPathException ipe) {
            System.out.println(ipe.getMessage());
            return this.runConsole(idata, parent);
        }
        idata.setInstallPath(strTargetPath);
        if (strTargetPath != null && strTargetPath.length() > 0) {
            File selectedDir = new File(strTargetPath);
            idata.setInstallPath(selectedDir.getPath());
            File existParent = IoHelper.existingParent(new File(selectedDir.getPath()));
            if (this.isMustExist() && !selectedDir.exists()) {
                System.out.println(vs.substitute(idata.langpack.getString("PathInputPanel.required")));
                return this.runConsole(idata, parent);
            }
            if (existParent == null || !existParent.canWrite()) {
                System.out.println(idata.langpack.getString("TargetPanel.notwritable"));
                return this.runConsole(idata, parent);
            }
            if (selectedDir.exists() && selectedDir.isDirectory() && selectedDir.list() != null && selectedDir.list().length > 0) {
                int answer = this.askNonEmptyDir(idata);
                if (answer == 2) {
                    return false;
                }
                if (answer == 3) {
                    return this.runConsole(idata, parent);
                }
                return true;
            }
        }
        if ((i = TargetPanelConsoleHelper.askEndOfConsolePanel(idata)) == 1) {
            return true;
        }
        if (i == 2) {
            return false;
        }
        return this.runConsole(idata, parent);
    }

    protected int askNonEmptyDir(AutomatedInstallData idata) {
        if (idata.getVariable("new.product.conf") == null) {
            return TargetPanelConsoleHelper.askEndOfConsolePanel(idata);
        }
        return 1;
    }

    private void setMustExist(boolean mustExist) {
        this.mustExist = mustExist;
    }

    private boolean isMustExist() {
        return this.mustExist;
    }
}

