/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.CorrectWidthJTextArea;
import com.izforge.izpack.gui.CorrectWidthJTextField;
import com.izforge.izpack.gui.FlowLayout;
import com.izforge.izpack.gui.FocusListenerAutoScroll;
import com.izforge.izpack.gui.FocusListenerRepaint;
import com.izforge.izpack.gui.FontResources;
import com.izforge.izpack.gui.ScrollPaneFactory;
import com.izforge.izpack.gui.UiResources;
import com.izforge.izpack.panels.JFocusPanel;
import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Validator;
import com.izforge.izpack.panels.ValidatorContainer;
import com.izforge.izpack.util.Debug;
import java.awt.Color;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.plaf.ColorUIResource;
import javax.swing.text.JTextComponent;

public class TextInputField
extends JComponent
implements ProcessingClient {
    private static final long serialVersionUID = 8611515659787697087L;
    private Map<String, String> validatorParams;
    private Validator validationService;
    private JTextComponent field;
    private boolean hasParams = false;
    private Map<String, String> currentValidatorParams = null;
    private List<ValidatorContainer> validatorConfig = null;

    public TextInputField(String set, int size, int rows, String validator, Map<String, String> validatorParams, boolean numbersOnly) {
        this.validatorParams = validatorParams;
        this.hasParams = validatorParams != null;
        try {
            if (validator != null) {
                Debug.trace("Making Validator for: " + validator);
                this.validationService = (Validator)Class.forName(validator).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Throwable exception) {
            this.validationService = null;
            Debug.trace(exception);
        }
        FlowLayout layout = new FlowLayout();
        layout.setAlignment(3);
        layout.setVgap(0);
        layout.setHgap(0);
        this.setLayout(layout);
        if (rows > 1) {
            CorrectWidthJTextArea area = new CorrectWidthJTextArea(set, rows, size);
            area.setCaretPosition(0);
            area.setWrapStyleWord(true);
            area.setLineWrap(true);
            this.field = area;
            this.add(ScrollPaneFactory.createScroller(area));
        } else {
            this.field = new CorrectWidthJTextField(set, size);
            this.field.setCaretPosition(0);
            this.add(this.field);
        }
    }

    public TextInputField(String set, int size, int rows, List<ValidatorContainer> validators, boolean numbersOnly) {
        this.validatorConfig = validators;
        FlowLayout layout = new FlowLayout();
        layout.setAlignment(3);
        layout.setVgap(0);
        layout.setHgap(0);
        this.setLayout(layout);
        if (numbersOnly) {
            JTextField textField = this.JTextFieldNum(set);
            textField.setColumns(size);
            this.field = textField;
            JFocusPanel focusBorder = new JFocusPanel(this.field);
            this.field.addFocusListener(new FocusListenerRepaint());
            this.add(focusBorder);
        } else if (rows > 1) {
            CorrectWidthJTextArea area = new CorrectWidthJTextArea(set, rows, size);
            area.setCaretPosition(0);
            area.setWrapStyleWord(true);
            area.setLineWrap(true);
            area.setFont(FontResources.getOpenSansRegular());
            this.field = area;
            this.field.addFocusListener(new FocusListenerAutoScroll());
            this.add(ScrollPaneFactory.createScroller(area));
        } else {
            this.field = new CorrectWidthJTextField(set, size);
            this.field.setCaretPosition(0);
            this.field.addFocusListener(new FocusListenerAutoScroll());
            JFocusPanel focusBorder = new JFocusPanel(this.field);
            this.field.addFocusListener(new FocusListenerRepaint());
            this.add(focusBorder);
        }
    }

    public JTextField JTextFieldNum(String set) {
        CorrectWidthJTextField textField = new CorrectWidthJTextField(set){

            @Override
            public void processKeyEvent(KeyEvent ev) {
                char c = ev.getKeyChar();
                if (!Character.isLetter(c) && !TextInputField.this.isSymbol(c)) {
                    super.processKeyEvent(ev);
                }
            }
        };
        return textField;
    }

    private boolean isSymbol(char c) {
        String illegalSymbols = "~!@#$%^&*()_-=+{[}]|\\:;\"',<>./?";
        return illegalSymbols.contains("" + c);
    }

    @Override
    public Map<String, String> getValidatorParams() {
        if (this.validatorConfig == null) {
            return this.validatorParams;
        }
        return this.currentValidatorParams;
    }

    @Override
    public String getText() {
        return this.field.getText();
    }

    public void setText(String value) {
        this.field.setText(value);
    }

    public JTextComponent getField() {
        return this.field;
    }

    public void setField(JTextComponent field) {
        this.field = field;
    }

    @Override
    public String getFieldContents(int index) {
        return this.field.getText();
    }

    @Override
    public int getNumFields() {
        return 1;
    }

    public Validator.Status validateContents() {
        if (this.validationService != null) {
            Debug.trace("Validating contents");
            return this.validationService.validate(this);
        }
        Debug.trace("Not validating contents");
        return Validator.Status.OK;
    }

    public String validateContentsMultiValidators() {
        Validator validator = null;
        if (this.validatorConfig != null) {
            for (ValidatorContainer valContainer : this.validatorConfig) {
                validator = valContainer.getValidator();
                if (valContainer.hasParams()) {
                    this.hasParams = true;
                    this.currentValidatorParams = valContainer.getValidatorParams();
                } else {
                    this.hasParams = false;
                    this.currentValidatorParams = null;
                }
                if (validator.validate(this) == Validator.Status.OK) continue;
                String msg = valContainer.getMessage();
                return msg;
            }
            return "";
        }
        return "";
    }

    @Override
    public boolean hasParams() {
        return this.hasParams;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.field.setEnabled(enabled);
        this.field.setEditable(enabled);
    }

    public void setEditable(boolean editable) {
        this.field.setEditable(editable);
        if (!editable) {
            ColorUIResource c = new ColorUIResource(128, 128, 128);
            this.field.setBackground(UiResources.inactiveTextField);
            this.field.setForeground(c);
            this.field.setFocusable(false);
        } else {
            this.field.setBackground(Color.WHITE);
            this.field.setForeground(Color.BLACK);
            this.field.setFocusable(true);
        }
    }
}

