/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Pack;
import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.ConsoleInstaller;
import com.izforge.izpack.installer.PanelConsole;
import com.izforge.izpack.installer.PanelConsoleHelper;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.panels.DynamicPackSelector;
import com.izforge.izpack.panels.ImgPacksPanelAutomationHelper;
import com.izforge.izpack.util.AeshReadlineConsole;
import com.izforge.izpack.util.Debug;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class TreePacksPanelConsoleHelper
extends PanelConsoleHelper
implements PanelConsole {
    private static final String INFO = "PacksPanel.info";
    private static final String EMPTY = "";
    private static final String SPACE = " ";
    private static final String NO_PACKS = "TreePacksPanel.no.packs";
    private static final String CONTINUE = "TreePacksPanel.continue.question";
    private static final String ALREADY_SELECTED = "TreePacksPanel.already.selected";
    private static final String NOT_SELECTED = "TreePacksPanel.not.selected";
    private static final String REQUIRED = "TreePacksPanel.required";
    private static final String DONE = "TreePacksPanel.done";
    private static final String UNSELECTABLE = "TreePacksPanel.unselectable";
    private static final String CONFIRM = "TreePacksPanel.confirm";
    private static final String NUMBER = "TreePacksPanel.number";
    private static final String PROMPT = "TreePacksPanel.prompt";
    private static final String INVALID = "TreePacksPanel.invalid";
    private static final int SELECTED = 1;
    private static final int DESELECTED = 0;

    private static String getTranslation(AutomatedInstallData idata, String text) {
        return idata.langpack.getString(text);
    }

    private static void out(String message) {
        System.out.println(message);
    }

    private String getI18n(LocaleDatabase langpack, String key, String defaultValue) {
        String text = langpack.getString(key);
        return text != null && !text.equals(key) ? text : defaultValue;
    }

    @Override
    public String getSummaryBody(AutomatedInstallData idata) {
        StringBuffer retval = new StringBuffer(256);
        Iterator<Pack> iter = idata.selectedPacks.iterator();
        boolean first = true;
        while (iter.hasNext()) {
            if (!first) {
                retval.append("<br>");
            }
            first = false;
            Pack pack = iter.next();
            retval.append(this.getI18NPackName(pack, idata));
        }
        return retval.toString();
    }

    private String getI18NPackName(Pack pack, AutomatedInstallData idata) {
        String packName = pack.name;
        String key = pack.id;
        if (idata.langpack != null && pack.id != null && !EMPTY.equals(pack.id)) {
            packName = idata.langpack.getString(key);
        }
        if (EMPTY.equals(packName) || key == null || key.equals(packName)) {
            packName = pack.name;
        }
        return packName;
    }

    @Override
    public boolean runConsole(AutomatedInstallData installData, ConsoleInstaller parent) {
        HashMap<String, List<String>> treeData = new HashMap<String, List<String>>();
        HashMap<String, Pack> idToPack = new HashMap<String, Pack>();
        LinkedList<String> packParents = new LinkedList<String>();
        ArrayList<Pack> selectedPacks = new ArrayList<Pack>();
        LocaleDatabase langpack = installData.langpack;
        try {
            InputStream inputStream = ResourceManager.getInstance().getInputStream("packsLang.xml");
            langpack.add(inputStream);
        }
        catch (Exception e) {
            Debug.trace(e);
        }
        TreePacksPanelConsoleHelper.out(EMPTY);
        System.out.print(TreePacksPanelConsoleHelper.getTranslation(installData, INFO));
        TreePacksPanelConsoleHelper.out(EMPTY);
        for (Pack pack : installData.availablePacks) {
            List<String> kids = null;
            idToPack.put(pack.id, pack);
            if (pack.parent != null) {
                kids = treeData.containsKey(pack.parent) ? (List)treeData.get(pack.parent) : new ArrayList<String>();
                kids.add(pack.id);
            } else {
                packParents.add(pack.id);
            }
            treeData.put(pack.parent, kids);
        }
        this.selectHelper(treeData, selectedPacks, installData, idToPack, packParents, true, "\t");
        TreePacksPanelConsoleHelper.out(TreePacksPanelConsoleHelper.getTranslation(installData, DONE));
        installData.selectedPacks = selectedPacks;
        if (selectedPacks.size() == 0) {
            TreePacksPanelConsoleHelper.out(TreePacksPanelConsoleHelper.getTranslation(installData, NO_PACKS));
            TreePacksPanelConsoleHelper.out(TreePacksPanelConsoleHelper.getTranslation(installData, CONTINUE));
        }
        switch (TreePacksPanelConsoleHelper.askEndOfConsolePanel(installData)) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        return this.runConsole(installData, parent);
    }

    @Override
    public void makeXMLData(IXMLElement panelRoot, AutomatedInstallData idata) {
        new ImgPacksPanelAutomationHelper().makeXMLData(idata, panelRoot);
    }

    private boolean selectHelper(Map<String, List<String>> treeData, List<Pack> selectedPacks, AutomatedInstallData installData, Map<String, Pack> idToPack, List<String> packsStrings, boolean packMaster, String indent) {
        ArrayList<Pack> packs = new ArrayList<Pack>();
        for (Pack pack : installData.availablePacks) {
            packs.add(pack);
        }
        int[] selected = new int[packs.size()];
        int[] mapChoiceToSelection = new int[packs.size()];
        int choiceCount = 0;
        HashMap<String, Integer> idPos = new HashMap<String, Integer>();
        for (int i = 0; i < packs.size(); ++i) {
            Pack pack = (Pack)packs.get(i);
            Boolean conditionSatisfied = this.checkCondition(installData, pack);
            Boolean conditionExists = conditionSatisfied != null;
            idPos.put(pack.id, i);
            if (conditionExists.booleanValue()) {
                if (conditionSatisfied.booleanValue()) {
                    selected[i] = 1;
                }
            } else if (pack.preselected) {
                selected[i] = 1;
            }
            if (pack.isHidden()) continue;
            mapChoiceToSelection[choiceCount] = i;
            ++choiceCount;
        }
        DynamicPackSelector dPackSelector = new DynamicPackSelector(selected, packs, idPos);
        int packnum = this.printPackMenu(installData, packs, indent, selected, mapChoiceToSelection);
        while (true) {
            System.out.println(TreePacksPanelConsoleHelper.getTranslation(installData, PROMPT));
            int choice = -1;
            try {
                choice = Integer.parseInt(AeshReadlineConsole.readLine()) - 1;
            }
            catch (NumberFormatException e) {
                TreePacksPanelConsoleHelper.out(TreePacksPanelConsoleHelper.getTranslation(installData, NUMBER));
                continue;
            }
            if (choice < packnum && choice >= 0) {
                choice = mapChoiceToSelection[choice];
                if (((Pack)packs.get((int)choice)).required || !((Pack)packs.get((int)choice)).selectable) {
                    TreePacksPanelConsoleHelper.out(TreePacksPanelConsoleHelper.getTranslation(installData, INVALID));
                    continue;
                }
                selected[choice] = (selected[choice] + 1) % 2;
                if (treeData.containsKey(((Pack)packs.get((int)choice)).id)) {
                    for (String child : treeData.get(((Pack)packs.get((int)choice)).id)) {
                        selected[((Integer)idPos.get((Object)child)).intValue()] = selected[choice];
                    }
                } else if (((Pack)packs.get((int)choice)).parent != null && !((Pack)packs.get((int)((Integer)idPos.get((Object)((Pack)packs.get((int)choice)).parent)).intValue())).required) {
                    selected[((Integer)idPos.get((Object)((Pack)packs.get((int)choice)).parent)).intValue()] = 1;
                    for (String child : treeData.get(((Pack)packs.get((int)choice)).parent)) {
                        if (selected[(Integer)idPos.get(child)] != 0) continue;
                        selected[((Integer)idPos.get((Object)((Pack)packs.get((int)choice)).parent)).intValue()] = 0;
                    }
                }
                dPackSelector.onSelectionUpdate(choice);
                this.printPackMenu(installData, packs, indent, selected, mapChoiceToSelection);
                continue;
            }
            if (choice == -1) break;
            TreePacksPanelConsoleHelper.out(TreePacksPanelConsoleHelper.getTranslation(installData, INVALID));
        }
        for (int i = 0; i < selected.length; ++i) {
            if (selected[i] != 1) continue;
            selectedPacks.add((Pack)packs.get(i));
        }
        return true;
    }

    private Boolean checkCondition(AutomatedInstallData installData, Pack pack) {
        if (pack.hasCondition()) {
            return installData.getRules().isConditionTrue(pack.getCondition());
        }
        return null;
    }

    @Override
    public boolean runConsoleFromPropertiesFile(AutomatedInstallData installData, Properties p) {
        return false;
    }

    @Override
    public boolean runGeneratePropertiesFile(AutomatedInstallData installData, PrintWriter printWriter) {
        return false;
    }

    public int printPackMenu(AutomatedInstallData iData, List<Pack> packs, String indent, int[] selected, int[] choiceMap) {
        long totalSize = 0L;
        int packnum = 1;
        for (Pack p : packs) {
            if (p.isHidden()) continue;
            if (p.required) {
                Object[] objectArray = new Object[5];
                objectArray[0] = packnum;
                objectArray[1] = selected[choiceMap[packnum - 1]] == 1 ? "x" : SPACE;
                objectArray[2] = TreePacksPanelConsoleHelper.getTranslation(iData, REQUIRED);
                objectArray[3] = iData.langpack.getString(p.id);
                objectArray[4] = Pack.toByteUnitsString(p.getSize());
                System.out.printf("%-4d [%s] %-15s [%s] (%-4s)\n", objectArray);
            } else if (!p.selectable) {
                Object[] objectArray = new Object[5];
                objectArray[0] = packnum;
                objectArray[1] = selected[choiceMap[packnum - 1]] == 1 ? "x" : SPACE;
                objectArray[2] = TreePacksPanelConsoleHelper.getTranslation(iData, UNSELECTABLE);
                objectArray[3] = iData.langpack.getString(p.id);
                objectArray[4] = Pack.toByteUnitsString(p.getSize());
                System.out.printf("%-4d [%s] %-15s [%s] (%-4s)\n", objectArray);
            } else {
                Object[] objectArray = new Object[5];
                objectArray[0] = packnum;
                objectArray[1] = selected[choiceMap[packnum - 1]] == 1 ? "x" : SPACE;
                objectArray[2] = EMPTY;
                objectArray[3] = iData.langpack.getString(p.id);
                objectArray[4] = Pack.toByteUnitsString(p.getSize());
                System.out.printf("%-4d [%s] %-15s [%s] (%-4s)\n", objectArray);
            }
            if (selected[choiceMap[packnum - 1]] == 1) {
                totalSize += p.getSize();
            }
            ++packnum;
        }
        System.out.println("Total Size Required: " + Pack.toByteUnitsString(totalSize));
        System.out.println(TreePacksPanelConsoleHelper.getTranslation(iData, CONFIRM));
        return packnum - 1;
    }
}

