/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Pack;
import com.izforge.izpack.Panel;
import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.adaptator.impl.XMLParser;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.ComboBoxFactory;
import com.izforge.izpack.gui.CorrectWidthJPasswordField;
import com.izforge.izpack.gui.FlowLayout;
import com.izforge.izpack.gui.FocusListenerAutoScroll;
import com.izforge.izpack.gui.FocusListenerRepaint;
import com.izforge.izpack.gui.FontResources;
import com.izforge.izpack.gui.GridBagConstraintsFactory;
import com.izforge.izpack.gui.JRadioButtonFactory;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.gui.PanelFactory;
import com.izforge.izpack.gui.PopupListenerAutoScroll;
import com.izforge.izpack.gui.ScrollPaneFactory;
import com.izforge.izpack.gui.UiResources;
import com.izforge.izpack.gui.dynamic.DynamicComponentsPanel;
import com.izforge.izpack.gui.dynamic.SecurityDomainModule;
import com.izforge.izpack.gui.dynamic.TwoJTextFieldJPanel;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.installer.ResourceNotFoundException;
import com.izforge.izpack.panels.DirInputField;
import com.izforge.izpack.panels.DirUrlInputField;
import com.izforge.izpack.panels.FileDirInputField;
import com.izforge.izpack.panels.FileDownloadManager;
import com.izforge.izpack.panels.FileInputField;
import com.izforge.izpack.panels.FileUrlInputField;
import com.izforge.izpack.panels.FinalAndInitialVariables;
import com.izforge.izpack.panels.JFocusPanel;
import com.izforge.izpack.panels.JTextMessagePane;
import com.izforge.izpack.panels.JTextUrlPane;
import com.izforge.izpack.panels.MultipleFieldValidator;
import com.izforge.izpack.panels.MultipleFileInputField;
import com.izforge.izpack.panels.PasswordGroup;
import com.izforge.izpack.panels.PasswordUIElement;
import com.izforge.izpack.panels.PathSelectionPanel;
import com.izforge.izpack.panels.Processor;
import com.izforge.izpack.panels.RadioButtonGroupUIElement;
import com.izforge.izpack.panels.RadioButtonUIElement;
import com.izforge.izpack.panels.RuleInputField;
import com.izforge.izpack.panels.StringInputProcessingClient;
import com.izforge.izpack.panels.TextInputField;
import com.izforge.izpack.panels.UIElement;
import com.izforge.izpack.panels.UIElementType;
import com.izforge.izpack.panels.UserInputPanelAutomationHelper;
import com.izforge.izpack.panels.Validator;
import com.izforge.izpack.panels.ValidatorContainer;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.rules.VariableExistenceCondition;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.ReversePathSubstitutor;
import com.izforge.izpack.util.VariableSubstitutor;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class UserInputPanel
extends IzPanel
implements ActionListener,
ItemListener,
AdjustmentListener,
ComponentListener {
    private static final long serialVersionUID = 3257850965439886129L;
    protected static final String ICON_KEY = "icon";
    private static final String SPEC_FILE_NAME = "userInputSpec.xml";
    private static final String LANG_FILE_NAME = "userInputLang.xml";
    private static final String NODE_ID = "panel";
    private static final String FIELD_NODE_ID = "field";
    private static final String INSTANCE_IDENTIFIER = "order";
    protected static final String PANEL_IDENTIFIER = "id";
    private static final String SUMMARY = "summary";
    private static final String DEPENDS_ON = "dependson";
    private static final String TYPE = "type";
    private static final String DESCRIPTION = "description";
    private static final String VARIABLE = "variable";
    private static final String AUTOPROMPT = "autoPrompt";
    private static final String REPLACEPATH = "replacePath";
    protected static final String TEXT = "txt";
    protected static final String ID = "id";
    private static final String SPEC = "spec";
    private static final String SET = "set";
    private static final String ISCONFIRM = "isConfirm";
    private static final String REVALIDATE = "revalidate";
    private static final String EDITABLE = "editable";
    private static final String NO = "no";
    private static final String YES = "yes";
    private static final String TOPBUFFER = "topBuffer";
    private static final String RIGID = "rigid";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String ALIGNMENT = "align";
    private static final String LEFT = "left";
    private static final String CENTER = "center";
    private static final String RIGHT = "right";
    private static final String TOP = "top";
    private static final String ITALICS = "italic";
    private static final String BOLD = "bold";
    private static final String SIZE = "size";
    protected static final String VALIDATOR = "validator";
    private static final String PROCESSOR = "processor";
    protected static final String CLASS = "class";
    private static final String TITLE_FIELD = "title";
    private static final String TEXT_FIELD = "text";
    private static final String AUTO_TEXT_FIELD = "autotext";
    private static final String TEXT_SIZE = "size";
    private static final String TEXT_ROWS = "rows";
    private static final String STATIC_TEXT = "staticText";
    private static final String COMBO_FIELD = "combo";
    private static final String COMBO_CHOICE = "choice";
    private static final String COMBO_VALUE = "value";
    private static final String RADIO_FIELD = "radio";
    private static final String RADIO_CHOICE = "choice";
    private static final String RADIO_VALUE = "value";
    private static final String SPACE_FIELD = "space";
    private static final String DIVIDER_FIELD = "divider";
    private static final String CHECK_FIELD = "check";
    private static final String RULE_FIELD = "rule";
    private static final String RULE_LAYOUT = "layout";
    private static final String RULE_SEPARATOR = "separator";
    private static final String RULE_RESULT_FORMAT = "resultFormat";
    private static final String RULE_PLAIN_STRING = "plainString";
    private static final String RULE_DISPLAY_FORMAT = "displayFormat";
    private static final String RULE_SPECIAL_SEPARATOR = "specialSeparator";
    private static final String RULE_ENCRYPTED = "processed";
    protected static final String RULE_PARAM_NAME = "name";
    protected static final String RULE_PARAM_VALUE = "value";
    protected static final String RULE_PARAM = "param";
    private static final String PWD_FIELD = "password";
    private static final String PWD_INPUT = "pwd";
    private static final String PWD_SIZE = "size";
    private static final String SEARCH_FIELD = "search";
    private static final String FILE_FIELD = "file";
    private static final String FILE_DIR_FIELD = "filedir";
    private static final String DIR_URL_FIELD = "dirurl";
    private static final String FILE_URL_FIELD = "fileurl";
    private static final String DIR_FIELD = "dir";
    private static final String SEARCH_CHOICE = "choice";
    private static final String SEARCH_FILENAME = "filename";
    private static final String SEARCH_RESULT = "result";
    private static final String SEARCH_VALUE = "value";
    private static final String SEARCH_TYPE = "type";
    private static final String SEARCH_FILE = "file";
    private static final String SEARCH_DIRECTORY = "directory";
    private static final String SEARCH_PARENTDIR = "parentdir";
    private static final String SEARCH_CHECKFILENAME = "checkfilename";
    private static final String SELECTEDPACKS = "createForPack";
    private static final String UNSELECTEDPACKS = "createForUnselectedPack";
    private static final String DEFAULT_FOCUS = "defaultFocus";
    private static final String TOOLTIP = "tooltip";
    protected static final String ATTRIBUTE_CONDITIONID_NAME = "conditionid";
    protected static final String ATTRIBUTE_ALWAYS_DISPALAY = "alwaysDisplay";
    protected static final String VARIABLE_NODE = "variable";
    protected static final String ATTRIBUTE_VARIABLE_NAME = "name";
    protected static final String ATTRIBUTE_VARIABLE_VALUE = "value";
    private static final String ATTRIBUTE_INDENT = "indent";
    private static final int SPACE_BETWEEN_ELEMENTS = 20;
    private static final int CONTENT_PANEL_PADDING = 20;
    private static final int ALIGNED_ELEMENT_RIGHT_PADDING = 20;
    private static final int COLUMN_PIXEL_SCALE = 15;
    private static final String BUTTON_FIELD = "button";
    public static final String DYNAMIC_FIELD = "dynamic";
    public static final String DYNAMIC_FIELD_PATH = "pathField";
    public static final String DYNAMIC_FIELD_SECURITY_DOMAIN = "securityDomainModule";
    public static final String DYNAMIC_FIELD_TWOTEXT = "twoTextField";
    public static final String DYNAMIC_FIELD_COMPONENT_NUM_ENDING = "-number-dynamic-elements";
    private static final String NAME = "name";
    private static final String OS = "os";
    private static final String FAMILY = "family";
    private static final String MULTIPLE_FILE_FIELD = "multiFile";
    private static final String TEMPLATE = "template";
    private static final String MULTICAST_PORT = "multicast-port";
    private static final String MULTICAST_ADDRESS = "multicast-address";
    private static final String PORT = "port";
    private static final String PORT_TEMPLATE = "port.template";
    private static final String MULTICAST_PORT_TEMPLATE = "multicast-port.template";
    private static final String MULTICAST_ADDRESS_TEMPLATE = "multicast-address.template";
    private static final String VALIDATOR_PORT_TEMPLATE = "validator.template";
    private static final String OFFSET_TEMPLATE = "offset.template";
    private static final String VALIDATOR_M_ADDRESS_TEMPLATE = "multicast-address-validator.template";
    private static final String VALIDATOR_M_PORT_TEMPLATE = "multicast-port-validator.template";
    private static final String VALIDATOR_M_RANGE_TEMPLATE = "multicast-port-range-validator.template";
    private static final String VALIDATOR_ADDRESS_TEMPLATE = "verify-address-validator.template";
    private static final String VALIDATOR_RANGE_TEMPLATE = "range-validator.template";
    private static final String VALIDATOR_COLLISION_TEMPLATE = "port.collision.check.template";
    private static final String REGEX_TEMPLATE = "regex.template";
    private static final String MULTICAST_PORT_VALIDATOR = "multicast-port.validator";
    private static final String MULTICAST_ADDRESS_VALIDATOR = "multicast-address.validator";
    private static final String MULTICAST_PORT_RANGE_VALIDATOR = "multicast-port.range-validator";
    private static final String ADDRESS_VALIDATOR = "verify-address.validator";
    private static final String RANGE_VALIDATOR = "range-validator";
    private static final String OFFSET_VARIABLE_ELEMENT = "maximum.offset.variable";
    private static final String COLLISION_VALIDATOR = "port.collision.check";
    private static final String SUMMARIZE = "summarize";
    private static final String DEEP_SUB = "deepSub";
    private static final String COMPONENT_FILL = "fill";
    private static final String BUTTON_PASSWORD_FIELD = "passwordFieldId";
    private static final String IS_HEADER = "isHeader";
    private static final String SUPPRESS_DOWNLOAD = "suppressDownload";
    private static final String[] supportedRemoteProtocols = new String[]{"http", "https", "ftp", "file"};
    private static String multicastAddress = null;
    private static String multicastPort = null;
    private static String portText = null;
    private static String offsetText = null;
    private static String regexTemplate = null;
    private static String validatorPortText = null;
    private static String validatorRangeText = null;
    private static String validatorVerifyAddressText = null;
    private static String validatorMulticastAddressText = null;
    private static String validatorMulticastPortText = null;
    private static String validatorMulticastRangeText = null;
    private static String portOffsetVariable = null;
    private static String offsetValidator = null;
    private static String validatorCollisionText = null;
    private static String PostInstallPanelId = "postinstall";
    private boolean isVisible = true;
    private static int largestElementWidth = 0;
    private static int columnWidthConstraint = 100;
    private static boolean largeElementLast = false;
    private static ArrayList<JTextArea> labelList = new ArrayList();
    private static Map<String, Boolean> wasVisited = new HashMap<String, Boolean>();
    private static Map<String, DirUrlInputField> fieldsToDownload = new HashMap<String, DirUrlInputField>();
    private static int instanceCount = 0;
    protected int instanceNumber = 0;
    private boolean packsDefined = false;
    private InstallerFrame parentFrame;
    private IXMLElement spec;
    private boolean haveSpec = false;
    private Vector<ButtonGroup> buttonGroups = new Vector();
    private Map<String, PasswordGroup> passwordGroups = new HashMap<String, PasswordGroup>();
    private Vector passwordGroupsRead = new Vector();
    private Vector<SearchField> searchFields = new Vector();
    private Vector<TextValuePair> entries = new Vector();
    private Vector<TextValuePair> summaryEntries = new Vector();
    private HashSet<String> replacePathMap = new HashSet();
    private LocaleDatabase langpack = null;
    private boolean validating = true;
    private boolean eventsActivated = false;
    private Vector<UIElement> elements = new Vector();
    private JPanel panel;
    private JPanel contentPanel;
    private JScrollPane scroller;
    private HashMap<String, String> dependencies = new HashMap();
    private HashMap<String, String> passwords = new HashMap();
    private int currentRow;

    public UserInputPanel(InstallerFrame parent, InstallData installData) {
        super(parent, installData);
        this.instanceNumber = instanceCount++;
        this.parentFrame = parent;
    }

    private void createBuiltInVariableConditions(String variable) {
        if (variable == null) {
            return;
        }
        VariableExistenceCondition variableCondition = new VariableExistenceCondition();
        variableCondition.setId("izpack.input." + variable);
        variableCondition.setInstalldata(this.idata);
        variableCondition.setVariable(variable);
        this.parent.getRules().addCondition(variableCondition);
    }

    protected void init() {
        this.eventsActivated = false;
        try {
            this.langpack = (LocaleDatabase)this.parent.langpack.clone();
            String resource = "userInputLang.xml_" + this.idata.localeISO3;
            this.langpack.add(ResourceManager.getInstance().getInputStream(resource));
        }
        catch (ResourceNotFoundException e) {
            Debug.trace(e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.readSpec();
        }
        catch (Throwable exception) {
            exception.printStackTrace();
        }
        int topbuff = 25;
        boolean rigid = false;
        try {
            topbuff = Integer.parseInt(this.spec.getAttribute(TOPBUFFER));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            rigid = Boolean.parseBoolean(this.spec.getAttribute(RIGID));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setLayout(new BorderLayout());
        this.panel = PanelFactory.createMainPanel(false);
        this.panel.setBorder(BorderFactory.createEmptyBorder());
        if (this.parent.hasBackground) {
            this.panel.setOpaque(false);
        }
        this.contentPanel = PanelFactory.createContentPanel(false);
        largestElementWidth = 0;
        if (!this.haveSpec) {
            return;
        }
        this.updateVariables();
        IXMLElement temp = null;
        Vector<IXMLElement> fieldsTemplate = null;
        fieldsTemplate = this.spec.getChildrenNamed(REGEX_TEMPLATE);
        for (int i = 0; i < fieldsTemplate.size(); ++i) {
            temp = fieldsTemplate.elementAt(i);
            regexTemplate = temp.getAttribute(TEXT);
        }
        portText = this.getTranslatedTextFromID(this.spec, PORT_TEMPLATE);
        multicastPort = this.getTranslatedTextFromID(this.spec, MULTICAST_PORT_TEMPLATE);
        multicastAddress = this.getTranslatedTextFromID(this.spec, MULTICAST_ADDRESS_TEMPLATE);
        validatorPortText = this.getTranslatedTextFromID(this.spec, VALIDATOR_PORT_TEMPLATE);
        validatorVerifyAddressText = this.getTranslatedTextFromID(this.spec, VALIDATOR_ADDRESS_TEMPLATE);
        validatorMulticastAddressText = this.getTranslatedTextFromID(this.spec, VALIDATOR_M_ADDRESS_TEMPLATE);
        validatorMulticastRangeText = this.getTranslatedTextFromID(this.spec, VALIDATOR_M_RANGE_TEMPLATE);
        validatorMulticastPortText = this.getTranslatedTextFromID(this.spec, VALIDATOR_M_PORT_TEMPLATE);
        validatorRangeText = this.getTranslatedTextFromID(this.spec, VALIDATOR_RANGE_TEMPLATE);
        offsetText = this.getTranslatedTextFromID(this.spec, OFFSET_TEMPLATE);
        offsetValidator = this.getID(this.spec, OFFSET_TEMPLATE);
        portOffsetVariable = this.getID(this.spec, OFFSET_VARIABLE_ELEMENT);
        validatorCollisionText = this.getTranslatedTextFromID(this.spec, VALIDATOR_COLLISION_TEMPLATE);
        ButtonFactory.clearButtonMnemonics();
        Vector<IXMLElement> fields = this.spec.getChildrenNamed(FIELD_NODE_ID);
        this.currentRow = 0;
        labelList.clear();
        largeElementLast = false;
        columnWidthConstraint = 100;
        for (int i = 0; i < fields.size(); ++i) {
            IXMLElement field = fields.elementAt(i);
            String attribute = field.getAttribute("type");
            String associatedVariable = field.getAttribute("variable");
            this.createBuiltInVariableConditions(associatedVariable);
            String panelId = ((IzPanel)this.idata.panels.get(this.idata.curPanelNumber)).getMetadata().getPanelid();
            if (attribute == null) continue;
            ++this.currentRow;
            if (attribute.equals(BUTTON_FIELD)) {
                this.addButtonField(field);
                continue;
            }
            if (attribute.equals(CHECK_FIELD)) {
                this.addCheckBox(field);
                continue;
            }
            if (attribute.equals(COMBO_FIELD)) {
                this.addComboBox(field);
                continue;
            }
            if (attribute.equals(DIR_FIELD)) {
                this.addDirectoryField(field);
                continue;
            }
            if (attribute.equals(DIVIDER_FIELD)) {
                this.addDivider(field);
                continue;
            }
            if (attribute.equals("file")) {
                this.addFileField(field);
                continue;
            }
            if (attribute.equals(FILE_DIR_FIELD)) {
                this.addFileDirField(field);
                continue;
            }
            if (attribute.equals(DIR_URL_FIELD)) {
                this.addDirUrlField(field);
                continue;
            }
            if (attribute.equals(FILE_URL_FIELD)) {
                this.addFileUrlField(field);
                continue;
            }
            if (attribute.equals(MULTIPLE_FILE_FIELD)) {
                this.addMultipleFileField(field);
                continue;
            }
            if (attribute.equals(PWD_FIELD)) {
                this.addPasswordField(field);
                continue;
            }
            if (attribute.equals(RADIO_FIELD)) {
                this.addRadioButtonGroup(field);
                continue;
            }
            if (attribute.equals(RULE_FIELD)) {
                this.addRuleField(field);
                continue;
            }
            if (attribute.equals(SEARCH_FIELD)) {
                this.addSearch(field);
                continue;
            }
            if (attribute.equals(SPACE_FIELD)) {
                this.addSpace(field);
                continue;
            }
            if (attribute.equals(STATIC_TEXT)) {
                this.addText(field);
                continue;
            }
            if (attribute.equals(TEXT_FIELD) || attribute.equals(AUTO_TEXT_FIELD)) {
                this.addTextField(field);
                continue;
            }
            if (attribute.equals(TITLE_FIELD)) {
                this.addTitle(field);
                continue;
            }
            if (!attribute.equals(DYNAMIC_FIELD)) continue;
            this.addDynamicComponent(field);
        }
        if (largeElementLast) {
            for (JTextArea label : labelList) {
                label.setColumns(columnWidthConstraint);
            }
        }
        this.eventsActivated = true;
    }

    private String getTranslatedTextFromID(IXMLElement spec, String template) {
        String temp = this.getID(spec, template);
        return temp == null ? null : this.langpack.getString(temp);
    }

    private String getID(IXMLElement spec, String template) {
        String temp = null;
        Vector<IXMLElement> fieldsTemplate = spec.getChildrenNamed(template);
        IXMLElement field = null;
        for (int i = 0; i < fieldsTemplate.size(); ++i) {
            field = fieldsTemplate.firstElement();
            temp = field.getAttribute("id");
        }
        return temp;
    }

    private List<ValidatorContainer> analyzeValidator(IXMLElement specElement) {
        ArrayList<ValidatorContainer> result = null;
        Vector<IXMLElement> validatorsElem = specElement.getChildrenNamed(VALIDATOR);
        if (validatorsElem != null && validatorsElem.size() > 0) {
            int vsize = validatorsElem.size();
            result = new ArrayList<ValidatorContainer>(vsize);
            for (int i = 0; i < vsize; ++i) {
                IXMLElement element2 = validatorsElem.get(i);
                String validator = element2.getAttribute(CLASS);
                String message = this.getText(element2);
                HashMap<String, String> validateParamMap = new HashMap<String, String>();
                Vector<IXMLElement> validateParams = element2.getChildrenNamed(RULE_PARAM);
                if (validateParams != null && validateParams.size() > 0) {
                    for (IXMLElement element2 : validateParams) {
                        String paramName = element2.getAttribute("name");
                        String paramValue = element2.getAttribute("value");
                        validateParamMap.put(paramName, paramValue);
                    }
                }
                result.add(new ValidatorContainer(validator, message, validateParamMap));
            }
        }
        return result;
    }

    private void addDirectoryField(IXMLElement field) {
        IXMLElement spec = field.getFirstChildNamed(SPEC);
        String variable = field.getAttribute("variable");
        if (variable == null || spec == null) {
            return;
        }
        String value = this.idata.getVariable(variable);
        String conditionid = field.getAttribute(ATTRIBUTE_CONDITIONID_NAME);
        boolean isActive = conditionid == null || this.idata.getRules().isConditionTrue(conditionid);
        String alwaysActive = field.getAttribute(ATTRIBUTE_ALWAYS_DISPALAY);
        boolean visibleWhenNotActive = alwaysActive != null && alwaysActive.equals(TRUE);
        Vector<IXMLElement> forPacks = field.getChildrenNamed(SELECTEDPACKS);
        Vector<IXMLElement> forOs = field.getChildrenNamed(OS);
        String textSize = spec.getAttribute("size", "1");
        List<ValidatorContainer> validatorConfig = this.analyzeValidator(field);
        int size = Integer.parseInt(textSize);
        boolean create = Boolean.parseBoolean(spec.getAttribute("create", FALSE));
        boolean mustExist = Boolean.parseBoolean(spec.getAttribute("mustExist", TRUE));
        boolean allowEmptyValue = Boolean.parseBoolean(spec.getAttribute("allowEmptyValue", FALSE));
        boolean replacePath = Boolean.parseBoolean(spec.getAttribute(REPLACEPATH, FALSE));
        String defaultValue = spec.getAttribute(SET, "");
        if (value != null) {
            defaultValue = value;
        }
        if (!defaultValue.isEmpty()) {
            VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
            defaultValue = Boolean.parseBoolean(field.getAttribute(DEEP_SUB, FALSE)) ? vs.deepSubstitute(defaultValue, null) : vs.substitute(defaultValue, null);
        }
        DirInputField fileInput = new DirInputField(this, this.idata, true, defaultValue, size, validatorConfig, mustExist, create);
        fileInput.setAllowEmptyInput(allowEmptyValue);
        fileInput.setEnabled(isActive);
        this.addToolTiptoElement(field, fileInput.getField());
        this.addToolTiptoElement(field, fileInput.getButton());
        fileInput.setVisible(isActive || visibleWhenNotActive || this.displayHidden);
        UIElement dirUiElement = new UIElement();
        dirUiElement.setDeepSub(Boolean.parseBoolean(field.getAttribute(DEEP_SUB, FALSE)));
        dirUiElement.setComponent(fileInput, this.parent.hasBackground);
        dirUiElement.setType(UIElementType.DIRECTORY);
        dirUiElement.setAssociatedVariable(variable);
        dirUiElement.setConstraints(GridBagConstraintsFactory.createNonFullLineElementConstraint(this.currentRow, 0, 17, 0));
        dirUiElement.setForPacks(forPacks);
        dirUiElement.setForOs(forOs);
        dirUiElement.setReplacePath(replacePath);
        dirUiElement.setConditionid(conditionid);
        dirUiElement.setAlwaysActive(visibleWhenNotActive);
        this.parseSummarizeAttribute(spec, dirUiElement);
        if (this.focusedOnActivate(field)) {
            this.setInitialFocus(fileInput.getField());
        }
        this.elements.add(dirUiElement);
    }

    private void addMultipleFileField(IXMLElement field) {
        String variable = field.getAttribute("variable");
        IXMLElement spec = field.getFirstChildNamed(SPEC);
        if (variable == null || variable.length() == 0) {
            return;
        }
        if (spec == null) {
            return;
        }
        String value = this.idata.getVariable(variable);
        String conditionid = field.getAttribute(ATTRIBUTE_CONDITIONID_NAME);
        boolean isActive = conditionid == null || this.idata.getRules().isConditionTrue(conditionid);
        String alwaysActive = field.getAttribute(ATTRIBUTE_ALWAYS_DISPALAY);
        boolean visibleWhenNotActive = alwaysActive != null && alwaysActive.equals(TRUE);
        String labelText = this.getText(spec);
        int size = Integer.parseInt(spec.getAttribute("size", "1"));
        String visRows = spec.getAttribute("visibleRows", "10");
        String prefX = spec.getAttribute("prefX", "200");
        String prefY = spec.getAttribute("prefY", "200");
        String filter = spec.getAttribute("fileext", "");
        String filterdesc = spec.getAttribute("fileextdesc", "");
        List<ValidatorContainer> validatorConfig = this.analyzeValidator(field);
        int preferredX = Integer.parseInt(prefX);
        int preferredY = Integer.parseInt(prefY);
        int visibleRows = Integer.parseInt(visRows);
        boolean allowEmptyValue = Boolean.parseBoolean(spec.getAttribute("allowEmptyValue", FALSE));
        boolean createMultipleVariables = Boolean.parseBoolean(spec.getAttribute("multipleVariables", FALSE));
        filterdesc = this.langpack.getString(filterdesc);
        String defaultValue = spec.getAttribute(SET, ";");
        if (value != null && !value.isEmpty()) {
            defaultValue = value;
        }
        if (!defaultValue.isEmpty()) {
            VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
            defaultValue = Boolean.parseBoolean(field.getAttribute(DEEP_SUB, FALSE)) ? vs.deepSubstitute(defaultValue, null) : vs.substitute(defaultValue, null);
        }
        Vector<IXMLElement> forPacks = field.getChildrenNamed(SELECTEDPACKS);
        Vector<IXMLElement> forOs = field.getChildrenNamed(OS);
        MultipleFileInputField fileInputField = new MultipleFileInputField(this.parentFrame, this.idata, false, defaultValue, size, validatorConfig, filter, filterdesc, createMultipleVariables, visibleRows, preferredX, preferredY, labelText);
        fileInputField.setAllowEmptyInput(allowEmptyValue);
        fileInputField.setEnabled(isActive);
        for (String file : defaultValue.split(";")) {
            if (file.isEmpty()) continue;
            fileInputField.addFile(file);
        }
        this.addToolTiptoElement(field, fileInputField.getFileList());
        this.addToolTiptoElement(field, fileInputField.getBrowseButton());
        fileInputField.setVisible(isActive || visibleWhenNotActive || this.displayHidden);
        UIElement fileUiElement = new UIElement();
        fileUiElement.setDeepSub(Boolean.parseBoolean(field.getAttribute(DEEP_SUB, FALSE)));
        fileUiElement.setComponent(fileInputField, this.parent.hasBackground);
        fileUiElement.setType(UIElementType.MULTIPLE_FILE);
        fileUiElement.setAssociatedVariable(variable);
        fileUiElement.setConstraints(GridBagConstraintsFactory.createNonFullLineElementConstraint(this.currentRow, 0, 17, 0));
        fileUiElement.setForPacks(forPacks);
        fileUiElement.setForOs(forOs);
        fileUiElement.setConditionid(conditionid);
        fileUiElement.setAlwaysActive(visibleWhenNotActive);
        this.elements.add(fileUiElement);
    }

    private void addFileField(IXMLElement field) {
        IXMLElement spec = field.getFirstChildNamed(SPEC);
        String variable = field.getAttribute("variable");
        if (variable == null || spec == null) {
            return;
        }
        String value = this.idata.getVariable(variable);
        String conditionid = field.getAttribute(ATTRIBUTE_CONDITIONID_NAME);
        boolean isActive = conditionid == null || this.idata.getRules().isConditionTrue(conditionid);
        String alwaysActive = field.getAttribute(ATTRIBUTE_ALWAYS_DISPALAY);
        boolean visibleWhenNotActive = alwaysActive != null && alwaysActive.equals(TRUE);
        Vector<IXMLElement> forPacks = field.getChildrenNamed(SELECTEDPACKS);
        Vector<IXMLElement> forOs = field.getChildrenNamed(OS);
        String textSize = spec.getAttribute("size", "1");
        String filter = spec.getAttribute("fileext", "");
        String filterdesc = spec.getAttribute("fileextdesc", "");
        filterdesc = this.idata.langpack.getString(filterdesc);
        List<ValidatorContainer> validatorConfig = this.analyzeValidator(field);
        int size = Integer.parseInt(textSize);
        boolean mustExist = Boolean.parseBoolean(spec.getAttribute("mustExist", TRUE));
        boolean allowEmptyValue = Boolean.parseBoolean(spec.getAttribute("allowEmptyValue", FALSE));
        boolean replacePath = Boolean.parseBoolean(spec.getAttribute(REPLACEPATH, FALSE));
        String defaultValue = spec.getAttribute(SET, "");
        if (value != null) {
            defaultValue = value;
        }
        if (!defaultValue.isEmpty()) {
            VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
            defaultValue = Boolean.parseBoolean(field.getAttribute(DEEP_SUB, FALSE)) ? vs.deepSubstitute(defaultValue, null) : vs.substitute(defaultValue, null);
        }
        JLabel label = new JLabel(this.getText(spec));
        label.setEnabled(isActive);
        this.addToolTiptoElement(field, label);
        FileInputField fileInputField = new FileInputField(this, this.idata, false, defaultValue, size, validatorConfig, filter, filterdesc, mustExist);
        fileInputField.setAllowEmptyInput(allowEmptyValue);
        fileInputField.setEnabled(isActive);
        this.addToolTiptoElement(field, fileInputField.getField());
        this.addToolTiptoElement(field, fileInputField.getButton());
        fileInputField.setVisible(isActive || visibleWhenNotActive || this.displayHidden);
        UIElement fileUiElement = new UIElement();
        fileUiElement.setDeepSub(Boolean.parseBoolean(field.getAttribute(DEEP_SUB, FALSE)));
        fileUiElement.setComponent(fileInputField, this.parent.hasBackground);
        fileUiElement.setDependency(field.getAttribute(DEPENDS_ON, ""));
        fileUiElement.setAssociatedVariable(variable);
        fileUiElement.setConstraints(GridBagConstraintsFactory.createNonFullLineElementConstraint(this.currentRow, 0, 17, 0));
        fileUiElement.setType(UIElementType.FILE);
        fileUiElement.setForPacks(forPacks);
        fileUiElement.setForOs(forOs);
        fileUiElement.setReplacePath(replacePath);
        this.parseSummarizeAttribute(spec, fileUiElement);
        fileUiElement.setConditionid(conditionid);
        fileUiElement.setAlwaysActive(visibleWhenNotActive);
        if (this.focusedOnActivate(field)) {
            this.setInitialFocus(fileUiElement.getComponent());
        }
        this.elements.add(fileUiElement);
    }

    private void addFileDirField(IXMLElement field) {
        IXMLElement spec = field.getFirstChildNamed(SPEC);
        String variable = field.getAttribute("variable");
        if (variable == null || spec == null) {
            return;
        }
        String value = this.idata.getVariable(variable);
        String conditionid = field.getAttribute(ATTRIBUTE_CONDITIONID_NAME);
        boolean isActive = conditionid == null || this.idata.getRules().isConditionTrue(conditionid);
        String alwaysActive = field.getAttribute(ATTRIBUTE_ALWAYS_DISPALAY);
        boolean visibleWhenNotActive = alwaysActive != null && alwaysActive.equals(TRUE);
        Vector<IXMLElement> forPacks = field.getChildrenNamed(SELECTEDPACKS);
        Vector<IXMLElement> forOs = field.getChildrenNamed(OS);
        String textSize = spec.getAttribute("size", "1");
        String filter = spec.getAttribute("fileext", "");
        String filterdesc = spec.getAttribute("fileextdesc", "");
        filterdesc = this.idata.langpack.getString(filterdesc);
        List<ValidatorContainer> validatorConfig = this.analyzeValidator(field);
        int size = Integer.parseInt(textSize);
        boolean mustExist = Boolean.parseBoolean(spec.getAttribute("mustExist", TRUE));
        boolean allowEmptyValue = Boolean.parseBoolean(spec.getAttribute("allowEmptyValue", FALSE));
        boolean replacePath = Boolean.parseBoolean(spec.getAttribute(REPLACEPATH, FALSE));
        String defaultValue = spec.getAttribute(SET, "");
        if (value != null) {
            defaultValue = value;
        }
        if (!defaultValue.isEmpty()) {
            VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
            defaultValue = Boolean.parseBoolean(field.getAttribute(DEEP_SUB, FALSE)) ? vs.deepSubstitute(defaultValue, null) : vs.substitute(defaultValue, null);
        }
        JLabel label = new JLabel(this.getText(spec));
        label.setEnabled(isActive);
        this.addToolTiptoElement(field, label);
        FileDirInputField fileDirInputField = new FileDirInputField(this, this.idata, false, defaultValue, size, validatorConfig, mustExist);
        fileDirInputField.setAllowEmptyInput(allowEmptyValue);
        fileDirInputField.setEnabled(isActive);
        this.addToolTiptoElement(field, fileDirInputField.getField());
        this.addToolTiptoElement(field, fileDirInputField.getButton());
        fileDirInputField.setVisible(isActive || visibleWhenNotActive || this.displayHidden);
        UIElement fileUiElement = new UIElement();
        fileUiElement.setDeepSub(Boolean.parseBoolean(field.getAttribute(DEEP_SUB, FALSE)));
        fileUiElement.setComponent(fileDirInputField, this.parent.hasBackground);
        fileUiElement.setDependency(field.getAttribute(DEPENDS_ON, ""));
        fileUiElement.setAssociatedVariable(variable);
        fileUiElement.setConstraints(GridBagConstraintsFactory.createNonFullLineElementConstraint(this.currentRow, 0, 17, 0));
        fileUiElement.setType(UIElementType.FILE);
        fileUiElement.setForPacks(forPacks);
        fileUiElement.setForOs(forOs);
        fileUiElement.setReplacePath(replacePath);
        this.parseSummarizeAttribute(spec, fileUiElement);
        fileUiElement.setConditionid(conditionid);
        fileUiElement.setAlwaysActive(visibleWhenNotActive);
        if (this.focusedOnActivate(field)) {
            this.setInitialFocus(fileUiElement.getComponent());
        }
        this.elements.add(fileUiElement);
    }

    private void addDirUrlField(IXMLElement field) {
        IXMLElement spec = field.getFirstChildNamed(SPEC);
        String variable = field.getAttribute("variable");
        if (variable == null || spec == null) {
            return;
        }
        String value = this.idata.getVariable(variable);
        String conditionid = field.getAttribute(ATTRIBUTE_CONDITIONID_NAME);
        boolean isActive = conditionid == null || this.idata.getRules().isConditionTrue(conditionid);
        String alwaysActive = field.getAttribute(ATTRIBUTE_ALWAYS_DISPALAY);
        boolean visibleWhenNotActive = alwaysActive != null && alwaysActive.equals(TRUE);
        Vector<IXMLElement> forPacks = field.getChildrenNamed(SELECTEDPACKS);
        Vector<IXMLElement> forOs = field.getChildrenNamed(OS);
        String textSize = spec.getAttribute("size", "1");
        String filter = spec.getAttribute("fileext", "");
        String filterdesc = spec.getAttribute("fileextdesc", "");
        filterdesc = this.idata.langpack.getString(filterdesc);
        List<ValidatorContainer> validatorConfig = this.analyzeValidator(field);
        int size = Integer.parseInt(textSize);
        boolean mustExist = Boolean.parseBoolean(spec.getAttribute("mustExist", TRUE));
        boolean allowEmptyValue = Boolean.parseBoolean(spec.getAttribute("allowEmptyValue", FALSE));
        boolean replacePath = Boolean.parseBoolean(spec.getAttribute(REPLACEPATH, FALSE));
        boolean suppress = Boolean.parseBoolean(spec.getAttribute(SUPPRESS_DOWNLOAD, FALSE));
        String defaultValue = spec.getAttribute(SET, "");
        if (value != null) {
            defaultValue = value;
        }
        if (!defaultValue.isEmpty()) {
            VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
            defaultValue = Boolean.parseBoolean(field.getAttribute(DEEP_SUB, FALSE)) ? vs.deepSubstitute(defaultValue, null) : vs.substitute(defaultValue, null);
        }
        JLabel label = new JLabel(this.getText(spec));
        label.setEnabled(isActive);
        this.addToolTiptoElement(field, label);
        DirUrlInputField dirUrlInputField = new DirUrlInputField(this, this.idata, false, defaultValue, size, validatorConfig, filter, filterdesc, mustExist);
        dirUrlInputField.setAllowEmptyInput(allowEmptyValue);
        dirUrlInputField.setEnabled(isActive);
        dirUrlInputField.suppressDownload(suppress);
        this.addToolTiptoElement(field, dirUrlInputField.getField());
        this.addToolTiptoElement(field, dirUrlInputField.getButton());
        dirUrlInputField.setVisible(isActive || visibleWhenNotActive || this.displayHidden);
        UIElement dirUrlUIElement = new UIElement();
        dirUrlUIElement.setDeepSub(Boolean.parseBoolean(field.getAttribute(DEEP_SUB, FALSE)));
        dirUrlUIElement.setComponent(dirUrlInputField, this.parent.hasBackground);
        dirUrlUIElement.setDependency(field.getAttribute(DEPENDS_ON, ""));
        dirUrlUIElement.setAssociatedVariable(variable);
        dirUrlUIElement.setConstraints(GridBagConstraintsFactory.createNonFullLineElementConstraint(this.currentRow, 0, 17, 0));
        dirUrlUIElement.setType(UIElementType.DIR_URL);
        dirUrlUIElement.setForPacks(forPacks);
        dirUrlUIElement.setForOs(forOs);
        dirUrlUIElement.setReplacePath(replacePath);
        this.parseSummarizeAttribute(spec, dirUrlUIElement);
        dirUrlUIElement.setConditionid(conditionid);
        dirUrlUIElement.setAlwaysActive(visibleWhenNotActive);
        if (this.focusedOnActivate(field)) {
            this.setInitialFocus(dirUrlUIElement.getComponent());
        }
        this.elements.add(dirUrlUIElement);
    }

    private void addFileUrlField(IXMLElement field) {
        IXMLElement spec = field.getFirstChildNamed(SPEC);
        String variable = field.getAttribute("variable");
        if (variable == null || spec == null) {
            return;
        }
        String value = this.idata.getVariable(variable);
        String conditionid = field.getAttribute(ATTRIBUTE_CONDITIONID_NAME);
        boolean isActive = conditionid == null || this.idata.getRules().isConditionTrue(conditionid);
        String alwaysActive = field.getAttribute(ATTRIBUTE_ALWAYS_DISPALAY);
        boolean visibleWhenNotActive = alwaysActive != null && alwaysActive.equals(TRUE);
        Vector<IXMLElement> forPacks = field.getChildrenNamed(SELECTEDPACKS);
        Vector<IXMLElement> forOs = field.getChildrenNamed(OS);
        String textSize = spec.getAttribute("size", "1");
        String filter = spec.getAttribute("fileext", "");
        String filterdesc = spec.getAttribute("fileextdesc", "");
        boolean hidingEnabled = Boolean.parseBoolean(spec.getAttribute("hidingEnabled", TRUE));
        filterdesc = this.idata.langpack.getString(filterdesc);
        List<ValidatorContainer> validatorConfig = this.analyzeValidator(field);
        int size = Integer.parseInt(textSize);
        boolean mustExist = Boolean.parseBoolean(spec.getAttribute("mustExist", TRUE));
        boolean allowEmptyValue = Boolean.parseBoolean(spec.getAttribute("allowEmptyValue", FALSE));
        boolean replacePath = Boolean.parseBoolean(spec.getAttribute(REPLACEPATH, FALSE));
        boolean suppressDownload = Boolean.parseBoolean(spec.getAttribute(SUPPRESS_DOWNLOAD, FALSE));
        String defaultValue = spec.getAttribute(SET, "");
        if (value != null) {
            defaultValue = value;
        }
        if (!defaultValue.isEmpty()) {
            VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
            defaultValue = Boolean.parseBoolean(field.getAttribute(DEEP_SUB, FALSE)) ? vs.deepSubstitute(defaultValue, null) : vs.substitute(defaultValue, null);
        }
        JLabel label = new JLabel(this.getText(spec));
        label.setEnabled(isActive);
        this.addToolTiptoElement(field, label);
        FileUrlInputField fileUrlInputField = new FileUrlInputField(this, this.idata, false, defaultValue, size, validatorConfig, filter, filterdesc, mustExist, hidingEnabled);
        fileUrlInputField.setAllowEmptyInput(allowEmptyValue);
        fileUrlInputField.setEnabled(isActive);
        fileUrlInputField.suppressDownload(suppressDownload);
        this.addToolTiptoElement(field, fileUrlInputField.getField());
        this.addToolTiptoElement(field, fileUrlInputField.getButton());
        UIElement labelUiElement = new UIElement();
        labelUiElement.setComponent(label, this.parent.hasBackground);
        labelUiElement.setType(UIElementType.LABEL);
        labelUiElement.setConstraints(GridBagConstraintsFactory.createNonFullLineElementConstraint(this.currentRow, 0, 17, 0));
        labelUiElement.setForPacks(forPacks);
        labelUiElement.setForOs(forOs);
        ++this.currentRow;
        fileUrlInputField.setVisible(isActive || visibleWhenNotActive || this.displayHidden);
        UIElement fileUrlUIElement = new UIElement();
        fileUrlUIElement.setDeepSub(Boolean.parseBoolean(field.getAttribute(DEEP_SUB, FALSE)));
        fileUrlUIElement.setComponent(fileUrlInputField, this.parent.hasBackground);
        fileUrlUIElement.setDependency(field.getAttribute(DEPENDS_ON, ""));
        fileUrlUIElement.setAssociatedVariable(variable);
        fileUrlUIElement.setConstraints(GridBagConstraintsFactory.createNonFullLineElementConstraint(this.currentRow, 0, 17, 0));
        fileUrlUIElement.setType(UIElementType.FILE_URL);
        fileUrlUIElement.setForPacks(forPacks);
        fileUrlUIElement.setForOs(forOs);
        fileUrlUIElement.setReplacePath(replacePath);
        this.parseSummarizeAttribute(spec, fileUrlUIElement);
        fileUrlUIElement.setConditionid(conditionid);
        fileUrlUIElement.setAlwaysActive(visibleWhenNotActive);
        if (this.focusedOnActivate(field)) {
            this.setInitialFocus(fileUrlUIElement.getComponent());
        }
        this.elements.add(fileUrlUIElement);
        this.elements.add(labelUiElement);
    }

    private boolean focusedOnActivate(IXMLElement field) {
        String defaultFocus = field.getAttribute(DEFAULT_FOCUS);
        return defaultFocus != null && defaultFocus.equals(TRUE);
    }

    private boolean isHeader(IXMLElement field) {
        String isHeader = field.getAttribute(IS_HEADER);
        return isHeader != null && isHeader.equals(TRUE);
    }

    private void addToolTiptoElement(IXMLElement field, JComponent component) {
        String tooltip = field.getAttribute(TOOLTIP);
        if (tooltip != null) {
            component.setToolTipText("<html><p width=\"200\">" + this.idata.langpack.getString(tooltip) + "</p></html>");
        }
    }

    private void parseSummarizeAttribute(IXMLElement ele, UIElement field) {
        if (ele == null || field == null) {
            return;
        }
        field.setSummarize(!ele.hasAttribute(SUMMARIZE) || !ele.getAttribute(SUMMARIZE).equals(FALSE));
    }

    @Override
    public boolean isValidated() {
        return this.readInput();
    }

    @Override
    public void panelActivate() {
        super.panelActivate();
        super.removeAll();
        this.elements.clear();
        this.entries.clear();
        this.init();
        if (this.spec == null) {
            this.emitError("User input specification could not be found.", "The specification for the user input panel could not be found. Please contact the packager.");
            this.parentFrame.skipPanel();
        }
        this.updateVariables();
        Vector<IXMLElement> forPacks = this.spec.getChildrenNamed(SELECTEDPACKS);
        Vector<IXMLElement> forUnselectedPacks = this.spec.getChildrenNamed(UNSELECTEDPACKS);
        Vector<IXMLElement> forOs = this.spec.getChildrenNamed(OS);
        if (!(this.itemRequiredFor(forPacks) && this.itemRequiredForUnselected(forUnselectedPacks) && this.itemRequiredForOs(forOs))) {
            this.parentFrame.skipPanel();
            return;
        }
        if (!this.haveSpec) {
            this.parentFrame.skipPanel();
            return;
        }
        this.buildUI();
        this.setSize(this.getMaximumSize().width, this.getMaximumSize().height);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UserInputPanel.this.validate();
            }
        });
        if (this.packsDefined) {
            this.parentFrame.lockPrevButton();
        }
    }

    @Override
    public void makeXMLData(IXMLElement panelRoot) {
        LinkedHashMap<String, String> entryMap = new LinkedHashMap<String, String>();
        for (int i = 0; i < this.entries.size(); ++i) {
            TextValuePair pair = this.entries.elementAt(i);
            String key = pair.toString();
            if (pair.getValue() == null) {
                entryMap.put(key, null);
                continue;
            }
            String value = this.idata.getVariable(key);
            if (this.replacePathMap.contains(key)) {
                value = ReversePathSubstitutor.substitute("INSTALL_PATH", value);
            }
            entryMap.put(key, value);
        }
        new UserInputPanelAutomationHelper(entryMap).makeXMLData(this.idata, panelRoot);
    }

    private void buildUI() {
        for (UIElement element : this.elements) {
            if (this.itemRequiredFor(element.getForPacks()) && this.itemRequiredForOs(element.getForOs())) {
                if (element.isDisplayed()) continue;
                element.setDisplayed(true);
                this.contentPanel.add((Component)element.getComponent(), element.getConstraints());
                element.getComponent().addComponentListener(this);
                continue;
            }
            if (!element.isDisplayed()) continue;
            element.setDisplayed(false);
            this.contentPanel.remove(element.getComponent());
        }
        this.panel.add((Component)this.contentPanel, GridBagConstraintsFactory.getContentPanelConstraints());
        this.scroller = ScrollPaneFactory.createNoHorizontalPanelScroller(BorderFactory.createEmptyBorder(), this.panel, false);
        if (this.parent.hasBackground) {
            this.scroller.getViewport().setOpaque(false);
        }
        if (this.parent.hasBackground) {
            this.scroller.setOpaque(false);
        }
        this.add((Component)this.scroller, "Center");
        this.scroller.getHorizontalScrollBar().addAdjustmentListener(this);
    }

    @Override
    public void saveToInstallData() {
        this.saveToInstallData(false);
    }

    public void saveToInstallData(boolean fromNext) {
        for (UIElement element : this.elements) {
            JPanel input;
            String value;
            String var = element.getAssociatedVariable();
            if (!element.isDisplayed()) continue;
            if (element.getType() == UIElementType.RULE) {
                RuleInputField ruleField = (RuleInputField)element.getComponent();
                FinalAndInitialVariables moreVars = ruleField.getFinalAndInitialVariables();
                int count = 0;
                for (String temp : moreVars.getInitialVariables(var)) {
                    temp = temp.substring(temp.indexOf("{") + 1, temp.indexOf("}"));
                    this.idata.setVariable(temp, ruleField.getFieldContents(count));
                    ++count;
                }
                this.idata.setVariable(var, ruleField.getText());
                continue;
            }
            if (element.getType() == UIElementType.TEXT) {
                TextInputField textField = (TextInputField)element.getComponent();
                this.idata.setVariable(var, textField.getText());
                continue;
            }
            if (element.getType() == UIElementType.PASSWORD) {
                PasswordUIElement pwdField = (PasswordUIElement)element;
                PasswordGroup group = pwdField.getPasswordGroup();
                String id = pwdField.getId();
                if (fromNext) {
                    this.passwords.put(id, group.getNamedField(id));
                } else {
                    this.passwords.put(id, "");
                }
                this.idata.setVariable(var, group.getPassword());
                continue;
            }
            if (element.getType() == UIElementType.CHECKBOX) {
                JCheckBox checkBox = (JCheckBox)element.getComponent();
                Object trueValue = element.getTrueValue();
                String falseValue = element.getFalseValue();
                if (trueValue == null) {
                    trueValue = "";
                }
                if (falseValue == null) {
                    falseValue = "";
                }
                if (checkBox.isSelected()) {
                    this.idata.setVariable(var, (String)trueValue);
                    continue;
                }
                this.idata.setVariable(var, falseValue);
                continue;
            }
            if (element.getType() == UIElementType.GROUPRADIO) {
                RadioButtonGroupUIElement rbg = (RadioButtonGroupUIElement)element;
                for (RadioButtonUIElement b : rbg.getRadioButtons()) {
                    JRadioButton radioButton = (JRadioButton)b.getComponent();
                    if (!radioButton.isSelected() || !radioButton.isEnabled()) continue;
                    this.idata.setVariable(var, b.getTrueValue());
                }
                continue;
            }
            if (element.getType() == UIElementType.COMBOBOX) {
                JComboBox comboBox = (JComboBox)this.getVisibleComponent(element.getComponent());
                value = ((TextValuePair)comboBox.getSelectedItem()).getValue();
                this.idata.setVariable(var, value);
                continue;
            }
            if (element.getType() == UIElementType.FILE) {
                input = (FileInputField)element.getComponent();
                value = ((FileInputField)input).getSelectedFile().getAbsolutePath();
                this.idata.setVariable(var, value);
                continue;
            }
            if (element.getType() == UIElementType.FILE_DIR) {
                input = (FileInputField)element.getComponent();
                value = ((FileInputField)input).getSelectedFile().getAbsolutePath();
                this.idata.setVariable(var, value);
                continue;
            }
            if (element.getType() == UIElementType.DIR_URL) {
                input = (DirUrlInputField)element.getComponent();
                value = ((DirUrlInputField)input).getSelectedValue();
                this.idata.setVariable(var, value);
                continue;
            }
            if (element.getType() == UIElementType.FILE_URL) {
                input = (FileUrlInputField)element.getComponent();
                value = ((DirUrlInputField)input).getSelectedValue();
                this.idata.setVariable(var, value);
                continue;
            }
            if (element.getType() == UIElementType.DIRECTORY) {
                input = (FileInputField)element.getComponent();
                value = ((FileInputField)input).getSelectedFile().getAbsolutePath();
                this.idata.setVariable(var, value);
                continue;
            }
            if (element.getType() == UIElementType.MULTIPLE_FILE) {
                input = (MultipleFileInputField)element.getComponent();
                List<String> files = ((MultipleFileInputField)input).getSelectedFiles();
                if (((MultipleFileInputField)input).isCreateMultipleVariables()) {
                    int index = 0;
                    for (String file : files) {
                        StringBuffer indexedVariableName = new StringBuffer(var);
                        if (index > 0) {
                            indexedVariableName.append("_");
                            indexedVariableName.append(index);
                        }
                        ++index;
                        this.idata.setVariable(indexedVariableName.toString(), file);
                    }
                    continue;
                }
                if (files == null || files.isEmpty()) {
                    this.idata.setVariable(var, ";");
                    continue;
                }
                StringBuffer buffer = new StringBuffer();
                for (String file : files) {
                    buffer.append(file);
                    buffer.append(";");
                }
                this.idata.setVariable(var, buffer.toString());
                continue;
            }
            if (element.getType() != UIElementType.DYNAMIC) continue;
            this.readDynamicComponent(element, false);
        }
    }

    private boolean readInput() {
        boolean success = true;
        this.passwordGroupsRead.clear();
        this.summaryEntries.clear();
        this.saveToInstallData(true);
        for (UIElement element : this.elements) {
            JComponent component = this.getVisibleComponent(element.getComponent());
            boolean isEnabled = component.isEnabled();
            if (!element.isDisplayed() || !isEnabled) continue;
            if (element.getType() == UIElementType.RULE) {
                success = this.readRuleField(element);
            } else if (element.getType() == UIElementType.PASSWORD) {
                success = this.readPasswordField(element);
            } else if (element.getType() == UIElementType.TEXT) {
                success = this.readTextField(element);
            } else if (element.getType() == UIElementType.COMBOBOX) {
                success = this.readComboBox(element);
            } else if (element.getType() == UIElementType.GROUPRADIO) {
                success = this.readRadioButtonGroup(element);
            } else if (element.getType() == UIElementType.CHECKBOX) {
                success = this.readCheckBox(element);
            } else if (element.getType() == UIElementType.SEARCH) {
                success = this.readSearch(element);
            } else if (element.getType() == UIElementType.MULTIPLE_FILE) {
                success = this.readMultipleFileField(element);
            } else if (element.getType() == UIElementType.FILE) {
                success = this.readFileField(element);
            } else if (element.getType() == UIElementType.DIR_URL) {
                success = this.readDirUrlField(element);
            } else if (element.getType() == UIElementType.FILE_URL) {
                success = this.readFileUrlField(element);
            } else if (element.getType() == UIElementType.DIRECTORY) {
                success = this.readDirectoryField(element);
            } else if (element.getType() == UIElementType.DYNAMIC) {
                success = this.readDynamicComponent(element, true);
            }
            if (success) continue;
            return false;
        }
        if (!fieldsToDownload.isEmpty()) {
            JPanel downloadDisplayPanel = new JPanel();
            downloadDisplayPanel.setLayout(new GridBagLayout());
            final ArrayList<FileDownloadManager> downloadPanels = new ArrayList<FileDownloadManager>();
            final JButton ok = ButtonFactory.createButton(UIManager.getString((Object)"OptionPane.okButtonText", this.idata.locale));
            ok.setEnabled(false);
            JButton cancel = ButtonFactory.createButton(UIManager.getString((Object)"OptionPane.cancelButtonText", this.idata.locale));
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 23;
            c.fill = 1;
            c.insets = new Insets(10, 0, 10, 0);
            c.gridx = 0;
            c.weightx = 1.0;
            c.gridy = 0;
            c.weighty = 1.0;
            for (Map.Entry<String, DirUrlInputField> entry : fieldsToDownload.entrySet()) {
                FileDownloadManager panelToAdd = new FileDownloadManager(entry.getKey(), entry.getValue().getInputText(), this.idata, this.parentFrame);
                downloadPanels.add(panelToAdd);
                downloadDisplayPanel.add((Component)panelToAdd.getDownloadDisplayPanel(), c);
                panelToAdd.startDownload();
                ++c.gridy;
            }
            this.parent.lockNextButton();
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        for (FileDownloadManager fdm : downloadPanels) {
                            fdm.getFileDownloaderThread().join();
                        }
                        ok.setEnabled(true);
                    }
                    catch (InterruptedException ie) {
                        ie.printStackTrace();
                    }
                }
            });
            thread.start();
            int res = JOptionPane.showOptionDialog(this.parent.getContentPane(), downloadDisplayPanel, this.idata.langpack.getString("filedownloader.downloading.title"), 2, -1, null, new Object[]{ok, cancel}, ok);
            if (res == 1 || res == -1) {
                for (FileDownloadManager fdp : downloadPanels) {
                    fdp.stopDownload();
                    success = false;
                }
            }
            this.parent.unlockNextButton();
            if (success) {
                for (FileDownloadManager fdp : downloadPanels) {
                    String downloadPath = fdp.getFilePath();
                    if (downloadPath.isEmpty()) continue;
                    this.idata.setVariable(fdp.getAssociatedVariable() + ".tmp", downloadPath);
                }
                fieldsToDownload.clear();
            }
        }
        return success;
    }

    private boolean readDynamicComponent(UIElement field, boolean performValidation) {
        DynamicComponentsPanel dynamicComponentsPanel = (DynamicComponentsPanel)field.getComponent();
        Map<String, String> inputMap = dynamicComponentsPanel.serialize(field.getAssociatedVariable());
        ArrayList valueLists = new ArrayList();
        String variable = field.getAssociatedVariable();
        boolean result = true;
        if (!dynamicComponentsPanel.isEnabled()) {
            return result;
        }
        if (dynamicComponentsPanel.isVisible()) {
            for (int i = 1; i <= dynamicComponentsPanel.getCurrentNumberOfComponents(); ++i) {
                ArrayList<String> componentValues = new ArrayList<String>();
                if (dynamicComponentsPanel.getDynamicComponentType().equals(TwoJTextFieldJPanel.class)) {
                    componentValues.add(inputMap.get(String.format("%s-%d-name", variable, i)));
                    componentValues.add(inputMap.get(String.format("%s-%d-value", variable, i)));
                } else if (dynamicComponentsPanel.getDynamicComponentType().equals(SecurityDomainModule.class)) {
                    componentValues.add(inputMap.get(String.format("%s-%d-code", variable, i)));
                    componentValues.add(inputMap.get(String.format("%s-%d-flag", variable, i)));
                    componentValues.add(inputMap.get(String.format("%s-%d-operation", variable, i)));
                } else if (dynamicComponentsPanel.getDynamicComponentType().equals(PathSelectionPanel.class)) {
                    componentValues.add(inputMap.get(String.format("%s-%d-path", variable, i)));
                }
                valueLists.add(componentValues);
            }
            if (this.validating && performValidation) {
                List values;
                Iterator i = valueLists.iterator();
                while (i.hasNext() && (result = this.validateValue(values = (List)i.next(), dynamicComponentsPanel.getValidators()))) {
                }
            }
            if (result) {
                UserInputPanel.removeExistingDynamicComponentVariables(variable);
                for (String key : inputMap.keySet()) {
                    String value = inputMap.get(key);
                    this.idata.setVariable(key, value);
                    this.entries.add(new TextValuePair(key, value));
                }
                String numberOfComponents = Integer.toString(dynamicComponentsPanel.getCurrentNumberOfComponents());
                this.idata.setVariable(variable + DYNAMIC_FIELD_COMPONENT_NUM_ENDING, numberOfComponents);
                this.entries.add(new TextValuePair(variable + DYNAMIC_FIELD_COMPONENT_NUM_ENDING, numberOfComponents));
            }
        }
        return result;
    }

    public boolean validateValue(List<String> values, List<ValidatorContainer> containers) {
        String columnKey = "column";
        for (ValidatorContainer validator : containers) {
            ArrayList<ValidatorContainer> validators = new ArrayList<ValidatorContainer>();
            validators.add(validator);
            if (validator.getValidatorParams().containsKey(columnKey)) {
                int column = Integer.parseInt(validator.getValidatorParams().get(columnKey));
                StringInputProcessingClient processingClient = new StringInputProcessingClient(values.get(column), validators);
                List<Validator.Status> validationResult = processingClient.validate();
                if (validationResult.contains((Object)Validator.Status.ERROR)) {
                    String validatorError = processingClient.getValidationMessage().get(processingClient.getValidationMessage().size() - 1);
                    this.emitError(this.idata.langpack.getString("Error"), validatorError);
                    return false;
                }
                if (!validationResult.contains((Object)Validator.Status.WARNING)) continue;
                StringBuilder errors = new StringBuilder();
                for (String message : processingClient.getValidationMessage()) {
                    errors.append(message).append('\n');
                }
                errors.append(this.parentFrame.langpack.getString("UserInputPanel.validation.warning.question"));
                continue;
            }
            MultipleFieldValidator processingClient = new MultipleFieldValidator(values, validators);
            List<Validator.Status> validationResult = processingClient.validate();
            if (validationResult.contains((Object)Validator.Status.ERROR)) {
                String validatorError = processingClient.getValidationMessage().get(processingClient.getValidationMessage().size());
                this.emitError(this.idata.langpack.getString("Error"), validatorError);
                return false;
            }
            if (!validationResult.contains((Object)Validator.Status.WARNING)) continue;
            StringBuilder errors = new StringBuilder();
            for (String message : processingClient.getValidationMessage()) {
                errors.append(message).append('\n');
            }
            this.emitWarning(this.idata.langpack.getString("Warning"), errors.toString());
        }
        return true;
    }

    public static void removeExistingDynamicComponentVariables(String variable) {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        String startRegex = String.format("^%s-[0-9]{1,2}-.*$", variable);
        String endRegex = "^.*-path|.*-name$|^.*-value$|^.*-code$|^.*-flag$|^.*-operation$";
        for (String key : idata.getVariables().stringPropertyNames()) {
            if (!key.matches(startRegex) || !key.matches(endRegex)) continue;
            idata.getVariables().remove(key);
        }
    }

    private boolean readDirectoryField(UIElement field) {
        boolean result;
        block6: {
            result = false;
            try {
                FileInputField input = (FileInputField)this.getVisibleComponent(field.getComponent());
                boolean bl = result = !this.validating || input.validateField();
                if (result) {
                    String value = "";
                    File inputFile = input.getSelectedFile();
                    if (inputFile != null && !inputFile.getName().equals("")) {
                        value = input.getSelectedFile().getAbsolutePath();
                    }
                    if (field.getReplacePath()) {
                        this.replacePathMap.add(field.getAssociatedVariable());
                    }
                    this.idata.setVariable(field.getAssociatedVariable(), value);
                    this.entries.add(new TextValuePair(field.getAssociatedVariable(), value));
                    if (field.isSummarized()) {
                        this.summaryEntries.add(new TextValuePair(field.getAssociatedVariable(), value));
                    }
                }
            }
            catch (Exception e) {
                if (!Debug.stackTracing()) break block6;
                Debug.trace(e);
            }
        }
        return result;
    }

    private boolean readFileField(UIElement field) {
        boolean result;
        block6: {
            result = false;
            try {
                FileInputField input = (FileInputField)this.getVisibleComponent(field.getComponent());
                boolean bl = result = !this.validating || input.validateField();
                if (result) {
                    String value = "";
                    File inputFile = input.getSelectedFile();
                    if (inputFile != null && !inputFile.getName().equals("")) {
                        value = input.getSelectedFile().getAbsolutePath();
                    }
                    if (field.getReplacePath()) {
                        this.replacePathMap.add(field.getAssociatedVariable());
                    }
                    this.idata.setVariable(field.getAssociatedVariable(), value);
                    this.entries.add(new TextValuePair(field.getAssociatedVariable(), value));
                    if (field.isSummarized()) {
                        this.summaryEntries.add(new TextValuePair(field.getAssociatedVariable(), value));
                    }
                }
            }
            catch (Exception e) {
                if (!Debug.stackTracing()) break block6;
                Debug.trace(e);
            }
        }
        return result;
    }

    private boolean readDirUrlField(UIElement field) {
        boolean result;
        block6: {
            result = false;
            try {
                DirUrlInputField input = (DirUrlInputField)this.getVisibleComponent(field.getComponent());
                boolean bl = result = !this.validating || input.validateField();
                if (result) {
                    String value = input.getSelectedValue();
                    if (field.getReplacePath()) {
                        this.replacePathMap.add(field.getAssociatedVariable());
                    }
                    fieldsToDownload.remove(field.getAssociatedVariable());
                    this.idata.setVariable(field.getAssociatedVariable(), value);
                    this.entries.add(new TextValuePair(field.getAssociatedVariable(), value));
                    if (!input.isSuppressed() && this.isRemoteFile(value)) {
                        fieldsToDownload.put(field.getAssociatedVariable(), input);
                    }
                    if (field.isSummarized()) {
                        this.summaryEntries.add(new TextValuePair(field.getAssociatedVariable(), value));
                    }
                }
            }
            catch (Exception e) {
                if (!Debug.stackTracing()) break block6;
                Debug.trace(e);
            }
        }
        return result;
    }

    private boolean isRemoteFile(String value) {
        for (String protocol : supportedRemoteProtocols) {
            if (!value.startsWith(protocol)) continue;
            return true;
        }
        return false;
    }

    private JComponent getVisibleComponent(JComponent component) {
        if (component instanceof JFocusPanel) {
            return ((JFocusPanel)component).getComponent();
        }
        return component;
    }

    private boolean readFileUrlField(UIElement field) {
        boolean result;
        block6: {
            result = false;
            try {
                FileUrlInputField input = (FileUrlInputField)this.getVisibleComponent(field.getComponent());
                boolean bl = result = !this.validating || input.validateField();
                if (result) {
                    String value = input.getSelectedValue();
                    if (field.getReplacePath()) {
                        this.replacePathMap.add(field.getAssociatedVariable());
                    }
                    fieldsToDownload.remove(field.getAssociatedVariable());
                    this.idata.setVariable(field.getAssociatedVariable(), value);
                    this.entries.add(new TextValuePair(field.getAssociatedVariable(), value));
                    if (!input.isSuppressed() && this.isRemoteFile(value)) {
                        fieldsToDownload.put(field.getAssociatedVariable(), input);
                    }
                    if (field.isSummarized()) {
                        this.summaryEntries.add(new TextValuePair(field.getAssociatedVariable(), value));
                    }
                }
            }
            catch (Exception e) {
                if (!Debug.stackTracing()) break block6;
                Debug.trace(e);
            }
        }
        return result;
    }

    private boolean readFileDirField(UIElement field) {
        boolean result;
        block6: {
            result = false;
            try {
                FileInputField input = (FileInputField)field.getComponent();
                boolean bl = result = !this.validating || input.validateField();
                if (result) {
                    String value = "";
                    File inputFile = input.getSelectedFile();
                    if (inputFile != null && !inputFile.getName().equals("")) {
                        value = input.getSelectedFile().getAbsolutePath();
                    }
                    if (field.getReplacePath()) {
                        this.replacePathMap.add(field.getAssociatedVariable());
                    }
                    this.idata.setVariable(field.getAssociatedVariable(), value);
                    this.entries.add(new TextValuePair(field.getAssociatedVariable(), value));
                    if (field.isSummarized()) {
                        this.summaryEntries.add(new TextValuePair(field.getAssociatedVariable(), value));
                    }
                }
            }
            catch (Exception e) {
                if (!Debug.stackTracing()) break block6;
                Debug.trace(e);
            }
        }
        return result;
    }

    private boolean readMultipleFileField(UIElement field) {
        boolean result;
        block9: {
            result = false;
            try {
                MultipleFileInputField input = (MultipleFileInputField)field.getComponent();
                boolean bl = result = !this.validating || input.validateField();
                if (result) {
                    List<String> files = input.getSelectedFiles();
                    String variable = field.getAssociatedVariable();
                    if (input.isCreateMultipleVariables()) {
                        int index = 0;
                        for (String file : files) {
                            StringBuffer indexedVariableName = new StringBuffer(variable);
                            if (index > 0) {
                                indexedVariableName.append("_");
                                indexedVariableName.append(index);
                            }
                            ++index;
                            this.idata.setVariable(indexedVariableName.toString(), file);
                            this.entries.add(new TextValuePair(indexedVariableName.toString(), file));
                            if (!field.isSummarized()) continue;
                            this.summaryEntries.add(new TextValuePair(field.getAssociatedVariable(), file));
                        }
                    } else {
                        StringBuffer buffer = new StringBuffer();
                        for (String file : files) {
                            buffer.append(file);
                            buffer.append(";");
                        }
                        this.idata.setVariable(variable, buffer.toString());
                        String value = buffer.toString();
                        this.entries.add(new TextValuePair(variable, value));
                        if (field.isSummarized()) {
                            this.summaryEntries.add(new TextValuePair(field.getAssociatedVariable(), value));
                        }
                    }
                }
            }
            catch (Exception e) {
                if (!Debug.stackTracing()) break block9;
                Debug.trace(e);
            }
        }
        return result;
    }

    private void readSpec() throws Exception {
        InputStream input = null;
        String instance = Integer.toString(this.instanceNumber);
        String panelid = null;
        Panel p = this.getMetadata();
        if (p != null) {
            panelid = p.getPanelid();
        }
        try {
            input = this.parentFrame.getResource(SPEC_FILE_NAME);
        }
        catch (Exception exception) {
            this.haveSpec = false;
            return;
        }
        if (input == null) {
            this.haveSpec = false;
            return;
        }
        XMLParser parser = new XMLParser();
        IXMLElement data = parser.parse(input);
        if (data.hasChildren()) {
            Vector<IXMLElement> specElements = data.getChildrenNamed(NODE_ID);
            for (int i = 0; i < specElements.size(); ++i) {
                data = specElements.elementAt(i);
                String summary = data.getAttribute(SUMMARY);
                String panelattribute = data.getAttribute("id");
                String attribute = data.getAttribute(INSTANCE_IDENTIFIER);
                if ((attribute == null || !instance.equals(attribute)) && (panelattribute == null || panelid == null || !panelid.equals(panelattribute))) continue;
                this.spec = data;
                input.close();
                this.haveSpec = true;
                return;
            }
            this.haveSpec = false;
            return;
        }
        this.haveSpec = false;
    }

    private void addTitle(IXMLElement spec) {
        String htmlLabel = "<html>%s</html>";
        String title = this.getText(spec);
        String subtitleId = spec.getAttribute("subtitle", "");
        boolean italic = this.getBoolean(spec, ITALICS, false);
        boolean bold = this.getBoolean(spec, BOLD, false);
        float multiplier = this.getFloat(spec, "size", 1.0f);
        int justify = this.getAlignment(spec);
        String conditionid = spec.getAttribute(ATTRIBUTE_CONDITIONID_NAME);
        boolean isActive = conditionid == null || this.idata.getRules().isConditionTrue(conditionid);
        String icon = this.getIconName(spec);
        if (title != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(title.trim());
            Font font = FontResources.getOpenSansLight();
            int style = 0;
            if (bold) {
                ++style;
            }
            if (italic) {
                style += 2;
            }
            float fontSize = (float)font.getSize() * multiplier;
            font = font.deriveFont(style, fontSize);
            if (!subtitleId.isEmpty()) {
                String subtitleText = this.langpack.getString(subtitleId);
                float subtitleFontSize = fontSize * 0.6f;
                sb.append("<br/><span style='font-size:").append((int)subtitleFontSize).append("px'>").append(subtitleText).append("</span>");
            }
            JLabel label = null;
            ImageIcon imgicon = null;
            try {
                imgicon = this.parent.icons.getImageIcon(icon);
                label = LabelFactory.create(title, imgicon, 11, true);
            }
            catch (Exception e) {
                Debug.trace("Icon " + icon + " not found in icon list. " + e.getMessage());
                label = LabelFactory.create(String.format("<html>%s</html>", sb.toString()));
            }
            label.setFont(font);
            label.setAlignmentX(0.0f);
            label.setEnabled(isActive);
            label.setFocusable(false);
            this.panel.add((Component)label, GridBagConstraintsFactory.getTitleConstraints(justify));
            this.addToolTiptoElement(spec, label);
        }
    }

    protected String getIconName(IXMLElement element) {
        if (element == null) {
            return null;
        }
        String key = element.getAttribute(ICON_KEY);
        String text = null;
        if (key != null && this.langpack != null) {
            try {
                text = this.langpack.getString(key);
            }
            catch (Throwable exception) {
                text = null;
            }
        }
        return text;
    }

    private void addRuleField(IXMLElement spec) {
        String separator;
        boolean isHeader;
        String set;
        String layout;
        JTextArea label;
        Vector<IXMLElement> forPacks = spec.getChildrenNamed(SELECTEDPACKS);
        Vector<IXMLElement> forOs = spec.getChildrenNamed(OS);
        IXMLElement element = spec.getFirstChildNamed(SPEC);
        String variable = spec.getAttribute("variable");
        RuleInputField field = null;
        String message = null;
        String processor = null;
        String conditionid = spec.getAttribute(ATTRIBUTE_CONDITIONID_NAME);
        boolean isActive = conditionid == null || this.idata.getRules().isConditionTrue(conditionid);
        String alwaysActive = spec.getAttribute(ATTRIBUTE_ALWAYS_DISPALAY);
        boolean visibleWhenNotActive = alwaysActive != null && alwaysActive.equals(TRUE);
        int resultFormat = 2;
        if (element != null) {
            label = LabelFactory.createMultilineLabel(this.getText(element), true);
            label.setFocusable(false);
            label.setEnabled(isActive);
            layout = element.getAttribute(RULE_LAYOUT);
            set = element.getAttribute(SET);
            isHeader = this.isHeader(element);
            separator = element.getAttribute(RULE_SEPARATOR);
            String format = element.getAttribute(RULE_RESULT_FORMAT);
            if (format != null) {
                if (format.equals(RULE_PLAIN_STRING)) {
                    resultFormat = 1;
                } else if (format.equals(RULE_DISPLAY_FORMAT)) {
                    resultFormat = 2;
                } else if (format.equals(RULE_SPECIAL_SEPARATOR)) {
                    resultFormat = 3;
                } else if (format.equals(RULE_ENCRYPTED)) {
                    resultFormat = 4;
                }
            }
        } else {
            return;
        }
        element = spec.getFirstChildNamed(DESCRIPTION);
        this.addDescription(element, forPacks, forOs, this.currentRow);
        ++this.currentRow;
        List<ValidatorContainer> validatorConfig = this.analyzeValidator(spec);
        element = spec.getFirstChildNamed(PROCESSOR);
        if (element != null) {
            processor = element.getAttribute(CLASS);
        }
        RuleInputField.finalVariable = variable;
        field = new RuleInputField(layout, set, separator, validatorConfig, processor, resultFormat, this.getToolkit(), this.idata);
        field.setEnabled(isActive);
        if (this.focusedOnActivate(spec) && field.getInputFields() != null) {
            this.setInitialFocus(field.getInputFields().get(0));
        }
        int totalRuleFieldWidth = 0;
        for (JTextComponent jtc : field.getInputFields()) {
            jtc.setFocusable(!isHeader);
            AccessibleContext ac = jtc.getAccessibleContext();
            ac.setAccessibleDescription("RuleInputField TextComponent containing part of the variable " + variable);
            this.addToolTiptoElement(spec, jtc);
            totalRuleFieldWidth = (int)((double)totalRuleFieldWidth + (jtc.getPreferredSize().getWidth() + 5.0));
        }
        String indentStr = spec.getAttribute(ATTRIBUTE_INDENT);
        int indent = this.getIndent(spec);
        label.setVisible(isActive || visibleWhenNotActive || this.displayHidden);
        this.setLabelColumns(label, totalRuleFieldWidth, indent);
        UIElement labelUiElement = new UIElement();
        labelUiElement.setType(UIElementType.LABEL);
        labelUiElement.setConstraints(GridBagConstraintsFactory.createAlignedElementConstraint(this.currentRow, 0, indent, 2));
        labelUiElement.setComponent(label, this.parent.hasBackground);
        labelUiElement.setForPacks(forPacks);
        labelUiElement.setForOs(forOs);
        labelUiElement.setConditionid(conditionid);
        labelUiElement.setAlwaysActive(visibleWhenNotActive);
        this.elements.add(labelUiElement);
        this.addToolTiptoElement(spec, label);
        this.parseSummarizeAttribute(spec, labelUiElement);
        field.setVisible(isActive || visibleWhenNotActive || this.displayHidden);
        UIElement ruleField = new UIElement();
        ruleField.setType(UIElementType.RULE);
        ruleField.setConstraints(GridBagConstraintsFactory.createAlignedElementConstraint(this.currentRow, 1, 20, 2));
        ruleField.setComponent(field, this.parent.hasBackground);
        ruleField.setForPacks(forPacks);
        ruleField.setForOs(forOs);
        ruleField.setAssociatedVariable(variable);
        ruleField.setMessage(message);
        ruleField.setConditionid(conditionid);
        ruleField.setAlwaysActive(visibleWhenNotActive);
        this.elements.add(ruleField);
    }

    @Override
    public String getSummaryBody() {
        String key;
        LinkedHashMap<String, String> entryMap = new LinkedHashMap<String, String>();
        for (int i = 0; i < this.summaryEntries.size(); ++i) {
            TextValuePair pair = this.summaryEntries.elementAt(i);
            key = pair.toString();
            entryMap.put(key, this.idata.getVariable(key));
        }
        Iterator keys = entryMap.keySet().iterator();
        StringBuilder tmp = new StringBuilder();
        while (keys.hasNext()) {
            key = (String)keys.next();
            String value = (String)entryMap.get(key);
            String keyname = this.idata.langpack.getString(key);
            if (keyname.equals("") || value.isEmpty()) continue;
            tmp.append(keyname + ": " + value + "<br>");
        }
        if (tmp.toString().trim().isEmpty()) {
            return null;
        }
        return tmp.toString();
    }

    @Override
    public String getInstanceNumber() {
        return Integer.toString(this.instanceNumber);
    }

    private boolean readRuleField(UIElement field) {
        boolean success;
        RuleInputField ruleField = null;
        String variable = null;
        String message = null;
        try {
            ruleField = (RuleInputField)field.getComponent();
            variable = field.getAssociatedVariable();
            message = field.getMessage();
        }
        catch (Throwable exception) {
            return true;
        }
        if (variable == null || ruleField == null) {
            return true;
        }
        String validated = ruleField.validateContentsMultiValidators();
        boolean bl = success = !this.validating || validated.equals("");
        if (!success) {
            this.showWarningMessageDialog(this.parentFrame, validated);
            return false;
        }
        FinalAndInitialVariables boo = ruleField.getFinalAndInitialVariables();
        int count = 0;
        for (String temp : boo.getInitialVariables(variable)) {
            temp = temp.substring(temp.indexOf("{") + 1, temp.indexOf("}"));
            this.idata.setVariable(temp, ruleField.getFieldContents(count));
            ++count;
        }
        String value = ruleField.getText();
        this.idata.setVariable(variable, value);
        this.entries.add(new TextValuePair(variable, value));
        if (field.isSummarized()) {
            this.summaryEntries.add(new TextValuePair(field.getAssociatedVariable(), value));
        }
        return true;
    }

    private void addTextField(IXMLElement field) {
        boolean numeric;
        IXMLElement spec = field.getFirstChildNamed(SPEC);
        String variable = field.getAttribute("variable");
        boolean bl = numeric = spec.getAttribute("numeric") != null;
        if (variable == null || spec == null) {
            return;
        }
        String value = this.idata.getVariable(variable);
        String conditionid = field.getAttribute(ATTRIBUTE_CONDITIONID_NAME);
        boolean isActive = conditionid == null || this.idata.getRules().isConditionTrue(conditionid);
        String alwaysActive = field.getAttribute(ATTRIBUTE_ALWAYS_DISPALAY);
        boolean visibleWhenNotActive = alwaysActive != null && alwaysActive.equals(TRUE);
        Boolean isEditable = null;
        if (field.hasAttribute(EDITABLE)) {
            isEditable = field.getAttribute(EDITABLE).equals(TRUE);
        }
        String defaultValue = spec.getAttribute(SET, "");
        String textSize = spec.getAttribute("size", "1");
        String textRows = spec.getAttribute(TEXT_ROWS, "1");
        int fill = this.getFill(spec.getAttribute(COMPONENT_FILL, "horizontal"));
        int size = Integer.parseInt(textSize);
        int rows = Integer.parseInt(textRows);
        if (value != null) {
            defaultValue = value;
        } else if (!defaultValue.isEmpty()) {
            VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
            defaultValue = Boolean.parseBoolean(field.getAttribute(DEEP_SUB, FALSE)) ? vs.deepSubstitute(defaultValue, null) : vs.substitute(defaultValue, null);
        }
        List<ValidatorContainer> validatorConfig = this.analyzeValidator(field);
        Vector<IXMLElement> forPacks = field.getChildrenNamed(SELECTEDPACKS);
        Vector<IXMLElement> forOs = field.getChildrenNamed(OS);
        IXMLElement descr = field.getFirstChildNamed(DESCRIPTION);
        this.addDescription(descr, forPacks, forOs, this.currentRow);
        ++this.currentRow;
        JTextArea label = LabelFactory.createMultilineLabel(this.getText(spec), true);
        label.setFocusable(false);
        label.setEnabled(isActive);
        label.setVisible(isActive || visibleWhenNotActive || this.displayHidden);
        TextInputField inputField = new TextInputField(defaultValue, size, rows, validatorConfig, numeric);
        inputField.setEnabled(isActive);
        inputField.setEditable(isEditable == null ? isActive : isEditable);
        inputField.setVisible(isActive || visibleWhenNotActive || this.displayHidden);
        if (this.focusedOnActivate(field)) {
            this.setInitialFocus(inputField.getField());
        }
        this.setLabelColumns(label, (int)inputField.getPreferredSize().getWidth(), this.getIndent(field));
        UIElement labelUiElement = new UIElement();
        labelUiElement.setType(UIElementType.LABEL);
        labelUiElement.setConstraints(GridBagConstraintsFactory.createAlignedElementConstraint(this.currentRow, 0, this.getIndent(field), 0));
        labelUiElement.setComponent(label, this.parent.hasBackground);
        labelUiElement.setForPacks(forPacks);
        labelUiElement.setForOs(forOs);
        labelUiElement.setConditionid(conditionid);
        labelUiElement.setAlwaysActive(visibleWhenNotActive);
        this.addToolTiptoElement(field, label);
        this.parseSummarizeAttribute(spec, labelUiElement);
        AccessibleContext ac = inputField.getField().getAccessibleContext();
        ac.setAccessibleDescription("JTextComponent for setting variable: " + variable);
        UIElement textUiElement = new UIElement();
        textUiElement.setDeepSub(Boolean.parseBoolean(field.getAttribute(DEEP_SUB, FALSE)));
        textUiElement.setDependency(field.getAttribute(DEPENDS_ON, ""));
        textUiElement.setComponent(inputField, this.parent.hasBackground);
        textUiElement.setType(UIElementType.TEXT);
        textUiElement.setAssociatedVariable(variable);
        textUiElement.setConstraints(GridBagConstraintsFactory.createAlignedElementConstraint(this.currentRow, 1, 20, fill));
        textUiElement.setForPacks(forPacks);
        textUiElement.setForOs(forOs);
        textUiElement.setConditionid(conditionid);
        textUiElement.setAlwaysActive(visibleWhenNotActive);
        textUiElement.setEditable(isEditable);
        this.addToolTiptoElement(field, inputField.getField());
        this.parseSummarizeAttribute(spec, textUiElement);
        if (this.focusedOnActivate(field)) {
            this.setInitialFocus(inputField.getField());
        }
        this.elements.add(labelUiElement);
        this.elements.add(textUiElement);
    }

    private int getFill(String fill) {
        if (fill.equals("horizontal")) {
            return 2;
        }
        if (fill.equals("vertical")) {
            return 3;
        }
        if (fill.equals("both")) {
            return 1;
        }
        if (fill.equals("remainder")) {
            return 0;
        }
        if (fill.equals("relative")) {
            return -1;
        }
        if (fill.equals("none")) {
            return 0;
        }
        return 2;
    }

    private boolean readTextField(UIElement field) {
        boolean success;
        TextInputField textField = null;
        String variable = null;
        String value = null;
        try {
            textField = (TextInputField)field.getComponent();
            variable = field.getAssociatedVariable();
            value = textField.getText();
        }
        catch (Throwable exception) {
            return true;
        }
        if (variable == null || value == null || !textField.isEnabled()) {
            return true;
        }
        Debug.trace("Validating text field");
        String validated = textField.validateContentsMultiValidators();
        boolean bl = success = !this.validating || validated.equals("");
        if (!success) {
            this.showMessageDialog(this.parentFrame, validated, "UserInputPanel.error.caption", 0);
            return false;
        }
        Debug.trace("Field validated");
        this.idata.setVariable(variable, value);
        this.entries.add(new TextValuePair(variable, value));
        if (field.isSummarized()) {
            this.summaryEntries.add(new TextValuePair(field.getAssociatedVariable(), value));
        }
        return true;
    }

    private void addButtonField(IXMLElement data) {
        Vector<IXMLElement> forPacks = data.getChildrenNamed(SELECTEDPACKS);
        Vector<IXMLElement> forOs = data.getChildrenNamed(OS);
        IXMLElement spec = data.getFirstChildNamed(SPEC);
        String variable = data.getAttribute("variable");
        String conditionid = data.getAttribute(ATTRIBUTE_CONDITIONID_NAME);
        boolean isActive = conditionid == null || this.idata.getRules().isConditionTrue(conditionid);
        String alwaysActive = data.getAttribute(ATTRIBUTE_ALWAYS_DISPALAY);
        boolean visibleWhenNotActive = alwaysActive != null && alwaysActive.equals(TRUE);
        String passwordGroup = spec.getAttribute(BUTTON_PASSWORD_FIELD);
        final String successMessage = this.idata.langpack.getString(spec.getAttribute("msg"));
        final List<ValidatorContainer> validators = this.analyzeValidator(spec);
        ArrayList<String> errorMsgs = new ArrayList<String>();
        for (IXMLElement validatorTag : spec.getChildrenNamed(VALIDATOR)) {
            errorMsgs.add(validatorTag.getAttribute("id"));
        }
        PasswordGroup temp = new PasswordGroup(this.idata, new ArrayList<ValidatorContainer>(), "Dummy");
        if (passwordGroup != null && !passwordGroup.isEmpty()) {
            temp.setGroupName(passwordGroup);
        }
        final PasswordGroup processor = temp;
        JButton button = ButtonFactory.createButton(this.idata.langpack.getString(spec.getAttribute("id", "Missing String")));
        button.setEnabled(isActive);
        boolean useError = Boolean.parseBoolean(spec.getAttribute("useErrors", TRUE));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int i = 0;
                    UserInputPanel.this.saveToInstallData();
                    for (ValidatorContainer v : validators) {
                        Validator validator = v.getValidator();
                        DataValidator dValidator = (DataValidator)((Object)validator);
                        Validator.Status returnValue = validator.validate(processor);
                        if (returnValue == Validator.Status.ERROR) {
                            UserInputPanel.this.emitError(((UserInputPanel)UserInputPanel.this).idata.langpack.getString("Error"), ((UserInputPanel)UserInputPanel.this).idata.langpack.getString(dValidator.getErrorMessageId()));
                            return;
                        }
                        if (returnValue == Validator.Status.WARNING) {
                            UserInputPanel.this.emitWarning(((UserInputPanel)UserInputPanel.this).idata.langpack.getString("Warning"), ((UserInputPanel)UserInputPanel.this).idata.langpack.getString(dValidator.getWarningMessageId()));
                            return;
                        }
                        ++i;
                    }
                    for (UIElement elm : UserInputPanel.this.elements) {
                        elm.getMessage();
                    }
                }
                catch (Exception exc) {
                    Debug.trace("Failed " + exc);
                }
                UserInputPanel.this.emitNotification(successMessage);
            }
        });
        String indentStr = data.getAttribute(ATTRIBUTE_INDENT);
        int indent = this.getIndent(data);
        button.setVisible(isActive || visibleWhenNotActive || this.displayHidden);
        UIElement buttonUiElement = new UIElement();
        buttonUiElement.setType(UIElementType.BUTTON);
        buttonUiElement.setConstraints(GridBagConstraintsFactory.createNonFullLineElementConstraint(this.currentRow, 0, 17, indent));
        buttonUiElement.setComponent(button, this.parent.hasBackground);
        buttonUiElement.setForPacks(forPacks);
        buttonUiElement.setForOs(forOs);
        buttonUiElement.setAssociatedVariable(variable);
        buttonUiElement.setDeepSub(Boolean.parseBoolean(spec.getAttribute(DEEP_SUB, FALSE)));
        buttonUiElement.setDependency(spec.getAttribute(DEPENDS_ON, ""));
        buttonUiElement.setSummarize(false);
        buttonUiElement.setConditionid(conditionid);
        buttonUiElement.setAlwaysActive(visibleWhenNotActive);
        this.addToolTiptoElement(data, button);
        this.elements.add(buttonUiElement);
    }

    private void addDynamicComponent(IXMLElement field) {
        JLabel rightLabel;
        Vector<IXMLElement> forPacks = field.getChildrenNamed(SELECTEDPACKS);
        Vector<IXMLElement> forOs = field.getChildrenNamed(OS);
        IXMLElement spec = field.getFirstChildNamed(SPEC);
        String variable = field.getAttribute("variable");
        String conditionid = field.getAttribute(ATTRIBUTE_CONDITIONID_NAME);
        boolean isActive = conditionid == null || this.idata.getRules().isConditionTrue(conditionid);
        String alwaysActive = field.getAttribute(ATTRIBUTE_ALWAYS_DISPALAY);
        boolean visibleWhenNotActive = alwaysActive != null && alwaysActive.equals(TRUE);
        String addButtonText = spec.getAttribute("addButton");
        String removeButtonText = spec.getAttribute("removeButton");
        String componentType = field.getAttribute("componentType");
        int maxComponents = Integer.parseInt(spec.getAttribute("max"));
        int minComponents = Integer.parseInt(spec.getAttribute("min"));
        Class type = null;
        DynamicComponentsPanel dynamicComponent = null;
        if (componentType.equals(DYNAMIC_FIELD_PATH)) {
            type = PathSelectionPanel.class;
            String filter = spec.getAttribute("fileext", "");
            String filterdesc = spec.getAttribute("fileextdesc", "");
            dynamicComponent = new DynamicComponentsPanel(type, maxComponents, minComponents, this.idata.langpack.getString(field.getAttribute(TOOLTIP)), this.idata.langpack.getString(addButtonText), this.idata.langpack.getString(removeButtonText));
            dynamicComponent.setFileExt(filter);
            dynamicComponent.setFileExtDes(filterdesc);
        } else if (componentType.equals(DYNAMIC_FIELD_TWOTEXT)) {
            String panelid = ((IzPanel)this.idata.panels.get(this.idata.curPanelNumber)).getMetadata().getPanelid();
            if (panelid.equals("Datasource Configuration Panel")) {
                String JDBCDriverType = this.idata.getVariable("jdbc.driver.name");
                if (JDBCDriverType.equals("ibmdb2") || JDBCDriverType.equals("oracle")) {
                    minComponents = 1;
                } else if (JDBCDriverType.equals("sqlserver") || JDBCDriverType.equals("postgresql")) {
                    minComponents = 3;
                } else if (JDBCDriverType.equals("mysql") || JDBCDriverType.equals("mariadb")) {
                    minComponents = 2;
                } else if (JDBCDriverType.equals("sybase")) {
                    minComponents = 4;
                }
            }
            type = TwoJTextFieldJPanel.class;
            JPanel headerPanel = new JPanel(new GridLayout(1, 1));
            headerPanel.setOpaque(false);
            JLabel leftLabel = new JLabel(spec.getAttribute("leftLabel"));
            leftLabel.setOpaque(false);
            rightLabel = new JLabel(spec.getAttribute("rightLabel"));
            rightLabel.setOpaque(false);
            headerPanel.add(leftLabel);
            headerPanel.add(rightLabel);
            dynamicComponent = new DynamicComponentsPanel(type, maxComponents, minComponents, headerPanel, this.idata.langpack.getString(field.getAttribute(TOOLTIP)), this.idata.langpack.getString(addButtonText), this.idata.langpack.getString(removeButtonText));
        } else if (componentType.equals(DYNAMIC_FIELD_SECURITY_DOMAIN)) {
            type = SecurityDomainModule.class;
            JPanel headerPanel = new JPanel(new GridLayout(1, 3));
            headerPanel.setOpaque(false);
            JLabel leftLabel = new JLabel(this.idata.langpack.getString(spec.getAttribute("leftLabel")));
            leftLabel.setOpaque(false);
            JLabel centreLabel = new JLabel(this.idata.langpack.getString(spec.getAttribute("centreLabel")));
            centreLabel.setOpaque(false);
            rightLabel = new JLabel(this.idata.langpack.getString(spec.getAttribute("rightLabel")));
            rightLabel.setOpaque(false);
            headerPanel.add(leftLabel);
            headerPanel.add(centreLabel);
            headerPanel.add(rightLabel);
            dynamicComponent = new DynamicComponentsPanel(type, maxComponents, minComponents, headerPanel, this.idata.langpack.getString(field.getAttribute(TOOLTIP)), this.idata.langpack.getString(addButtonText), this.idata.langpack.getString(removeButtonText));
        }
        dynamicComponent.setIzpanel(this);
        dynamicComponent.setIdata(this.idata);
        int numberOfComponents = this.getPreviousNumComponents(variable);
        if (componentType.equals(DYNAMIC_FIELD_PATH)) {
            dynamicComponent.addInitial(this.getInitalComponentValues(variable, numberOfComponents, minComponents, "path"));
        } else if (componentType.equals(DYNAMIC_FIELD_SECURITY_DOMAIN)) {
            String secDomainType = spec.getAttribute("secDomainType");
            if (secDomainType != null && !secDomainType.isEmpty()) {
                dynamicComponent.setId(secDomainType);
            }
            String[][] securityDomainDefaults = this.getInitialSecuirtyDomainValues(variable, numberOfComponents, minComponents);
            dynamicComponent.initializeDefaults(securityDomainDefaults);
        } else if (componentType.equals(DYNAMIC_FIELD_TWOTEXT)) {
            VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
            Vector<IXMLElement> providedDefaults = spec.getChildrenNamed("default");
            ArrayList<IXMLElement> validDefaults = new ArrayList<IXMLElement>();
            for (IXMLElement element : providedDefaults) {
                String defaultCondition = element.getAttribute(ATTRIBUTE_CONDITIONID_NAME);
                if (defaultCondition != null && !this.idata.getRules().isConditionTrue(defaultCondition)) continue;
                validDefaults.add(element);
            }
            String[][] defaults = new String[validDefaults.size()][2];
            HashSet<String> defaultKeys = new HashSet<String>();
            for (int i = 0; i < validDefaults.size(); ++i) {
                String key = ((IXMLElement)validDefaults.get(i)).getAttribute("key");
                defaultKeys.add(key);
                defaults[i][0] = key;
                defaults[i][1] = vs.substitute(((IXMLElement)validDefaults.get(i)).getAttribute("value"));
            }
            dynamicComponent.initializeDefaults(defaults);
            String panelid = ((IzPanel)this.idata.panels.get(this.idata.curPanelNumber)).getMetadata().getPanelid();
            if (numberOfComponents - validDefaults.size() > 0 && !panelid.equals("Datasource Configuration Panel")) {
                String[][] persistentTwoText = this.getInitialTwoTextComponents(variable, numberOfComponents, validDefaults.size());
                dynamicComponent.initializeDefaults(persistentTwoText, true);
            }
        }
        List<ValidatorContainer> validatorsList = this.analyzeValidator(field);
        dynamicComponent.setValidators(validatorsList);
        dynamicComponent.setVisible(isActive || visibleWhenNotActive || this.displayHidden);
        dynamicComponent.setEnabled(isActive);
        if (!componentType.equals(DYNAMIC_FIELD_SECURITY_DOMAIN)) {
            JTextArea label = LabelFactory.createMultilineLabel(this.getText(spec), false);
            this.setLabelColumns(label, dynamicComponent.getAddDynamicComponentButton().getPreferredSize().width + dynamicComponent.getRemoveDynamicComponentButton().getPreferredSize().width + 20, this.getIndent(field));
            label.setFocusable(false);
            label.setEnabled(isActive);
            label.setVisible(isActive || visibleWhenNotActive || this.displayHidden);
            UIElement labelUiElement = new UIElement();
            labelUiElement.setType(UIElementType.LABEL);
            labelUiElement.setConstraints(GridBagConstraintsFactory.createAlignedElementConstraint(this.currentRow, 0, this.getIndent(field), 2));
            labelUiElement.setComponent(label, this.parent.hasBackground);
            labelUiElement.setForPacks(forPacks);
            labelUiElement.setForOs(forOs);
            labelUiElement.setConditionid(conditionid);
            labelUiElement.setAlwaysActive(visibleWhenNotActive);
            this.addToolTiptoElement(field, label);
            this.parseSummarizeAttribute(spec, labelUiElement);
            this.elements.add(labelUiElement);
        }
        UIElement dynamicUIElement = new UIElement();
        dynamicUIElement.setType(UIElementType.DYNAMIC);
        if (componentType.equals(DYNAMIC_FIELD_SECURITY_DOMAIN)) {
            dynamicUIElement.setConstraints(GridBagConstraintsFactory.createFullLineElementConstraint(this.currentRow, 0, this.getIndent(field)));
        } else {
            dynamicUIElement.setConstraints(GridBagConstraintsFactory.createAlignedElementConstraint(this.currentRow, 1, 20, 2));
        }
        dynamicUIElement.setComponent(dynamicComponent, this.parent.hasBackground);
        dynamicUIElement.setForPacks(forPacks);
        dynamicUIElement.setForOs(forOs);
        dynamicUIElement.setAssociatedVariable(variable);
        dynamicUIElement.setDeepSub(false);
        dynamicUIElement.setSummarize(false);
        dynamicUIElement.setConditionid(conditionid);
        dynamicUIElement.setAlwaysActive(visibleWhenNotActive);
        this.elements.add(dynamicUIElement);
    }

    private int getPreviousNumComponents(String variable) {
        String numberString = this.idata.getVariable(variable + DYNAMIC_FIELD_COMPONENT_NUM_ENDING);
        int retVal = 0;
        if (numberString != null) {
            retVal = Integer.parseInt(numberString);
        }
        return retVal;
    }

    private String[][] getInitialSecuirtyDomainValues(String variable, int numberComponents, int minComponents) {
        int i;
        int size = numberComponents > minComponents ? numberComponents : minComponents;
        String[][] retArr = new String[size][3];
        for (i = 0; i < numberComponents; ++i) {
            retArr[i][0] = this.idata.getVariable(String.format("%s-%d-operation", variable, i + 1));
            retArr[i][1] = this.idata.getVariable(String.format("%s-%d-code", variable, i + 1));
            retArr[i][2] = this.idata.getVariable(String.format("%s-%d-flag", variable, i + 1));
        }
        for (i = numberComponents; i < minComponents; ++i) {
            retArr[i] = new String[]{"testName=testValue", "", ""};
        }
        return retArr;
    }

    private ArrayList<String> getInitalComponentValues(String variable, int numberComponents, int minComponents, String type) {
        ArrayList<String> retList = new ArrayList<String>();
        for (int i = 0; i < numberComponents; ++i) {
            retList.add(this.idata.getVariable(String.format("%s-%d-%s", variable, i + 1, type)));
        }
        while (retList.size() < minComponents) {
            retList.add("");
        }
        return retList;
    }

    private String[][] getInitialTwoTextComponents(String variable, int numberComponents, int numberDefaults) {
        int numNonDefaultComponent = numberComponents - numberDefaults;
        String[][] retArr = new String[numNonDefaultComponent][2];
        for (int i = 0; i < numNonDefaultComponent; ++i) {
            retArr[i][0] = this.idata.getVariable(String.format("%s-%d-name", variable, i + numberDefaults + 1));
            retArr[i][1] = this.idata.getVariable(String.format("%s-%d-value", variable, i + numberDefaults + 1));
        }
        return retArr;
    }

    private void addComboBox(IXMLElement spec) {
        String size;
        Vector<IXMLElement> forPacks = spec.getChildrenNamed(SELECTEDPACKS);
        Vector<IXMLElement> forOs = spec.getChildrenNamed(OS);
        IXMLElement element = spec.getFirstChildNamed(SPEC);
        String variable = spec.getAttribute("variable");
        TextValuePair listItem = null;
        String conditionid = spec.getAttribute(ATTRIBUTE_CONDITIONID_NAME);
        boolean isActive = conditionid == null || this.idata.getRules().isConditionTrue(conditionid);
        String alwaysActive = spec.getAttribute(ATTRIBUTE_ALWAYS_DISPALAY);
        boolean visibleWhenNotActive = alwaysActive != null && alwaysActive.equals(TRUE);
        JComboBox field = ComboBoxFactory.createComboBox();
        JFocusPanel emptyBorder = new JFocusPanel(field);
        field.setActionCommand("JComboBox setting variable: " + variable);
        field.setVisible(isActive || this.isDisplayingHidden() || visibleWhenNotActive);
        field.setEnabled(isActive);
        if (this.focusedOnActivate(spec)) {
            this.setInitialFocus(field);
        }
        AccessibleContext ac = field.getAccessibleContext();
        ac.setAccessibleDescription("This JComboBox sets the variable: " + variable);
        JTextArea label = LabelFactory.createMultilineLabel("", true);
        label.setFocusable(false);
        label.setEnabled(isActive);
        field.addFocusListener(new FocusListenerAutoScroll());
        field.addPopupMenuListener(new PopupListenerAutoScroll());
        String causesValidation = element.getAttribute(REVALIDATE);
        if (causesValidation != null && causesValidation.equals(YES)) {
            field.addItemListener(this);
        }
        if ((size = element.getAttribute("size")) != null) {
            field.setPreferredSize(new Dimension(Integer.valueOf(size), field.getPreferredSize().height));
            field.setMaximumSize(new Dimension(Integer.valueOf(size), field.getPreferredSize().height));
            field.setMinimumSize(new Dimension(Integer.valueOf(size), field.getPreferredSize().height));
        }
        int fill = this.getFill(element.getAttribute(COMPONENT_FILL, "horizontal"));
        boolean userinput = false;
        if (element != null) {
            Vector<IXMLElement> choices = element.getChildrenNamed("choice");
            if (choices == null) {
                return;
            }
            String currentvariablevalue = this.idata.getVariable(variable);
            if (currentvariablevalue != null) {
                userinput = true;
            }
            int choicenum = 0;
            for (int i = 0; i < choices.size(); ++i) {
                VariableSubstitutor vs;
                String set;
                String choiceCondition = choices.elementAt(i).getAttribute(ATTRIBUTE_CONDITIONID_NAME);
                if (choiceCondition != null && !this.parent.getRules().isConditionTrue(choiceCondition, this.idata.getVariables())) continue;
                String processorClass = choices.elementAt(i).getAttribute(PROCESSOR);
                if (processorClass != null && !"".equals(processorClass)) {
                    String choiceValues = "";
                    try {
                        choiceValues = ((Processor)Class.forName(processorClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).process(null);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    set = choices.elementAt(i).getAttribute(SET);
                    if (set == null) {
                        set = "";
                    }
                    if (set != null && !"".equals(set)) {
                        vs = new VariableSubstitutor(this.idata.getVariables());
                        set = Boolean.parseBoolean(spec.getAttribute(DEEP_SUB, FALSE)) ? vs.deepSubstitute(set, null) : vs.substitute(set, null);
                    }
                    StringTokenizer tokenizer = new StringTokenizer(choiceValues, ":");
                    int counter = 0;
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        listItem = new TextValuePair(token, token);
                        field.addItem(listItem);
                        if (set.equals(token)) {
                            field.setSelectedIndex(field.getItemCount() - 1);
                        }
                        ++counter;
                    }
                    continue;
                }
                String value = choices.elementAt(i).getAttribute("value");
                listItem = new TextValuePair(this.getText(choices.elementAt(i)), value);
                field.addItem(listItem);
                if (userinput) {
                    if (value != null && value.length() > 0 && currentvariablevalue.equals(value)) {
                        field.setSelectedIndex(choicenum);
                    }
                } else {
                    set = choices.elementAt(i).getAttribute(SET);
                    if (set != null) {
                        if (set != null && !"".equals(set)) {
                            vs = new VariableSubstitutor(this.idata.getVariables());
                            set = Boolean.parseBoolean(spec.getAttribute(DEEP_SUB, FALSE)) ? vs.deepSubstitute(set, null) : vs.substitute(set, null);
                        }
                        if (set.equals(TRUE)) {
                            field.setSelectedIndex(choicenum);
                        }
                    }
                }
                ++choicenum;
            }
        } else {
            return;
        }
        element = spec.getFirstChildNamed(DESCRIPTION);
        String description = this.getText(element);
        if (description != null) {
            label.setText(description);
            label.setVisible(isActive || this.isDisplayingHidden() || visibleWhenNotActive);
            label.setEnabled(isActive);
        }
        this.setLabelColumns(label, (int)field.getPreferredSize().getWidth(), 0);
        label.setVisible(isActive || visibleWhenNotActive || this.displayHidden);
        UIElement labelUiElement = new UIElement();
        labelUiElement.setType(UIElementType.LABEL);
        labelUiElement.setConstraints(GridBagConstraintsFactory.createAlignedElementConstraint(this.currentRow, 0, 0, 2));
        labelUiElement.setComponent(label, this.parent.hasBackground);
        labelUiElement.setForPacks(forPacks);
        labelUiElement.setForOs(forOs);
        labelUiElement.setConditionid(conditionid);
        labelUiElement.setAlwaysActive(visibleWhenNotActive);
        this.elements.add(labelUiElement);
        this.addToolTiptoElement(spec, label);
        this.parseSummarizeAttribute(spec, labelUiElement);
        field.setVisible(isActive || visibleWhenNotActive || this.displayHidden);
        UIElement comboUiElement = new UIElement();
        comboUiElement.setType(UIElementType.COMBOBOX);
        comboUiElement.setConstraints(GridBagConstraintsFactory.createAlignedElementConstraint(this.currentRow, 1, 20, fill));
        comboUiElement.setComponent(emptyBorder, this.parent.hasBackground);
        comboUiElement.setForPacks(forPacks);
        comboUiElement.setForOs(forOs);
        comboUiElement.setAssociatedVariable(variable);
        comboUiElement.setDeepSub(Boolean.parseBoolean(spec.getAttribute(DEEP_SUB, FALSE)));
        comboUiElement.setDependency(spec.getAttribute(DEPENDS_ON, ""));
        comboUiElement.setConditionid(conditionid);
        comboUiElement.setAlwaysActive(visibleWhenNotActive);
        this.elements.add(comboUiElement);
        this.addToolTiptoElement(spec, field);
        this.parseSummarizeAttribute(spec, comboUiElement);
    }

    private boolean readComboBox(UIElement field) {
        String value;
        String variable;
        try {
            variable = field.getAssociatedVariable();
            JComboBox comboBox = (JComboBox)((JFocusPanel)field.getComponent()).getComponent();
            value = ((TextValuePair)comboBox.getSelectedItem()).getValue();
        }
        catch (Throwable exception) {
            return true;
        }
        if (variable == null || value == null) {
            return true;
        }
        this.idata.setVariable(variable, value);
        this.entries.add(new TextValuePair(variable, value));
        if (field.isSummarized()) {
            this.summaryEntries.add(new TextValuePair(field.getAssociatedVariable(), value));
        }
        return true;
    }

    private void repositionComboPopup() {
        for (UIElement e : this.elements) {
            JComboBox b;
            if (e.type != UIElementType.COMBOBOX || !(b = (JComboBox)((JFocusPanel)e.getComponent()).getComponent()).isPopupVisible()) continue;
            b.hidePopup();
            b.showPopup();
        }
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        this.repositionComboPopup();
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.repositionComboPopup();
    }

    private RadioButtonUIElement addRadioButton(IXMLElement field, int indent) {
        String trueValue = field.getAttribute("value");
        String defaultValue = field.getAttribute(SET, FALSE);
        Vector<IXMLElement> forPacks = field.getChildrenNamed(SELECTEDPACKS);
        Vector<IXMLElement> forOs = field.getChildrenNamed(OS);
        IXMLElement descr = field.getFirstChildNamed(DESCRIPTION);
        this.addDescription(descr, forPacks, forOs, this.currentRow);
        ++this.currentRow;
        VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
        JRadioButton radioButton = JRadioButtonFactory.createJradioButton();
        radioButton.setText("<html>" + this.getText(field) + "</html>");
        radioButton.addFocusListener(new FocusListenerAutoScroll());
        int extraWhiteSpace = indent + 20 + 20;
        int maxWidth = this.idata.guiPrefs.width - this.parent.getSideNavigationWidth() - 20 - (Integer)UIManager.get("ScrollBar.width") - 45 - extraWhiteSpace;
        String causesValidation = field.getAttribute(REVALIDATE);
        if (causesValidation != null && causesValidation.equals(YES)) {
            radioButton.addActionListener(this);
        }
        if (defaultValue != null && !defaultValue.isEmpty()) {
            defaultValue = Boolean.parseBoolean(field.getAttribute(DEEP_SUB, FALSE)) ? vs.deepSubstitute(defaultValue, null) : vs.substitute(defaultValue, null);
        }
        RadioButtonUIElement radioUiElement = new RadioButtonUIElement();
        radioUiElement.setType(UIElementType.RADIOBUTTON);
        radioUiElement.setComponent(radioButton, this.parent.hasBackground);
        radioUiElement.setDeepSub(Boolean.parseBoolean(field.getAttribute(DEEP_SUB, FALSE)));
        radioUiElement.setForOs(forOs);
        radioUiElement.setForPacks(forPacks);
        radioUiElement.setTrueValue(trueValue);
        radioUiElement.setConstraints(GridBagConstraintsFactory.createCheckAndRadioConstraint(this.currentRow, 0, indent, 0.1));
        ++this.currentRow;
        this.addToolTiptoElement(field, radioButton);
        this.parseSummarizeAttribute(field, radioUiElement);
        return radioUiElement;
    }

    private void addRadioButtonGroup(IXMLElement field) {
        IXMLElement spec = field.getFirstChildNamed(SPEC);
        String variable = field.getAttribute("variable");
        String value = this.idata.getVariable(variable);
        String conditionid = field.getAttribute(ATTRIBUTE_CONDITIONID_NAME);
        boolean isActive = conditionid == null || this.idata.getRules().isConditionTrue(conditionid);
        String alwaysActive = field.getAttribute(ATTRIBUTE_ALWAYS_DISPALAY);
        boolean visibleWhenNotActive = alwaysActive != null && alwaysActive.equals(TRUE);
        boolean first = true;
        if (spec == null || variable == null) {
            return;
        }
        Vector<IXMLElement> choices = spec.getChildrenNamed("choice");
        if (choices == null) {
            return;
        }
        Vector<IXMLElement> forPacks = field.getChildrenNamed(SELECTEDPACKS);
        Vector<IXMLElement> forOs = field.getChildrenNamed(OS);
        IXMLElement descr = field.getFirstChildNamed(DESCRIPTION);
        this.addDescription(descr, forPacks, forOs, this.currentRow);
        ButtonGroup group = new ButtonGroup();
        JPanel buttonPanel = PanelFactory.createRadioButtonPanel(this.parent.hasBackground, group);
        Box verticalBox = Box.createVerticalBox();
        RadioButtonGroupUIElement radioUiGroupElement = new RadioButtonGroupUIElement();
        this.parseSummarizeAttribute(field, radioUiGroupElement);
        radioUiGroupElement.setType(UIElementType.GROUPRADIO);
        radioUiGroupElement.setConstraints(GridBagConstraintsFactory.createRadioGroupConstraints(this.currentRow + 1, 2, choices.size(), this.getIndent(field)));
        radioUiGroupElement.setDeepSub(Boolean.parseBoolean(field.getAttribute(DEEP_SUB, FALSE)));
        radioUiGroupElement.setForOs(forOs);
        radioUiGroupElement.setForPacks(forPacks);
        radioUiGroupElement.setConditionid(conditionid);
        radioUiGroupElement.setAssociatedVariable(variable);
        radioUiGroupElement.setAlwaysActive(visibleWhenNotActive);
        radioUiGroupElement.setComponent(buttonPanel, this.parent.hasBackground);
        radioUiGroupElement.setButtonGroup(group);
        for (IXMLElement choice : choices) {
            RadioButtonUIElement radioUI = this.addRadioButton(choice, this.getIndent(field));
            JRadioButton radioButton = (JRadioButton)radioUI.getComponent();
            radioButton.setVisible(isActive || visibleWhenNotActive || this.displayHidden);
            radioButton.setEnabled(isActive);
            verticalBox.add(radioButton);
            radioUiGroupElement.addRadioButton(radioUI);
            group.add(radioButton);
            AccessibleContext ac = radioButton.getAccessibleContext();
            ac.setAccessibleDescription("If this button is selected, " + variable + " will be set to " + radioUI.getTrueValue());
            radioButton.setActionCommand("JRadioButton setting variable: " + variable + " = " + radioUI.getTrueValue());
            if (first) {
                if (this.focusedOnActivate(field)) {
                    this.setInitialFocus(radioButton);
                } else {
                    group.setSelected(radioButton.getModel(), true);
                }
                first = false;
            }
            if (value == null || !value.equals(radioUI.getTrueValue())) continue;
            group.setSelected(radioButton.getModel(), true);
            if (!this.focusedOnActivate(field)) continue;
            this.setInitialFocus(radioButton);
        }
        buttonPanel.add(verticalBox);
        this.buttonGroups.add(group);
        this.elements.add(radioUiGroupElement);
    }

    private int getIndent(IXMLElement field) {
        int value = 0;
        if (this.spec != null) {
            try {
                value = field.getAttribute(ATTRIBUTE_INDENT) != null ? Integer.parseInt(field.getAttribute(ATTRIBUTE_INDENT)) : 0;
            }
            catch (NumberFormatException e) {
                value = 0;
            }
        }
        return value;
    }

    private boolean readRadioButtonGroup(UIElement field) {
        String variable = null;
        String value = null;
        try {
            RadioButtonGroupUIElement rbg = (RadioButtonGroupUIElement)field;
            for (RadioButtonUIElement b : rbg.getRadioButtons()) {
                JRadioButton radioButton = (JRadioButton)b.getComponent();
                if (!radioButton.isSelected() || !radioButton.isEnabled()) continue;
                variable = field.getAssociatedVariable();
                value = b.getTrueValue();
                break;
            }
            this.idata.setVariable(variable, value);
        }
        catch (Throwable exception) {
            return true;
        }
        this.entries.add(new TextValuePair(variable, value));
        if (field.isSummarized()) {
            this.summaryEntries.add(new TextValuePair(field.getAssociatedVariable(), value));
        }
        return true;
    }

    private void addPasswordField(IXMLElement field) {
        IXMLElement spec = field.getFirstChildNamed(SPEC);
        String variable = field.getAttribute("variable");
        if (variable == null || spec == null) {
            return;
        }
        String value = this.idata.getVariable(variable);
        IXMLElement description = field.getFirstChildNamed(DESCRIPTION);
        IXMLElement processorElem = field.getFirstChildNamed(PROCESSOR);
        Vector<IXMLElement> forOs = field.getChildrenNamed(OS);
        Vector<IXMLElement> forPacks = field.getChildrenNamed(SELECTEDPACKS);
        String conditionid = field.getAttribute(ATTRIBUTE_CONDITIONID_NAME);
        boolean isActive = conditionid == null || this.idata.getRules().isConditionTrue(conditionid);
        String alwaysActive = field.getAttribute(ATTRIBUTE_ALWAYS_DISPALAY);
        boolean visibleWhenNotActive = alwaysActive != null && alwaysActive.equals(TRUE);
        List<ValidatorContainer> validatorsList = this.analyzeValidator(field);
        if (validatorsList == null) {
            validatorsList = new ArrayList<ValidatorContainer>();
        }
        String processor = null;
        if (processorElem != null) {
            processor = processorElem.getAttribute(CLASS);
        }
        String prompt = field.getAttribute(AUTOPROMPT, FALSE);
        boolean autoPrompt = Boolean.parseBoolean(prompt);
        this.addDescription(description, forPacks, forOs, this.currentRow);
        ++this.currentRow;
        PasswordGroup group = new PasswordGroup(this.idata, validatorsList, processor);
        if (spec != null) {
            VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
            Vector<IXMLElement> inputs = spec.getChildrenNamed(PWD_INPUT);
            if (inputs == null) {
                return;
            }
            int size = 0;
            boolean first = true;
            for (IXMLElement passSpec : inputs) {
                JTextArea label = LabelFactory.createMultilineLabel(this.getText(passSpec), true);
                label.setFocusable(false);
                label.setEnabled(isActive);
                String id = passSpec.getAttribute("id");
                String set = passSpec.getAttribute(SET);
                boolean isConfrim = Boolean.parseBoolean(passSpec.getAttribute(ISCONFIRM));
                if (set != null && !set.isEmpty()) {
                    set = vs.substitute(set, null);
                }
                try {
                    size = Integer.parseInt(passSpec.getAttribute("size", "1"));
                }
                catch (Throwable exception) {
                    size = 1;
                }
                CorrectWidthJPasswordField passwordField = new CorrectWidthJPasswordField(set, size);
                passwordField.addFocusListener(new FocusListenerAutoScroll());
                passwordField.setVisible(isActive || this.isDisplayingHidden() || visibleWhenNotActive);
                if (this.focusedOnActivate(field)) {
                    passwordField.grabFocus();
                }
                passwordField.setEnabled(isActive);
                passwordField.setEditable(isActive);
                passwordField.setCaretPosition(0);
                passwordField.addFocusListener(new FocusListenerRepaint());
                JFocusPanel focusBorder = new JFocusPanel(passwordField);
                this.setLabelColumns(label, (int)passwordField.getPreferredSize().getWidth(), this.getIndent(field));
                AccessibleContext ac = passwordField.getAccessibleContext();
                ac.setAccessibleDescription("This JPasswordField contains the value for variable: " + variable);
                passwordField.setActionCommand("Password field to set variable: " + variable);
                label.setVisible(isActive || visibleWhenNotActive || this.displayHidden);
                UIElement labelUiElement = new UIElement();
                labelUiElement.setComponent(label, this.parent.hasBackground);
                labelUiElement.setType(UIElementType.LABEL);
                labelUiElement.setConstraints(GridBagConstraintsFactory.createAlignedElementConstraint(this.currentRow, 0, this.getIndent(field), 2));
                labelUiElement.setForPacks(forPacks);
                labelUiElement.setForOs(forOs);
                labelUiElement.setConditionid(conditionid);
                labelUiElement.setAlwaysActive(visibleWhenNotActive);
                passwordField.setVisible(isActive || visibleWhenNotActive || this.displayHidden);
                PasswordUIElement passwordUiElement = new PasswordUIElement();
                passwordUiElement.setComponent(focusBorder, false);
                passwordUiElement.setType(UIElementType.PASSWORD);
                passwordUiElement.setAssociatedVariable(variable);
                passwordUiElement.setConstraints(GridBagConstraintsFactory.createAlignedElementConstraint(this.currentRow, 1, 20, this.getFill(spec.getAttribute(COMPONENT_FILL, "horizontal"))));
                passwordUiElement.setAutoPrompt(autoPrompt);
                passwordUiElement.setPasswordGroup(group);
                passwordUiElement.setForPacks(forPacks);
                passwordUiElement.setForOs(forOs);
                passwordUiElement.setId(id);
                passwordUiElement.setConfirm(isConfrim);
                this.addToolTiptoElement(field, label);
                this.addToolTiptoElement(field, passwordField);
                this.parseSummarizeAttribute(field, passwordUiElement);
                passwordUiElement.setConditionid(conditionid);
                passwordUiElement.setAlwaysActive(visibleWhenNotActive);
                ++this.currentRow;
                this.elements.add(labelUiElement);
                this.elements.add(passwordUiElement);
                if (!first && this.passwords.containsKey(id)) {
                    passwordField.setText(this.passwords.get(id));
                } else if (!first) {
                    passwordField.setText(set);
                } else if (first) {
                    if (this.focusedOnActivate(field)) {
                        this.setInitialFocus(passwordField);
                    }
                    first = false;
                    if (value == null) {
                        passwordField.setText(set);
                    } else {
                        passwordField.setText(value);
                    }
                }
                group.addField(passwordField);
                group.addNamedField(id, passwordField);
            }
        }
        this.passwordGroups.put(variable, group);
    }

    private boolean readPasswordField(UIElement field) {
        PasswordUIElement pwdField = (PasswordUIElement)field;
        boolean autoPrompt = pwdField.getAutoPrompt();
        PasswordGroup group = null;
        String variable = null;
        JFocusPanel jfp = (JFocusPanel)pwdField.getComponent();
        JPasswordField jp = (JPasswordField)jfp.getComponent();
        try {
            group = pwdField.getPasswordGroup();
            variable = field.getAssociatedVariable();
        }
        catch (Throwable exception) {
            return true;
        }
        if (variable == null || !jp.isEnabled() || this.passwordGroupsRead.contains(group)) {
            return true;
        }
        this.passwordGroupsRead.add(group);
        int size = group.validatorSize();
        boolean success = !this.validating || size < 1;
        ArrayList<String> warnings = new ArrayList<String>();
        ArrayList<Validator.Status> results = new ArrayList<Validator.Status>();
        if (!success) {
            for (int i = 0; i < size; ++i) {
                Validator.Status validationResult = group.validateContents(i);
                if (validationResult == Validator.Status.ERROR) {
                    this.emitError(this.parentFrame.langpack.getString("UserInputPanel.validation.error"), group.getValidatorMessage(i));
                    results.add(validationResult);
                    jp.grabFocus();
                    break;
                }
                if (validationResult == Validator.Status.WARNING) {
                    warnings.add(group.getValidatorMessage(i));
                }
                results.add(validationResult);
            }
        }
        boolean bl = success = !results.contains((Object)Validator.Status.ERROR);
        if (results.contains((Object)Validator.Status.WARNING)) {
            StringBuilder warning = new StringBuilder();
            for (String w : warnings) {
                warning.append(w);
                warning.append('\n');
            }
            warning.append(this.parentFrame.langpack.getString("UserInputPanel.validation.warning.question"));
            success = this.emitWarning(this.parentFrame.langpack.getString("UserInputPanel.validation.warning"), warning.toString());
            jp.grabFocus();
        }
        if (success) {
            String value = group.getPassword();
            this.idata.setVariable(variable, value);
            TextValuePair pair = autoPrompt ? new TextValuePair(variable, null) : new TextValuePair(variable, value);
            this.entries.add(pair);
            if (field.isSummarized()) {
                this.summaryEntries.add(new TextValuePair(field.getAssociatedVariable(), value));
            }
        }
        return success;
    }

    private void addCheckBox(IXMLElement field) {
        IXMLElement spec = field.getFirstChildNamed(SPEC);
        String variable = field.getAttribute("variable");
        if (variable == null) {
            return;
        }
        String value = this.idata.getVariable(variable);
        String label = "";
        String causesValidataion = NO;
        String trueValue = TRUE;
        String falseValue = FALSE;
        String defaultSetting = FALSE;
        boolean defaultValue = false;
        boolean set = false;
        if (spec != null) {
            label = this.getText(spec);
            trueValue = spec.getAttribute(TRUE);
            falseValue = spec.getAttribute(FALSE);
            causesValidataion = spec.getAttribute(REVALIDATE, NO);
            defaultSetting = spec.getAttribute(SET, FALSE);
            defaultValue = defaultSetting.equals(FALSE) ? false : (defaultSetting.equals(TRUE) ? true : this.idata.getRules().isConditionTrue(defaultSetting));
            set = value == null ? defaultValue : (value.equals(trueValue) ? true : (value.equals(falseValue) ? false : Boolean.parseBoolean(value)));
            Debug.trace("CheckBox\n============\nValue of associated variable: " + value + "\nDefault Value: " + defaultValue + "\nCheckbox should be set to: " + set);
        }
        Vector<IXMLElement> forPacks = field.getChildrenNamed(SELECTEDPACKS);
        Vector<IXMLElement> forOs = field.getChildrenNamed(OS);
        IXMLElement descr = field.getFirstChildNamed(DESCRIPTION);
        String dependencyVar = field.getAttribute(DEPENDS_ON, "");
        String conditionid = field.getAttribute(ATTRIBUTE_CONDITIONID_NAME);
        boolean isActive = conditionid == null || this.idata.getRules().isConditionTrue(conditionid);
        String alwaysActive = field.getAttribute(ATTRIBUTE_ALWAYS_DISPALAY);
        boolean visibleWhenNotActive = alwaysActive != null && alwaysActive.equals(TRUE);
        this.addDescription(descr, forPacks, forOs, this.currentRow);
        ++this.currentRow;
        if (!dependencyVar.isEmpty()) {
            String dependecyVal = this.idata.getVariable(dependencyVar);
            if (!this.dependencies.containsKey(dependencyVar)) {
                this.dependencies.put(dependencyVar, dependecyVal);
                set = defaultValue;
            } else if (!this.dependencies.get(dependencyVar).equals(dependecyVal)) {
                this.dependencies.put(dependencyVar, this.idata.getVariable(dependencyVar));
                set = defaultValue;
            }
        }
        JCheckBox checkbox = new JCheckBox(label);
        checkbox.setVisible(isActive || this.isDisplayingHidden() || visibleWhenNotActive);
        checkbox.setSelected(set);
        checkbox.setEnabled(isActive);
        checkbox.addFocusListener(new FocusListenerAutoScroll());
        this.addToolTiptoElement(field, checkbox);
        if (causesValidataion.equals(YES)) {
            checkbox.addActionListener(this);
        }
        AccessibleContext ac = checkbox.getAccessibleContext();
        ac.setAccessibleDescription("This checkbox will set " + variable + " to " + trueValue + " if checked, or to " + falseValue + " if unchecked.");
        checkbox.setActionCommand("JCheckBox to set: " + variable + " = " + trueValue);
        checkbox.setVisible(isActive || visibleWhenNotActive || this.displayHidden);
        UIElement checkboxUiElement = new UIElement();
        checkboxUiElement.setType(UIElementType.CHECKBOX);
        checkboxUiElement.setComponent(checkbox, this.parent.hasBackground);
        checkboxUiElement.setForOs(forOs);
        checkboxUiElement.setForPacks(forPacks);
        checkboxUiElement.setTrueValue(trueValue);
        checkboxUiElement.setFalseValue(falseValue);
        checkboxUiElement.setConstraints(GridBagConstraintsFactory.createCheckAndRadioConstraint(this.currentRow, 0, this.getIndent(field), 0.1));
        checkboxUiElement.setAssociatedVariable(variable);
        checkboxUiElement.setConditionid(conditionid);
        checkboxUiElement.setAlwaysActive(visibleWhenNotActive);
        if (this.focusedOnActivate(field)) {
            this.setInitialFocus(checkboxUiElement.getComponent());
        }
        if (set) {
            this.idata.setVariable(variable, trueValue);
        } else {
            this.idata.setVariable(variable, falseValue);
        }
        this.elements.add(checkboxUiElement);
    }

    private boolean readCheckBox(UIElement field) {
        String variable = null;
        String trueValue = null;
        String falseValue = null;
        JCheckBox box = null;
        try {
            box = (JCheckBox)field.getComponent();
            variable = field.getAssociatedVariable();
            trueValue = field.getTrueValue();
            if (trueValue == null) {
                trueValue = "";
            }
            if ((falseValue = field.getFalseValue()) == null) {
                falseValue = "";
            }
        }
        catch (Throwable exception) {
            Debug.trace("readCheckBox(): failed: " + exception);
            return true;
        }
        if (box.isSelected()) {
            Debug.trace("readCheckBox(): selected, setting " + variable + " to " + trueValue);
            this.idata.setVariable(variable, trueValue);
            this.entries.add(new TextValuePair(variable, trueValue));
            if (field.isSummarized()) {
                this.summaryEntries.add(new TextValuePair(field.getAssociatedVariable(), trueValue));
            }
        } else {
            Debug.trace("readCheckBox(): not selected, setting " + variable + " to " + falseValue);
            this.idata.setVariable(variable, falseValue);
            this.entries.add(new TextValuePair(variable, falseValue));
            if (field.isSummarized()) {
                this.summaryEntries.add(new TextValuePair(field.getAssociatedVariable(), falseValue));
            }
        }
        return true;
    }

    private void addSearch(IXMLElement spec) {
        boolean showAutodetect;
        Vector<IXMLElement> forPacks = spec.getChildrenNamed(SELECTEDPACKS);
        Vector<IXMLElement> forOs = spec.getChildrenNamed(OS);
        IXMLElement element = spec.getFirstChildNamed(SPEC);
        String variable = spec.getAttribute("variable");
        String conditionid = spec.getAttribute(ATTRIBUTE_CONDITIONID_NAME);
        boolean isActive = conditionid == null || this.idata.getRules().isConditionTrue(conditionid);
        String alwaysActive = spec.getAttribute(ATTRIBUTE_ALWAYS_DISPALAY);
        boolean visibleWhenNotActive = alwaysActive != null && alwaysActive.equals(TRUE);
        String filename = null;
        String check_filename = null;
        int search_type = 0;
        int result_type = 0;
        JComboBox combobox = ComboBoxFactory.createComboBox();
        JLabel label = null;
        combobox.setEditable(isActive);
        if (element != null) {
            String result_type_str;
            label = new JLabel(this.getText(element));
            label.setEnabled(isActive);
            search_type = 2;
            String search_type_str = element.getAttribute("type");
            if (search_type_str != null) {
                if (search_type_str.equals("file")) {
                    search_type = 2;
                } else if (search_type_str.equals(SEARCH_DIRECTORY)) {
                    search_type = 1;
                }
            }
            if ((result_type_str = element.getAttribute(SEARCH_RESULT)) == null) {
                return;
            }
            if (result_type_str.equals("file")) {
                result_type = 2;
            } else if (result_type_str.equals(SEARCH_DIRECTORY)) {
                result_type = 1;
            } else if (result_type_str.equals(SEARCH_PARENTDIR)) {
                result_type = 3;
            } else {
                return;
            }
            filename = element.getAttribute(SEARCH_FILENAME);
            check_filename = element.getAttribute(SEARCH_CHECKFILENAME);
            Vector<IXMLElement> choices = element.getChildrenNamed("choice");
            if (choices == null) {
                return;
            }
            for (int i = 0; i < choices.size(); ++i) {
                IXMLElement choice_el = choices.elementAt(i);
                if (!OsConstraint.oneMatchesCurrentSystem(choice_el)) continue;
                String value = choice_el.getAttribute("value");
                combobox.addItem(value);
                String set = choices.elementAt(i).getAttribute(SET);
                if (set == null) continue;
                if (set != null && !"".equals(set)) {
                    VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
                    set = Boolean.parseBoolean(spec.getAttribute(DEEP_SUB, FALSE)) ? vs.deepSubstitute(set, null) : vs.substitute(set, null);
                }
                if (!set.equals(TRUE)) continue;
                combobox.setSelectedIndex(i);
            }
        } else {
            return;
        }
        element = spec.getFirstChildNamed(DESCRIPTION);
        this.addDescription(element, forPacks, forOs, this.currentRow);
        ++this.currentRow;
        String indentStr = spec.getAttribute(ATTRIBUTE_INDENT);
        int indent = this.getIndent(spec);
        label.setVisible(isActive || visibleWhenNotActive || this.displayHidden);
        UIElement labelUiElement = new UIElement();
        labelUiElement.setType(UIElementType.LABEL);
        labelUiElement.setConstraints(GridBagConstraintsFactory.createNonFullLineElementConstraint(this.currentRow, 0, 17, indent));
        labelUiElement.setComponent(label, this.parent.hasBackground);
        labelUiElement.setForPacks(forPacks);
        labelUiElement.setForOs(forOs);
        labelUiElement.setConditionid(conditionid);
        labelUiElement.setAlwaysActive(visibleWhenNotActive);
        this.elements.add(labelUiElement);
        this.addToolTiptoElement(spec, label);
        StringBuffer tooltiptext = new StringBuffer();
        if (filename != null && filename.length() > 0) {
            tooltiptext.append(MessageFormat.format(this.parentFrame.langpack.getString("UserInputPanel.search.location"), new Object[]{new String[]{filename}}));
        }
        boolean bl = showAutodetect = check_filename != null && check_filename.length() > 0;
        if (showAutodetect) {
            tooltiptext.append(MessageFormat.format(this.parentFrame.langpack.getString("UserInputPanel.search.location.checkedfile"), new Object[]{new String[]{check_filename}}));
        }
        if (tooltiptext.length() > 0) {
            combobox.setToolTipText(tooltiptext.toString());
        }
        combobox.setVisible(isActive || visibleWhenNotActive || this.displayHidden);
        UIElement searchUiElement = new UIElement();
        searchUiElement.setType(UIElementType.SEARCH);
        searchUiElement.setConstraints(GridBagConstraintsFactory.createNonFullLineElementConstraint(this.currentRow, 1, 17, indent));
        searchUiElement.setComponent(combobox, this.parent.hasBackground);
        searchUiElement.setForPacks(forPacks);
        searchUiElement.setForOs(forOs);
        searchUiElement.setAssociatedVariable(variable);
        searchUiElement.setDeepSub(Boolean.parseBoolean(spec.getAttribute(DEEP_SUB, FALSE)));
        searchUiElement.setDependency(spec.getAttribute(DEPENDS_ON, ""));
        searchUiElement.setConditionid(conditionid);
        searchUiElement.setAlwaysActive(visibleWhenNotActive);
        this.elements.add(searchUiElement);
        this.addToolTiptoElement(spec, combobox);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(3));
        JButton autodetectButton = ButtonFactory.createButton(this.parentFrame.langpack.getString("UserInputPanel.search.autodetect"), this.idata.buttonsHColor);
        autodetectButton.setVisible(showAutodetect);
        autodetectButton.setToolTipText(this.parentFrame.langpack.getString("UserInputPanel.search.autodetect.tooltip"));
        buttonPanel.add(autodetectButton);
        JButton browseButton = ButtonFactory.createButton(this.parentFrame.langpack.getString("UserInputPanel.search.browse"), this.idata.buttonsHColor);
        buttonPanel.add(browseButton);
        buttonPanel.setVisible(isActive || visibleWhenNotActive || this.displayHidden);
        UIElement searchbuttonUiElement = new UIElement();
        searchbuttonUiElement.setType(UIElementType.SEARCHBUTTON);
        searchbuttonUiElement.setConstraints(GridBagConstraintsFactory.createNonFullLineElementConstraint(this.currentRow, 2, 17, indent));
        searchbuttonUiElement.setComponent(buttonPanel, this.parent.hasBackground);
        searchbuttonUiElement.setForPacks(forPacks);
        searchbuttonUiElement.setForOs(forOs);
        this.elements.add(searchbuttonUiElement);
        this.addToolTiptoElement(spec, buttonPanel);
        this.searchFields.add(new SearchField(filename, check_filename, this.parentFrame, combobox, autodetectButton, browseButton, search_type, result_type));
    }

    private boolean readSearch(UIElement field) {
        String variable = null;
        String value = null;
        JComboBox comboBox = null;
        try {
            variable = field.getAssociatedVariable();
            comboBox = (JComboBox)field.getComponent();
            for (int i = 0; i < this.searchFields.size(); ++i) {
                SearchField sf = this.searchFields.elementAt(i);
                if (!sf.belongsTo(comboBox)) continue;
                value = sf.getResult();
                break;
            }
        }
        catch (Throwable exception) {
            return true;
        }
        if (variable == null || value == null) {
            return true;
        }
        this.idata.setVariable(variable, value);
        this.entries.add(new TextValuePair(variable, value));
        if (field.isSummarized()) {
            this.summaryEntries.add(new TextValuePair(field.getAssociatedVariable(), value));
        }
        return true;
    }

    private void addText(IXMLElement spec) {
        Vector<IXMLElement> forPacks = spec.getChildrenNamed(SELECTEDPACKS);
        Vector<IXMLElement> forOs = spec.getChildrenNamed(OS);
        this.addDescription(spec, forPacks, forOs, this.currentRow);
    }

    private void addSpace(IXMLElement spec) {
        Vector<IXMLElement> forPacks = spec.getChildrenNamed(SELECTEDPACKS);
        Vector<IXMLElement> forOs = spec.getChildrenNamed(OS);
        JPanel panel = new JPanel();
        panel.setFocusable(false);
        UIElement spaceUiElement = new UIElement();
        spaceUiElement.setType(UIElementType.SPACE);
        spaceUiElement.setConstraints(GridBagConstraintsFactory.createNonFullLineElementConstraint(this.currentRow, 0, 17, 0));
        spaceUiElement.setComponent(panel, this.parent.hasBackground);
        spaceUiElement.setForPacks(forPacks);
        spaceUiElement.setForOs(forOs);
        this.elements.add(spaceUiElement);
    }

    private void addDivider(IXMLElement spec) {
        Vector<IXMLElement> forPacks = spec.getChildrenNamed(SELECTEDPACKS);
        Vector<IXMLElement> forOs = spec.getChildrenNamed(OS);
        JPanel panel = new JPanel();
        String alignment = spec.getAttribute(ALIGNMENT);
        if (alignment != null) {
            if (alignment.equals(TOP)) {
                panel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.gray));
            } else {
                panel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.gray));
            }
        } else {
            panel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.gray));
        }
        UIElement dividerUiElement = new UIElement();
        dividerUiElement.setType(UIElementType.DIVIDER);
        dividerUiElement.setConstraints(GridBagConstraintsFactory.createDividerConstraints(this.currentRow, 0));
        dividerUiElement.setComponent(panel, this.parent.hasBackground);
        dividerUiElement.setForPacks(forPacks);
        dividerUiElement.setForOs(forOs);
        this.elements.add(dividerUiElement);
    }

    private void addDescription(IXMLElement spec, Vector<IXMLElement> forPacks, Vector<IXMLElement> forOs, int row) {
        String description;
        if (spec != null && (description = this.getText(spec)) != null) {
            JTextArea label;
            JTextArea temp;
            boolean visibleWhenNotActive;
            String conditionid = spec.getAttribute(ATTRIBUTE_CONDITIONID_NAME);
            boolean isActive = conditionid == null || this.idata.getRules().isConditionTrue(conditionid);
            String alwaysActive = spec.getAttribute(ATTRIBUTE_ALWAYS_DISPALAY);
            boolean bl = visibleWhenNotActive = alwaysActive != null && alwaysActive.equals(TRUE);
            if (description.startsWith("<html>") && description.endsWith("</html>")) {
                temp = new JTextUrlPane();
                ((JTextUrlPane)temp).setText(description);
                temp.setBackground(UIManager.getColor("label.background"));
                temp.setMargin(new Insets(3, 0, 3, 0));
                temp.setEditable(false);
                label = temp;
            } else {
                temp = LabelFactory.createMultilineLabel(description, true);
                temp.setMargin(new Insets(0, 0, 0, 0));
                label = temp;
            }
            ((JComponent)label).getPreferredSize();
            label.setFocusable(false);
            label.setEnabled(isActive);
            label.setVisible(isActive || visibleWhenNotActive || this.displayHidden);
            UIElement descUiElement = new UIElement();
            descUiElement.setType(UIElementType.DESCRIPTION);
            descUiElement.setConstraints(GridBagConstraintsFactory.createFullLineElementConstraint(row, 0, 0));
            descUiElement.setComponent(label, this.parent.hasBackground);
            descUiElement.setForPacks(forPacks);
            descUiElement.setForOs(forOs);
            descUiElement.setConditionid(conditionid);
            descUiElement.setAlwaysActive(visibleWhenNotActive);
            this.elements.add(descUiElement);
            this.addToolTiptoElement(spec, label);
        }
    }

    private boolean getBoolean(IXMLElement element, String attribute, boolean defaultValue) {
        String value;
        boolean result = defaultValue;
        if (attribute != null && attribute.length() > 0 && (value = element.getAttribute(attribute)) != null) {
            if (value.equals(TRUE)) {
                result = true;
            } else if (value.equals(FALSE)) {
                result = false;
            }
        }
        return result;
    }

    private float getFloat(IXMLElement element, String attribute, float defaultValue) {
        float result = defaultValue;
        if (attribute != null && attribute.length() > 0) {
            try {
                result = Float.parseFloat(element.getAttribute(attribute));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    private String getText(IXMLElement element) {
        if (element == null) {
            return null;
        }
        String key = element.getAttribute("id");
        String text = element.getAttribute(TEXT);
        String templateUsed = element.getAttribute(TEMPLATE);
        boolean deepSub = Boolean.parseBoolean(element.getAttribute(DEEP_SUB, FALSE));
        if (templateUsed != null && Boolean.valueOf(templateUsed).booleanValue()) {
            String[] j = key.split("\\.");
            String i = j[j.length - 2];
            if (key.endsWith(MULTICAST_ADDRESS)) {
                text = multicastAddress.replaceAll(regexTemplate, i);
            } else if (key.endsWith(MULTICAST_PORT)) {
                text = multicastPort.replaceAll(regexTemplate, i);
            } else if (key.endsWith(PORT)) {
                text = portText.replaceAll(regexTemplate, i);
            } else if (key.endsWith(MULTICAST_ADDRESS_VALIDATOR)) {
                i = j[j.length - 3];
                text = validatorMulticastAddressText.replaceAll(regexTemplate, i);
            } else if (key.endsWith(MULTICAST_PORT_VALIDATOR)) {
                i = j[j.length - 3];
                text = validatorMulticastPortText.replaceAll(regexTemplate, i);
            } else if (key.endsWith(MULTICAST_PORT_RANGE_VALIDATOR)) {
                i = j[j.length - 3];
                text = validatorMulticastRangeText.replaceAll(regexTemplate, i);
            } else if (key.endsWith(ADDRESS_VALIDATOR)) {
                i = j[j.length - 3];
                text = validatorVerifyAddressText.replaceAll(regexTemplate, i);
            } else if (key.equals(offsetValidator)) {
                text = offsetText.replaceAll(regexTemplate, AutomatedInstallData.getInstance().getVariable(portOffsetVariable));
            } else if (key.endsWith(RANGE_VALIDATOR)) {
                text = validatorRangeText.replaceAll(regexTemplate, i);
            } else if (key.endsWith(COLLISION_VALIDATOR)) {
                text = validatorCollisionText.replaceAll(regexTemplate, i);
            } else if (key.endsWith(VALIDATOR)) {
                text = validatorPortText.replaceAll(regexTemplate, i);
            } else {
                i = j[j.length - 1];
                text = portText.replaceAll(regexTemplate, i);
            }
        } else if (key != null && this.langpack != null && (text = this.langpack.getString(key)) == null) {
            text = key;
        }
        VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
        if (deepSub) {
            return vs.deepSubstitute(text, null);
        }
        return vs.substitute(text, null);
    }

    private int getAlignment(IXMLElement element) {
        int result = 18;
        String value = element.getAttribute(ALIGNMENT);
        if (value != null) {
            if (value.equals(LEFT)) {
                result = 17;
            } else if (value.equals(CENTER)) {
                result = 10;
            } else if (value.equals(RIGHT)) {
                result = 13;
            }
        }
        return result;
    }

    public boolean itemRequiredForOs(Vector<IXMLElement> os) {
        if (os.size() == 0) {
            return true;
        }
        for (int i = 0; i < os.size(); ++i) {
            String family = os.elementAt(i).getAttribute(FAMILY);
            boolean match = false;
            if ("windows".equals(family)) {
                match = OsVersion.IS_WINDOWS;
            } else if ("mac".equals(family)) {
                match = OsVersion.IS_OSX;
            } else if ("unix".equals(family)) {
                match = OsVersion.IS_UNIX;
            }
            if (!match) continue;
            return true;
        }
        return false;
    }

    private boolean itemRequiredFor(Vector<IXMLElement> packs) {
        if (packs.size() == 0) {
            return true;
        }
        for (int i = 0; i < this.idata.selectedPacks.size(); ++i) {
            String selected = ((Pack)this.idata.selectedPacks.get((int)i)).name;
            for (int k = 0; k < packs.size(); ++k) {
                String required = packs.elementAt(k).getAttribute("name", "");
                if (!selected.equals(required)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean itemRequiredForUnselected(Vector<IXMLElement> packs) {
        if (packs.size() == 0) {
            return true;
        }
        for (int i = 0; i < this.idata.selectedPacks.size(); ++i) {
            String selected = ((Pack)this.idata.selectedPacks.get((int)i)).name;
            for (int k = 0; k < packs.size(); ++k) {
                String required = packs.elementAt(k).getAttribute("name", "");
                if (!selected.equals(required)) continue;
                return false;
            }
        }
        return true;
    }

    protected void updateVariables() {
        Vector<IXMLElement> variables = this.spec.getChildrenNamed("variable");
        RulesEngine rules = this.parent.getRules();
        VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
        for (int i = 0; i < variables.size(); ++i) {
            String conditionid;
            IXMLElement variable = variables.elementAt(i);
            String vname = variable.getAttribute("name");
            String vvalue = variable.getAttribute("value");
            System.out.println("Variable name: " + vname);
            System.out.println("Variable value: " + vvalue);
            if (vvalue == null && variable.hasChildren()) {
                IXMLElement value = variable.getFirstChildNamed("value");
                vvalue = value.getContent();
                System.out.println("Variable value child: " + vvalue);
            }
            boolean isActive = (conditionid = variable.getAttribute(ATTRIBUTE_CONDITIONID_NAME)) == null || this.idata.getRules().isConditionTrue(conditionid);
            System.out.println("Condition id: " + conditionid);
            if (conditionid != null && !rules.isConditionTrue(conditionid, this.idata.getVariables()) || !OsConstraint.oneMatchesCurrentSystem(variable) || vname == null) continue;
            if (vvalue != null) {
                System.out.println("Vname in os contraints: " + vname);
                vvalue = vs.substitute(vvalue, null);
                System.out.println("Variable Value for os Constraint: " + vvalue);
                this.idata.setVariable(vname, "");
                vvalue = vs.substitute(vvalue, null);
                System.out.println("Variable Value for os Constraint After cutting curcular references: " + vvalue);
            }
            this.idata.setVariable(vname, vvalue);
            this.entries.add(new TextValuePair(vname, vvalue));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.performEvent(e);
    }

    @Override
    public void itemStateChanged(ItemEvent arg0) {
        Component c = (Component)arg0.getSource();
        if (c.hasFocus()) {
            this.setInitialFocus(c);
        }
        this.performEvent(arg0);
    }

    public void performEvent(AWTEvent e) {
        Debug.trace("Setting validating to false");
        this.validating = false;
        this.updateDialog();
        if (e instanceof ActionEvent) {
            Debug.trace("Setting validating back to true");
        }
        this.validating = true;
    }

    private void showMessageDialog(InstallerFrame parentFrame, String message, String caption, int messageType) {
        String localizedCaption;
        String localizedMessage = parentFrame.langpack.getString(message);
        if (localizedMessage == null || localizedMessage.trim().length() == 0) {
            localizedMessage = message;
        }
        if ((localizedCaption = parentFrame.langpack.getString(caption)) == null || localizedCaption.trim().length() == 0) {
            localizedCaption = caption;
        }
        JOptionPane.showMessageDialog(parentFrame, new JTextMessagePane(localizedMessage, this.maxMessageWidth, this.fontMetrics), localizedCaption, messageType);
    }

    private void showWarningMessageDialog(InstallerFrame parentFrame, String message) {
        this.showMessageDialog(parentFrame, message, "UserInputPanel.error.caption", 2);
    }

    private void updateDialog() {
        if (this.eventsActivated) {
            this.eventsActivated = false;
            if (this.isValidated()) {
                VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
                this.getInstallerFrame().getParentInstaller().refreshDynamicVariables(vs, this.idata);
                for (UIElement element : this.elements) {
                    String condition = element.getConditionid();
                    boolean evaluatedCondition = this.evaluateCondition(condition);
                    boolean isVisible = evaluatedCondition || this.isDisplayingHidden() || element.isAlwaysActive();
                    this.updateComponent(element, evaluatedCondition, isVisible);
                }
                String panelid = ((IzPanel)this.idata.panels.get(this.idata.curPanelNumber)).getMetadata().getPanelid();
                this.entries.clear();
                this.updateVariables();
            }
            this.eventsActivated = true;
        }
    }

    private boolean evaluateCondition(String condition) {
        if (condition != null) {
            return this.idata.getRules().isConditionTrue(condition);
        }
        return true;
    }

    private void updateTextField(UIElement element, boolean isEnabled, JTextComponent textComponent) {
        if (element.isEditable() != null) {
            textComponent.setEditable(element.isEditable());
        } else {
            textComponent.setEditable(isEnabled);
            if (!isEnabled) {
                ColorUIResource c = new ColorUIResource(128, 128, 128);
                textComponent.setBackground(UiResources.inactiveTextField);
                textComponent.setForeground(c);
            } else {
                textComponent.setBackground(Color.WHITE);
                textComponent.setForeground(Color.BLACK);
            }
        }
    }

    private void updateComponent(UIElement element, boolean isEnabled, boolean isVisible) {
        JComponent textComponent;
        JComponent component = this.getVisibleComponent(element.getComponent());
        UIElementType type = element.getType();
        String variable = element.getAssociatedVariable();
        component.setEnabled(isEnabled);
        component.setVisible(isVisible);
        if (type == UIElementType.GROUPRADIO) {
            RadioButtonGroupUIElement rbg = (RadioButtonGroupUIElement)element;
            for (RadioButtonUIElement b : rbg.getRadioButtons()) {
                b.getComponent().setEnabled(isEnabled);
                b.getComponent().setVisible(isVisible);
            }
        }
        if (component instanceof JTextComponent && type == UIElementType.TEXT) {
            textComponent = (JTextComponent)component;
            ((JTextComponent)textComponent).setText(this.idata.getVariable(variable));
            this.updateTextField(element, isEnabled, (JTextComponent)textComponent);
        } else if (type == UIElementType.PASSWORD) {
            PasswordUIElement passElement = (PasswordUIElement)element;
            JPasswordField passField = (JPasswordField)component;
            boolean isConfirm = passElement.isConfirm();
            if (!isConfirm) {
                passField.setText(this.idata.getVariable(variable));
            }
            this.updateTextField(passElement, isEnabled, passField);
        } else if (component instanceof TextInputField) {
            textComponent = (TextInputField)component;
            ((TextInputField)textComponent).setText(this.idata.getVariable(variable));
            if (element.isEditable() != null) {
                ((TextInputField)textComponent).setEditable(element.isEditable());
            } else {
                ((TextInputField)textComponent).setEditable(isEnabled);
            }
        }
    }

    public Map<String, PasswordGroup> getPasswordGroups() {
        return this.passwordGroups;
    }

    private boolean willBeOffscreen(JTextComponent component, int fieldWidth, int extraSpace) {
        int contentPanelWidth = this.idata.guiPrefs.width - this.parent.getSideNavigationWidth() - 20 - (Integer)UIManager.get("ScrollBar.width") - 80;
        int componentWidth = this.getFontMetrics(this.getFont()).stringWidth(component.getText());
        return componentWidth + fieldWidth + extraSpace >= contentPanelWidth;
    }

    private int getNumberWrappedLines(String text, int extraSpace) {
        int contentPanelWidth = this.idata.guiPrefs.width - this.parent.getSideNavigationWidth() - 20 - (Integer)UIManager.get("ScrollBar.width") - 45;
        int componentWidth = this.getFontMetrics(this.getFont()).stringWidth(text);
        return (componentWidth + extraSpace + (contentPanelWidth - 1)) / contentPanelWidth;
    }

    private int getMinimumColumns(JTextComponent component) {
        int estimatedWidth = component.getFontMetrics(this.getFont()).stringWidth(component.getText()) + 20 + 20;
        return estimatedWidth / this.getFont().getSize();
    }

    public void setLabelColumns(JTextArea label, int fieldWidth, int indent) {
        boolean setLargestElementWidth = false;
        boolean setColumnWidthConstraint = false;
        int panelWhiteSpace = 100 + indent;
        if (fieldWidth >= largestElementWidth) {
            largestElementWidth = fieldWidth;
            setLargestElementWidth = true;
        }
        if (this.willBeOffscreen(label, largestElementWidth, panelWhiteSpace)) {
            int remainder = this.idata.guiPrefs.width - this.parent.getSideNavigationWidth() - panelWhiteSpace - largestElementWidth - 20;
            if (remainder / 15 < columnWidthConstraint) {
                columnWidthConstraint = remainder / 15;
                setColumnWidthConstraint = true;
            }
            largeElementLast = setLargestElementWidth && setColumnWidthConstraint;
            label.setColumns(remainder / 15);
        } else {
            label.setColumns(this.getMinimumColumns(label));
        }
        labelList.add(label);
    }

    public void setElementMaxMinPrefSize(JComponent component, String text, int whiteSpace, int maxWidth) {
        int numberOfLines = this.getNumberWrappedLines(text, whiteSpace);
        component.setMaximumSize(new Dimension(maxWidth, 1000));
        component.setPreferredSize(new Dimension(maxWidth, component.getPreferredSize().height * numberOfLines));
        component.setMinimumSize(new Dimension(maxWidth, component.getPreferredSize().height * numberOfLines));
    }

    private class SearchField
    implements ActionListener {
        public static final int TYPE_DIRECTORY = 1;
        public static final int TYPE_FILE = 2;
        public static final int RESULT_DIRECTORY = 1;
        public static final int RESULT_FILE = 2;
        public static final int RESULT_PARENTDIR = 3;
        private String filename = null;
        private String checkFilename = null;
        private JButton autodetectButton = null;
        private JButton browseButton = null;
        private JComboBox pathComboBox = null;
        private int searchType = 1;
        private int resultType = 1;
        private InstallerFrame parent = null;

        public SearchField(String filename, String checkFilename, InstallerFrame parent, JComboBox combobox, JButton autobutton, JButton browsebutton, int search_type, int result_type) {
            this.filename = filename;
            this.checkFilename = checkFilename;
            this.parent = parent;
            this.autodetectButton = autobutton;
            this.browseButton = browsebutton;
            this.pathComboBox = combobox;
            this.searchType = search_type;
            this.resultType = result_type;
            this.autodetectButton.addActionListener(this);
            this.browseButton.addActionListener(this);
            ((JTextField)this.pathComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.checkNextButtonState();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.checkNextButtonState();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.checkNextButtonState();
                }

                private void checkNextButtonState() {
                    Document doc = ((JTextField)SearchField.this.pathComboBox.getEditor().getEditorComponent()).getDocument();
                    try {
                        if (SearchField.this.pathMatches(doc.getText(0, doc.getLength()))) {
                            SearchField.this.getInstallerFrame().unlockNextButton(false);
                        } else {
                            SearchField.this.getInstallerFrame().lockNextButton();
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            });
            this.autodetect();
        }

        private InstallerFrame getInstallerFrame() {
            return this.parent;
        }

        public boolean belongsTo(JComboBox combobox) {
            return this.pathComboBox == combobox;
        }

        private boolean pathMatches(String path) {
            if (path != null) {
                File file = null;
                file = this.filename == null || this.searchType == 1 ? new File(path) : new File(path, this.filename);
                if (file.exists() && (this.searchType == 1 && file.isDirectory() || this.searchType == 2 && file.isFile())) {
                    if (this.checkFilename == null) {
                        return true;
                    }
                    file = new File(file, this.checkFilename);
                    return file.exists();
                }
            }
            return false;
        }

        public boolean autodetect() {
            String path;
            Vector<String> items = new Vector<String>();
            String selected = (String)this.pathComboBox.getSelectedItem();
            if (selected == null) {
                this.parent.lockNextButton();
                return false;
            }
            boolean found = false;
            for (int x = 0; x < this.pathComboBox.getItemCount(); ++x) {
                if (!this.pathComboBox.getItemAt(x).equals(selected)) continue;
                found = true;
            }
            if (!found) {
                this.pathComboBox.addItem(this.pathComboBox.getSelectedItem());
            }
            VariableSubstitutor vs = new VariableSubstitutor(UserInputPanel.this.idata.getVariables());
            for (int i = 0; i < this.pathComboBox.getItemCount(); ++i) {
                path = vs.substitute((String)this.pathComboBox.getItemAt(i), null);
                if (path.endsWith("*")) {
                    File[] subdirs;
                    File dir = new File(path = path.substring(0, path.length() - 1));
                    if (!dir.isDirectory()) continue;
                    for (File subdir : subdirs = dir.listFiles()) {
                        String search = subdir.getAbsolutePath();
                        if (!this.pathMatches(search)) continue;
                        items.add(search);
                    }
                    continue;
                }
                if (!this.pathMatches(path)) continue;
                items.add(path);
            }
            items = new Vector(new HashSet(items));
            this.pathComboBox.removeAllItems();
            for (String item : items) {
                String res = vs.substitute(item, "plain");
                this.pathComboBox.addItem(res);
            }
            for (int i = 0; i < this.pathComboBox.getItemCount(); ++i) {
                path = (String)this.pathComboBox.getItemAt(i);
                if (!this.pathMatches(path)) continue;
                this.pathComboBox.setSelectedIndex(i);
                this.parent.unlockNextButton();
                return true;
            }
            if (this.pathMatches((String)this.pathComboBox.getSelectedItem())) {
                this.parent.unlockNextButton();
                return true;
            }
            this.parent.lockNextButton();
            return false;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == this.autodetectButton) {
                if (!this.autodetect()) {
                    UserInputPanel.this.showMessageDialog(this.parent, "UserInputPanel.search.autodetect.failed.message", "UserInputPanel.search.autodetect.failed.caption", 2);
                }
            } else if (event.getSource() == this.browseButton) {
                int result;
                JFileChooser chooser = new JFileChooser();
                if (this.resultType != 2) {
                    chooser.setFileSelectionMode(1);
                }
                if ((result = chooser.showOpenDialog(this.parent)) == 0) {
                    File f = chooser.getSelectedFile();
                    this.pathComboBox.setSelectedItem(f.getAbsolutePath());
                    if (this.resultType != 2 && !this.pathMatches(f.getAbsolutePath())) {
                        UserInputPanel.this.showMessageDialog(this.parent, "UserInputPanel.search.wrongselection.message", "UserInputPanel.search.wrongselection.caption", 2);
                    }
                }
            }
        }

        public String getResult() {
            String item = (String)this.pathComboBox.getSelectedItem();
            if (item != null) {
                item = item.trim();
            }
            String path = item;
            File f = new File(item);
            if (!f.isDirectory()) {
                path = f.getParent();
            }
            if (this.resultType == 1) {
                return path;
            }
            if (this.resultType == 2) {
                if (this.filename != null) {
                    return path + File.separatorChar + this.filename;
                }
                return item;
            }
            if (this.resultType == 3) {
                File dir = new File(path);
                return dir.getParent();
            }
            return null;
        }
    }

    protected static class TextValuePair {
        private boolean autoPrompt = false;
        private String text = "";
        private String value = "";

        public TextValuePair(String text, String value) {
            this.text = text;
            this.value = value;
        }

        public void setText(String text) {
            this.text = text;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.text;
        }

        public String getValue() {
            return this.value;
        }

        public boolean getAutoPrompt() {
            return this.autoPrompt;
        }

        public void setAutoPrompt(boolean value) {
            this.autoPrompt = value;
        }
    }
}

