/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.InstallerException;
import com.izforge.izpack.installer.PanelAutomation;
import com.izforge.izpack.panels.StringInputProcessingClient;
import com.izforge.izpack.panels.UserInputPanelConsoleHelper;
import com.izforge.izpack.panels.Validator;
import com.izforge.izpack.panels.ValidatorContainer;
import com.izforge.izpack.util.AeshReadlineConsole;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.SpecHelper;
import com.izforge.izpack.util.VariableSubstitutor;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class UserInputPanelAutomationHelper
implements PanelAutomation {
    private static final String AUTO_KEY_USER_INPUT = "userInput";
    private static final String AUTO_KEY_ENTRY = "entry";
    private static final String AUTO_ATTRIBUTE_KEY = "key";
    private static final String AUTO_ATTRIBUTE_VALUE = "value";
    private static final String AUTO_ATTRIBUTE_AUTOPROMPT = "autoPrompt";
    private static final String REPLACEPATH = "replacePath";
    private Map<String, String> entries;
    private static SpecHelper specHelper;
    private static Vector<IXMLElement> panels;
    private static final String SPEC_FILE_NAME = "userInputSpec.xml";
    private static final String FIELD_NODE_ID = "field";
    private static final String VALIDATOR = "validator";
    private static final String CLASS = "class";
    protected static final String RULE_PARAM = "param";
    private static final String VALIDATION_ERROR = "UserInputPanel.validation.error";
    private static final String VALIDATION_WARNING = "UserInputPanel.validation.warning";
    private static final String PANEL_NODE_ID = "panel";
    private static final String PANEL_ORDER = "order";
    protected static final String PANEL_IDENTIFIER = "id";

    public UserInputPanelAutomationHelper() {
        this.entries = null;
    }

    public UserInputPanelAutomationHelper(Map<String, String> entries) {
        this.entries = entries;
    }

    @Override
    public void makeXMLData(AutomatedInstallData idata, IXMLElement panelRoot) {
        XMLElementImpl userInput = new XMLElementImpl(AUTO_KEY_USER_INPUT, panelRoot);
        panelRoot.addChild(userInput);
        Iterator<String> keys = this.entries.keySet().iterator();
        while (keys.hasNext()) {
            boolean autoPrompt = false;
            String key = keys.next();
            String value = this.entries.get(key);
            if (value == null) {
                autoPrompt = true;
                idata.autoPromptVars.add(key);
            }
            XMLElementImpl dataElement = new XMLElementImpl(AUTO_KEY_ENTRY, userInput);
            dataElement.setAttribute(AUTO_ATTRIBUTE_KEY, key);
            if (autoPrompt) {
                dataElement.setAttribute(AUTO_ATTRIBUTE_AUTOPROMPT, "true");
            } else {
                dataElement.setAttribute(AUTO_ATTRIBUTE_VALUE, value);
            }
            userInput.addChild(dataElement);
        }
    }

    @Override
    public void runAutomated(AutomatedInstallData idata, IXMLElement panelRoot) throws InstallerException {
        VariableSubstitutor vs = new VariableSubstitutor(idata.getVariables());
        IXMLElement userInput = panelRoot.getFirstChildNamed(AUTO_KEY_USER_INPUT);
        if (userInput == null) {
            throw new InstallerException("Missing userInput element on line " + panelRoot.getLineNr());
        }
        Vector<IXMLElement> userEntries = userInput.getChildrenNamed(AUTO_KEY_ENTRY);
        if (userEntries == null) {
            throw new InstallerException("Missing entry element(s) on line " + panelRoot.getLineNr());
        }
        for (int i = 0; i < userEntries.size(); ++i) {
            IXMLElement dataElement = userEntries.elementAt(i);
            String variable = dataElement.getAttribute(AUTO_ATTRIBUTE_KEY);
            String value = dataElement.getAttribute(AUTO_ATTRIBUTE_VALUE);
            String autoPrompt = dataElement.getAttribute(AUTO_ATTRIBUTE_AUTOPROMPT);
            if (UserInputPanelAutomationHelper.getAutoPromptVariable(idata, variable, autoPrompt)) continue;
            Debug.trace("UserInputPanel: setting variable " + variable + " to " + value);
            value = vs.substitute(value);
            idata.setVariable(variable, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IXMLElement readFieldSpec(AutomatedInstallData idata, String variable) throws Exception {
        IXMLElement curField = null;
        String panelId = idata.panelsOrder.get(idata.curPanelNumber).getPanelid();
        Integer panelOrder = idata.curPanelNumber;
        try {
            if (specHelper == null) {
                specHelper = new SpecHelper();
                specHelper.readSpec(specHelper.getResource(SPEC_FILE_NAME));
            }
            curField = specHelper.getFieldForVariable(variable);
            return curField;
        }
        catch (Exception e) {
            Debug.log(e.getMessage());
        }
        finally {
            return curField;
        }
    }

    public static boolean getAutoPromptVariable(AutomatedInstallData idata, String variable, String autoPrompt) {
        return UserInputPanelAutomationHelper.getAutoPromptVariable(idata, variable, autoPrompt, false, null, null);
    }

    public static boolean getAutoPromptVariable(AutomatedInstallData idata, String variable, String autoPrompt, String prompt, String rePrompt) {
        return UserInputPanelAutomationHelper.getAutoPromptVariable(idata, variable, autoPrompt, true, prompt, rePrompt);
    }

    private static boolean getAutoPromptVariable(AutomatedInstallData idata, String variable, String autoPrompt, boolean customPanel, String prompt, String rePrompt) {
        IXMLElement currentField = null;
        if (autoPrompt == null || !autoPrompt.equalsIgnoreCase("true")) {
            return false;
        }
        if (!customPanel) {
            try {
                currentField = UserInputPanelAutomationHelper.readFieldSpec(idata, variable);
            }
            catch (Exception e) {
                Debug.log("Unable to read userInputPanel spec xml. No validation available.");
            }
        }
        if (idata.getVariable(variable) == null || idata.getVariable(variable).isEmpty()) {
            UserInputPanelAutomationHelper.getInputs(idata, variable, currentField, prompt, rePrompt);
        } else {
            String value = idata.getVariable(variable);
            if (!UserInputPanelAutomationHelper.validate(idata, value, currentField)) {
                UserInputPanelAutomationHelper.getInputs(idata, variable, currentField, prompt, rePrompt);
            }
        }
        return true;
    }

    public static void getInputs(AutomatedInstallData idata, String variable, IXMLElement currentField, String prompt, String rePrompt) {
        String value = "";
        String first = "";
        String second = "1";
        boolean valid = false;
        if (currentField != null) {
            Vector<IXMLElement> children = currentField.getFirstChildNamed("spec").getChildren();
            prompt = idata.langpack.getString(children.get(0).getAttribute(PANEL_IDENTIFIER));
            rePrompt = idata.langpack.getString(children.get(1).getAttribute(PANEL_IDENTIFIER));
        }
        while (!first.equals(second) || !valid) {
            System.out.println(prompt);
            first = AeshReadlineConsole.readPassword();
            System.out.println(rePrompt);
            second = AeshReadlineConsole.readPassword();
            if (!first.equals(second)) {
                System.out.println("The values didn't match, please try again.");
                continue;
            }
            valid = UserInputPanelAutomationHelper.validate(idata, first, currentField);
            if (!valid) continue;
            value = first;
        }
        Debug.trace("UserInputPanel: setting variable " + variable + " to " + value);
        idata.setVariable(variable, value);
    }

    private static boolean validate(AutomatedInstallData idata, String input, IXMLElement currentField) {
        List<ValidatorContainer> validators = null;
        StringInputProcessingClient validation = null;
        boolean valid = false;
        if (currentField != null) {
            validators = specHelper.getValidatorsFromField(idata, currentField);
            validation = new StringInputProcessingClient(input, validators);
            List<Validator.Status> validationResult = validation.validate();
            if (validationResult.contains((Object)Validator.Status.ERROR)) {
                System.out.println(UserInputPanelConsoleHelper.getTranslation(idata, VALIDATION_ERROR) + System.getProperty("line.separator"));
                for (String message : validation.getValidationMessage()) {
                    System.out.println(message);
                }
                return false;
            }
            if (validationResult.contains((Object)Validator.Status.WARNING)) {
                System.out.println(UserInputPanelConsoleHelper.getTranslation(idata, VALIDATION_WARNING) + System.getProperty("line.separator"));
                for (String message : validation.getValidationMessage()) {
                    System.out.println(message);
                }
                return true;
            }
            return true;
        }
        return true;
    }
}

