/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.gui.dynamic.SecurityDomainModule;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.ConsoleInstaller;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.installer.PanelConsole;
import com.izforge.izpack.installer.PanelConsoleHelper;
import com.izforge.izpack.panels.FileDownloadManagerConsoleHelper;
import com.izforge.izpack.panels.MultipleFieldValidator;
import com.izforge.izpack.panels.PasswordGroup;
import com.izforge.izpack.panels.Processor;
import com.izforge.izpack.panels.StringInputProcessingClient;
import com.izforge.izpack.panels.UserInputPanel;
import com.izforge.izpack.panels.UserInputPanelAutomationHelper;
import com.izforge.izpack.panels.Validator;
import com.izforge.izpack.panels.ValidatorContainer;
import com.izforge.izpack.util.AeshReadlineConsole;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.ErrorIzpackPathException;
import com.izforge.izpack.util.FileUtil;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.ReversePathSubstitutor;
import com.izforge.izpack.util.SpecHelper;
import com.izforge.izpack.util.VariableSubstitutor;
import com.izforge.izpack.util.WarningIzpackPathException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UserInputPanelConsoleHelper
extends PanelConsoleHelper
implements PanelConsole {
    private boolean erase = false;
    private boolean mustConfirm = true;
    private String eraseTo;
    protected int instanceNumber = 0;
    private static int instanceCount = 0;
    private static final int INITIAL = 0;
    private static final int CONFIRMATION = 1;
    private static final String SPEC_FILE_NAME = "userInputSpec.xml";
    private static final String NODE_ID = "panel";
    private static final String INSTANCE_IDENTIFIER = "order";
    protected static final String PANEL_IDENTIFIER = "id";
    private static final String FIELD_NODE_ID = "field";
    protected static final String ATTRIBUTE_CONDITIONID_NAME = "conditionid";
    protected static final String ATTRIBUTE_DEPENDENT = "dependent";
    private static final String VARIABLE = "variable";
    private static final String SET = "set";
    private static final String TEXT = "txt";
    private static final String SPEC = "spec";
    private static final String PWD = "pwd";
    private static final String SUMMARIZE = "summarize";
    private static final String AUTOPROMPT = "autoPrompt";
    private static final String HIDEINCONSOLE = "hideInConsole";
    private static final String REPLACEPATH = "replacePath";
    private static final String REVALIDATE = "revalidate";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String TEXT_FIELD = "text";
    private static final String AUTO_TEXT_FIELD = "autotext";
    private static final String COMBO_FIELD = "combo";
    private static final String STATIC_TEXT = "staticText";
    private static final String CHOICE = "choice";
    private static final String DIR = "dir";
    private static final String FILE = "file";
    private static final String FILE_URL = "fileurl";
    private static final String FILE_DIR = "filedir";
    private static final String DIR_URL = "dirurl";
    private static final String PASSWORD = "password";
    private static final String VALUE = "value";
    private static final String RADIO_FIELD = "radio";
    private static final String TITLE_FIELD = "title";
    private static final String CHECK_FIELD = "check";
    private static final String RULE_FIELD = "rule";
    private static final String DYNAMIC_FIELD = "dynamic";
    private static final String SPACE = "space";
    private static final String DIVIDER = "divider";
    private static final String BUTTON = "button";
    static final String DISPLAY_FORMAT = "displayFormat";
    static final String PLAIN_STRING = "plainString";
    static final String SPECIAL_SEPARATOR = "specialSeparator";
    static final String LAYOUT = "layout";
    static final String RESULT_FORMAT = "resultFormat";
    private static final String DESCRIPTION = "description";
    private static final String TRUE = "true";
    private static final String NAME = "name";
    private static final String FAMILY = "family";
    private static final String OS = "os";
    private static final String SELECTEDPACKS = "createForPack";
    private static final String EDITABLE = "editable";
    private static final String STRING_PORT_TEMPLATE = "port.template";
    private static final String STRING_TO_PASTE = "regex.template";
    private static final String STRING_MULTICAST_ADDRESS_TEMPLATE = "multicast-address.template";
    private static final String STRING_MULTICAST_PORT_TEMPLATE = "multicast-port.template";
    private static final String OFFSET_TEMPLATE = "offset.template";
    private static final String VALIDATOR_PORT_TEMPLATE = "validator.template";
    private static final String VALIDATOR_M_RANGE_TEMPLATE = "multicast-port-range-validator.template";
    private static final String VALIDATOR_M_ADDRESS_TEMPLATE = "multicast-address-validator.template";
    private static final String VALIDATOR_M_PORT_TEMPLATE = "multicast-port-validator.template";
    private static final String VALIDATOR_ADDRESS_TEMPLATE = "verify-address-validator.template";
    private static final String VALIDATOR_RANGE_TEMPLATE = "range-validator.template";
    private static final String MULTICAST_ADDRESS_VALIDATOR = "multicast-address.validator";
    private static final String MULTICAST_PORT_VALIDATOR = "multicast-port.validator";
    private static final String MULTICAST_PORT_RANGE_VALIDATOR = "multicast-port.range-validator";
    private static final String ADDRESS_VALIDATOR = "verify-address.validator";
    private static final String VALIDATOR = "validator";
    private static final String RANGE_VALIDATOR = "range-validator";
    private static final String VALIDATION_FAILED = "UserInputPanel.validation.failed";
    private static final String VALIDATION_ERROR = "UserInputPanel.validation.error";
    private static final String VALIDATION_WARNING = "UserInputPanel.validation.warning";
    private static final String CONSOLE_ERROR = "UserInputPanel.console.error";
    private static final String INPUT_SELECTION = "UserInputPanel.input.selection";
    private static final String INPUT_CHOICE = "UserInputPanel.choice";
    private static final String CONFIRM_SELECTION = "TreePacksPanel.confirm";
    private static final String NUMBER = "TreePacksPanel.number";
    private static final String INVALID = "TreePacksPanel.invalid";
    private static final String OFFSET_VARIABLE_ELEMENT = "maximum.offset.variable";
    private static final String MULTICAST_ADDRESS = "multicast-address";
    private static final String MULTICAST_PORT = "multicast-port";
    private static final String ADDRESS = "verify-address";
    private static final String PORT = "port";
    private static Input SPACE_INTPUT_FIELD = new Input("space", null, null, "space", "\r", 0);
    private static Input DIVIDER_INPUT_FIELD = new Input("divider", null, null, "divider", "------------------------------------------", 0);
    private static String portTemplateText = null;
    private static String regexTemplate = null;
    private static String multicastTemplateText = null;
    private static String multicastAddTemplateText = null;
    private static String validatorRangeText = null;
    private static String validatorMulticastAddressText = null;
    private static String validatorMulticastPortText = null;
    private static String validatorMulticastRangeText = null;
    private static String validatorVerifyAddressText = null;
    private static String validatorPortText = null;
    private static String offsetText = null;
    private static String portOffsetVariable = null;
    private static String offsetValidator = null;
    private static String prevPassword = "";
    public List<Input> listInputs;
    private Vector<UserInputPanel.TextValuePair> entriesForAutomatedInstall = new Vector();
    private HashSet<String> replacePathMap = new HashSet();
    private Vector<UserInputPanel.TextValuePair> entriesForSummaryPanel = new Vector();

    public UserInputPanelConsoleHelper() {
        this.instanceNumber = instanceCount++;
        this.listInputs = new ArrayList<Input>();
    }

    public List<ValidatorContainer> analyzeValidator(IXMLElement specElement, AutomatedInstallData idata) {
        ArrayList<ValidatorContainer> result = null;
        Vector<IXMLElement> validatorsElem = specElement.getChildrenNamed(VALIDATOR);
        if (validatorsElem != null && validatorsElem.size() > 0) {
            int vsize = validatorsElem.size();
            result = new ArrayList<ValidatorContainer>(vsize);
            for (int i = 0; i < vsize; ++i) {
                IXMLElement element2 = validatorsElem.get(i);
                String validator = element2.getAttribute("class");
                String message = UserInputPanelConsoleHelper.getStrText(element2, idata);
                HashMap<String, String> validateParamMap = new HashMap<String, String>();
                Vector<IXMLElement> validateParams = element2.getChildrenNamed("param");
                if (validateParams != null && validateParams.size() > 0) {
                    for (IXMLElement element2 : validateParams) {
                        String paramName = element2.getAttribute(NAME);
                        String paramValue = element2.getAttribute(VALUE);
                        validateParamMap.put(paramName, paramValue);
                    }
                }
                result.add(new ValidatorContainer(validator, message, validateParamMap));
            }
        }
        return result;
    }

    @Override
    public boolean runConsoleFromPropertiesFile(AutomatedInstallData installData, Properties p) {
        this.collectInputs(installData);
        Iterator<Input> inputIterator = this.listInputs.iterator();
        while (inputIterator.hasNext()) {
            String strVariableValue;
            String strVariableName = inputIterator.next().strVariableName;
            if (strVariableName == null || (strVariableValue = p.getProperty(strVariableName)) == null) continue;
            installData.setVariable(strVariableName, strVariableValue);
        }
        return true;
    }

    @Override
    public void makeXMLData(IXMLElement panelRoot, AutomatedInstallData idata) {
        LinkedHashMap<String, String> entryMap = new LinkedHashMap<String, String>();
        for (int i = 0; i < this.entriesForAutomatedInstall.size(); ++i) {
            UserInputPanel.TextValuePair pair = this.entriesForAutomatedInstall.elementAt(i);
            String key = pair.toString();
            if (pair.getValue() == null) {
                entryMap.put(key, null);
                continue;
            }
            String value = idata.getVariable(key);
            if (this.replacePathMap.contains(key)) {
                value = ReversePathSubstitutor.substitute("INSTALL_PATH", value);
            }
            entryMap.put(key, value);
        }
        new UserInputPanelAutomationHelper(entryMap).makeXMLData(idata, panelRoot);
    }

    @Override
    public String getSummaryBody(AutomatedInstallData idata) {
        String key;
        HashMap<String, String> entryMap = new HashMap<String, String>();
        for (int i = 0; i < this.entriesForSummaryPanel.size(); ++i) {
            UserInputPanel.TextValuePair pair = this.entriesForSummaryPanel.elementAt(i);
            key = pair.toString();
            entryMap.put(key, idata.getVariable(key));
        }
        Iterator keys = entryMap.keySet().iterator();
        StringBuilder tmp = new StringBuilder();
        while (keys.hasNext()) {
            key = (String)keys.next();
            String value = (String)entryMap.get(key);
            String keyname = idata.langpack.getString(key);
            tmp.append(keyname + ": " + value + "<br>");
        }
        if (tmp.toString().trim().isEmpty()) {
            return null;
        }
        return tmp.toString();
    }

    @Override
    public boolean runGeneratePropertiesFile(AutomatedInstallData installData, PrintWriter printWriter) {
        this.collectInputs(installData);
        for (Input input : this.listInputs) {
            if (input.strVariableName == null) continue;
            printWriter.println(input.strVariableName + "=");
        }
        return true;
    }

    public void buildCheckboxList(ArrayList<Input> fieldInputs, Iterator<Input> inputsIterator, Input input, int nextIndex) {
        fieldInputs.add(input);
        while (inputsIterator.hasNext() && this.listInputs.get((int)nextIndex).strFieldType.equals(CHECK_FIELD)) {
            input = inputsIterator.next();
            fieldInputs.add(input);
            ++nextIndex;
        }
    }

    @Override
    public boolean runConsole(AutomatedInstallData idata, ConsoleInstaller parent) {
        int nextIndex = 0;
        parent.refreshDynamicVariables(new VariableSubstitutor(idata.getVariables()), idata);
        boolean processpanel = this.collectInputs(idata);
        if (!processpanel) {
            return true;
        }
        boolean status = true;
        Iterator<Input> inputsIterator = this.listInputs.iterator();
        ArrayList<Input> fieldInputs = new ArrayList<Input>();
        try {
            while (inputsIterator.hasNext()) {
                Input input = inputsIterator.next();
                ++nextIndex;
                if (input.condition != null && !idata.getRules().isConditionTrue(input.condition)) continue;
                if (TEXT_FIELD.equals(input.strFieldType) || AUTO_TEXT_FIELD.equals(input.strFieldType) || FILE.equals(input.strFieldType) || RULE_FIELD.equals(input.strFieldType) || DIR.equals(input.strFieldType) || FILE_DIR.equals(input.strFieldType) || FILE_URL.equals(input.strFieldType) || DIR_URL.equals(input.strFieldType)) {
                    status = status && this.processTextField(input, idata);
                    continue;
                }
                if (COMBO_FIELD.equals(input.strFieldType) || RADIO_FIELD.equals(input.strFieldType)) {
                    status = status && this.processComboRadioField(input, idata);
                    continue;
                }
                if (CHECK_FIELD.equals(input.strFieldType)) {
                    this.buildCheckboxList(fieldInputs, inputsIterator, input, nextIndex);
                    status = status && this.processCheckField(idata, fieldInputs);
                    fieldInputs.clear();
                    continue;
                }
                if (STATIC_TEXT.equals(input.strFieldType) || TITLE_FIELD.equals(input.strFieldType) || DIVIDER.equals(input.strFieldType) || SPACE.equals(input.strFieldType)) {
                    status = status && this.processSimpleField(input, idata);
                    continue;
                }
                if (PASSWORD.equals(input.strFieldType)) {
                    status = status && this.processPasswordField(input, idata);
                    continue;
                }
                if (BUTTON.equals(input.strFieldType)) {
                    status = status && this.processButtonField(input, idata);
                    continue;
                }
                if (!DYNAMIC_FIELD.equals(input.strFieldType)) continue;
                status = status && this.processDynamicField(input, idata);
            }
        }
        catch (RevalidationTriggeredException e) {
            return this.runConsole(idata, parent);
        }
        int i = UserInputPanelConsoleHelper.askEndOfConsolePanel(idata);
        if (i == 1) {
            prevPassword = "";
            return true;
        }
        if (i == 2) {
            return false;
        }
        this.entriesForSummaryPanel.clear();
        this.entriesForAutomatedInstall.clear();
        return this.runConsole(idata, parent);
    }

    private String paste(String getChildren, IXMLElement spec, AutomatedInstallData idata) {
        return UserInputPanelConsoleHelper.getTranslation(idata, this.getID(getChildren, spec, idata));
    }

    private String getID(String getChildren, IXMLElement spec, AutomatedInstallData idata) {
        Vector<IXMLElement> var = spec.getChildrenNamed(getChildren);
        String templateID = null;
        for (int i = 0; i < var.size(); ++i) {
            IXMLElement element = var.elementAt(i);
            templateID = element.getAttribute(PANEL_IDENTIFIER);
        }
        return templateID;
    }

    public boolean collectInputs(AutomatedInstallData idata) {
        this.listInputs.clear();
        IXMLElement spec = null;
        String panelid = idata.panelsOrder.get(idata.curPanelNumber).getPanelid();
        String instance = Integer.toString(this.instanceNumber);
        SpecHelper specHelper = new SpecHelper();
        try {
            specHelper.readSpec(specHelper.getResource(SPEC_FILE_NAME));
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return false;
        }
        Vector<IXMLElement> specElements = specHelper.getSpec().getChildrenNamed(NODE_ID);
        for (int i = 0; i < specElements.size(); ++i) {
            IXMLElement data = specElements.elementAt(i);
            String attribute = data.getAttribute(INSTANCE_IDENTIFIER);
            String dataID = data.getAttribute(PANEL_IDENTIFIER);
            if ((attribute == null || !instance.equals(attribute)) && (dataID == null || panelid == null || !panelid.equals(dataID))) continue;
            Vector<IXMLElement> forPacks = data.getChildrenNamed(SELECTEDPACKS);
            Vector<IXMLElement> forOs = data.getChildrenNamed(OS);
            if (!this.itemRequiredFor(forPacks, idata) || !this.itemRequiredForOs(forOs)) continue;
            spec = data;
            break;
        }
        if (spec == null) {
            return false;
        }
        Vector<IXMLElement> fieldsRegexs = spec.getChildrenNamed(STRING_TO_PASTE);
        for (int i = 0; i < fieldsRegexs.size(); ++i) {
            IXMLElement fieldRegex = fieldsRegexs.elementAt(i);
            regexTemplate = fieldRegex.getAttribute(TEXT);
        }
        portTemplateText = this.paste(STRING_PORT_TEMPLATE, spec, idata);
        multicastAddTemplateText = this.paste(STRING_MULTICAST_ADDRESS_TEMPLATE, spec, idata);
        multicastTemplateText = this.paste(STRING_MULTICAST_PORT_TEMPLATE, spec, idata);
        validatorMulticastAddressText = this.paste(VALIDATOR_M_ADDRESS_TEMPLATE, spec, idata);
        validatorMulticastPortText = this.paste(VALIDATOR_M_PORT_TEMPLATE, spec, idata);
        validatorVerifyAddressText = this.paste(VALIDATOR_ADDRESS_TEMPLATE, spec, idata);
        validatorMulticastRangeText = this.paste(VALIDATOR_M_RANGE_TEMPLATE, spec, idata);
        validatorPortText = this.paste(VALIDATOR_PORT_TEMPLATE, spec, idata);
        validatorRangeText = this.paste(VALIDATOR_RANGE_TEMPLATE, spec, idata);
        offsetText = this.paste(OFFSET_TEMPLATE, spec, idata);
        offsetValidator = this.getID(OFFSET_TEMPLATE, spec, idata);
        portOffsetVariable = this.getID(OFFSET_VARIABLE_ELEMENT, spec, idata);
        Vector<IXMLElement> fields = spec.getChildrenNamed(FIELD_NODE_ID);
        for (int i = 0; i < fields.size(); ++i) {
            Input in;
            IXMLElement field = fields.elementAt(i);
            Vector<IXMLElement> forPacks = field.getChildrenNamed(SELECTEDPACKS);
            Vector<IXMLElement> forOs = field.getChildrenNamed(OS);
            if (!this.itemRequiredFor(forPacks, idata) || !this.itemRequiredForOs(forOs)) continue;
            String conditionid = field.getAttribute(ATTRIBUTE_CONDITIONID_NAME);
            String isDependent = field.getAttribute(ATTRIBUTE_DEPENDENT);
            if (conditionid != null && (!idata.getRules().isConditionTrue(conditionid, idata.getVariables()) && isDependent == null || isDependent != null && !idata.getRules().isConditionTrue(isDependent, idata.getVariables())) || (in = this.getInputFromField(field, idata)) == null) continue;
            in.condition = conditionid;
            if (this.erase) {
                if (in.strVariableName == null || !in.strVariableName.equals(this.eraseTo)) continue;
                this.erase = false;
                continue;
            }
            if (!(in instanceof Button)) {
                in.validators = this.analyzeValidator(field, idata);
                if (in instanceof Password) {
                    for (Input singleInput : ((Password)in).input) {
                        singleInput.validators = in.validators;
                    }
                }
            }
            this.listInputs.add(in);
        }
        return true;
    }

    boolean processSimpleField(Input input, AutomatedInstallData idata) {
        VariableSubstitutor vs = new VariableSubstitutor(idata.getVariables());
        String text = vs.substitute(input.strText, null);
        text = this.formatTextForConsole(text);
        System.out.println(text);
        return true;
    }

    private String formatTextForConsole(String text) {
        Document doc = this.generateDocument(text);
        if (doc == null) {
            return text;
        }
        NodeList nodes = doc.getElementsByTagName("a");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String link = node.getAttributes().getNamedItem("href").getTextContent();
            String currentNodeText = node.getTextContent();
            String textContent = currentNodeText + " " + link;
            node.setTextContent(textContent);
        }
        return doc.getDocumentElement().getTextContent();
    }

    private Document generateDocument(String text) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            builder.setErrorHandler(null);
            Document doc = builder.parse(new ByteArrayInputStream(text.getBytes("UTF-8")));
            return doc;
        }
        catch (Exception e) {
            Debug.log(e);
            return null;
        }
    }

    boolean processPasswordTextField(Input input, int stage, AutomatedInstallData idata, boolean autoPrompt) {
        boolean done;
        String variable = input.strVariableName;
        StringInputProcessingClient validation = null;
        String set = "";
        String value = "";
        String strIn = null;
        String prevPwd = prevPassword;
        if (prevPwd != null) {
            if (stage == 0) {
                this.mustConfirm = false;
            }
            for (int j = 0; j < prevPwd.length(); ++j) {
                set = set + "*";
            }
        } else {
            prevPwd = "";
        }
        if (variable == null || variable.length() == 0) {
            return true;
        }
        if (input.listChoices.size() == 0) {
            Debug.trace("Error: no spec element defined in file field");
            return false;
        }
        String fieldText = input.listChoices.get((int)stage).strText;
        do {
            List<Validator.Status> validationResult;
            if (stage == 1 && !this.mustConfirm) {
                value = prevPwd;
                this.mustConfirm = true;
                break;
            }
            done = true;
            System.out.println(fieldText + " [" + set + "] ");
            try {
                strIn = AeshReadlineConsole.readPassword();
            }
            catch (Exception e) {
                e.printStackTrace();
                done = false;
            }
            if (!strIn.trim().equals("") || stage == 1 && this.mustConfirm) {
                value = strIn;
                this.mustConfirm = true;
            } else {
                value = prevPwd;
            }
            if (input.validators != null && !input.validators.isEmpty()) {
                validation = new StringInputProcessingClient(value, input.validators);
            }
            if (!(validationResult = validation.validate()).contains((Object)Validator.Status.ERROR)) continue;
            done = false;
            if (stage == 0) {
                prevPassword = "";
                set = "";
            }
            System.out.println(UserInputPanelConsoleHelper.getTranslation(idata, VALIDATION_ERROR) + ": ");
            for (String message : validation.getValidationMessage()) {
                System.out.println(message);
            }
        } while (!done);
        if (stage == 0) {
            prevPassword = value;
        } else if (stage == 1) {
            prevPassword = "";
        }
        idata.setVariable(variable, value);
        this.addToSummary(input, variable, value);
        this.addToAutomated(input, variable, value);
        return true;
    }

    private boolean processPasswordField(Input input, AutomatedInstallData idata) {
        Password pwd = (Password)input;
        boolean autoPrompt = pwd.getAutoPrompt();
        boolean rtn = false;
        LinkedList<String> values = new LinkedList<String>();
        for (int i = 0; i < pwd.input.length; ++i) {
            boolean done;
            do {
                done = true;
                rtn = this.processPasswordTextField(pwd.input[i], i, idata, autoPrompt);
                if (!rtn) {
                    return false;
                }
                values.add(idata.getVariable(pwd.input[i].strVariableName));
                if (i <= 0 || pwd.validators == null || pwd.validators.isEmpty()) continue;
                MultipleFieldValidator validation = new MultipleFieldValidator(values, pwd.validators);
                List<Validator.Status> validationResult = validation.validate();
                if (validationResult.contains((Object)Validator.Status.ERROR)) {
                    values.clear();
                    done = false;
                    prevPassword = "";
                    System.out.println(UserInputPanelConsoleHelper.getTranslation(idata, VALIDATION_ERROR) + ": ");
                    for (String message : validation.getValidationMessage()) {
                        System.out.println(message);
                    }
                    i = 0;
                    continue;
                }
                if (!validationResult.contains((Object)Validator.Status.WARNING)) continue;
                System.out.println(UserInputPanelConsoleHelper.getTranslation(idata, VALIDATION_WARNING) + ": ");
                for (String message : validation.getValidationMessage()) {
                    System.out.println(message);
                }
            } while (!done);
        }
        return rtn;
    }

    boolean processDynamicField(Input input, AutomatedInstallData idata) {
        DynamicComponent dynamicComponent = (DynamicComponent)input;
        boolean success = false;
        int accept = 49;
        int add = 50;
        int remove = 51;
        int redisplay = 52;
        String addString = idata.langpack.getString(dynamicComponent.getAddText());
        String removeString = idata.langpack.getString(dynamicComponent.getRemoveText());
        String redisplayText = dynamicComponent.getRedisplayText() != null ? idata.langpack.getString(dynamicComponent.getRedisplayText()) : idata.langpack.getString("dynamicComponents.redisplay.default");
        UserInputPanel.removeExistingDynamicComponentVariables(dynamicComponent.strVariableName);
        try {
            if (dynamicComponent.isTwoTextField() && !dynamicComponent.defaults.isEmpty()) {
                for (String[] keypair : dynamicComponent.defaults) {
                    ArrayList<String> enteredDefaults = new ArrayList<String>();
                    enteredDefaults.add(keypair[0]);
                    System.out.println(String.format(idata.langpack.getString("dynamicComponents.twotext.defaults.console"), keypair[0], keypair[1]));
                    String val = AeshReadlineConsole.readLine();
                    if (val.isEmpty()) {
                        enteredDefaults.add(keypair[1]);
                    } else {
                        enteredDefaults.add(val);
                    }
                    dynamicComponent.addElement(enteredDefaults);
                }
            }
            ArrayList<String> dirs = new ArrayList<String>();
            if (dynamicComponent.isPathField()) {
                System.out.println(idata.langpack.getString(dynamicComponent.strText));
                dirs.add(AeshReadlineConsole.readFile(false));
                dynamicComponent.addElement(dirs);
                dynamicComponent.saveValues(idata.getVariables(), this.entriesForAutomatedInstall);
            }
            Stack<String> usedCodes = new Stack<String>();
            while (!success) {
                dynamicComponent.printStack();
                int response = this.askAddRemoveAcceptDynamic(addString, removeString, redisplayText, idata.langpack.getString("dynamicComponents.add.remove.phrase"));
                if (response == redisplay) {
                    throw new RevalidationTriggeredException();
                }
                if (response == remove) {
                    dynamicComponent.removeElement();
                    if (usedCodes.empty()) continue;
                    usedCodes.pop();
                    continue;
                }
                if (response == add) {
                    ArrayList<String> values = new ArrayList<String>();
                    if (dynamicComponent.isPathField()) {
                        System.out.println(idata.langpack.getString(dynamicComponent.strText));
                        values.add(AeshReadlineConsole.readFile(false));
                        dynamicComponent.addElement(values);
                        continue;
                    }
                    if (dynamicComponent.isTwoTextField()) {
                        System.out.println(idata.langpack.getString(dynamicComponent.strText) + idata.langpack.getString("dynamicComponents.twotext.example.console"));
                        String keyVal = AeshReadlineConsole.readLine();
                        String[] keypair = keyVal.split("=");
                        if (keypair.length != 2) {
                            System.out.println(idata.langpack.getString("dynamicComponents.twotext.error.console"));
                            continue;
                        }
                        values.add(0, keypair[0]);
                        values.add(1, keypair[1]);
                        dynamicComponent.addElement(values);
                        continue;
                    }
                    if (!dynamicComponent.isSecurityDomainModule()) continue;
                    String[] options = SecurityDomainModule.codes.get(dynamicComponent.getSecDomType());
                    if (options.length == usedCodes.size()) {
                        System.out.println(idata.langpack.getString("dynamicComponents.security.domain.module.error.console"));
                        continue;
                    }
                    System.out.println(idata.langpack.getString("dynamicComponents.security.domain.code.console"));
                    String code = this.getSecurityDomainSelection(options, usedCodes);
                    values.add(code);
                    usedCodes.push(code);
                    System.out.println(idata.langpack.getString("dynamicComponents.security.domain.flag.console"));
                    values.add(this.getSecurityDomainSelection(SecurityDomainModule.flags.get(dynamicComponent.getSecDomType()), null));
                    boolean proceed = false;
                    while (!proceed) {
                        System.out.println(idata.langpack.getString("dynamicComponents.security.domain.operation.console"));
                        String userInput = AeshReadlineConsole.readLine();
                        values.add(userInput);
                        dynamicComponent.addElement(values);
                        String errormsg = idata.langpack.getString(VALIDATION_ERROR);
                        proceed = dynamicComponent.validate(errormsg);
                        if (proceed) continue;
                        values.remove(userInput);
                        dynamicComponent.removeElement();
                    }
                    continue;
                }
                if (response == accept) {
                    if (!dynamicComponent.validateNumberElements()) {
                        System.out.println(String.format(idata.langpack.getString("dynamicComponents.number.error"), dynamicComponent.minComponents, dynamicComponent.maxComponents));
                        continue;
                    }
                    String errormsg = idata.langpack.getString(VALIDATION_ERROR);
                    success = dynamicComponent.validate(errormsg);
                    continue;
                }
                System.out.println(idata.langpack.getString("dynamicComponents.selection.error"));
            }
            dynamicComponent.saveValues(idata.getVariables(), this.entriesForAutomatedInstall);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return success;
    }

    private int askAddRemoveAcceptDynamic(String addText, String removeText, String redisplayText, String phrase) throws IOException {
        System.out.println(String.format(phrase, addText, removeText, redisplayText));
        try {
            return AeshReadlineConsole.readChar();
        }
        catch (StringIndexOutOfBoundsException e) {
            return -1;
        }
    }

    private String getSecurityDomainSelection(String[] optionsArray, Stack<String> usedValues) {
        ArrayList<String> options = new ArrayList<String>(Arrays.asList(optionsArray));
        if (usedValues != null) {
            for (String value : usedValues) {
                if (!options.contains(value)) continue;
                options.remove(value);
            }
        }
        for (int i = 0; i < options.size(); ++i) {
            if (i == 0) {
                System.out.println(String.format("%d [x] %s", i, options.get(i)));
                continue;
            }
            System.out.println(String.format("%d [ ] %s", i, options.get(i)));
        }
        while (true) {
            try {
                String codeSelected = AeshReadlineConsole.readLine();
                int val = codeSelected.trim().isEmpty() ? 0 : Integer.parseInt(codeSelected);
                String selectedOption = options.get(val);
                return selectedOption;
            }
            catch (NumberFormatException nfe) {
                System.out.println(AutomatedInstallData.getInstance().langpack.getString("dynamicComponents.selection.error"));
                continue;
            }
            catch (ArrayIndexOutOfBoundsException aie) {
                System.out.println(String.format(AutomatedInstallData.getInstance().langpack.getString("dynamicComponents.select.number.error"), options.size() - 1));
                continue;
            }
            catch (IndexOutOfBoundsException ie) {
                System.out.println(String.format(AutomatedInstallData.getInstance().langpack.getString("dynamicComponents.select.number.error"), options.size() - 1));
                continue;
            }
            break;
        }
    }

    boolean processButtonField(Input input, AutomatedInstallData idata) {
        Button button = (Button)input;
        String message = button.getMessageId();
        String question = button.getQuestionId();
        List<String> errorMessages = button.getErrorMessages();
        int answer = UserInputPanelConsoleHelper.askYesNo(UserInputPanelConsoleHelper.getTranslation(idata, question), false);
        if (answer == 47) {
            int i = 0;
            for (ValidatorContainer validatorContainer : button.validators) {
                PasswordGroup dummyProcessor = new PasswordGroup(idata, new ArrayList<ValidatorContainer>(), "Dummy");
                Validator validator = validatorContainer.getValidator();
                DataValidator dValidator = (DataValidator)((Object)validator);
                Validator.Status returnValue = validator.validate(dummyProcessor);
                if (returnValue == Validator.Status.ERROR) {
                    System.out.println(UserInputPanelConsoleHelper.getTranslation(idata, VALIDATION_ERROR) + ": " + UserInputPanelConsoleHelper.getTranslation(idata, dValidator.getErrorMessageId()));
                } else if (returnValue == Validator.Status.WARNING) {
                    System.out.println(UserInputPanelConsoleHelper.getTranslation(idata, VALIDATION_WARNING) + ": " + UserInputPanelConsoleHelper.getTranslation(idata, dValidator.getWarningMessageId()));
                } else {
                    System.out.println(UserInputPanelConsoleHelper.getTranslation(idata, message));
                }
                ++i;
            }
        }
        return true;
    }

    boolean processTextField(Input input, AutomatedInstallData idata) {
        String value;
        String variable = input.strVariableName;
        boolean passwordText = PASSWORD.equals(input.strFieldType);
        boolean directoryText = DIR.equals(input.strFieldType);
        boolean fileText = FILE.equals(input.strFieldType);
        boolean filedirText = FILE_DIR.equals(input.strFieldType);
        boolean fileurl = FILE_URL.equals(input.strFieldType);
        boolean dirurl = DIR_URL.equals(input.strFieldType);
        boolean autotext = AUTO_TEXT_FIELD.equals(input.strFieldType);
        StringInputProcessingClient validation = null;
        if (variable == null || variable.length() == 0) {
            return true;
        }
        if (input.listChoices.size() == 0) {
            Debug.trace("Error: no spec element defined in file field");
            return false;
        }
        String set = idata.getVariable(variable);
        if (set == null && (set = input.strDefaultValue) == null) {
            set = "";
        }
        if (set != null && !"".equals(set)) {
            VariableSubstitutor vs = new VariableSubstitutor(idata.getVariables());
            set = vs.deepSubstitute(set, null);
        }
        set = autotext ? "" : set;
        String fieldText = input.listChoices.get((int)0).strText;
        while (true) {
            FileDownloadManagerConsoleHelper downloader;
            String strIn;
            boolean done = true;
            boolean downloadRequired = false;
            if (fieldText == null) {
                System.out.println(" [" + set + "] ");
            } else {
                System.out.println(fieldText + " [" + set + "] ");
            }
            if (directoryText || fileText || filedirText || fileurl || dirurl) {
                strIn = AeshReadlineConsole.readFile(directoryText);
                if (!(strIn.isEmpty() || strIn.startsWith("https://") || strIn.startsWith("http://") || strIn.startsWith("ftp://") || strIn.startsWith("file://"))) {
                    strIn = new File(strIn).getAbsolutePath();
                    try {
                        if (!FileUtil.isPathValid(strIn)) {
                            System.out.println(idata.langpack.getString("TargetPanel.notwritable"));
                            done = false;
                        }
                    }
                    catch (WarningIzpackPathException wipe) {
                        int proceed = UserInputPanelConsoleHelper.askYesNo(wipe.getMessage(), false);
                        if (proceed == 49) {
                            done = false;
                        }
                    }
                    catch (ErrorIzpackPathException ipe) {
                        System.out.println(ipe.getMessage());
                        done = false;
                    }
                } else if ((filedirText || fileurl) && !input.suppressDownload) {
                    downloadRequired = true;
                }
            } else {
                strIn = input.editable ? AeshReadlineConsole.readLine() : "";
            }
            String testValue = null;
            String systemProp = null;
            boolean isSystemProperty = false;
            String string = value = !strIn.trim().equals("") ? strIn : set;
            if (input.validators != null && !input.validators.isEmpty()) {
                List<Validator.Status> validationResult;
                if (value != null && value.startsWith("${") && value.contains(":") && value.endsWith("}")) {
                    isSystemProperty = true;
                    String[] split = null;
                    testValue = value.substring(2, value.length() - 1);
                    split = testValue.split(":", 2);
                    if (split.length >= 2) {
                        systemProp = split[0];
                        testValue = split[1];
                    }
                    validation = new StringInputProcessingClient(testValue, input.validators);
                } else {
                    validation = new StringInputProcessingClient(value, input.validators);
                }
                if (variable.contains(PORT) || variable.contains("address") || variable.contains("standalone") || variable.contains("domain")) {
                    validation.setNumFields(2);
                }
                if ((validationResult = validation.validate()).contains((Object)Validator.Status.ERROR)) {
                    done = false;
                    System.out.println(UserInputPanelConsoleHelper.getTranslation(idata, VALIDATION_ERROR) + ": ");
                    for (String message : validation.getValidationMessage()) {
                        System.out.println(message);
                    }
                } else if (!validationResult.contains((Object)Validator.Status.ERROR) && validationResult.contains((Object)Validator.Status.WARNING)) {
                    System.out.println(UserInputPanelConsoleHelper.getTranslation(idata, VALIDATION_WARNING) + ": ");
                    for (String message : validation.getValidationMessage()) {
                        System.out.println(message);
                    }
                    System.out.println(UserInputPanelConsoleHelper.getTranslation(idata, "UserInputPanel.validation.warning.question"));
                }
            }
            if (downloadRequired && done && (done = (downloader = new FileDownloadManagerConsoleHelper(strIn)).getResult())) {
                idata.setVariable(variable + ".tmp", downloader.getDownloadPath());
            }
            if (done) {
                if (isSystemProperty) {
                    idata.setVariable(variable + "-1", systemProp);
                    idata.setVariable(variable + "-2", testValue);
                }
                break;
            }
            idata.setVariable(variable, value);
            this.addToSummary(input, variable, value);
            this.addToAutomated(input, variable, value);
        }
        idata.setVariable(variable, value);
        this.addToSummary(input, variable, value);
        this.addToAutomated(input, variable, value);
        return true;
    }

    boolean processComboRadioField(Input input, AutomatedInstallData idata) {
        Choice choice;
        int i;
        List<Choice> lisChoices;
        VariableSubstitutor vs = new VariableSubstitutor(idata.getVariables());
        String variable = input.strVariableName;
        if (variable == null || variable.length() == 0) {
            return false;
        }
        String currentvariablevalue = idata.getVariable(variable);
        input.iSelectedChoice = -1;
        boolean userinput = false;
        if (input.strText != null) {
            System.out.println(input.strText);
        }
        if ((lisChoices = input.listChoices).size() == 0) {
            Debug.trace("Error: no spec element defined in file field");
            return false;
        }
        if (currentvariablevalue != null && !currentvariablevalue.equals("")) {
            userinput = true;
        }
        for (i = 0; i < lisChoices.size(); ++i) {
            choice = lisChoices.get(i);
            String value = choice.strValue;
            if (userinput) {
                if (value != null && value.length() > 0 && currentvariablevalue.equals(value)) {
                    input.iSelectedChoice = i;
                }
            } else {
                String set = choice.strSet;
                if (set != null) {
                    if (set != null && !"".equals(set)) {
                        set = vs.substitute(set, null);
                    }
                    if (set.equals(TRUE)) {
                        input.iSelectedChoice = i;
                    }
                    if (currentvariablevalue == null) {
                        currentvariablevalue = input.listChoices.get((int)input.iSelectedChoice).strValue;
                    }
                }
            }
            if (input.iSelectedChoice != -1) continue;
            input.iSelectedChoice = 0;
        }
        for (i = 0; i < lisChoices.size(); ++i) {
            choice = lisChoices.get(i);
            choice.strText = vs.substitute(choice.strText);
            System.out.println(i + "  [" + (input.iSelectedChoice == i ? "x" : " ") + "] " + (choice.strText != null ? choice.strText : ""));
        }
        boolean bKeepAsking = true;
        while (bKeepAsking) {
            System.out.println(UserInputPanelConsoleHelper.getTranslation(idata, INPUT_SELECTION) + ": ");
            String strIn = AeshReadlineConsole.readLine();
            int j = -1;
            if (strIn.trim().equals("") && input.iSelectedChoice != -1) {
                bKeepAsking = false;
                continue;
            }
            try {
                j = Integer.parseInt(strIn);
            }
            catch (NumberFormatException e) {
                System.out.println(UserInputPanelConsoleHelper.getTranslation(idata, NUMBER));
            }
            if (j >= 0 && j < lisChoices.size()) {
                input.iSelectedChoice = j;
                bKeepAsking = false;
                continue;
            }
            if (j >= 0 && j < lisChoices.size()) continue;
            System.out.println(UserInputPanelConsoleHelper.getTranslation(idata, INVALID));
        }
        String newValue = input.listChoices.get((int)input.iSelectedChoice).strValue;
        idata.setVariable(variable, newValue);
        this.addToSummary(input, variable, newValue);
        this.addToAutomated(input, variable, newValue);
        if (input.revalidate && !currentvariablevalue.equals(newValue)) {
            this.erase = true;
            this.eraseTo = variable;
            throw new RevalidationTriggeredException();
        }
        return true;
    }

    public void printConfigOptions(AutomatedInstallData idata, ArrayList<Input> fieldInputs) {
        for (int k = 0; k < fieldInputs.size(); ++k) {
            Input input = fieldInputs.get(k);
            Choice choice = input.listChoices.get(0);
            if (input.condition != null && !idata.getRules().isConditionTrue(input.condition)) continue;
            System.out.println(k + 1 + "  [" + (input.iSelectedChoice == 1 ? "x" : " ") + "] " + (choice.strText != null ? choice.strText : ""));
        }
        System.out.println(UserInputPanelConsoleHelper.getTranslation(idata, CONFIRM_SELECTION));
        System.out.println(UserInputPanelConsoleHelper.getTranslation(idata, INPUT_SELECTION) + ": ");
    }

    boolean processCheckField(AutomatedInstallData idata, ArrayList<Input> fieldInputs) {
        Input input;
        int len = fieldInputs.size();
        for (int k = 0; k < len; ++k) {
            List<Choice> lisChoices;
            input = fieldInputs.get(k);
            String variable = input.strVariableName;
            if (variable == null || variable.length() == 0) {
                return false;
            }
            String currentvariablevalue = idata.getVariable(variable);
            if (currentvariablevalue == null) {
                currentvariablevalue = "";
            }
            if ((lisChoices = input.listChoices).size() == 0) {
                Debug.trace("Error: no spec element defined in check field");
                return false;
            }
            for (int i = 0; i < lisChoices.size(); ++i) {
                Choice choice = lisChoices.get(i);
                String value = choice.strValue;
                if (value != null && value.length() > 0 && currentvariablevalue.equals(value)) {
                    input.iSelectedChoice = i;
                    continue;
                }
                String set = input.strDefaultValue;
                if (set == null) continue;
                if (set != null && !"".equals(set)) {
                    VariableSubstitutor vs = new VariableSubstitutor(idata.getVariables());
                    set = vs.substitute(set, null);
                }
                if (!set.equals(TRUE)) continue;
                input.iSelectedChoice = 1;
            }
        }
        this.printConfigOptions(idata, fieldInputs);
        boolean bKeepAsking = true;
        while (bKeepAsking) {
            String strIn = AeshReadlineConsole.readLine();
            int j = -1;
            try {
                j = Integer.parseInt(strIn);
            }
            catch (NumberFormatException e) {
                System.out.println(UserInputPanelConsoleHelper.getTranslation(idata, NUMBER));
                System.out.println(UserInputPanelConsoleHelper.getTranslation(idata, CONFIRM_SELECTION));
                continue;
            }
            if (j == 0) {
                bKeepAsking = false;
                continue;
            }
            if (j < 0 || j > len || fieldInputs.get((int)(j - 1)).condition != null && !idata.getRules().isConditionTrue(fieldInputs.get((int)(j - 1)).condition)) {
                System.out.println(UserInputPanelConsoleHelper.getTranslation(idata, INVALID));
                System.out.println(UserInputPanelConsoleHelper.getTranslation(idata, CONFIRM_SELECTION));
                continue;
            }
            input = fieldInputs.get(j - 1);
            input.iSelectedChoice = (input.iSelectedChoice + 1) % 2;
            String newValue = input.listChoices.get((int)input.iSelectedChoice).strValue;
            String variable = input.strVariableName;
            idata.setVariable(variable, newValue);
            this.printConfigOptions(idata, fieldInputs);
        }
        if (idata.getVariable("jdbc.driver.install").equals("false")) {
            idata.setVariable("installDatasource", "false");
        }
        for (int k = 0; k < len; ++k) {
            input = fieldInputs.get(k);
            String newValue = input.listChoices.get((int)input.iSelectedChoice).strValue;
            String variable = input.strVariableName;
            String currentvariablevalue = idata.getVariable(variable);
            if (input.condition == null || idata.getRules().isConditionTrue(input.condition)) {
                this.addToSummary(input, variable, newValue);
                this.addToAutomated(input, variable, newValue);
            }
            if (!input.revalidate || currentvariablevalue.equals(newValue)) continue;
            this.erase = true;
            this.eraseTo = variable;
            throw new RevalidationTriggeredException();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTranslation(AutomatedInstallData idata, String id) {
        String temp = null;
        try {
            temp = idata.langpack.getString(id);
            return temp;
        }
        catch (NullPointerException e) {
            temp = null;
            return temp;
        }
        finally {
            return temp;
        }
    }

    public static String getStrText(IXMLElement field, AutomatedInstallData idata) {
        String ID = PANEL_IDENTIFIER;
        String idAttribute = field.getAttribute(PANEL_IDENTIFIER);
        if (UserInputPanelConsoleHelper.isTemplateUsed(field, idata)) {
            String[] i = idAttribute.split("\\.");
            String j = i[i.length - 2];
            if (idAttribute.endsWith(MULTICAST_PORT)) {
                return multicastTemplateText.replaceAll(regexTemplate, j);
            }
            if (idAttribute.endsWith(MULTICAST_ADDRESS)) {
                return multicastAddTemplateText.replaceAll(regexTemplate, j);
            }
            if (idAttribute.endsWith(PORT)) {
                return portTemplateText.replaceAll(regexTemplate, j);
            }
            if (idAttribute.endsWith(MULTICAST_ADDRESS_VALIDATOR)) {
                j = i[i.length - 3];
                return validatorMulticastAddressText.replaceAll(regexTemplate, j);
            }
            if (idAttribute.endsWith(MULTICAST_PORT_VALIDATOR)) {
                j = i[i.length - 3];
                return validatorMulticastPortText.replaceAll(regexTemplate, j);
            }
            if (idAttribute.endsWith(MULTICAST_PORT_RANGE_VALIDATOR)) {
                j = i[i.length - 3];
                return validatorMulticastRangeText.replaceAll(regexTemplate, j);
            }
            if (idAttribute.endsWith(ADDRESS_VALIDATOR)) {
                j = i[i.length - 3];
                return validatorVerifyAddressText.replaceAll(regexTemplate, j);
            }
            if (idAttribute.endsWith(RANGE_VALIDATOR)) {
                return validatorRangeText.replaceAll(regexTemplate, j);
            }
            if (idAttribute.equals(offsetValidator)) {
                return offsetText.replaceAll(regexTemplate, idata.getVariable(portOffsetVariable));
            }
            if (idAttribute.endsWith(VALIDATOR)) {
                return validatorPortText.replaceAll(regexTemplate, j);
            }
            j = i[i.length - 1];
            return portTemplateText.replaceAll(regexTemplate, j);
        }
        if (idAttribute == null) {
            if (field.hasAttribute(TEXT)) {
                return field.getAttribute(TEXT);
            }
            return "";
        }
        String temp = UserInputPanelConsoleHelper.getTranslation(idata, idAttribute);
        String returnValue = temp != null ? temp : (field.hasAttribute(TEXT) ? field.getAttribute(TEXT) : "");
        String SUBID = "subtitle";
        String subtitleAttribute = field.getAttribute("subtitle");
        String subtitleTemp = UserInputPanelConsoleHelper.getTranslation(idata, subtitleAttribute);
        if (subtitleTemp != null) {
            return returnValue + String.format("\n(%s)", subtitleTemp);
        }
        return returnValue;
    }

    private static boolean isTemplateUsed(IXMLElement field, AutomatedInstallData idata) {
        String TEMPLATE = "template";
        String temp = field.getAttribute("template");
        if (temp == null) {
            return false;
        }
        return Boolean.valueOf(temp);
    }

    public Input getInputFromField(IXMLElement field, AutomatedInstallData idata) {
        IXMLElement spec;
        boolean hideInConsole;
        String strVariableName = field.getAttribute(VARIABLE);
        String strFieldType = field.getAttribute(TYPE_ATTRIBUTE);
        String prompt = field.getAttribute(AUTOPROMPT);
        String summ = field.getAttribute(SUMMARIZE);
        String hideCons = field.getAttribute(HIDEINCONSOLE);
        boolean autoPrompt = prompt != null && Boolean.parseBoolean(prompt);
        boolean summarize = summ == null || Boolean.parseBoolean(summ);
        boolean bl = hideInConsole = hideCons != null && Boolean.parseBoolean(hideCons);
        if (hideInConsole) {
            return null;
        }
        if (TITLE_FIELD.equals(strFieldType)) {
            String strText = null;
            strText = UserInputPanelConsoleHelper.getStrText(field, idata);
            return new Input(strVariableName, null, null, TITLE_FIELD, strText, 0);
        }
        if (STATIC_TEXT.equals(strFieldType)) {
            String strText = null;
            strText = UserInputPanelConsoleHelper.getStrText(field, idata);
            return new Input(strVariableName, null, null, STATIC_TEXT, strText, 0);
        }
        if (TEXT_FIELD.equals(strFieldType) || FILE.equals(strFieldType) || DIR.equals(strFieldType) || FILE_DIR.equals(strFieldType) || DIR_URL.equals(strFieldType) || FILE_URL.equals(strFieldType) || AUTO_TEXT_FIELD.equals(strFieldType)) {
            ArrayList<Choice> choicesList = new ArrayList<Choice>();
            String strFieldText = null;
            String strSet = null;
            String strText = null;
            IXMLElement spec2 = field.getFirstChildNamed(SPEC);
            IXMLElement description = field.getFirstChildNamed(DESCRIPTION);
            String reval = spec2.getAttribute(REVALIDATE, "false");
            boolean revalidate = reval != null ? "yes".equals(reval) : false;
            String repPath = spec2.getAttribute(REPLACEPATH);
            boolean replacePath = repPath != null ? Boolean.parseBoolean(repPath) : false;
            String editable = field.getAttribute(EDITABLE);
            boolean canEdit = editable != null ? Boolean.parseBoolean(editable) : true;
            boolean suppressDownload = Boolean.parseBoolean(spec2.getAttribute("suppressDownload", "false"));
            if (spec2 != null) {
                strText = UserInputPanelConsoleHelper.getStrText(spec2, idata);
                strSet = spec2.getAttribute(SET);
            }
            if (description != null) {
                strFieldText = UserInputPanelConsoleHelper.getStrText(description, idata);
            }
            choicesList.add(new Choice(strText, null, strSet));
            return new Input(strVariableName, strSet, choicesList, strFieldType, strFieldText, 0, summarize, autoPrompt, revalidate, replacePath, canEdit, suppressDownload);
        }
        if (RULE_FIELD.equals(strFieldType)) {
            ArrayList<Choice> choicesList = new ArrayList<Choice>();
            String strFieldText = null;
            String strSet = null;
            String strText = null;
            IXMLElement spec3 = field.getFirstChildNamed(SPEC);
            IXMLElement description = field.getFirstChildNamed(DESCRIPTION);
            if (spec3 != null) {
                if (UserInputPanelConsoleHelper.isTemplateUsed(spec3, idata)) {
                    // empty if block
                }
                strText = UserInputPanelConsoleHelper.getStrText(spec3, idata);
                strSet = spec3.getAttribute(SET);
            }
            if (description != null) {
                strFieldText = UserInputPanelConsoleHelper.getStrText(description, idata);
            }
            if (strSet != null && spec3.getAttribute(LAYOUT) != null) {
                String token;
                StringTokenizer layoutTokenizer = new StringTokenizer(spec3.getAttribute(LAYOUT));
                List<String> listSet = Arrays.asList(new String[layoutTokenizer.countTokens()]);
                StringTokenizer setTokenizer = new StringTokenizer(strSet);
                while (setTokenizer.hasMoreTokens()) {
                    token = setTokenizer.nextToken();
                    if (token.indexOf(":") <= -1) continue;
                    listSet.set(Integer.parseInt(token.substring(0, token.indexOf(":"))), token.substring(token.indexOf(":") + 1));
                }
                int iCounter = 0;
                StringBuffer sb = new StringBuffer();
                String strRusultFormat = spec3.getAttribute(RESULT_FORMAT);
                String strSpecialSeparator = spec3.getAttribute(SPECIAL_SEPARATOR);
                while (layoutTokenizer.hasMoreTokens()) {
                    token = layoutTokenizer.nextToken();
                    if (token.matches(".*:.*:.*")) {
                        sb.append(listSet.get(iCounter) != null ? listSet.get(iCounter) : "");
                        ++iCounter;
                        continue;
                    }
                    if (SPECIAL_SEPARATOR.equals(strRusultFormat)) {
                        sb.append(strSpecialSeparator);
                        continue;
                    }
                    if (PLAIN_STRING.equals(strRusultFormat)) continue;
                    sb.append(token);
                }
                strSet = sb.toString();
            }
            choicesList.add(new Choice(strText, null, strSet));
            return new Input(strVariableName, strSet, choicesList, TEXT_FIELD, strFieldText, 0);
        }
        if (COMBO_FIELD.equals(strFieldType) || RADIO_FIELD.equals(strFieldType)) {
            ArrayList<Choice> choicesList = new ArrayList<Choice>();
            String strFieldText = null;
            int selection = -1;
            IXMLElement spec4 = field.getFirstChildNamed(SPEC);
            String reval = spec4.getAttribute(REVALIDATE, "false");
            boolean revalidate = reval != null ? "yes".equals(reval) : false;
            IXMLElement description = field.getFirstChildNamed(DESCRIPTION);
            Vector<IXMLElement> choices = null;
            if (spec4 != null) {
                choices = spec4.getChildrenNamed(CHOICE);
            }
            if (description != null) {
                strFieldText = UserInputPanelConsoleHelper.getStrText(description, idata);
            }
            for (int i = 0; i < choices.size(); ++i) {
                VariableSubstitutor vs;
                String set;
                IXMLElement choice = choices.elementAt(i);
                String processorClass = choice.getAttribute("processor");
                String conditionid = choice.getAttribute(ATTRIBUTE_CONDITIONID_NAME);
                if (conditionid != null && !idata.getRules().isConditionTrue(conditionid, idata.getVariables())) continue;
                if (processorClass != null && !"".equals(processorClass)) {
                    String choiceValues = "";
                    try {
                        choiceValues = ((Processor)Class.forName(processorClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).process(null);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    set = choice.getAttribute(SET);
                    if (set == null) {
                        set = "";
                    }
                    if (set != null && !"".equals(set)) {
                        vs = new VariableSubstitutor(idata.getVariables());
                        set = vs.substitute(set, null);
                    }
                    StringTokenizer tokenizer = new StringTokenizer(choiceValues, ":");
                    int counter = 0;
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        String choiceSet = null;
                        if (token.equals(set)) {
                            choiceSet = TRUE;
                            selection = counter;
                        }
                        choicesList.add(new Choice(token, token, choiceSet));
                        ++counter;
                    }
                    continue;
                }
                String value = choice.getAttribute(VALUE);
                set = choice.getAttribute(SET);
                if (set != null) {
                    if (set != null && !"".equals(set)) {
                        vs = new VariableSubstitutor(idata.getVariables());
                        set = vs.substitute(set, null);
                    }
                    if (set.equalsIgnoreCase(TRUE)) {
                        selection = i;
                    }
                }
                choicesList.add(new Choice(UserInputPanelConsoleHelper.getStrText(choice, idata), value, set));
            }
            if (choicesList.size() == 1) {
                selection = 0;
            }
            return new Input(strVariableName, null, choicesList, strFieldType, strFieldText, selection, revalidate, summarize, autoPrompt);
        }
        if (CHECK_FIELD.equals(strFieldType)) {
            ArrayList<Choice> choicesList = new ArrayList<Choice>();
            String strFieldText = null;
            String strSet = null;
            String strText = null;
            int iSelectedChoice = 0;
            IXMLElement spec5 = field.getFirstChildNamed(SPEC);
            String reval = spec5.getAttribute(REVALIDATE, "false");
            boolean revalidate = reval != null ? "yes".equals(reval) : false;
            IXMLElement description = field.getFirstChildNamed(DESCRIPTION);
            if (spec5 != null) {
                strText = UserInputPanelConsoleHelper.getStrText(spec5, idata);
                strSet = spec5.getAttribute(SET);
                choicesList.add(new Choice(strText, spec5.getAttribute("false"), null));
                choicesList.add(new Choice(strText, spec5.getAttribute(TRUE), null));
                if (strSet != null && strSet.equalsIgnoreCase(TRUE)) {
                    iSelectedChoice = 1;
                }
            } else {
                System.out.println("No spec specified for input of type check");
            }
            if (description != null) {
                strFieldText = UserInputPanelConsoleHelper.getStrText(description, idata);
            }
            return new Input(strVariableName, strSet, choicesList, CHECK_FIELD, strFieldText, iSelectedChoice, revalidate, summarize, autoPrompt);
        }
        if (SPACE.equals(strFieldType)) {
            return SPACE_INTPUT_FIELD;
        }
        if (DIVIDER.equals(strFieldType)) {
            return DIVIDER_INPUT_FIELD;
        }
        if (PASSWORD.equals(strFieldType)) {
            ArrayList<Choice> choicesList = new ArrayList<Choice>();
            String strFieldText = null;
            String strSet = null;
            String strText = null;
            IXMLElement spec6 = field.getFirstChildNamed(SPEC);
            if (spec6 != null) {
                Vector<IXMLElement> pwds = spec6.getChildrenNamed(PWD);
                if (pwds == null || pwds.size() == 0) {
                    System.out.println("No pwd specified in the spec for type password");
                    return null;
                }
                Input[] inputs = new Input[pwds.size()];
                for (int i = 0; i < pwds.size(); ++i) {
                    IXMLElement pwde = pwds.elementAt(i);
                    strText = UserInputPanelConsoleHelper.getStrText(pwde, idata);
                    strSet = pwde.getAttribute(SET);
                    choicesList.add(new Choice(strText, null, strSet));
                    inputs[i] = new Input(strVariableName, strSet, choicesList, strFieldType, strFieldText, 0, summarize, autoPrompt);
                }
                return new Password(strFieldType, inputs, autoPrompt, summarize);
            }
            System.out.println("No spec specified for input of type password");
            return null;
        }
        if (BUTTON.equals(strFieldType) && (spec = field.getFirstChildNamed(SPEC)) != null) {
            String questionText = spec.getAttribute(PANEL_IDENTIFIER);
            List<ValidatorContainer> validatorContainers = this.analyzeValidator(spec, idata);
            if (validatorContainers.isEmpty()) {
                System.out.println("Button field has no validators.");
                return null;
            }
            ArrayList<String> errorMessages = new ArrayList<String>();
            for (IXMLElement validatorTag : spec.getChildrenNamed(VALIDATOR)) {
                errorMessages.add(validatorTag.getAttribute(PANEL_IDENTIFIER));
            }
            String successText = spec.getAttribute("msg");
            Button button = new Button(strFieldType, questionText, successText, errorMessages);
            button.validators = validatorContainers;
            return button;
        }
        if (DYNAMIC_FIELD.equals(strFieldType)) {
            VariableSubstitutor vs = new VariableSubstitutor(idata.getVariables());
            String variable = field.getAttribute(VARIABLE);
            String componentType = field.getAttribute("componentType");
            IXMLElement spec7 = field.getFirstChildNamed(SPEC);
            String id = spec7.getAttribute(PANEL_IDENTIFIER);
            String secDomType = spec7.getAttribute("secDomainType");
            if (secDomType == null) {
                secDomType = "authen";
            }
            String addButtonText = spec7.getAttribute("addButton");
            String removeButtonText = spec7.getAttribute("removeButton");
            String redisplayText = spec7.getAttribute("redisplayText");
            String maxComponents = spec7.getAttribute("max");
            String minComponents = spec7.getAttribute("min");
            Vector<IXMLElement> providedDefaults = spec7.getChildrenNamed("default");
            ArrayList<String[]> validDefaults = new ArrayList<String[]>();
            for (IXMLElement element : providedDefaults) {
                String defaultCondition = element.getAttribute(ATTRIBUTE_CONDITIONID_NAME);
                if (defaultCondition != null && !idata.getRules().isConditionTrue(defaultCondition)) continue;
                String key = element.getAttribute("key");
                String value = element.getAttribute(VALUE);
                validDefaults.add(new String[]{vs.substitute(key), vs.substitute(value)});
            }
            DynamicComponent dynamicComponent = new DynamicComponent(strFieldType, variable, id, componentType, Integer.parseInt(minComponents), Integer.parseInt(maxComponents), validDefaults, addButtonText, removeButtonText, redisplayText, secDomType);
            dynamicComponent.validators = this.analyzeValidator(field, idata);
            return dynamicComponent;
        }
        System.out.println(strFieldType + " field collection not implemented");
        return null;
    }

    private boolean itemRequiredFor(Vector<IXMLElement> packs, AutomatedInstallData idata) {
        if (packs.size() == 0) {
            return true;
        }
        for (int i = 0; i < idata.selectedPacks.size(); ++i) {
            String selected = idata.selectedPacks.get((int)i).name;
            for (int k = 0; k < packs.size(); ++k) {
                String required = packs.elementAt(k).getAttribute(NAME, "");
                if (!selected.equals(required)) continue;
                return true;
            }
        }
        return false;
    }

    private void addToSummary(Input input, String key, String value) {
        if (input.getSummarize() && !input.getAutoPrompt()) {
            this.entriesForSummaryPanel.add(new UserInputPanel.TextValuePair(key, value));
        }
    }

    private void addToAutomated(Input input, String key, String value) {
        if (input.getAutoPrompt()) {
            this.entriesForAutomatedInstall.add(new UserInputPanel.TextValuePair(key, null));
        } else {
            if (input.getReplacePath()) {
                this.replacePathMap.add(key);
            }
            this.entriesForAutomatedInstall.add(new UserInputPanel.TextValuePair(key, value));
        }
    }

    public boolean itemRequiredForOs(Vector<IXMLElement> os) {
        if (os.size() == 0) {
            return true;
        }
        for (int i = 0; i < os.size(); ++i) {
            String family = os.elementAt(i).getAttribute(FAMILY);
            boolean match = false;
            if ("windows".equals(family)) {
                match = OsVersion.IS_WINDOWS;
            } else if ("mac".equals(family)) {
                match = OsVersion.IS_OSX;
            } else if ("unix".equals(family)) {
                match = OsVersion.IS_UNIX;
            }
            if (!match) continue;
            return true;
        }
        return false;
    }

    private String getText(IXMLElement element, AutomatedInstallData idata) {
        if (element == null) {
            return null;
        }
        String text = UserInputPanelConsoleHelper.getStrText(element, idata);
        if (text == null || text.length() == 0) {
            text = element.getAttribute(PANEL_IDENTIFIER);
        }
        if (text != null && text.length() > 0) {
            VariableSubstitutor vs = new VariableSubstitutor(idata.getVariables());
            return vs.substitute(text, null);
        }
        return text;
    }

    @Override
    public String getInstanceNumber() {
        return Integer.toString(this.instanceNumber);
    }

    public static class DynamicComponent
    extends Input {
        private String componentType;
        private int maxComponents;
        private int minComponents;
        private List<String[]> defaults;
        private String secDomType;
        private String addText;
        private String removeText;
        private String redisplayText;
        private Stack<List<String>> stack;

        public DynamicComponent(String strFieldType, String variableName, String id, String dynamicComponentType, int minComp, int maxComp, List<String[]> defaults, String addText, String removeText, String redisplayText, String secDomType) {
            super(variableName, "", null, strFieldType, id, -1, true, false, false, true, true);
            this.componentType = dynamicComponentType;
            this.maxComponents = maxComp;
            this.minComponents = minComp;
            this.defaults = defaults;
            this.secDomType = secDomType;
            this.addText = addText;
            this.removeText = removeText;
            this.redisplayText = redisplayText;
            this.stack = new Stack();
        }

        public boolean validateNumberElements() {
            return this.stack.size() >= this.minComponents && this.stack.size() <= this.maxComponents;
        }

        public void addElement(List<String> values) {
            this.stack.push(values);
            AutomatedInstallData.getInstance().setAttribute("dynamic.component.values", this.stack);
        }

        public void removeElement() {
            if (!this.stack.isEmpty() && this.stack.size() > this.defaults.size()) {
                this.stack.pop();
                AutomatedInstallData.getInstance().setAttribute("dynamic.component.values", this.stack);
            } else {
                System.out.println(AutomatedInstallData.getInstance().langpack.getString("dynamicComponents.cannot.remove.elements.console"));
            }
        }

        public void printStack() {
            if (this.stack.isEmpty()) {
                System.out.println("[ ]");
            } else {
                for (List list : this.stack) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("[ ");
                    for (String element : list) {
                        sb.append(element + ", ");
                    }
                    sb.delete(sb.length() - 2, sb.length() - 1);
                    sb.append("]");
                    System.out.println(sb.toString());
                }
            }
        }

        public boolean validate(String errorMessage) {
            String columnKey = "column";
            for (List list : this.stack) {
                for (ValidatorContainer validator : this.validators) {
                    ArrayList<ValidatorContainer> validators = new ArrayList<ValidatorContainer>();
                    validators.add(validator);
                    if (validator.getValidatorParams().containsKey(columnKey)) {
                        int column = Integer.parseInt(validator.getValidatorParams().get(columnKey));
                        StringInputProcessingClient processingClient = new StringInputProcessingClient((String)list.get(column), validators);
                        List<Validator.Status> validationResult = processingClient.validate();
                        if (validationResult.contains((Object)Validator.Status.ERROR)) {
                            System.out.println(errorMessage + ": ");
                            for (String message : processingClient.getValidationMessage()) {
                                System.out.println(message);
                            }
                            return false;
                        }
                        if (!validationResult.contains((Object)Validator.Status.WARNING)) continue;
                        System.out.println("Validation warning:");
                        for (String message : processingClient.getValidationMessage()) {
                            System.out.println(message);
                        }
                        continue;
                    }
                    MultipleFieldValidator processingClient = new MultipleFieldValidator(list, validators);
                    List<Validator.Status> validationResult = processingClient.validate();
                    if (validationResult.contains((Object)Validator.Status.ERROR)) {
                        System.out.println(errorMessage + ": ");
                        for (String message : processingClient.getValidationMessage()) {
                            System.out.println(message);
                        }
                        return false;
                    }
                    if (validationResult.contains((Object)Validator.Status.ERROR) || !validationResult.contains((Object)Validator.Status.WARNING)) continue;
                    System.out.println("Validation warning: ");
                    for (String message : processingClient.getValidationMessage()) {
                        System.out.println(message);
                    }
                }
            }
            return true;
        }

        public String getSecDomType() {
            return this.secDomType;
        }

        public String getAddText() {
            return this.addText;
        }

        public String getRemoveText() {
            return this.removeText;
        }

        public boolean isPathField() {
            return this.componentType.equals("pathField");
        }

        public boolean isSecurityDomainModule() {
            return this.componentType.equals("securityDomainModule");
        }

        public boolean isTwoTextField() {
            return this.componentType.equals("twoTextField");
        }

        public void saveValues(Properties variables, Vector<UserInputPanel.TextValuePair> entriesForAutomatedInstall) {
            for (int i = 0; i < this.stack.size(); ++i) {
                if (this.isPathField()) {
                    String key = this.generateDynamicKeyName(this.strVariableName, i + 1, "path");
                    variables.put(key, ((List)this.stack.get(i)).get(0));
                    entriesForAutomatedInstall.add(new UserInputPanel.TextValuePair(key, (String)((List)this.stack.get(i)).get(0)));
                    continue;
                }
                if (this.isTwoTextField()) {
                    String nameKey = this.generateDynamicKeyName(this.strVariableName, i + 1, UserInputPanelConsoleHelper.NAME);
                    String valueKey = this.generateDynamicKeyName(this.strVariableName, i + 1, UserInputPanelConsoleHelper.VALUE);
                    variables.put(nameKey, ((List)this.stack.get(i)).get(0));
                    variables.put(valueKey, ((List)this.stack.get(i)).get(1));
                    entriesForAutomatedInstall.add(new UserInputPanel.TextValuePair(nameKey, (String)((List)this.stack.get(i)).get(0)));
                    entriesForAutomatedInstall.add(new UserInputPanel.TextValuePair(valueKey, (String)((List)this.stack.get(i)).get(1)));
                    continue;
                }
                if (!this.isSecurityDomainModule()) continue;
                String codeKey = this.generateDynamicKeyName(this.strVariableName, i + 1, "code");
                String flagKey = this.generateDynamicKeyName(this.strVariableName, i + 1, "flag");
                String operationKey = this.generateDynamicKeyName(this.strVariableName, i + 1, "operation");
                variables.put(codeKey, ((List)this.stack.get(i)).get(0));
                variables.put(flagKey, ((List)this.stack.get(i)).get(1));
                variables.put(operationKey, ((List)this.stack.get(i)).get(2));
                entriesForAutomatedInstall.add(new UserInputPanel.TextValuePair(codeKey, (String)((List)this.stack.get(i)).get(0)));
                entriesForAutomatedInstall.add(new UserInputPanel.TextValuePair(flagKey, (String)((List)this.stack.get(i)).get(1)));
                entriesForAutomatedInstall.add(new UserInputPanel.TextValuePair(operationKey, (String)((List)this.stack.get(i)).get(2)));
            }
            String numberComponents = String.valueOf(this.stack.size());
            variables.put(this.strVariableName + "-number-dynamic-elements", numberComponents);
            entriesForAutomatedInstall.add(new UserInputPanel.TextValuePair(this.strVariableName + "-number-dynamic-elements", numberComponents));
        }

        private String generateDynamicKeyName(String variable, int num, String ending) {
            return String.format("%s-%d-%s", variable, num, ending);
        }

        public String getRedisplayText() {
            return this.redisplayText;
        }

        public int getSize() {
            return this.stack.size();
        }
    }

    public static class Button
    extends Input {
        private String successMessageId;
        private List<String> errorMessages;
        private String questionId;

        public Button(String strFieldType, String question, String successMessage, List<String> errors) {
            super(strFieldType);
            this.questionId = question;
            this.successMessageId = successMessage;
            this.errorMessages = errors;
        }

        public String getMessageId() {
            return this.successMessageId;
        }

        public List<String> getErrorMessages() {
            return this.errorMessages;
        }

        public String getQuestionId() {
            return this.questionId;
        }
    }

    public static class Password
    extends Input {
        Input[] input;

        public Password(String strFieldType, Input[] input, boolean autoPrompt, boolean summarize) {
            super(strFieldType);
            this.input = input;
            this.autoPrompt = autoPrompt;
            this.summarize = summarize;
        }
    }

    public static class Choice {
        String strText;
        String strValue;
        String strSet;

        public Choice(String strText, String strValue, String strSet) {
            this.strText = strText;
            this.strValue = strValue;
            this.strSet = strSet;
        }
    }

    public static class Input {
        String strVariableName;
        String strDefaultValue;
        List<Choice> listChoices;
        String strFieldType;
        String condition;
        String strText;
        int iSelectedChoice = -1;
        boolean revalidate;
        boolean summarize = true;
        boolean autoPrompt = false;
        boolean replacePath = false;
        boolean editable = true;
        boolean suppressDownload = false;
        public List<ValidatorContainer> validators;

        public Input(String strFieldType) {
            this.strFieldType = strFieldType;
        }

        public Input(String strVariableName, String strDefaultValue, List<Choice> listChoices, String strFieldType, String strFieldText, int iSelectedChoice, boolean summarize, boolean autoPrompt) {
            this(strVariableName, strDefaultValue, listChoices, strFieldType, strFieldText, iSelectedChoice);
            this.summarize = summarize;
            this.autoPrompt = autoPrompt;
        }

        public Input(String strVariableName, String strDefaultValue, List<Choice> listChoices, String strFieldType, String strFieldText, int iSelectedChoice, boolean summarize, boolean autoPrompt, boolean revalidate, boolean replacePath, boolean editable) {
            this(strVariableName, strDefaultValue, listChoices, strFieldType, strFieldText, iSelectedChoice);
            this.summarize = summarize;
            this.autoPrompt = autoPrompt;
            this.replacePath = replacePath;
            this.revalidate = revalidate;
            this.editable = editable;
        }

        public Input(String strVariableName, String strDefaultValue, List<Choice> listChoices, String strFieldType, String strFieldText, int iSelectedChoice) {
            this.strVariableName = strVariableName;
            this.strDefaultValue = strDefaultValue;
            this.listChoices = listChoices;
            this.strFieldType = strFieldType;
            this.strText = strFieldText;
            this.iSelectedChoice = iSelectedChoice;
        }

        public Input(String strVariableName, String strDefaultValue, List<Choice> listChoices, String strFieldType, String strFieldText, int iSelectedChoice, boolean revalidate, boolean summarize, boolean autoPrompt) {
            this(strVariableName, strDefaultValue, listChoices, strFieldType, strFieldText, iSelectedChoice, revalidate);
            this.summarize = summarize;
            this.autoPrompt = autoPrompt;
        }

        public Input(String strVariableName, String strDefaultValue, List<Choice> listChoices, String strFieldType, String strFieldText, int iSelectedChoice, boolean revalidate) {
            this(strVariableName, strDefaultValue, listChoices, strFieldType, strFieldText, iSelectedChoice);
            this.revalidate = revalidate;
        }

        public Input(String strVariableName, String strSet, List<Choice> choicesList, String strFieldType, String strFieldText, int i, boolean summarize, boolean autoPrompt, boolean revalidate, boolean replacePath, boolean canEdit, boolean suppressDownload) {
            this(strVariableName, strSet, choicesList, strFieldType, strFieldText, i, summarize, autoPrompt, revalidate, replacePath, canEdit);
            this.suppressDownload = suppressDownload;
        }

        public boolean getSummarize() {
            return this.summarize;
        }

        public boolean getAutoPrompt() {
            return this.autoPrompt;
        }

        public boolean getReplacePath() {
            return this.replacePath;
        }
    }

    private class RevalidationTriggeredException
    extends RuntimeException {
        private RevalidationTriggeredException() {
        }
    }
}

