/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.rules;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.rules.Condition;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.Debug;
import java.util.ArrayList;
import java.util.List;

public abstract class AnyArityCondition
extends Condition {
    protected List<Condition> operands;

    protected abstract String getTag();

    public AnyArityCondition() {
    }

    public AnyArityCondition(AutomatedInstallData installdata) {
        this.installdata = installdata;
    }

    public AnyArityCondition(Condition operand1, Condition operand2, AutomatedInstallData installdata) {
        this(installdata);
        ArrayList<Condition> operands = new ArrayList<Condition>();
        operands.add(operand1);
        operands.add(operand2);
        this.setConditions(operands);
    }

    protected void setConditions(List<Condition> operands) {
        this.operands = operands;
        for (Condition operand : this.operands) {
            if (operand == null) continue;
            operand.setInstalldata(this.installdata);
        }
    }

    @Override
    public void readFromXML(IXMLElement xmlcondition) {
        this.operands = new ArrayList<Condition>();
        try {
            for (int i = 0; i < xmlcondition.getChildren().size(); ++i) {
                this.operands.add(RulesEngine.analyzeCondition(xmlcondition.getChildAtIndex(i)));
            }
        }
        catch (Exception e) {
            Debug.log("missing element in condition");
        }
    }

    @Override
    public String getDependenciesDetails() {
        StringBuffer details = new StringBuffer();
        details.append(this.id);
        details.append(" depends on:<ul>");
        for (Condition condition : this.operands) {
            details.append("<li>");
            details.append(condition.getDependenciesDetails());
            details.append("</li> ").append(this.getTag()).append(" ");
        }
        details.substring(0, details.length() - this.getTag().length() + 1);
        details.append("</ul>");
        return details.toString();
    }

    @Override
    public void makeXMLData(IXMLElement root) {
        for (Condition operand : this.operands) {
            IXMLElement ele = RulesEngine.createConditionElement(operand, root);
            operand.makeXMLData(ele);
            root.addChild(ele);
        }
    }
}

