/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.rules;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.rules.Condition;
import com.izforge.izpack.util.Debug;
import java.util.HashMap;

public class CompareNumericsCondition
extends Condition {
    private static final long serialVersionUID = 5631805710151645907L;
    protected String variablename;
    protected String value;
    protected String operator;

    public CompareNumericsCondition(String variablename, String value, HashMap packstoremove) {
        this.variablename = variablename;
        this.value = value;
        this.operator = "eq";
    }

    public CompareNumericsCondition(String variablename, String value) {
        this.variablename = variablename;
        this.value = value;
        this.operator = "eq";
    }

    public CompareNumericsCondition() {
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getVariablename() {
        return this.variablename;
    }

    public void setVariablename(String variablename) {
        this.variablename = variablename;
    }

    @Override
    public void readFromXML(IXMLElement xmlcondition) {
        try {
            this.variablename = xmlcondition.getFirstChildNamed("name").getContent();
            this.value = xmlcondition.getFirstChildNamed("value").getContent();
            this.operator = xmlcondition.getFirstChildNamed("operator").getContent();
        }
        catch (Exception e) {
            Debug.log("missing element in <condition type=\"variable\"/>");
        }
    }

    @Override
    public boolean isTrue() {
        String val;
        boolean result = false;
        if (this.installdata != null && (val = this.installdata.getVariable(this.variablename)) != null) {
            if (this.operator == null) {
                this.operator = "eq";
            }
            try {
                int currentValue = new Integer(val);
                int comparisonValue = new Integer(this.value);
                if ("eq".equalsIgnoreCase(this.operator)) {
                    result = currentValue == comparisonValue;
                } else if ("gt".equalsIgnoreCase(this.operator)) {
                    result = currentValue > comparisonValue;
                } else if ("lt".equalsIgnoreCase(this.operator)) {
                    result = currentValue < comparisonValue;
                } else if ("leq".equalsIgnoreCase(this.operator)) {
                    result = currentValue <= comparisonValue;
                } else if ("geq".equalsIgnoreCase(this.operator)) {
                    result = currentValue >= comparisonValue;
                }
            }
            catch (NumberFormatException nfe) {
                Debug.log("The value of the associated variable is not a numeric value or the value which should be compared is not a number.");
            }
        }
        return result;
    }

    @Override
    public String getDependenciesDetails() {
        StringBuffer details = new StringBuffer();
        details.append(this.id);
        details.append(" depends on a value of <b>");
        details.append(this.value);
        details.append("</b> on variable <b>");
        details.append(this.variablename);
        details.append(" (current value: ");
        details.append(this.installdata.getVariable(this.variablename));
        details.append(")");
        details.append("This value has to be ").append(this.operator);
        details.append("</b><br/>");
        return details.toString();
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    @Override
    public void makeXMLData(IXMLElement conditionRoot) {
        XMLElementImpl nameXml = new XMLElementImpl("name", conditionRoot);
        nameXml.setContent(this.variablename);
        conditionRoot.addChild(nameXml);
        XMLElementImpl valueXml = new XMLElementImpl("value", conditionRoot);
        valueXml.setContent(this.value);
        conditionRoot.addChild(valueXml);
        XMLElementImpl opXml = new XMLElementImpl("op", conditionRoot);
        opXml.setContent(this.operator);
        conditionRoot.addChild(opXml);
    }
}

