/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.rules;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.rules.Condition;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.File;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class ExistsCondition
extends Condition {
    private static final long serialVersionUID = -7424383017678759732L;
    private ContentType contentType;
    private String content;

    public ExistsCondition() {
    }

    public ExistsCondition(ContentType contentType) {
        this.contentType = contentType;
    }

    @Override
    public boolean isTrue() {
        boolean result = false;
        switch (this.contentType) {
            case VARIABLE: {
                String value;
                if (this.content == null || (value = this.getInstalldata().getVariable(this.content)) == null) break;
                result = true;
                break;
            }
            case FILE: {
                VariableSubstitutor subst;
                File file;
                if (this.content == null || !(file = new File((subst = new VariableSubstitutor(this.getInstalldata().getVariables())).substitute(this.content))).exists()) break;
                result = true;
                break;
            }
            default: {
                Debug.error("Illegal content type '" + this.contentType.getAttribute() + "' of ExistsCondition");
            }
        }
        return result;
    }

    @Override
    public void readFromXML(IXMLElement xmlcondition) throws Exception {
        if (xmlcondition != null) {
            if (xmlcondition.getChildrenCount() != 1) {
                throw new Exception("Condition \"" + this.getId() + "\" needs exactly one nested element");
            }
            IXMLElement child = xmlcondition.getChildAtIndex(0);
            this.contentType = ContentType.getFromAttribute(child.getName());
            if (this.contentType == null) {
                throw new Exception("Unknown nested element '" + child.getName() + "' to condition \"" + this.getId() + "\"");
            }
            this.content = child.getContent();
            if (this.content == null || this.content.length() == 0) {
                throw new Exception("Condition \"" + this.getId() + "\" has a nested element without valid contents");
            }
        }
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    @Override
    public void makeXMLData(IXMLElement conditionRoot) {
        XMLElementImpl el = new XMLElementImpl(this.contentType.getAttribute(), conditionRoot);
        el.setContent(this.content);
        conditionRoot.addChild(el);
    }

    public static enum ContentType {
        VARIABLE("variable"),
        FILE("file");

        private static Map<String, ContentType> lookup;
        private String attribute;

        private ContentType(String attribute) {
            this.attribute = attribute;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public static ContentType getFromAttribute(String attribute) {
            if (attribute != null && lookup.containsKey(attribute)) {
                return lookup.get(attribute);
            }
            return null;
        }

        static {
            lookup = new HashMap<String, ContentType>();
            for (ContentType operation : EnumSet.allOf(ContentType.class)) {
                lookup.put(operation.getAttribute(), operation);
            }
        }
    }
}

