/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.rules;

import com.izforge.izpack.Pack;
import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.adaptator.XMLException;
import com.izforge.izpack.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.adaptator.impl.XMLWriter;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.rules.AndCondition;
import com.izforge.izpack.rules.Condition;
import com.izforge.izpack.rules.JavaCondition;
import com.izforge.izpack.rules.NotCondition;
import com.izforge.izpack.rules.OrCondition;
import com.izforge.izpack.rules.PackselectionCondition;
import com.izforge.izpack.rules.XorCondition;
import com.izforge.izpack.util.Debug;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class RulesEngine
implements Serializable {
    private static final long serialVersionUID = 3966346766966632860L;
    protected Map<String, String> panelconditions;
    protected Map<String, String> packconditions;
    protected Map<String, String> optionalpackconditions;
    protected IXMLElement conditionsspec;
    protected static Map<String, Condition> conditionsmap = new HashMap<String, Condition>();
    protected static AutomatedInstallData installdata;

    private static void loadStaticConditions() {
        RulesEngine.createBuiltinOsCondition("IS_AIX", "izpack.aixinstall");
        RulesEngine.createBuiltinOsCondition("IS_WINDOWS", "izpack.windowsinstall");
        RulesEngine.createBuiltinOsCondition("IS_WINDOWS_XP", "izpack.windowsinstall.xp");
        RulesEngine.createBuiltinOsCondition("IS_WINDOWS_2003", "izpack.windowsinstall.2003");
        RulesEngine.createBuiltinOsCondition("IS_WINDOWS_VISTA", "izpack.windowsinstall.vista");
        RulesEngine.createBuiltinOsCondition("IS_WINDOWS_7", "izpack.windowsinstall.7");
        RulesEngine.createBuiltinOsCondition("IS_LINUX", "izpack.linuxinstall");
        RulesEngine.createBuiltinOsCondition("IS_SUNOS", "izpack.solarisinstall");
        RulesEngine.createBuiltinOsCondition("IS_MAC", "izpack.macinstall");
        RulesEngine.createBuiltinOsCondition("IS_SUNOS", "izpack.solarisinstall");
        RulesEngine.createBuiltinOsCondition("IS_SUNOS_X86", "izpack.solarisinstall.x86");
        RulesEngine.createBuiltinOsCondition("IS_SUNOS_SPARC", "izpack.solarisinstall.sparc");
        RulesEngine.createBuiltinOsCondition("IS_HPUX", "izpack.hpuxinstall");
    }

    private RulesEngine() {
        conditionsmap = new Hashtable<String, Condition>();
        this.panelconditions = new Hashtable<String, String>();
        this.packconditions = new Hashtable<String, String>();
        this.optionalpackconditions = new Hashtable<String, String>();
    }

    private void init() {
        Debug.trace("RulesEngine.init()");
        RulesEngine.loadStaticConditions();
        if (installdata != null && RulesEngine.installdata.allPacks != null) {
            Debug.trace("Initializing builtin conditions for packs.");
            for (Pack pack : RulesEngine.installdata.allPacks) {
                if (pack.id == null) continue;
                PackselectionCondition packselcond = new PackselectionCondition();
                packselcond.setInstalldata(installdata);
                packselcond.id = "izpack.selected." + pack.id;
                packselcond.packid = pack.id;
                conditionsmap.put(packselcond.id, packselcond);
                Debug.trace("Pack.getCondition(): " + pack.getCondition() + " for pack " + pack.id);
                if (pack.getCondition() == null || pack.getCondition().length() <= 0) continue;
                Debug.trace("Adding pack condition " + pack.getCondition() + " for pack " + pack.id);
                this.packconditions.put(pack.id, pack.getCondition());
            }
        }
    }

    private static void createBuiltinOsCondition(String osVersionField, String conditionId) {
        JavaCondition condition = new JavaCondition();
        condition.setInstalldata(installdata);
        condition.id = conditionId;
        condition.classname = "com.izforge.izpack.util.OsVersion";
        condition.fieldname = osVersionField;
        condition.returnvalue = "true";
        condition.returnvaluetype = "boolean";
        condition.complete = true;
        conditionsmap.put(condition.id, condition);
    }

    public RulesEngine(IXMLElement conditionsspecxml, AutomatedInstallData installdata) {
        this();
        this.conditionsspec = conditionsspecxml;
        RulesEngine.installdata = installdata;
        this.readConditions();
        this.init();
    }

    public RulesEngine(Map<String, Condition> rules, AutomatedInstallData installdata) {
        this();
        Debug.trace("Initializing RulesEngine");
        RulesEngine.installdata = installdata;
        conditionsmap = rules;
        for (String key : conditionsmap.keySet()) {
            Condition condition = conditionsmap.get(key);
            condition.setInstalldata(installdata);
        }
        this.init();
    }

    public String[] getKnownConditionIds() {
        Object[] conditionids = conditionsmap.keySet().toArray(new String[conditionsmap.size()]);
        Arrays.sort(conditionids);
        return conditionids;
    }

    protected boolean checkAttribute(String val, String attribute, String element) {
        if (val != null && val.length() > 0) {
            return true;
        }
        Debug.trace("Element " + element + " has to specify an attribute " + attribute);
        return false;
    }

    public static Condition analyzeCondition(IXMLElement condition) {
        Condition result;
        block9: {
            String condid = condition.getAttribute("id");
            String condtype = condition.getAttribute("type");
            result = null;
            if (condtype != null) {
                String conditionclassname = "";
                if (condtype.indexOf(46) > -1) {
                    conditionclassname = condtype;
                } else {
                    String conditiontype = condtype.toLowerCase();
                    conditionclassname = "com.izforge.izpack.rules." + conditiontype.substring(0, 1).toUpperCase() + conditiontype.substring(1, conditiontype.length());
                    conditionclassname = conditionclassname + "Condition";
                }
                try {
                    Class<Condition> conditionClass = RulesEngine.getConditionClass(conditionclassname);
                    if (conditionClass == null) break block9;
                    result = conditionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    try {
                        result.readFromXML(condition);
                    }
                    catch (Exception e) {
                        Debug.trace(e.getStackTrace());
                    }
                    if (condid != null) {
                        result.setId(condid);
                    }
                    result.setInstalldata(installdata);
                }
                catch (InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    Debug.trace(conditionclassname + " couldn't be instantiated.");
                    Debug.trace(e.toString());
                }
                catch (IllegalAccessException e) {
                    Debug.trace("Illegal access to " + conditionclassname);
                }
            }
        }
        return result;
    }

    private static Class<Condition> getConditionClass(String conditionClassName) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<Condition> conditionclass = null;
        try {
            conditionclass = loader.loadClass(conditionClassName);
        }
        catch (ClassNotFoundException e) {
            Debug.trace(e.toString());
            Debug.trace(conditionClassName + " not found in context class loader.");
        }
        try {
            loader = RulesEngine.class.getClassLoader();
            conditionclass = loader.loadClass(conditionClassName);
        }
        catch (ClassNotFoundException e) {
            Debug.trace(conditionClassName + " not found.");
            Debug.trace(e.toString());
        }
        return conditionclass;
    }

    protected void readConditions() {
        if (this.conditionsspec == null) {
            Debug.trace("No specification for conditions found.");
            return;
        }
        try {
            if (this.conditionsspec.hasChildren()) {
                Vector<IXMLElement> childs = this.conditionsspec.getChildrenNamed("condition");
                for (IXMLElement iXMLElement : childs) {
                    Condition cond = RulesEngine.analyzeCondition(iXMLElement);
                    if (cond == null) continue;
                    String condid = cond.getId();
                    cond.setInstalldata(installdata);
                    if (condid == null || "UNKNOWN".equals(condid)) continue;
                    conditionsmap.put(condid, cond);
                }
                Vector<IXMLElement> panelconditionels = this.conditionsspec.getChildrenNamed("panelcondition");
                for (IXMLElement panelel : panelconditionels) {
                    String panelid = panelel.getAttribute("panelid");
                    String conditionid = panelel.getAttribute("conditionid");
                    this.panelconditions.put(panelid, conditionid);
                }
                Vector<IXMLElement> vector = this.conditionsspec.getChildrenNamed("packcondition");
                for (IXMLElement panelel : vector) {
                    boolean optionalinstall;
                    String panelid = panelel.getAttribute("packid");
                    String conditionid = panelel.getAttribute("conditionid");
                    this.packconditions.put(panelid, conditionid);
                    String optional = panelel.getAttribute("optional");
                    if (optional == null || !(optionalinstall = Boolean.valueOf(optional).booleanValue())) continue;
                    this.optionalpackconditions.put(panelid, conditionid);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Condition getCondition(String id) {
        Condition result = conditionsmap.get(id);
        if (result == null) {
            result = RulesEngine.getConditionByExpr(new StringBuffer(id));
        }
        return result;
    }

    protected static Condition getConditionByExpr(StringBuffer conditionexpr) {
        Condition result = null;
        block6: for (int index = 0; index < conditionexpr.length(); ++index) {
            char currentchar = conditionexpr.charAt(index);
            switch (currentchar) {
                case '+': {
                    Condition op1 = conditionsmap.get(conditionexpr.substring(0, index));
                    conditionexpr.delete(0, index + 1);
                    result = new AndCondition(op1, RulesEngine.getConditionByExpr(conditionexpr), installdata);
                    continue block6;
                }
                case '|': {
                    Condition op1 = conditionsmap.get(conditionexpr.substring(0, index));
                    conditionexpr.delete(0, index + 1);
                    result = new OrCondition(op1, RulesEngine.getConditionByExpr(conditionexpr), installdata);
                    continue block6;
                }
                case '\\': {
                    Condition op1 = conditionsmap.get(conditionexpr.substring(0, index));
                    conditionexpr.delete(0, index + 1);
                    result = new XorCondition(op1, RulesEngine.getConditionByExpr(conditionexpr), installdata);
                    continue block6;
                }
                case '!': {
                    if (index > 0) {
                        Debug.trace("error: ! operator only allowed at position 0");
                        continue block6;
                    }
                    conditionexpr.deleteCharAt(index);
                    result = new NotCondition(RulesEngine.getConditionByExpr(conditionexpr), installdata);
                    continue block6;
                }
            }
        }
        if (conditionexpr.length() > 0 && (result = conditionsmap.get(conditionexpr.toString())) != null) {
            result.setInstalldata(installdata);
            conditionexpr.delete(0, conditionexpr.length());
        }
        return result;
    }

    public boolean isConditionTrue(String id, Properties variables) {
        Condition cond = RulesEngine.getCondition(id);
        if (cond == null) {
            Debug.trace("Condition (" + id + ") not found.");
            return true;
        }
        Debug.trace("Checking condition");
        if (cond.getInstalldata() == null) {
            cond.setInstalldata(installdata);
        }
        try {
            return cond.isTrue();
        }
        catch (NullPointerException npe) {
            Debug.error("Nullpointerexception checking condition: " + id);
            return false;
        }
    }

    public boolean isConditionTrue(Condition cond, Properties variables) {
        if (cond == null) {
            Debug.trace("Condition not found.");
            return true;
        }
        Debug.trace("Checking condition");
        return cond.isTrue();
    }

    public boolean isConditionTrue(String id) {
        Condition cond = RulesEngine.getCondition(id);
        if (cond != null) {
            if (cond.getInstalldata() == null) {
                cond.setInstalldata(installdata);
            }
            Debug.trace("Checking condition.");
            return this.isConditionTrue(cond);
        }
        Debug.trace("Condition (" + id + ") not found.");
        return true;
    }

    public boolean isConditionTrue(Condition cond) {
        if (cond.getInstalldata() == null) {
            cond.setInstalldata(installdata);
        }
        return cond.isTrue();
    }

    public boolean canShowPanel(String panelid, Properties variables) {
        Debug.trace("can show panel with id " + panelid + " ?");
        if (!this.panelconditions.containsKey(panelid)) {
            Debug.trace("no condition, show panel");
            return true;
        }
        Debug.trace("there is a condition");
        Condition condition = RulesEngine.getCondition(this.panelconditions.get(panelid));
        return condition != null && condition.isTrue();
    }

    public boolean canInstallPack(String packid, Properties variables) {
        if (packid == null) {
            return true;
        }
        Debug.trace("can install pack with id " + packid + "?");
        if (!this.packconditions.containsKey(packid)) {
            Debug.trace("no condition, can install pack");
            return true;
        }
        Debug.trace("there is a condition");
        Condition condition = RulesEngine.getCondition(this.packconditions.get(packid));
        return condition != null && condition.isTrue();
    }

    public boolean canInstallPackOptional(String packid, Properties variables) {
        Debug.trace("can install pack optional with id " + packid + "?");
        if (!this.optionalpackconditions.containsKey(packid)) {
            Debug.trace("not in optionalpackconditions.");
            return false;
        }
        Debug.trace("optional install possible");
        return true;
    }

    public void addCondition(Condition condition) {
        if (condition != null) {
            if (conditionsmap.containsKey(condition.id)) {
                if (Debug.isTRACE()) {
                    Debug.error("Condition already registered.");
                }
            } else {
                conditionsmap.put(condition.id, condition);
            }
        } else {
            Debug.error("Cannot add condition. Condition was null.");
        }
    }

    public void writeRulesXML(OutputStream out) {
        XMLWriter xmlOut = new XMLWriter();
        xmlOut.setOutput(out);
        if (this.conditionsspec != null) {
            Debug.trace("Writing original conditions specification.");
            try {
                xmlOut.write(this.conditionsspec);
            }
            catch (XMLException e) {
                Debug.error("Error writing condition specification: " + e);
            }
        } else {
            XMLElementImpl conditionsel = new XMLElementImpl("conditions");
            for (Condition condition : conditionsmap.values()) {
                IXMLElement conditionEl = RulesEngine.createConditionElement(condition, conditionsel);
                condition.makeXMLData(conditionEl);
                conditionsel.addChild(conditionEl);
            }
            Debug.trace("Writing generated conditions specification.");
            try {
                xmlOut.write(conditionsel);
            }
            catch (XMLException e) {
                Debug.error("Error writing condition specification: " + e);
            }
        }
    }

    public static IXMLElement createConditionElement(Condition condition, IXMLElement root) {
        XMLElementImpl xml = new XMLElementImpl("condition", root);
        xml.setAttribute("id", condition.getId());
        xml.setAttribute("type", condition.getClass().getCanonicalName());
        return xml;
    }

    static {
        RulesEngine.loadStaticConditions();
    }
}

