/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.rules;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.rules.Condition;
import com.izforge.izpack.util.Debug;
import java.util.HashMap;

public class VariableCondition
extends Condition {
    private static final long serialVersionUID = 2881336115632480575L;
    protected String variablename;
    protected String value;

    public VariableCondition(String variablename, String value, HashMap packstoremove) {
        this.variablename = variablename;
        this.value = value;
    }

    public VariableCondition(String variablename, String value) {
        this.variablename = variablename;
        this.value = value;
    }

    public VariableCondition() {
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getVariablename() {
        return this.variablename;
    }

    public void setVariablename(String variablename) {
        this.variablename = variablename;
    }

    @Override
    public void readFromXML(IXMLElement xmlcondition) {
        try {
            this.variablename = xmlcondition.getFirstChildNamed("name").getContent();
            this.value = xmlcondition.getFirstChildNamed("value").getContent();
        }
        catch (Exception e) {
            Debug.log("missing element in <condition type=\"variable\"/>");
        }
    }

    @Override
    public boolean isTrue() {
        if (this.installdata != null) {
            String val = this.installdata.getVariable(this.variablename);
            return val != null && val.equals(this.value);
        }
        return false;
    }

    @Override
    public String getDependenciesDetails() {
        StringBuffer details = new StringBuffer();
        details.append(this.id);
        details.append(" depends on a value of <b>");
        details.append(this.value);
        details.append("</b> on variable <b>");
        details.append(this.variablename);
        details.append(" (current value: ");
        details.append(this.installdata.getVariable(this.variablename));
        details.append(")");
        details.append("</b><br/>");
        return details.toString();
    }

    @Override
    public void makeXMLData(IXMLElement conditionRoot) {
        XMLElementImpl nameEl = new XMLElementImpl("name", conditionRoot);
        nameEl.setContent(this.variablename);
        conditionRoot.addChild(nameEl);
        XMLElementImpl valueEl = new XMLElementImpl("value", conditionRoot);
        valueEl.setContent(this.value);
        conditionRoot.addChild(valueEl);
    }
}

