/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.util.Housekeeper;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.aesh.readline.ConsoleBuffer;
import org.aesh.readline.InputProcessor;
import org.aesh.readline.Prompt;
import org.aesh.readline.Readline;
import org.aesh.readline.ReadlineBuilder;
import org.aesh.readline.action.Action;
import org.aesh.readline.completion.CompleteOperation;
import org.aesh.readline.completion.Completion;
import org.aesh.readline.editing.EditMode;
import org.aesh.readline.editing.EditModeBuilder;
import org.aesh.readline.terminal.Key;
import org.aesh.readline.tty.terminal.TerminalConnection;
import org.aesh.terminal.Attributes;
import org.aesh.terminal.Connection;
import org.aesh.terminal.tty.Signal;
import org.aesh.utils.Config;
import org.aesh.utils.OSUtils;

public class AeshReadlineConsole {
    private static TerminalConnection connection;
    private static Consumer<Void> defaultCloseHandler;

    public static String readLine() {
        return AeshReadlineConsole.readConsole(new Prompt(""), Collections.emptyList());
    }

    public static String readPassword() {
        return AeshReadlineConsole.readConsole(new Prompt("", Character.valueOf('*')), Collections.emptyList());
    }

    public static char readChar() {
        String line = AeshReadlineConsole.readLine();
        return line.toLowerCase().charAt(0);
    }

    public static String readFile(boolean isOnlyDirectories) {
        ArrayList<Completion> completions = new ArrayList<Completion>();
        if (OSUtils.IS_WINDOWS) {
            completions.add(new WindowsFileCompletion(isOnlyDirectories));
        } else {
            completions.add(new UnixFileCompletion(isOnlyDirectories));
        }
        String fileLocation = AeshReadlineConsole.readConsole(new Prompt(""), completions);
        if (fileLocation.startsWith("~" + File.separator)) {
            String userHome = Paths.get(System.getProperty("user.home"), new String[0]).toString() + File.separator;
            String replaceString = OSUtils.IS_WINDOWS ? userHome.replace("\\", "\\\\") : userHome;
            return fileLocation.replaceFirst("^~", replaceString);
        }
        if (fileLocation.startsWith("~")) {
            String userHomeParent = Paths.get(System.getProperty("user.home"), new String[0]).getParent().toString() + File.separator;
            String replaceString = OSUtils.IS_WINDOWS ? userHomeParent.replace("\\", "\\\\") : userHomeParent;
            return fileLocation.replaceFirst("^~", replaceString);
        }
        return fileLocation;
    }

    public static String readLineInterruptable() throws InterruptedException {
        return AeshReadlineConsole.readLine();
    }

    private static String readConsole(Prompt prompt, List<Completion> completions) {
        String[] out = new String[1];
        try {
            AeshReadlineConsole.initializeConnection();
            Readline readline = ReadlineBuilder.builder().enableHistory(false).editMode(AeshReadlineConsole.createIzpackEditMode()).build();
            if (connection.suspended()) {
                connection.awake();
            }
            readline.readline((Connection)connection, prompt, line -> {
                out[0] = line.trim();
                connection.stopReading();
            }, completions);
            connection.openBlocking();
        }
        catch (IOException e) {
            System.out.println("Failed to read input from TerminalConnection");
            e.printStackTrace();
        }
        return out[0];
    }

    private static void initializeConnection() throws IOException {
        if (connection == null) {
            connection = new TerminalConnection();
            Consumer<Signal> sigintHandler = signal -> {
                if (signal == Signal.INT) {
                    connection.close();
                }
            };
            defaultCloseHandler = connection.getCloseHandler();
            Consumer<Void> closeHandler = signal -> {
                String abortMessage = AutomatedInstallData.getInstance().langpack.getString("console.aborted");
                connection.write(abortMessage);
                connection.write(Config.getLineSeparator());
                InstallData.getInstance().setVariable("install.aborted", "true");
                Housekeeper housekeeper = Housekeeper.getInstance();
                housekeeper.runCleanup();
                housekeeper.wipeFiles();
                housekeeper.shutDownNoCleanUp(0);
            };
            Attributes attr = connection.getAttributes();
            attr.setLocalFlag(Attributes.LocalFlag.ECHOCTL, false);
            connection.setAttributes(attr);
            connection.setSignalHandler(sigintHandler);
            connection.setCloseHandler(closeHandler);
        }
    }

    public static void closeConnection() {
        if (connection != null) {
            connection.close();
        }
    }

    public static void closeConnectionClean() {
        if (connection != null) {
            connection.setCloseHandler(defaultCloseHandler);
            AeshReadlineConsole.closeConnection();
        }
    }

    private static EditMode createIzpackEditMode() {
        EditMode izpackMode = EditModeBuilder.builder().create();
        IzPackEnter enterAction = new IzPackEnter();
        izpackMode.addAction(Key.CTRL_J, enterAction);
        izpackMode.addAction(Key.CTRL_M, enterAction);
        izpackMode.addAction(Key.ENTER, enterAction);
        izpackMode.addAction(Key.ENTER_2, enterAction);
        return izpackMode;
    }

    static abstract class FilenameCompletion
    implements Completion<CompleteOperation> {
        private boolean isOnlyDirectories;

        FilenameCompletion(boolean isOnlyDirectories) {
            this.isOnlyDirectories = isOnlyDirectories;
        }

        String translatePath(String raw) {
            String translatedInput;
            boolean isRelative;
            try {
                Path relativeTest = Paths.get(raw, new String[0]);
                isRelative = !relativeTest.isAbsolute();
            }
            catch (InvalidPathException ipe) {
                isRelative = false;
            }
            if (raw.isEmpty()) {
                translatedInput = raw;
            } else if (raw.startsWith("~" + File.separator)) {
                translatedInput = raw.replaceFirst("^~", System.getProperty("user.home"));
            } else if (raw.startsWith("~")) {
                String userName = raw.substring(1);
                String userHomeDirectory = Paths.get(Paths.get(System.getProperty("user.home"), new String[0]).getParent().toString(), userName).toString();
                translatedInput = userName.isEmpty() || raw.endsWith(File.separator) ? userHomeDirectory + File.separator : userHomeDirectory;
            } else if (isRelative) {
                String relativeDirectory = Paths.get(System.getProperty("user.dir"), raw).toString();
                translatedInput = raw.endsWith(File.separator) ? relativeDirectory + File.separator : relativeDirectory;
            } else {
                translatedInput = raw;
            }
            return translatedInput;
        }

        @Override
        public void complete(CompleteOperation completeOperation) {
            List<String> candidates;
            completeOperation.doAppendSeparator(false);
            String rawInput = completeOperation.getBuffer();
            try {
                String translatedPath = this.translatePath(rawInput);
                Path currentPath = Paths.get(translatedPath, new String[0]);
                String incompleteFilename = this.getIncompleteFilename(translatedPath);
                candidates = this.platformSpecificCandidates(currentPath, translatedPath, incompleteFilename);
                completeOperation.setOffset(rawInput.length() - incompleteFilename.length());
            }
            catch (InvalidPathException ipe) {
                candidates = new ArrayList<String>();
            }
            completeOperation.addCompletionCandidates(candidates);
        }

        abstract List<String> platformSpecificCandidates(Path var1, String var2, String var3);

        List<String> getStandardCompletions(Path currentPath, String translatedPath, String incompleteFilename) {
            List<String> candidates = new ArrayList<String>();
            if (!Files.exists(currentPath, new LinkOption[0]) && currentPath.getParent() != null) {
                candidates = translatedPath.endsWith(File.separator) ? new ArrayList() : this.getPossibleCompletions(currentPath.getParent(), incompleteFilename);
            } else if (Files.exists(currentPath, new LinkOption[0])) {
                candidates = !incompleteFilename.isEmpty() ? this.getPossibleCompletions(currentPath.getParent(), incompleteFilename) : this.getPossibleCompletions(currentPath, incompleteFilename);
            }
            return candidates;
        }

        List<String> getPossibleCompletions(Path currentPath, String incompleteFilename) {
            List<String> possibleCompletions;
            try {
                possibleCompletions = Files.list(currentPath).filter(this.isOnlyDirectories ? this.isDirectory() : path -> true).filter(this.isHiddenFile(incompleteFilename).negate()).filter(this.startsWithIncompleteFilename(incompleteFilename)).map(Path::getFileName).map(Path::toString).map(filename -> Files.isDirectory(currentPath.resolve((String)filename), new LinkOption[0]) ? filename + File.separator : filename).sorted(Comparator.comparing(String::toLowerCase)).collect(Collectors.toList());
            }
            catch (IOException e) {
                possibleCompletions = Collections.emptyList();
            }
            return possibleCompletions;
        }

        String getIncompleteFilename(String currentPath) {
            if (currentPath.endsWith(File.separator)) {
                return "";
            }
            Path temp = Paths.get(currentPath, new String[0]).getFileName();
            return temp != null ? temp.toString() : "";
        }

        boolean isFileSystemRootDirectory(Path input) {
            return input.getParent() == null && Files.isDirectory(input, new LinkOption[0]);
        }

        Predicate<Path> isDirectory() {
            return path -> Files.isDirectory(path, new LinkOption[0]);
        }

        Predicate<Path> isHiddenFile(String incompleteFilename) {
            return path -> incompleteFilename.isEmpty() && path.getFileName().toString().startsWith(".");
        }

        Predicate<Path> startsWithIncompleteFilename(String incompleteFilename) {
            return path -> path.getFileName().toString().startsWith(incompleteFilename);
        }
    }

    static class UnixFileCompletion
    extends FilenameCompletion {
        UnixFileCompletion(boolean isOnlyDirectories) {
            super(isOnlyDirectories);
        }

        @Override
        public List<String> platformSpecificCandidates(Path currentPath, String translatedPath, String incompleteFilename) {
            List<String> candidates = new ArrayList<String>();
            if (translatedPath.isEmpty()) {
                for (Path root : FileSystems.getDefault().getRootDirectories()) {
                    candidates.add(root.toString());
                }
            } else if (Files.isDirectory(currentPath, new LinkOption[0]) || currentPath.getParent() != null) {
                candidates = this.isFileSystemRootDirectory(currentPath) ? this.getPossibleCompletions(currentPath, incompleteFilename) : this.getStandardCompletions(currentPath, translatedPath, incompleteFilename);
            }
            return candidates;
        }
    }

    static class WindowsFileCompletion
    extends FilenameCompletion {
        WindowsFileCompletion(boolean isOnlyDirectories) {
            super(isOnlyDirectories);
        }

        @Override
        public List<String> platformSpecificCandidates(Path currentPath, String translatedPath, String incompleteFilename) {
            List<String> candidates = new ArrayList<String>();
            if (translatedPath.isEmpty()) {
                for (Path root : FileSystems.getDefault().getRootDirectories()) {
                    candidates.add(root.toString());
                }
            } else if (translatedPath.length() < 3) {
                for (Path root : FileSystems.getDefault().getRootDirectories()) {
                    if (!root.toString().startsWith(translatedPath)) continue;
                    candidates.add(root.toString());
                }
            } else if (Files.isDirectory(currentPath, new LinkOption[0]) || currentPath.getParent() != null) {
                candidates = this.getStandardCompletions(currentPath, translatedPath, incompleteFilename);
            }
            return candidates;
        }
    }

    static class IzPackEnter
    implements Action {
        IzPackEnter() {
        }

        @Override
        public String name() {
            return "accept-line";
        }

        @Override
        public void accept(InputProcessor inputProcessor) {
            ConsoleBuffer console = inputProcessor.buffer();
            console.undoManager().clear();
            console.moveCursor(console.buffer().length());
            inputProcessor.setReturnValue(console.buffer().multiLine());
            console.buffer().reset();
        }
    }
}

