/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.gui.ScrollPaneFactory;
import com.izforge.izpack.util.ConsoleTextArea;
import com.izforge.izpack.util.StdIn;
import com.izforge.izpack.util.StdOut;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JScrollPane;

public final class Console {
    public static final int INITIAL_WIDTH = 800;
    public static final int INITIAL_HEIGHT = 600;
    private StdOut so;
    private StdOut se;

    public static void main(String[] args) {
        Runtime rt = Runtime.getRuntime();
        Process p = null;
        try {
            p = rt.exec(args);
            new Console(p);
            System.exit(p.exitValue());
        }
        catch (IOException e) {
            System.out.println("Error starting: " + args[0]);
            System.out.println(e);
        }
    }

    public String getOutputData() {
        if (this.so != null) {
            return this.so.getData();
        }
        return "";
    }

    public String getErrorData() {
        if (this.se != null) {
            return this.se.getData();
        }
        return "";
    }

    public Console(Process p) {
        JFrame frame = new JFrame();
        frame.setTitle("Console");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation(screenSize.width / 2 - 400, screenSize.height / 2 - 300);
        ConsoleTextArea cta = new ConsoleTextArea();
        JScrollPane scroll = ScrollPaneFactory.createScroller(cta);
        scroll.setPreferredSize(new Dimension(800, 600));
        frame.getContentPane().add(scroll);
        frame.pack();
        this.so = new StdOut(p, cta);
        this.se = new StdOut(p, cta);
        StdIn si = new StdIn(p, cta);
        this.so.start();
        this.se.start();
        si.start();
        try {
            frame.setVisible(true);
            p.waitFor();
        }
        catch (InterruptedException e) {
            System.out.println("Error during execution");
            System.out.println(e);
        }
        try {
            this.so.done();
            this.se.done();
            si.done();
            this.so.join();
            this.se.join();
            si.join();
        }
        catch (InterruptedException e) {
            System.out.println("Error in StdOut, StdErr or StdIn.");
            System.out.println(e);
        }
        frame.setVisible(false);
    }
}

