/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.gui.UiResources;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;

public class CustomDefaultListCellRenderer
extends DefaultListCellRenderer {
    private Border BORDER_MOUSEOVER = BorderFactory.createMatteBorder(1, 0, 1, 0, UiResources.blueButtonStroke);

    public CustomDefaultListCellRenderer() {
        this.setOpaque(true);
    }

    @Override
    public Component getListCellRendererComponent(JList jList, Object value, int i, boolean isSelected, boolean cellHasFocus) {
        Color background;
        super.getListCellRendererComponent((JList<?>)jList, value, i, isSelected, cellHasFocus);
        if (value instanceof FileFilter) {
            this.setText(((FileFilter)value).getDescription());
        } else {
            this.setText(value.toString());
        }
        Color foreground = jList.getForeground();
        if (i == -1) {
            this.setOpaque(false);
        } else {
            this.setOpaque(true);
        }
        if (isSelected && i != -1) {
            background = UiResources.blueFocus;
            this.setBorder(this.BORDER_MOUSEOVER);
        } else {
            background = Color.WHITE;
            this.setBorder(BorderFactory.createEmptyBorder());
        }
        this.setBackground(background);
        this.setForeground(foreground);
        return this;
    }
}

