/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Validator;
import com.izforge.izpack.util.RegularExpressionValidator;
import java.util.Map;
import java.util.regex.Pattern;

public class FieldNumberRegularExpressionValidator
extends RegularExpressionValidator {
    String FIELDNUMBER_PARAM = "fieldnumber";
    int FIELDNUMBER_DEFUALT = 0;
    public static final String STR_PATTERN_DEFAULT = "[a-zA-Z0-9._-]{3,}@[a-zA-Z0-9._-]+([.][a-zA-Z0-9_-]+)*[.][a-zA-Z0-9._-]{2,4}";
    private static final String PATTERN_PARAM = "pattern";

    @Override
    public Validator.Status validate(ProcessingClient client) {
        String patternString;
        Validator.Status failureStatus = Validator.Status.ERROR;
        if (client.hasParams() && Boolean.parseBoolean(client.getValidatorParams().get("warning"))) {
            failureStatus = Validator.Status.WARNING;
        }
        if (client.hasParams()) {
            Map<String, String> paramMap = client.getValidatorParams();
            patternString = paramMap.get(PATTERN_PARAM);
        } else {
            patternString = STR_PATTERN_DEFAULT;
        }
        Pattern pattern = Pattern.compile(patternString);
        boolean validationResult = pattern.matcher(this.getString(client)).matches();
        if (!validationResult) {
            return failureStatus;
        }
        return Validator.Status.OK;
    }

    protected String getString(ProcessingClient client) {
        int fieldNumber = client.hasParams() ? Integer.parseInt(client.getValidatorParams().get(this.FIELDNUMBER_PARAM)) : this.FIELDNUMBER_DEFUALT;
        int numFields = client.getNumFields();
        String returnValue = numFields <= fieldNumber ? client.getFieldContents(fieldNumber) : client.getFieldContents(numFields - 1);
        return returnValue;
    }
}

