/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class FileDownloader
extends Thread {
    private AbstractUIProgressHandler handler;
    private boolean result = true;
    private boolean download = true;
    private String outputPath;
    private String filename;
    private AutomatedInstallData data;
    private String url;

    public FileDownloader(AbstractUIProgressHandler handler, String url) {
        this.handler = handler;
        this.data = InstallData.getInstance();
        url = url.replace('\\', '/');
        this.filename = url.substring(url.lastIndexOf("/") + 1, url.length());
        this.url = url;
        this.getValidFilename(0);
    }

    public boolean getResult() {
        return this.result;
    }

    public String getPath() {
        return this.outputPath;
    }

    private void getValidFilename(int i) {
        String potentialPath;
        File tmp;
        String affix = "";
        if (i != 0) {
            affix = Integer.toString(i);
        }
        if (!(tmp = new File(potentialPath = this.data.getInstallPath() + File.separator + this.filename + affix)).exists()) {
            this.filename = this.filename + affix;
            this.outputPath = potentialPath;
        } else {
            this.getValidFilename(i + 1);
        }
    }

    public boolean isDownloading() {
        return this.download;
    }

    public void stopDownload() {
        this.result = false;
        this.download = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            int bytesRead;
            if (!this.download) {
                return;
            }
            URLConnection conn = new URL(this.url).openConnection();
            InputStream inputStream = conn.getInputStream();
            int len = conn.getContentLength();
            FileOutputStream outputStream = new FileOutputStream(this.outputPath);
            int BUFFER_SIZE = 4096;
            byte[] buffer = new byte[BUFFER_SIZE];
            long totalBytesRead = 0L;
            this.handler.startAction(this.data.langpack.getString("filedownloader.preparing"), 100);
            while ((bytesRead = inputStream.read(buffer)) != -1 && this.download) {
                outputStream.write(buffer, 0, bytesRead);
                int percentCompleted = (int)((double)(totalBytesRead += (long)bytesRead) * 100.0 / (double)len);
                this.handler.progress(percentCompleted, String.format(this.data.langpack.getString("filedownloader.download.progress"), percentCompleted));
            }
            outputStream.close();
            inputStream.close();
        }
        catch (Exception e) {
            this.handler.emitError(this.data.langpack.getString("filedownloader.error"), String.format(this.data.langpack.getString("filedownloader.error.writing"), this.filename));
            this.result = false;
        }
        finally {
            this.handler.stopAction();
            this.download = false;
            FileDownloader fileDownloader = this;
            synchronized (fileDownloader) {
                this.notifyAll();
            }
            if (new File(this.outputPath).exists()) {
                this.data.addTmpFile(this.outputPath);
            }
        }
    }
}

