/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.ErrorIzpackPathException;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.WarningIzpackPathException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class FileUtil {
    static ArrayList getFileContent(String fileName) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        File aFile = new File(fileName);
        if (!aFile.isFile()) {
            return result;
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(aFile));
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
            return result;
        }
        String aLine = null;
        while ((aLine = reader.readLine()) != null) {
            result.add(aLine + "\n");
        }
        reader.close();
        return result;
    }

    static boolean fileContains(String aFileName, String aSearchString) {
        return FileUtil.fileContains(aFileName, aSearchString, false);
    }

    static boolean fileContains(String aFileName, String aSearchString, boolean caseInSensitiveSearch) {
        boolean result = false;
        String searchString = caseInSensitiveSearch ? aSearchString.toLowerCase() : aSearchString;
        ArrayList fileContent = new ArrayList();
        try {
            fileContent = FileUtil.getFileContent(aFileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (Object aFileContent : fileContent) {
            String currentline = (String)aFileContent;
            if (caseInSensitiveSearch) {
                currentline = currentline.toLowerCase();
            }
            if (!currentline.contains(searchString)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static long getFileDateTime(URL url) {
        if (url == null) {
            return -1L;
        }
        String fileName = url.getFile();
        if (fileName.charAt(0) == '/' || fileName.charAt(0) == '\\') {
            fileName = fileName.substring(1, fileName.length());
        }
        try {
            File file = new File(fileName);
            if (!file.isDirectory() && !file.isFile()) {
                return -1L;
            }
            return file.lastModified();
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public static String[] getFileNames(String dirPath) throws Exception {
        return FileUtil.getFileNames(dirPath, null);
    }

    static String[] getFileNames(String dirPath, FilenameFilter fileNameFilter) throws Exception {
        String[] fileNames = null;
        File dir = new File(dirPath);
        if (dir.isDirectory()) {
            fileNames = fileNameFilter != null ? dir.list(fileNameFilter) : dir.list();
        }
        return fileNames;
    }

    public static boolean isPathValid(String dirPath) throws WarningIzpackPathException, ErrorIzpackPathException {
        AbstractPathValidator validator = OsVersion.IS_WINDOWS ? new WindowsPathValidator(dirPath) : new UnixPathValidator(dirPath);
        return validator.isValidPath();
    }

    public static boolean isPathValidOffset(String dirPath, int absoluteOffset) throws WarningIzpackPathException, ErrorIzpackPathException {
        AbstractPathValidator validator = OsVersion.IS_WINDOWS ? new WindowsPathValidator(dirPath) : new UnixPathValidator(dirPath);
        validator.setAbsoluteOffset(absoluteOffset);
        return validator.isValidPath();
    }

    static class UnixPathValidator
    extends AbstractPathValidator {
        String[] invalidChars = new String[]{"\\0", "//", ";", "\\", "\"", "  ", "?", "%", ":"};

        UnixPathValidator(String path) {
            super(path);
            this.softAbsoluteLength = 4095;
            this.maxAbsoluteLength = 4095;
        }

        @Override
        protected boolean noReservedNames() {
            return true;
        }

        @Override
        protected String[] getInvalidChars() {
            return this.invalidChars;
        }

        @Override
        protected boolean noInvalidPathCharacters() throws ErrorIzpackPathException {
            for (String character : this.getInvalidChars()) {
                int index = this.pathToValidate.indexOf(character);
                if (index == -1) continue;
                throw new ErrorIzpackPathException(this.pathToValidate, String.format(this.idata.langpack.getString("UserInputPanel.file.invalidfile.message"), String.format(this.idata.langpack.getString("TargetPanel.invalid"), this.invalidCharString())));
            }
            Paths.get(this.pathToValidate, new String[0]);
            return true;
        }
    }

    static class WindowsPathValidator
    extends AbstractPathValidator {
        String[] reservedNames = new String[]{"CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"};
        String[] invalidChars = new String[]{"<", ">", ":", "\"", "/", "\\\\", "|", "?", "*", "\\ ", "  ", "%"};

        WindowsPathValidator(String path) {
            super(path);
            this.softAbsoluteLength = 259;
            this.maxAbsoluteLength = 32760;
        }

        @Override
        protected boolean noReservedNames() {
            for (String name : this.reservedNames) {
                for (String pathPart : this.pathToValidate.split(Pattern.quote(File.separator))) {
                    if (!pathPart.equalsIgnoreCase(name)) continue;
                    throw new ErrorIzpackPathException(this.pathToValidate, String.format(this.idata.langpack.getString("UserInputPanel.file.invalidfile.message"), String.format(this.idata.langpack.getString("pathvalidator.reserved.name.error"), name)));
                }
            }
            return true;
        }

        @Override
        protected String[] getInvalidChars() {
            return this.invalidChars;
        }

        @Override
        protected boolean noInvalidPathCharacters() throws ErrorIzpackPathException {
            for (String character : this.getInvalidChars()) {
                int index = this.pathToValidate.substring(2).indexOf(character);
                if (index == -1) continue;
                throw new ErrorIzpackPathException(this.pathToValidate, String.format(this.idata.langpack.getString("UserInputPanel.file.invalidfile.message"), String.format(this.idata.langpack.getString("TargetPanel.invalid"), this.invalidCharString())));
            }
            Paths.get(this.pathToValidate, new String[0]);
            return true;
        }
    }

    static abstract class AbstractPathValidator {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        String pathToValidate;
        int maxFileNameLength = 255;
        int softAbsoluteLength;
        int maxAbsoluteLength;
        int absoluteOffset = 0;

        AbstractPathValidator(String path) {
            this.pathToValidate = path;
        }

        boolean isValidPath() throws ErrorIzpackPathException, WarningIzpackPathException {
            return this.validAbsolutePathLength() && this.validFileNameLength() && this.noReservedNames() && this.noInvalidPathCharacters();
        }

        protected abstract boolean noReservedNames();

        protected abstract String[] getInvalidChars();

        private void setAbsoluteOffset(int offset) {
            this.absoluteOffset = offset;
        }

        private boolean validAbsolutePathLength() throws ErrorIzpackPathException, WarningIzpackPathException {
            boolean hasOffset;
            String error = this.idata.langpack.getString("UserInputPanel.file.invalidfile.message");
            String warningContinue = this.idata.langpack.getString("installer.warning") + ": %s " + this.idata.langpack.getString("usermsg.continue") + "?";
            boolean bl = hasOffset = this.absoluteOffset != 0;
            if (hasOffset) {
                if (this.pathToValidate.length() > this.maxAbsoluteLength - this.absoluteOffset) {
                    throw new ErrorIzpackPathException(this.pathToValidate.substring(0, 40) + "...", String.format(error, String.format(this.idata.langpack.getString("pathvalidator.precomputed.absolute.length.error"), this.maxAbsoluteLength - this.absoluteOffset)));
                }
                if (this.pathToValidate.length() > this.softAbsoluteLength - this.absoluteOffset) {
                    throw new WarningIzpackPathException(this.pathToValidate.substring(0, 40) + "...", String.format(warningContinue, String.format(this.idata.langpack.getString("pathvalidator.precomputed.absolute.length.warning"), this.softAbsoluteLength - this.absoluteOffset)));
                }
            } else {
                if (this.pathToValidate.length() > this.maxAbsoluteLength) {
                    throw new ErrorIzpackPathException(this.pathToValidate.substring(0, 40) + "...", String.format(error, String.format(this.idata.langpack.getString("pathvalidator.absolute.length.error"), this.maxAbsoluteLength)));
                }
                if (this.pathToValidate.length() > this.softAbsoluteLength) {
                    throw new WarningIzpackPathException(this.pathToValidate.substring(0, 40) + "...", String.format(warningContinue, String.format(this.idata.langpack.getString("pathvalidator.absolute.length.warning"), this.softAbsoluteLength)));
                }
            }
            return true;
        }

        private boolean validFileNameLength() throws ErrorIzpackPathException {
            String[] pathComponents;
            for (String component : pathComponents = this.pathToValidate.split(Pattern.quote(File.separator))) {
                if (component.length() <= this.maxFileNameLength) continue;
                throw new ErrorIzpackPathException(this.pathToValidate.substring(0, 40) + "...", String.format(this.idata.langpack.getString("UserInputPanel.file.invalidfile.message"), String.format(this.idata.langpack.getString("pathvalidator.filename.length.error"), this.maxFileNameLength)));
            }
            return true;
        }

        String invalidCharString() {
            return Arrays.stream(this.getInvalidChars()).filter(c -> !"  ".equals(c)).distinct().map(c -> "\"" + c + "\"").collect(Collectors.joining(", "));
        }

        protected abstract boolean noInvalidPathCharacters() throws ErrorIzpackPathException;
    }
}

