/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;

public class GUIHelper {
    private static GridBagConstraints titleConstraints;
    private static GridBagConstraints contentPanelConstraints;
    private static GridBagConstraints infoLabelConstraints;

    public static Border createIzPackBorder() {
        MatteBorder matte = BorderFactory.createMatteBorder(1, 1, 1, 1, Color.gray);
        MatteBorder matte2 = BorderFactory.createMatteBorder(0, 0, 1, 1, Color.white);
        CompoundBorder border = BorderFactory.createCompoundBorder(matte2, matte);
        return border;
    }

    public static JPanel createMainPanel(boolean isOpaque) {
        JPanel panel = new JPanel();
        panel.setOpaque(isOpaque);
        GridBagLayout gbl = new GridBagLayout();
        gbl.columnWeights = new double[]{1.0};
        gbl.rowWeights = new double[]{0.0, 0.0, 1.0};
        panel.setLayout(gbl);
        return panel;
    }

    public static JScrollPane createPanelScroller(Border border, JPanel panel, boolean isOpaque) {
        JScrollPane scroller = new JScrollPane(panel, 20, 31);
        scroller.setViewportBorder(border);
        scroller.getVerticalScrollBar().setBorder(border);
        scroller.getViewport().setOpaque(isOpaque);
        scroller.setOpaque(isOpaque);
        System.out.println("Increment: " + scroller.getVerticalScrollBar().getUnitIncrement());
        return scroller;
    }

    public static GridBagConstraints getTitleConstraints() {
        if (titleConstraints == null) {
            titleConstraints = new GridBagConstraints();
            GUIHelper.titleConstraints.insets = new Insets(0, 0, 0, 80);
            GUIHelper.titleConstraints.fill = 2;
            GUIHelper.titleConstraints.anchor = 12;
            GUIHelper.titleConstraints.gridx = 0;
            GUIHelper.titleConstraints.gridy = 0;
        }
        return titleConstraints;
    }

    public static GridBagConstraints getInfoConstraints() {
        if (infoLabelConstraints == null) {
            infoLabelConstraints = new GridBagConstraints();
            GUIHelper.infoLabelConstraints.anchor = 18;
            GUIHelper.infoLabelConstraints.insets = new Insets(0, 80, 0, 80);
            GUIHelper.infoLabelConstraints.fill = 2;
            GUIHelper.infoLabelConstraints.gridx = 0;
            GUIHelper.infoLabelConstraints.gridy = 1;
        }
        return infoLabelConstraints;
    }

    public static GridBagConstraints getContentPanelConstraints() {
        if (contentPanelConstraints == null) {
            contentPanelConstraints = new GridBagConstraints();
            GUIHelper.contentPanelConstraints.insets = new Insets(0, 80, 0, 80);
            GUIHelper.contentPanelConstraints.fill = 1;
            GUIHelper.contentPanelConstraints.gridx = 0;
            GUIHelper.contentPanelConstraints.gridy = 2;
        }
        return contentPanelConstraints;
    }

    public static JPanel getRightAlignedPanel(boolean isOpaque) {
        JPanel panel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{1.0, 0.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panel.setLayout(gridBagLayout);
        panel.setOpaque(isOpaque);
        return panel;
    }
}

