/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Validator;
import java.net.InetAddress;
import java.net.ServerSocket;

public class HostAddressValidator
implements Validator {
    @Override
    public Validator.Status validate(ProcessingClient client) {
        Validator.Status failureStatus = Validator.Status.ERROR;
        if (client.hasParams() && Boolean.parseBoolean(client.getValidatorParams().get("warning"))) {
            failureStatus = Validator.Status.WARNING;
        }
        InetAddress inet = null;
        String host = "";
        int port = 0;
        boolean validationResult = false;
        try {
            host = client.getFieldContents(0);
            port = Integer.parseInt(client.getFieldContents(1));
        }
        catch (Exception e) {
            return failureStatus;
        }
        try {
            inet = InetAddress.getByName(host);
            ServerSocket socket = new ServerSocket(port, 0, inet);
            validationResult = socket.getLocalPort() > 0;
            socket.close();
        }
        catch (Exception ex) {
            validationResult = false;
        }
        if (!validationResult) {
            return failureStatus;
        }
        return Validator.Status.OK;
    }
}

