/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.installer.Unpacker;
import com.izforge.izpack.util.CleanupClient;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.Librarian;
import java.io.File;
import java.util.Collections;
import java.util.Vector;

public class Housekeeper {
    private static Housekeeper me = null;
    private Vector<CleanupClient> cleanupClients = new Vector();
    private Vector<CleanupClient> librarianClients = new Vector();

    private Housekeeper() {
    }

    public static Housekeeper getInstance() {
        if (me == null) {
            me = new Housekeeper();
        }
        return me;
    }

    public void registerForCleanup(CleanupClient client) {
        if (client instanceof Librarian) {
            this.librarianClients.add(0, client);
        } else {
            this.cleanupClients.add(client);
        }
    }

    public void runCleanup() {
        this.runClients(this.cleanupClients);
    }

    private void runClients(Vector<CleanupClient> clients) {
        for (int i = clients.size() - 1; i >= 0; --i) {
            try {
                clients.elementAt(i).cleanUp();
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void wipeFiles() {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        UninstallData udata = UninstallData.getInstance();
        if (!Unpacker.interruptAll(40000L)) {
            return;
        }
        udata.getInstalledFilesList().add(idata.getInstallPath() + "/uninstaller");
        Collections.sort(udata.getInstalledFilesList(), Collections.reverseOrder());
        for (String p : udata.getInstalledFilesList()) {
            try {
                File f = new File(p);
                if (f.delete()) continue;
                Debug.log("Cannot delete " + p);
            }
            catch (SecurityException e) {
                Debug.log(p + " not deleted: " + e.getMessage());
            }
        }
    }

    public void shutDown(int exitCode) {
        this.shutDownNoConsole(exitCode);
    }

    public void shutDownNoConsole(int exitCode) {
        Debug.log("Running cleanup Jobs.");
        this.runClients(this.cleanupClients);
        Debug.log("Running Librarian Cleanup");
        this.runClients(this.librarianClients);
        Debug.log("Shutting Down");
        System.exit(exitCode);
    }

    public void shutDownNoCleanUp(int exitCode) {
        Debug.log("Running Librarian Cleanup");
        this.runClients(this.librarianClients);
        Debug.log("Shutting Down");
        System.exit(exitCode);
    }
}

