/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;

public class JavaProcess {
    private JavaProcess() {
    }

    public static int forkJvm(Path jar, List<String> newJvmArgs, String[] passedArgs) {
        String javaHome = System.getProperty("java.home");
        String javaBin = Paths.get(javaHome, "bin", "java").toString();
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command().add(javaBin);
        builder.command().addAll(newJvmArgs);
        builder.command().add("-jar");
        builder.command().add(jar.toString());
        builder.command().addAll(Arrays.asList(passedArgs));
        builder.inheritIO();
        int retVal = 1;
        try {
            retVal = builder.start().waitFor();
        }
        catch (InterruptedException ie) {
            return 1;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return retVal;
    }
}

