/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.panels.PasswordGroup;
import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Validator;
import com.izforge.izpack.util.Debug;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;

public class PasswordEncryptionValidator
implements Validator {
    private Cipher encryptCipher;

    @Override
    public Validator.Status validate(ProcessingClient client) {
        Validator.Status failureStatus = Validator.Status.ERROR;
        boolean validationResult = true;
        String encryptedPassword = null;
        String key = null;
        String algorithm = null;
        Map params = this.getParams(client);
        if (Boolean.parseBoolean((String)params.get("warning"))) {
            failureStatus = Validator.Status.WARNING;
        }
        try {
            key = (String)params.get("encryptionKey");
            algorithm = (String)params.get("algorithm");
            if (key != null && algorithm != null) {
                this.initialize(key, algorithm);
                encryptedPassword = this.encryptString(client.getFieldContents(0));
                if (encryptedPassword != null) {
                    PasswordGroup group = (PasswordGroup)client;
                    group.setModifiedPassword(encryptedPassword);
                } else {
                    validationResult = false;
                }
            }
        }
        catch (Exception e) {
            Debug.trace("Password Encryption Failed: " + e);
            validationResult = false;
        }
        if (!validationResult) {
            return failureStatus;
        }
        return Validator.Status.OK;
    }

    private Map getParams(ProcessingClient client) {
        PasswordGroup group = null;
        Map<String, String> params = null;
        try {
            group = (PasswordGroup)client;
            if (group.hasParams()) {
                params = group.getValidatorParams();
            }
        }
        catch (Exception e) {
            Debug.trace("getParams() Failed: " + e);
        }
        return params;
    }

    private void initialize(String key, String algorithm) throws Exception {
        try {
            KeyGenerator keygen = KeyGenerator.getInstance(algorithm);
            keygen.init(new SecureRandom(key.getBytes()));
            byte[] keyBytes = keygen.generateKey().getEncoded();
            SecretKeySpec specKey = new SecretKeySpec(keyBytes, algorithm);
            this.encryptCipher = Cipher.getInstance(algorithm);
            this.encryptCipher.init(1, specKey);
        }
        catch (Exception e) {
            Debug.trace("Error initializing password encryption " + e.getMessage());
            throw e;
        }
    }

    public String encryptString(String string) throws Exception {
        String result = null;
        try {
            byte[] cryptedbytes = null;
            cryptedbytes = this.encryptCipher.doFinal(string.getBytes("UTF-8"));
            result = Base64.getEncoder().encodeToString(cryptedbytes);
        }
        catch (Exception e) {
            Debug.trace("Error encrypting string: " + e.getMessage());
            throw e;
        }
        return result;
    }
}

