/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Validator;
import java.net.InetAddress;
import java.net.ServerSocket;

public class PortValidator
implements Validator {
    @Override
    public Validator.Status validate(ProcessingClient client) {
        InetAddress inet = null;
        String host = "localhost";
        int numfields = client.getNumFields();
        boolean validationResult = true;
        Validator.Status failureStatus = Validator.Status.ERROR;
        if (client.hasParams() && Boolean.parseBoolean(client.getValidatorParams().get("warning"))) {
            failureStatus = Validator.Status.WARNING;
        }
        for (int i = 0; i < numfields; ++i) {
            String value = client.getFieldContents(i);
            if (value == null || value.length() == 0) {
                return failureStatus;
            }
            try {
                inet = InetAddress.getByName(host);
                ServerSocket socket = new ServerSocket(Integer.parseInt(value), 0, inet);
                boolean bl = validationResult = socket.getLocalPort() > 0;
                if (!validationResult) break;
                socket.close();
                continue;
            }
            catch (Exception ex) {
                validationResult = false;
            }
        }
        if (!validationResult) {
            return failureStatus;
        }
        return Validator.Status.OK;
    }
}

