/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import java.io.File;
import java.io.FilenameFilter;

public class PrefixFileFilter
implements FilenameFilter {
    private String prefix;
    private boolean onlyDirectories;

    public PrefixFileFilter(String prefix, boolean onlyDirectories) {
        this.prefix = prefix;
        this.onlyDirectories = onlyDirectories;
    }

    @Override
    public boolean accept(File dir, String name) {
        File fullPath = new File(dir.getAbsolutePath() + System.getProperty("file.separator") + name);
        if (this.onlyDirectories && !fullPath.isDirectory()) {
            return false;
        }
        if (this.prefix.isEmpty() && name.startsWith(".")) {
            return false;
        }
        return name.startsWith(this.prefix);
    }
}

