/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.panels.PasswordGroup;
import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Validator;
import java.util.Map;
import java.util.regex.Pattern;

public class RegularExpressionValidator
implements Validator {
    public static final String STR_PATTERN_DEFAULT = "[a-zA-Z0-9._-]{3,}@[a-zA-Z0-9._-]+([.][a-zA-Z0-9_-]+)*[.][a-zA-Z0-9._-]{2,4}";
    private static final String PATTERN_PARAM = "pattern";

    @Override
    public Validator.Status validate(ProcessingClient client) {
        String patternString;
        Validator.Status failureStatus = Validator.Status.ERROR;
        if (client.hasParams()) {
            Map<String, String> paramMap = client.getValidatorParams();
            patternString = paramMap.get(PATTERN_PARAM);
            if (Boolean.parseBoolean(paramMap.get("warning"))) {
                failureStatus = Validator.Status.WARNING;
            }
        } else {
            patternString = STR_PATTERN_DEFAULT;
        }
        Pattern pattern = Pattern.compile(patternString);
        boolean validationResult = pattern.matcher(this.getString(client)).matches();
        if (!validationResult) {
            return failureStatus;
        }
        return Validator.Status.OK;
    }

    private String getString(ProcessingClient client) {
        int numFields;
        String returnValue = "";
        returnValue = client instanceof PasswordGroup ? ((numFields = client.getNumFields()) > 0 ? client.getFieldContents(0) : client.getText()) : client.getText();
        return returnValue;
    }
}

