/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.util.ConsoleTextArea;
import com.izforge.izpack.util.ConsoleWrite;
import java.io.InputStreamReader;
import javax.swing.SwingUtilities;

class StdOut
extends Thread {
    private InputStreamReader output;
    private boolean processRunning;
    private ConsoleTextArea cta;
    private StringBuffer data;

    public StdOut(Process p, ConsoleTextArea cta) {
        this.setDaemon(true);
        this.output = new InputStreamReader(p.getInputStream());
        this.cta = cta;
        this.processRunning = true;
        this.data = new StringBuffer();
    }

    @Override
    public void run() {
        try {
            while (this.output.ready() || this.processRunning) {
                char[] array;
                int num;
                if (!this.output.ready() || (num = this.output.read(array = new char[255])) == -1) continue;
                String s = new String(array, 0, num);
                this.data.append(s);
                SwingUtilities.invokeAndWait(new ConsoleWrite(this.cta, s));
            }
        }
        catch (Exception e) {
            System.err.println("Problem writing to standard output.");
            System.err.println(e);
        }
    }

    public void done() {
        this.processRunning = false;
    }

    public String getData() {
        return this.data.toString();
    }
}

