/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import java.io.File;
import java.util.ArrayList;

public class StringTool {
    public static void main(String[] args) {
        System.out.println("Test: string.replace(abc$defg,$de ,null ):" + StringTool.replace("abc$defg", "$de", null, true));
    }

    public static String replace(String value, String from, String to) {
        return StringTool.replace(value, from, to, true);
    }

    public static String replace(String value, String from, String to, boolean aCaseSensitiveFlag) {
        if (value == null || value.length() == 0 || from == null || from.length() == 0) {
            return value;
        }
        if (to == null) {
            to = "";
        }
        if (!aCaseSensitiveFlag) {
            from = from.toLowerCase();
        }
        String result = value;
        int lastIndex = 0;
        int index = value.indexOf(from);
        if (index != -1) {
            StringBuffer buffer = new StringBuffer();
            while (index != -1) {
                buffer.append(value.substring(lastIndex, index)).append(to);
                lastIndex = index + from.length();
                index = value.indexOf(from, lastIndex);
            }
            buffer.append(value.substring(lastIndex));
            result = buffer.toString();
        }
        return result;
    }

    public static String escapeSpaces(String aPathString) {
        return StringTool.replaceOrEscapeAll(aPathString, null, null, true);
    }

    public static String replaceSpacesWithMinus(String aPathString) {
        return StringTool.replaceSpaces(aPathString, "-");
    }

    public static String replaceSpaces(String aPathString, String replaceWith) {
        return StringTool.replaceOrEscapeAll(aPathString, replaceWith, null, false);
    }

    public static String replaceOrEscapeAll(String aPathString, String replaceOrEscapeWith, String[] replaceWhat, boolean escape) {
        if (replaceWhat == null) {
            replaceWhat = new String[]{" ", "\t", "\n"};
        }
        if (replaceOrEscapeWith == null) {
            replaceOrEscapeWith = "\\";
        }
        for (int i = 0; i < replaceWhat.length; ++i) {
            aPathString = StringTool.replace(aPathString, replaceWhat[i], escape ? replaceOrEscapeWith + replaceWhat[i] : replaceOrEscapeWith);
        }
        return aPathString;
    }

    public static String normalizePath(String destination, String fileSeparator) {
        String FILESEP = fileSeparator == null ? File.separator : fileSeparator;
        destination = StringTool.replace(destination, "\\", "/");
        destination = StringTool.replace(destination, "//", "/");
        destination = StringTool.replace(destination, ":", ";");
        destination = StringTool.replace(destination, ";", ":");
        destination = StringTool.replace(destination, "/", FILESEP);
        if ("\\".equals(FILESEP)) {
            destination = StringTool.replace(destination, ":", ";");
            destination = StringTool.replace(destination, ";\\", ":\\");
        }
        return destination;
    }

    public static String normalizePath(String destination) {
        return StringTool.normalizePath(destination, null);
    }

    public static String stringArrayToSpaceSeparatedString(String[] args) {
        String result = "";
        for (String arg : args) {
            result = result + arg + " ";
        }
        return result;
    }

    public static String getPlatformEncoding() {
        return System.getProperty("file.encoding");
    }

    public static String UTF16() {
        return "UTF-16";
    }

    public static String stringArrayListToString(ArrayList aStringList) {
        return StringTool.stringArrayListToString(aStringList, null);
    }

    public static String stringArrayListToString(ArrayList aStringList, String aLineSeparator) {
        String LineSeparator = aLineSeparator;
        if (LineSeparator == null) {
            LineSeparator = System.getProperty("line.separator", "\n");
        }
        StringBuffer temp = new StringBuffer();
        for (Object anAStringList : aStringList) {
            temp.append(anAStringList).append(LineSeparator);
        }
        return temp.toString();
    }

    public static boolean startsWith(String str, String prefix) {
        return str != null && str.startsWith(prefix);
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        return str != null && prefix != null && str.toUpperCase().startsWith(prefix.toUpperCase());
    }

    public static String removeHTML(String source) {
        String result = "";
        try {
            result = source.replaceAll("\r", " ");
            result = result.replaceAll("\t", "");
            result = result.replaceAll("( )+", " ");
            result = result.replaceAll("<( )*head([^>])*>", "<head>");
            result = result.replaceAll("(<( )*(/)( )*head( )*>)", "</head>");
            result = result.replaceAll("(<head>).*(</head>)", "");
            result = result.replaceAll("<( )*script([^>])*>", "<script>");
            result = result.replaceAll("(<( )*(/)( )*script( )*>)", "</script>");
            result = result.replaceAll("(<script>).*(</script>)", "");
            result = result.replaceAll("<( )*style([^>])*>", "<style>");
            result = result.replaceAll("(<( )*(/)( )*style( )*>)", "</style>");
            result = result.replaceAll("(<style>).*(</style>)", "");
            result = result.replaceAll("<( )*td([^>])*>", "\t");
            result = result.replaceAll("<( )*br( )*>", "\r");
            result = result.replaceAll("<( )*li( )*>", "\r");
            result = result.replaceAll("<( )*div([^>])*>", "\r\r");
            result = result.replaceAll("<( )*tr([^>])*>", "\r\r");
            result = result.replaceAll("(<) h (\\w+) >", "\r");
            result = result.replaceAll("(\\b) (</) h (\\w+) (>) (\\b)", "");
            result = result.replaceAll("<( )*p([^>])*>", "\r\r");
            result = result.replaceAll("<[^>]*>", "");
            result = result.replaceAll("&bull;", " * ");
            result = result.replaceAll("&lsaquo;", "<");
            result = result.replaceAll("&rsaquo;", ">");
            result = result.replaceAll("&trade;", "(tm)");
            result = result.replaceAll("&#8482", "(tm)");
            result = result.replaceAll("&frasl;", "/");
            result = result.replaceAll("&lt;", "<");
            result = result.replaceAll("&gt;", ">");
            result = result.replaceAll("&copy;", "(c)");
            result = result.replaceAll("&reg;", "(r)");
            result = result.replaceAll("&(.{2,6});", "");
            result = result.replaceAll("(\r)( )+(\r)", "\r\r");
            result = result.replaceAll("(\t)( )+(\t)", "\t\t");
            result = result.replaceAll("(\t)( )+(\r)", "\t\r");
            result = result.replaceAll("(\r)( )+(\t)", "\r\t");
            result = result.replaceAll("(\r)(\t)+(\\r)", "\r\r");
            result = result.replaceAll("(\r)(\t)+", "\r\t");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String formatForNewLine(String str) {
        int nextIndex = 0;
        int currentIndex = 0;
        String newline = System.getProperty("line.separator", "\n");
        StringBuffer buffer = new StringBuffer();
        do {
            if ((nextIndex = str.indexOf("\\n", currentIndex)) > -1) {
                buffer.append(str.substring(currentIndex, nextIndex));
                buffer.append(newline);
                currentIndex = nextIndex + 2;
                continue;
            }
            buffer.append(str.substring(currentIndex, str.length()));
            buffer.append(newline);
        } while (nextIndex > -1);
        return buffer.toString();
    }
}

