/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.gui.FontResources;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.PanelConsole;
import com.izforge.izpack.installer.PanelConsoleHelper;
import com.izforge.izpack.panels.SummaryPanel;
import com.izforge.izpack.rules.RulesEngine;
import java.util.Iterator;

public class SummaryProcessor {
    private static String HTML_HEADER;
    private static String HTML_FOOTER;
    private static String BODY_START;
    private static String BODY_END;
    private static String HEAD_START;
    private static String HEAD_END;

    public static String getPanelSummary(AutomatedInstallData idata, boolean userShown) {
        Iterator<Object> iter;
        boolean isHeadless = false;
        boolean clearBuff = false;
        if (idata.panels != null && idata.panels.size() > 0) {
            iter = idata.panels.iterator();
        } else {
            iter = idata.consoles.iterator();
            isHeadless = true;
        }
        StringBuffer sb = new StringBuffer(2048);
        sb.append(HTML_HEADER);
        if (!userShown) {
            sb.append(HEAD_START).append("Application version:").append(HEAD_END);
            sb.append(BODY_START).append(idata.getVariable("APP_VER")).append(BODY_END);
        }
        while (iter.hasNext()) {
            String caption = null;
            String msg = null;
            if (isHeadless) {
                AutomatedInstallData.ConsoleInfo iNext = (AutomatedInstallData.ConsoleInfo)iter.next();
                if (iNext != null) {
                    String strCondition;
                    PanelConsole panel = iNext.console;
                    if (!iNext.panel.isInSummaryPanel()) continue;
                    if (panel instanceof PanelConsoleHelper && ((strCondition = iNext.panel.getCondition()) == null || idata.getRules().isConditionTrue(strCondition))) {
                        caption = ((PanelConsoleHelper)((Object)panel)).getSummaryCaption(idata);
                        msg = ((PanelConsoleHelper)((Object)panel)).getSummaryBody(idata);
                    }
                }
            } else {
                IzPanel panel = (IzPanel)iter.next();
                RulesEngine rules = idata.getRules();
                if (!panel.isInSummaryPanel() || panel.getMetadata().hasCondition() && !rules.isConditionTrue(panel.getMetadata().getCondition())) continue;
                caption = panel.getSummaryCaption();
                msg = !panel.getView() ? panel.getSummaryBody() : null;
            }
            if (caption == null || msg == null) continue;
            if (clearBuff) {
                sb.setLength(0);
                sb.append(HTML_HEADER);
                clearBuff = false;
            }
            sb.append(HEAD_START).append(caption).append(HEAD_END);
            sb.append(BODY_START).append(msg).append(BODY_END);
        }
        sb.append(HTML_FOOTER);
        return sb.toString();
    }

    public static String getSummary(AutomatedInstallData idata, boolean userShown) {
        Iterator<Object> iter;
        boolean isHeadless = false;
        boolean clearBuff = false;
        if (idata.panels != null && idata.panels.size() > 0) {
            iter = idata.panels.iterator();
        } else {
            iter = idata.consoles.iterator();
            isHeadless = true;
        }
        StringBuffer sb = new StringBuffer(2048);
        sb.append(HTML_HEADER);
        if (!userShown) {
            sb.append(HEAD_START).append("Application version:").append(HEAD_END);
            sb.append(BODY_START).append(idata.getVariable("APP_VER")).append(BODY_END);
        }
        while (iter.hasNext()) {
            String caption = null;
            String msg = null;
            if (isHeadless) {
                String strCondition;
                PanelConsole panel;
                AutomatedInstallData.ConsoleInfo iNext = (AutomatedInstallData.ConsoleInfo)iter.next();
                if (iNext != null && (panel = iNext.console) instanceof PanelConsoleHelper && ((strCondition = iNext.panel.getCondition()) == null || idata.getRules().isConditionTrue(strCondition))) {
                    caption = ((PanelConsoleHelper)((Object)panel)).getSummaryCaption(idata);
                    msg = ((PanelConsoleHelper)((Object)panel)).getSummaryBody(idata);
                }
            } else {
                IzPanel panel = (IzPanel)iter.next();
                if (panel instanceof SummaryPanel) {
                    clearBuff = true;
                    continue;
                }
                caption = panel.getSummaryCaption();
                msg = panel.getSummaryBody();
            }
            if (caption == null || msg == null) continue;
            if (clearBuff) {
                sb.setLength(0);
                sb.append(HTML_HEADER);
                clearBuff = false;
            }
            sb.append(HEAD_START).append(caption).append(HEAD_END);
            sb.append(BODY_START).append(msg).append(BODY_END);
        }
        sb.append(HTML_FOOTER);
        return sb.toString();
    }

    static {
        HTML_FOOTER = "</body>\n</html>\n";
        BODY_START = "<div class=\"body\">";
        BODY_END = "</div>";
        HEAD_START = "<h1>";
        HEAD_END = "</h1>\n";
        StringBuffer sb = new StringBuffer(256);
        String bodyFontName = FontResources.getOpenSansRegular().getFamily();
        String h1FontName = FontResources.getOpenSansLight().getFamily();
        int bodyFontSize = FontResources.getOpenSansRegular().getSize();
        int h1FontSize = FontResources.getOpenSansLight().getSize() - 5;
        sb.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n").append("<html>\n<meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\"><head>\n<STYLE TYPE=\"text/css\" media=screen,print>\n").append(String.format("h1{\n font: %spt %s;\n margin: 1em 0 0 0;\n  padding: 0;\n }", h1FontSize, h1FontName)).append(String.format("div.body{\n font: %spt %s;\n margin: 0mm 2mm 0  8mm;\n  padding: 0;\n }", bodyFontSize, bodyFontName)).append("</STYLE>\n</head>\n<body>\n");
        HTML_HEADER = sb.toString();
    }
}

