/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.action;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.PanelAction;
import com.izforge.izpack.installer.PanelActionConfiguration;
import com.izforge.izpack.util.AbstractUIHandler;
import com.redhat.installer.asconfiguration.jdbc.constant.JBossJDBCConstants;

public class DatabaseLoggingDefaultsAction
implements PanelAction {
    private AutomatedInstallData idata;

    @Override
    public void executeAction(AutomatedInstallData idata, AbstractUIHandler handler) {
        this.idata = idata;
        this.setDefaultH2Url();
        if (this.isJdbcInstalled()) {
            this.resetUsernamePassword();
            this.resetComboBox();
            this.setSpecificJdbcUrl();
        }
    }

    private void setSpecificJdbcUrl() {
        String subProtocol;
        String jdbcDriverName = this.idata.getVariable("jdbc.driver.name");
        String existingUrl = this.idata.getVariable("dblogging.url");
        String string = subProtocol = jdbcDriverName.equals("ibmdb2") ? "db2" : jdbcDriverName;
        if (existingUrl == null || !existingUrl.startsWith("jdbc:" + subProtocol)) {
            String finalUrl = JBossJDBCConstants.connUrlMap.get(jdbcDriverName);
            this.idata.setVariable("dblogging.url", finalUrl);
        }
    }

    private void resetComboBox() {
        String defaultDriver = this.idata.getVariable("dblogging.driver.jdbc.default");
        this.idata.setVariable("dblogging.driver", defaultDriver);
    }

    private void resetUsernamePassword() {
        String defaultH2Password = this.idata.getVariable("dblogging.h2.password.default");
        String existingPassword = this.idata.getVariable("dblogging.password");
        String defaultJDBCUserName = this.idata.getVariable("dblogging.jdbc.username.default");
        this.idata.setVariable("dblogging.username", defaultJDBCUserName);
        if (existingPassword == null || existingPassword.equals(defaultH2Password)) {
            this.idata.setVariable("dblogging.password", "");
        }
    }

    private void setDefaultH2Url() {
        String defaultUrl = this.idata.getVariable("dblogging.url.default");
        this.idata.setVariable("dblogging.url", defaultUrl);
    }

    private boolean isJdbcInstalled() {
        String driverChoice = this.idata.getVariable("jdbc.driver.install");
        return driverChoice != null && Boolean.parseBoolean(driverChoice);
    }

    @Override
    public void initialize(PanelActionConfiguration configuration) {
    }
}

