/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.action;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.PanelAction;
import com.izforge.izpack.installer.PanelActionConfiguration;
import com.izforge.izpack.util.AbstractUIHandler;

public class PostInstallDefaultReset
implements PanelAction {
    private static final String[] postInstallVars = new String[]{"installVault", "installSsl", "installLdap", "installInfinispan", "installSecurityDomain", "jdbc.driver.install", "datasource.install", "installQuickStarts", "installQuickstarts", "installLogging", "installPorts", "jsf.install"};
    private static final String[] vaultVariableStrings = new String[]{"vault.keystoreloc", "vault.encrdir", "vault.itercount", "vault.alias", "vault.salt", "vault.keystorepwd"};
    private static boolean loadVaultDefault = true;
    private static boolean loadVaultBackup = false;
    private AutomatedInstallData idata;

    @Override
    public void executeAction(AutomatedInstallData idata, AbstractUIHandler handler) {
        this.idata = idata;
        if (this.isAutoInstall()) {
            return;
        }
        if (!this.isAdvancedConfigSelected()) {
            this.setAdvancedConfigVariables(false);
        }
        if (this.isInstallJdbc()) {
            if (this.requiresDefaultDatabase()) {
                this.unsetDatabaseUsernamePassword();
            }
        } else {
            this.setJdbcVariablesToH2();
            if (this.requiresDefaultDatabase()) {
                this.setDatabaseVariableDefaults();
            }
        }
        if (this.vaultExists()) {
            this.setVaultDefaults();
        }
        if (this.isInstallDbLogging() && this.isProductName("dv")) {
            this.setDatabaseLoggingDefaults();
        }
    }

    private void setVaultDefaults() {
        if (this.isLoadDefaultVault()) {
            this.backupVaultVariables();
            this.loadDefaultVault();
        } else if (this.isLoadBackupVault()) {
            this.restoreBackedUpVault();
        }
    }

    private void loadDefaultVault() {
        for (String vaultVariable : vaultVariableStrings) {
            this.idata.setVariable(vaultVariable, this.idata.getVariable(vaultVariable + ".default"));
        }
    }

    private void unsetDatabaseUsernamePassword() {
        this.idata.getVariables().remove("db.user");
        this.idata.getVariables().remove("db.password");
    }

    private boolean vaultExists() {
        return this.idata.getVariable("installVault") != null;
    }

    private boolean isLoadDefaultVault() {
        return !this.isInstallVault() && this.requiresDefaultVault() && loadVaultDefault;
    }

    private boolean isInstallVault() {
        String installVault = this.idata.getVariable("installVault");
        return Boolean.parseBoolean(installVault);
    }

    private boolean isLoadBackupVault() {
        return this.isInstallVault() && this.requiresDefaultVault() && loadVaultBackup;
    }

    private void backupVaultVariables() {
        for (String vaultString : vaultVariableStrings) {
            if (this.idata.getVariable(vaultString) == null) {
                this.idata.setVariable(vaultString + ".backup", "");
                continue;
            }
            this.idata.setVariable(vaultString + ".backup", this.idata.getVariable(vaultString));
        }
        loadVaultBackup = true;
        loadVaultDefault = false;
    }

    private void restoreBackedUpVault() {
        if (this.idata.getVariable("vault.keystorepwd") != null) {
            this.idata.setVariable("vault.keystorepwd.default", this.idata.getVariable("vault.keystorepwd"));
        }
        for (String vaultString : vaultVariableStrings) {
            if (this.idata.getVariable(vaultString + ".backup") == null) continue;
            this.idata.setVariable(vaultString, this.idata.getVariable(vaultString + ".backup"));
        }
        loadVaultDefault = true;
        loadVaultBackup = false;
    }

    private void setDatabaseLoggingDefaults() {
        String defaultH2UserName = this.idata.getVariable("dblogging.h2.username.default");
        String defaultH2Password = this.idata.getVariable("dblogging.h2.password.default");
        String defaultUrl = this.idata.getVariable("dblogging.url.default");
        String defaultDriver = this.idata.getVariable("dblogging.driver.default");
        this.idata.setVariable("dblogging.driver", defaultDriver);
        this.idata.setVariable("dblogging.url", defaultUrl);
        this.idata.setVariable("dblogging.username", defaultH2UserName);
        this.idata.setVariable("dblogging.password", defaultH2Password);
    }

    private boolean isInstallDbLogging() {
        String dbLoggingOption = this.idata.getVariable("postinstall.dblogging.enabled");
        return dbLoggingOption != null && Boolean.parseBoolean(dbLoggingOption);
    }

    private void setDatabaseVariableDefaults() {
        this.idata.setVariable("db.url", this.idata.getVariable("db.default.url"));
        this.idata.setVariable("db.user", this.idata.getVariable("db.default.user"));
        this.idata.setVariable("db.password", this.idata.getVariable("db.default.password"));
    }

    private void setJdbcVariablesToH2() {
        this.idata.setVariable("jdbc.driver.name", "h2");
        this.idata.setVariable("db.dialect", "H2Dialect");
        this.idata.setVariable("db.driver", "h2");
    }

    private boolean isInstallJdbc() {
        String driverInstall = this.idata.getVariable("jdbc.driver.install");
        return driverInstall != null && Boolean.parseBoolean(driverInstall);
    }

    private boolean isInstallSsl() {
        return this.idata.getVariables().containsKey("installSsl") && this.idata.getVariable("installSsl").equalsIgnoreCase("true");
    }

    private boolean isProductName(String productName) {
        return this.idata.getVariable("product.name").equalsIgnoreCase(productName);
    }

    private void setAdvancedConfigVariables(boolean value) {
        for (String option : postInstallVars) {
            this.idata.setVariable(option, Boolean.toString(value));
        }
    }

    private boolean isAdvancedConfigSelected() {
        String radioButtonState = this.idata.getVariable("postinstallServer");
        return radioButtonState != null && Boolean.parseBoolean(radioButtonState);
    }

    private boolean isAutoInstall() {
        return this.idata.getVariable("installerMode").equals("AUTO");
    }

    public boolean requiresDefaultDatabase() {
        return Boolean.parseBoolean(this.idata.getVariable("requires.default.database"));
    }

    public boolean requiresDefaultVault() {
        return Boolean.parseBoolean(this.idata.getVariable("requires.vault.defaults.reset"));
    }

    @Override
    public void initialize(PanelActionConfiguration configuration) {
    }
}

