/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.ascontroller;

import com.izforge.izpack.event.SimpleInstallerListener;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.CleanupClient;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.Housekeeper;
import com.redhat.installer.installation.processpanel.ProcessPanelHelper;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandContextFactory;
import org.jboss.as.cli.CommandLineException;

public abstract class EmbeddedController
extends SimpleInstallerListener
implements CleanupClient {
    private static AutomatedInstallData idata;
    private static AbstractUIProcessHandler mHandler;
    private static boolean isSlave;

    public boolean run(AbstractUIProcessHandler handler, String[] args) {
        System.setProperty("jboss.domain.master.address", "127.0.0.1");
        isSlave = false;
        mHandler = handler;
        idata = AutomatedInstallData.getInstance();
        CommandContext embeddedServer = (CommandContext)idata.getAttribute(this.getServerVariable());
        if (args.length == 0 && embeddedServer == null) {
            return false;
        }
        if (embeddedServer == null) {
            if (args[0].equals("host-slave.xml")) {
                isSlave = true;
            }
            return this.startEmbeddedServer(args[0]);
        }
        return this.stopEmbeddedServer(embeddedServer);
    }

    private boolean stopEmbeddedServer(CommandContext embeddedServer) {
        try {
            embeddedServer.handle(this.getShutdownCommand());
        }
        catch (CommandLineException e) {
            Debug.log(e);
            return false;
        }
        ProcessPanelHelper.printToPanel(mHandler, EmbeddedController.idata.langpack.getString("EmbeddedController.shutdown"), false);
        idata.setAttribute(this.getServerVariable(), null);
        return true;
    }

    private boolean startEmbeddedServer(String descriptor) {
        CommandContext cc;
        try {
            cc = CommandContextFactory.getInstance().newCommandContext();
            cc.setSilent(true);
            cc.handle(String.format(this.getStartCommand(), idata.getInstallPath(), descriptor));
        }
        catch (CommandLineException e) {
            Debug.log(e);
            ProcessPanelHelper.printStackTraceToPanel(mHandler, e);
            return false;
        }
        ProcessPanelHelper.printToPanel(mHandler, String.format(EmbeddedController.idata.langpack.getString("EmbeddedController.success"), descriptor), false);
        idata.setAttribute(this.getServerVariable(), cc);
        return true;
    }

    @Override
    public void beforePacks(AutomatedInstallData idata, Integer x, AbstractUIProgressHandler handler) throws Exception {
        Debug.log("Registering EmbeddedController for Cleanup.");
        Housekeeper.getInstance().registerForCleanup(this);
    }

    @Override
    public void cleanUp() {
        CommandContext cc = (CommandContext)idata.getAttribute(this.getServerVariable());
        if (cc != null) {
            try {
                this.stopEmbeddedServer(cc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isSlave() {
        return isSlave;
    }

    public abstract String getServerVariable();

    public abstract String getStartCommand();

    public abstract String getShutdownCommand();

    static {
        isSlave = false;
    }
}

