/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.ascontroller;

import com.redhat.installer.asconfiguration.ports.utils.PortUtils;
import com.redhat.installer.ports.utils.PortOffset;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.as.security.vault.VaultSession;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EmbeddedServerCommands {
    private final String[] validAuthenticationCodes = new String[]{"Client", "org.jboss.security.ClientLoginModule", "Certificate", "org.jboss.security.auth.spi.BaseCertLoginModule", "CertificateUsers", "org.jboss.security.auth.spi.BaseCertLoginModule", "CertificateRoles", "org.jboss.security.auth.spi.CertRolesLoginModule", "Database", "org.jboss.security.auth.spi.DatabaseServerLoginModule", "DatabaseCertificate", "org.jboss.security.auth.spi.DatabaseCertLoginModule", "DatabaseUsers", "org.jboss.security.auth.spi.DatabaseServerLoginModule", "Identity", "org.jboss.security.auth.spi.IdentityLoginModule", "Ldap", "org.jboss.security.auth.spi.LdapLoginModule", "LdapExtended", "org.jboss.security.auth.spi.LdapExtLoginModule", "RoleMapping", "org.jboss.security.auth.spi.RoleMappingLoginModule", "RunAs", "org.jboss.security.auth.spi.RunAsLoginModule", "Simple", "org.jboss.security.auth.spi.SimpleServerLoginModule", "ConfiguredIdentity", "org.picketbox.datasource.security.ConfiguredIdentityLoginModule", "SecureIdentity", "org.picketbox.datasource.security.SecureIdentityLoginModule", "PropertiesUsers", "org.jboss.security.auth.spi.PropertiesUsersLoginModule", "SimpleUsers", "org.jboss.security.auth.spi.SimpleUsersLoginModule", "LdapUsers", "org.jboss.security.auth.spi.LdapUsersLoginModule", "Kerberos", "com.sun.security.auth.module.K5b5LoginModule", "SPNEGOUsers", "org.jboss.security.negotiation.spnego.SPNEGOLoginModule", "AdvancedLdap", "org.jboss.security.negotiation.AdvancedLdapLoginModule", "AdvancedADLdap", "org.jboss.security.negotiation.AdvancedADLoginModule", "UsersRoles", "org.jboss.security.auth.spi.UsersRolesLoginModule"};
    private final String[] validAuthorizationCodes = new String[]{"DenyAll", "org.jboss.security.authorization.modules.AllDenyAuthorizationModule", "PermitAll", "org.jboss.security.authorization.modules.AllPermitAuthorizationModule", "Delegating", "org.jboss.security.authorization.modules.DelegatingAuthorizationModule", "Web", "org.jboss.security.authorization.modules.WebAuthorizationModule", "JACC", "org.jboss.security.authorization.modules.JACCAuthorizationModule", "XACML", "org.jboss.security.authorization.modules.XACMLAuthorizationModule"};
    private final String[] validMappingCodes = new String[]{"PropertiesRoles", "org.jboss.security.mapping.providers.role.PropertiesRolesMappingProvider", "SimpleRoles", "org.jboss.security.mapping.providers.role.SimpleRolesMappingProvider", "DeploymentRoles", "org.jboss.security.mapping.providers.DeploymentRolesMappingProvider", "DatabaseRoles", "org.jboss.security.mapping.providers.role.DatabaseRolesMappingProvider", "LdapRoles", "org.jboss.security.mapping.providers.role.LdapRolesMappingProvider"};
    private final String[] validFlags = new String[]{"Required", "Requisite", "Sufficient", "Optional"};
    private final String[] validTypes = new String[]{"principal", "credential", "role", "attribute"};
    private static final String DOMAIN_CMD_PREFIX = "/host=%s";
    private static VaultSession vault = null;
    private String keystore;
    private String alias;
    private String encrDir;
    private String salt;
    private int iterations;
    private CommandContext cc;
    private boolean isDomain;
    private boolean isSlave;
    private String[] domainProfiles = new String[]{"default", "full", "full-ha", "ha"};
    private static String domainHostname;
    private String logPath = null;
    private Logger logger;

    public void setLogger(Logger logger2) {
        this.logger = logger2;
    }

    public boolean isDomain() {
        return this.isDomain;
    }

    public void setIsDomain(boolean set) {
        this.isDomain = set;
    }

    public void setCommandContext(CommandContext context) {
        this.cc = context;
    }

    public void createNewBatch() {
        this.cc.getBatchManager().activateNewBatch();
    }

    public void storeCurrentBatch(String name) {
        this.cc.getBatchManager().holdbackActiveBatch(name);
    }

    public void activateStoredBatch(String name) {
        this.cc.getBatchManager().activateHeldbackBatch(name);
    }

    public void setResolveParameterValues(boolean resolve) {
        this.cc.setResolveParameterValues(resolve);
    }

    public boolean hasVault() {
        return vault != null;
    }

    public VaultSession getVaultSession() {
        return vault;
    }

    public void setLogFilePath(String path) {
        this.logPath = new File(path).getAbsolutePath();
    }

    public void closeLogHandlers() {
        if (this.logger != null) {
            this.logger.info("Finished commands from: " + this.logger.getName());
            for (Handler h : this.logger.getHandlers()) {
                h.close();
                this.logger.removeHandler(h);
                this.logger = null;
            }
        }
    }

    public String getLogPath() {
        return this.logPath;
    }

    public void createVaultSession(String keystore, String keystorePwd, String encrDir, String salt, int iterations, String alias) throws Throwable {
        this.keystore = keystore;
        this.encrDir = encrDir;
        this.salt = salt;
        this.iterations = iterations;
        this.alias = alias;
        if (!encrDir.endsWith(File.separator)) {
            encrDir = encrDir + File.separator;
        }
        if (!this.hasVault()) {
            vault = new VaultSession(keystore, keystorePwd, encrDir, salt, iterations, true);
            vault.startVaultSession(alias);
        }
    }

    public boolean installVault() {
        if (!this.hasVault()) {
            return false;
        }
        String masked = vault.getKeystoreMaskedPassword();
        String command = "/core-service=vault:add(vault-options=[(\"KEYSTORE_URL\" => \"" + this.keystore.replaceAll("\\\\", "/") + "\"), (\"KEYSTORE_PASSWORD\" => \"" + masked + "\"), (\"KEYSTORE_ALIAS\" => \"" + this.alias + "\"), (\"SALT\" => \"" + this.salt + "\"), (\"ITERATION_COUNT\" => \"" + this.iterations + "\"), (\"ENC_FILE_DIR\" => \"" + this.encrDir.replaceAll("\\\\", "/") + "\")])";
        return this.executeCommand(command);
    }

    public boolean installVault(String keystore, String encrDir) {
        if (!this.hasVault()) {
            return false;
        }
        String masked = vault.getKeystoreMaskedPassword();
        String command = "/core-service=vault:add(vault-options=[(\"KEYSTORE_URL\" => \"" + keystore.replaceAll("\\\\", "/") + "\"), (\"KEYSTORE_PASSWORD\" => \"" + masked + "\"), (\"KEYSTORE_ALIAS\" => \"" + this.alias + "\"), (\"SALT\" => \"" + this.salt + "\"), (\"ITERATION_COUNT\" => \"" + this.iterations + "\"), (\"ENC_FILE_DIR\" => \"" + encrDir.replaceAll("\\\\", "/") + "\")])";
        return this.executeCommand(command);
    }

    public boolean addSystemProperty(String propertyName, String propertyValue) {
        String checkProperty = "/system-property=" + propertyName + ":read-attribute(name=value)";
        boolean exists = this.cc.getExitCode() == 0;
        String command = "/system-property=" + propertyName + ":add(value=" + propertyValue + ")";
        if (!exists) {
            return this.executeCommand(command);
        }
        return true;
    }

    private ModelNode getServerConfigList() {
        ModelNode result = null;
        try {
            result = this.cc.getModelControllerClient().execute(this.cc.buildRequest("/host=master:read-children-names(child-type=server-config)"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CommandFormatException e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean addPropertyToIndividualServer(String serverConfig, String propertyName, String propertyValue, boolean bootTime) {
        if (this.isDomain) {
            ModelNode check = this.getServerConfigList();
            for (ModelNode c : check.get("result").asList()) {
                String command;
                if (!c.asString().equals(serverConfig) || this.executeCommand(command = "/host=master/server-config=" + serverConfig + "/system-property=" + propertyName + ":add(value=" + propertyValue + ",boot-time=" + bootTime)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean deployArtifact(String artifactPath) {
        String command = this.isDomain ? "deploy " + artifactPath + " --all-server-groups" : "deploy " + artifactPath;
        return this.executeCommand(command);
    }

    public String maskPassword(String block, String attribute, String password) {
        String masked = "";
        if (vault != null) {
            try {
                masked = "${" + vault.addSecuredAttribute(block, attribute, password.toCharArray()) + "}";
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return masked;
    }

    public String maskPasswordPlain(String block, String attribute, String password) {
        String masked = "";
        if (vault != null) {
            try {
                masked = vault.addSecuredAttribute(block, attribute, password.toCharArray());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return masked;
    }

    public boolean installSslCustom(String keystore, String password, String realmName, String block, String attribute) {
        String sslCommand;
        if (this.hasVault()) {
            password = this.maskPassword(block, attribute, password);
        }
        if (!this.executeCommand(sslCommand = "/core-service=management/security-realm=" + realmName + "/server-identity=ssl:add(keystore-path=\"" + keystore.replaceAll("\\\\", "/") + "\",keystore-password=\"" + password + "\")")) {
            return false;
        }
        String trustStore = "/core-service=management/security-realm=" + realmName + "/authentication=truststore:add(keystore-path=\"" + keystore.replaceAll("\\\\", "/") + "\",keystore-password=\"" + password + "\")";
        return this.executeCommand(trustStore);
    }

    public boolean installSsl(String keystore, String password, String realmName) {
        return this.installSslCustom(keystore, password, realmName, "ssl", "password");
    }

    public boolean addHttps(String realm, String httpsPort) {
        if (this.isDomain || httpsPort != null && !httpsPort.isEmpty()) {
            return this.setUpDomain(realm, httpsPort);
        }
        return this.setUpStandalone(realm);
    }

    public boolean runCommandsInList(List<String> commands) {
        boolean result = true;
        for (String cmd : commands) {
            result = result && this.executeCommand(cmd);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createModuleXml(String basePath, String modulePath, String moduleName, List<String> resourceNames, List<String> dependencyNames) throws ParserConfigurationException, TransformerException, IOException {
        File module = new File(basePath, modulePath + File.separator + "module.xml");
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element root = doc.createElement("module");
        Attr xmlns = doc.createAttribute("xmlns");
        Attr modName = doc.createAttribute("name");
        xmlns.setValue("urn:jboss:module:1.0");
        modName.setValue(moduleName);
        root.setAttributeNode(xmlns);
        root.setAttributeNode(modName);
        doc.appendChild(root);
        Element resources = doc.createElement("resources");
        root.appendChild(resources);
        for (String string : resourceNames) {
            Element resourceRoot = doc.createElement("resource-root");
            Attr resourcePath = doc.createAttribute("path");
            resourcePath.setValue(string);
            resourceRoot.setAttributeNode(resourcePath);
            resources.appendChild(resourceRoot);
        }
        Element dependencies = doc.createElement("dependencies");
        root.appendChild(dependencies);
        for (String dep : dependencyNames) {
            Element dependency = doc.createElement("module");
            Attr depName = doc.createAttribute("name");
            depName.setValue(dep);
            dependency.setAttributeNode(depName);
            dependencies.appendChild(dependency);
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("indent-number", 4);
        Transformer trans = transformerFactory.newTransformer();
        trans.setOutputProperty("indent", "yes");
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(new StringWriter());
        trans.transform(source, result);
        String outputString = result.getWriter().toString();
        try (BufferedWriter writeOut = null;){
            writeOut = new BufferedWriter(new FileWriter(module));
            writeOut.write(outputString);
        }
    }

    public boolean installJsfDefault(String name, String version) {
        String cmd = "/subsystem=jsf:write-attribute(name=default-jsf-impl-slot, value=" + name + "-" + version + ")";
        return this.executeCommand(cmd);
    }

    public boolean installJdbcDriver(String jdbcName, String jdbcModuleName, String jdbcXaDsName) {
        String addJdbcCmd = "/subsystem=datasources/jdbc-driver=" + jdbcName + ":add(driver-name=\"" + jdbcName + "\",driver-module-name=\"" + jdbcModuleName + "\",driver-xa-datasource-class-name=\"" + jdbcXaDsName + "\")";
        return this.executeCommand(addJdbcCmd);
    }

    public boolean setUpDomain(String realm, String httpsPort) {
        httpsPort = PortOffset.apply(httpsPort);
        if (this.isSlave) {
            String addCommand = "/core-service=management/management-interface=http-interface:add(interface=management,security-realm=\"" + realm + "\")";
            this.executeCommand(addCommand);
        }
        String addSecurePort = "/core-service=management/management-interface=http-interface:write-attribute(name=secure-port, value=" + httpsPort + ")";
        String undefine = "/core-service=management/management-interface=http-interface:undefine-attribute(name=port)";
        return this.executeCommand(addSecurePort) && this.executeCommand(undefine);
    }

    public boolean setUpStandalone(String realm) {
        String redefine = "/core-service=management/management-interface=http-interface:undefine-attribute(name=security-realm)";
        String addCommand = "/core-service=management/management-interface=http-interface:write-attribute(name=security-realm,value=\"" + realm + "\")";
        if (!this.executeCommand(redefine) || !this.executeCommand(addCommand)) {
            return false;
        }
        String undefineHttp = "/core-service=management/management-interface=http-interface:undefine-attribute(name=socket-binding";
        String defineHttps = "/core-service=management/management-interface=http-interface:write-attribute(name=secure-socket-binding,value=management-https)";
        ModelNode check = this.getModelNodeResult("/core-service=management:read-children-names(child-type=management-interface)");
        for (ModelNode c : check.get("result").asList()) {
            if (!c.asString().equals("http-interface") || this.executeCommand(undefineHttp) && this.executeCommand(defineHttps)) continue;
            return false;
        }
        return true;
    }

    public boolean installDatasourceSecurityDomain(String dsName, String dsJndiName, String driverName, String connectionUrl, String dsMinPool, String dsMaxPool, String dsSecurityDomain, String jta) {
        return this.installDatasource(dsName, dsJndiName, driverName, connectionUrl, dsMinPool, dsMaxPool, dsSecurityDomain, null, null, null, null, null, jta);
    }

    public boolean installDatasourceUsernamePwd(String dsName, String dsJndiName, String driverName, String connectionUrl, String dsMinPool, String dsMaxPool, String dsUsername, String dsPassword, String jta) {
        return this.installDatasource(dsName, dsJndiName, driverName, connectionUrl, dsMinPool, dsMaxPool, null, dsUsername, dsPassword, null, null, null, jta);
    }

    public boolean installDatasourceSecurityDomainMinimal(String dsName, String dsJndiName, String driverName, String connectionUrl, String dsSecurityDomain) {
        return this.installDatasource(dsName, dsJndiName, driverName, connectionUrl, null, null, dsSecurityDomain, null, null, null, null, null, null);
    }

    public boolean installDatasourceUserPwdMinimal(String dsName, String dsJndiName, String driverName, String connectionUrl, String dsUsername, String dsPassword) {
        return this.installDatasource(dsName, dsJndiName, driverName, connectionUrl, null, null, null, dsUsername, dsPassword, null, null, null, null);
    }

    public boolean installXaDatasourceSecurityDomain(String dsName, String dsJndiName, String driverName, String dsMinPool, String dsMaxPool, String dsSecurityDomain, Map<String, String> xaProps, String dsXaRecoveryUser, String dsXaRecoveryPass, String jta) {
        return this.installDatasource(dsName, dsJndiName, driverName, null, dsMinPool, dsMaxPool, dsSecurityDomain, null, null, xaProps, dsXaRecoveryUser, dsXaRecoveryPass, jta);
    }

    public boolean installXaDatasourceUsernamePwd(String dsName, String dsJndiName, String driverName, String dsMinPool, String dsMaxPool, String dsUsername, String dsPassword, Map<String, String> xaProps, String dsXaRecoveryUser, String dsXaRecoveryPass, String jta) {
        return this.installDatasource(dsName, dsJndiName, driverName, null, dsMinPool, dsMaxPool, null, dsUsername, dsPassword, xaProps, dsXaRecoveryUser, dsXaRecoveryPass, jta);
    }

    private boolean installDatasource(String dsName, String dsJndiName, String driverName, String connectionUrl, String dsMinPool, String dsMaxPool, String dsSecurityDomain, String dsUsername, String dsPassword, Map<String, String> xaProps, String dsXaRecoveryUser, String dsXaRecoveryPass, String jta) {
        boolean dsIsXa = false;
        boolean result = true;
        if (dsName == null || dsJndiName == null || driverName == null) {
            return false;
        }
        if (connectionUrl == null && xaProps == null) {
            return false;
        }
        if (dsSecurityDomain == null && dsUsername == null && dsPassword == null) {
            return false;
        }
        String command = "";
        if (xaProps != null) {
            dsIsXa = true;
            command = "/subsystem=datasources/xa-data-source=";
        } else {
            command = "/subsystem=datasources/data-source=";
        }
        command = command + dsName + ":add(jndi-name=\"" + dsJndiName + "\",driver-name=" + driverName;
        if (dsMinPool != null) {
            command = command + ",min-pool-size=" + dsMinPool;
        }
        if (dsMaxPool != null) {
            command = command + ",max-pool-size=" + dsMaxPool;
        }
        if (jta != null) {
            command = command + ",jta=" + jta;
        }
        if (dsSecurityDomain != null) {
            command = command + ",security-domain=" + dsSecurityDomain;
        } else {
            if (this.hasVault() && dsPassword != null) {
                dsPassword = this.maskPassword("datasource." + dsName, "password", dsPassword);
            }
            command = command + ",user-name=" + dsUsername + ",password=\"" + dsPassword + "\"";
        }
        command = this.setUniqueDsElements(command, driverName);
        String xaPropsCommand = "";
        if (dsIsXa) {
            if (driverName.equals("ibmdb2")) {
                command = command + ",recovery-plugin-class-name=org.jboss.jca.core.recovery.ConfigurableRecoveryPlugin,recovery-plugin-properties=EnabledIsValid=false";
            }
            if (this.hasVault() && dsXaRecoveryPass != null) {
                dsXaRecoveryPass = this.maskPassword("datasource." + dsName, "recoveryPassword", dsXaRecoveryPass);
            }
            if (dsXaRecoveryUser != null && dsXaRecoveryPass != null) {
                command = command + ",recovery-username=" + dsXaRecoveryUser + ",recovery-password=" + dsXaRecoveryPass;
            }
        } else {
            command = command + ",connection-url=\"" + connectionUrl + "\"";
        }
        if (!this.executeCommand(command)) {
            return false;
        }
        if (dsIsXa) {
            xaPropsCommand = xaPropsCommand + "/subsystem=datasources/xa-data-source=" + dsName + "/xa-datasource-properties=%s:add(value=%s)";
            for (String property : xaProps.keySet()) {
                if (xaProps.get(property) == null) continue;
                this.executeCommand(String.format(xaPropsCommand, property, xaProps.get(property)));
            }
        }
        return result;
    }

    private String setUniqueDsElements(String addDsCmd, String driverName) {
        String dsStaleChecker;
        String dsValidChecker;
        String dsExceptionSorter;
        if (driverName.equals("ibmdb2")) {
            dsExceptionSorter = "org.jboss.jca.adapters.jdbc.extensions.db2.DB2ExceptionSorter";
            dsValidChecker = "org.jboss.jca.adapters.jdbc.extensions.db2.DB2ValidConnectionChecker";
            dsStaleChecker = "org.jboss.jca.adapters.jdbc.extensions.db2.DB2StaleConnectionChecker";
        } else if (driverName.equals("sybase")) {
            dsExceptionSorter = "org.jboss.jca.adapters.jdbc.extensions.sybase.SybaseExceptionSorter";
            dsValidChecker = "org.jboss.jca.adapters.jdbc.extensions.sybase.SybaseValidConnectionChecker";
            dsStaleChecker = null;
        } else if (driverName.equals("mysql")) {
            dsExceptionSorter = "org.jboss.jca.adapters.jdbc.extensions.mysql.MySQLExceptionSorter";
            dsValidChecker = "org.jboss.jca.adapters.jdbc.extensions.mysql.MySQLValidConnectionChecker";
            dsStaleChecker = null;
        } else if (driverName.equals("mariadb")) {
            dsExceptionSorter = "org.jboss.jca.adapters.jdbc.extensions.mysql.MySQLExceptionSorter";
            dsValidChecker = "org.jboss.jca.adapters.jdbc.extensions.mysql.MySQLValidConnectionChecker";
            dsStaleChecker = null;
        } else if (driverName.equals("postgresql")) {
            dsExceptionSorter = "org.jboss.jca.adapters.jdbc.extensions.postgres.PostgreSQLExceptionSorter";
            dsValidChecker = "org.jboss.jca.adapters.jdbc.extensions.postgres.PostgreSQLValidConnectionChecker";
            dsStaleChecker = null;
        } else if (driverName.equals("sqlserver")) {
            dsExceptionSorter = null;
            dsValidChecker = "org.jboss.jca.adapters.jdbc.extensions.mssql.MSSQLValidConnectionChecker";
            dsStaleChecker = null;
        } else if (driverName.equals("oracle")) {
            dsExceptionSorter = "org.jboss.jca.adapters.jdbc.extensions.oracle.OracleExceptionSorter";
            dsValidChecker = "org.jboss.jca.adapters.jdbc.extensions.oracle.OracleValidConnectionChecker";
            dsStaleChecker = "org.jboss.jca.adapters.jdbc.extensions.oracle.OracleStaleConnectionChecker";
        } else {
            dsExceptionSorter = null;
            dsValidChecker = null;
            dsStaleChecker = null;
        }
        if (dsExceptionSorter != null) {
            addDsCmd = addDsCmd + ",exception-sorter-class-name=" + dsExceptionSorter;
        }
        if (dsValidChecker != null) {
            addDsCmd = addDsCmd + ",valid-connection-checker-class-name=" + dsValidChecker;
        }
        if (dsStaleChecker != null) {
            addDsCmd = addDsCmd + ",stale-connection-checker-class-name=" + dsStaleChecker;
        }
        return addDsCmd;
    }

    public boolean installLdap(String ldapName, String ldapPassword, String ldapUrl, String ldapAuthDn, String ldapRealmName, String ldapBaseDn, String ldapFilter, String ldapRecursive, boolean isAdvancedFilter) {
        if (!this.createLdapConnection(ldapName, ldapPassword, ldapUrl, ldapAuthDn)) {
            this.logger.log(Level.SEVERE, "ldap connection failed.");
            return false;
        }
        if (!this.createLdapSecurityRealm(ldapName, ldapRealmName, ldapBaseDn, ldapFilter, ldapRecursive, isAdvancedFilter)) {
            this.logger.log(Level.SEVERE, "ldap security realm definition failed.");
            return false;
        }
        if (!this.installLdapToInterfaces(ldapRealmName)) {
            this.logger.log(Level.SEVERE, "adding ldap realm to interfaces failed.");
            return false;
        }
        return true;
    }

    public boolean createLdapConnection(String ldapName, String ldapPwd, String ldapUrl, String ldapDn) {
        String addLdapConnCmd = "/core-service=management/ldap-connection=" + ldapName + "/:add(search-credential=\"" + ldapPwd + "\",url=\"" + ldapUrl + "\",search-dn=\"" + ldapDn + "\")";
        return this.executeCommand(addLdapConnCmd);
    }

    public boolean createLdapSecurityRealm(String ldapName, String ldapRealmName, String ldapBaseDn, String ldapFilter, String ldapRecursive, boolean isAdvancedFilter) {
        String createLdapSecRealmCmd = "/core-service=management/security-realm=\"" + ldapRealmName + "\":add";
        String addLdapSecRealmCmd = "/core-service=management/security-realm=\"" + ldapRealmName + "\"/authentication=ldap:add(base-dn=\"" + ldapBaseDn + "\", recursive=\"" + ldapRecursive + "\", connection=\"" + ldapName + "\"";
        addLdapSecRealmCmd = isAdvancedFilter ? addLdapSecRealmCmd + ",advanced-filter=\"" + ldapFilter + "\")" : addLdapSecRealmCmd + ",username-attribute=\"" + ldapFilter + "\")";
        if (!this.executeCommand(createLdapSecRealmCmd)) {
            return false;
        }
        return this.executeCommand(addLdapSecRealmCmd);
    }

    public boolean writeSecurityRealmAttribute(String interfaceName, String realmName) {
        ModelNode check = new ModelNode();
        String checkCmd = "/core-service=management:read-children-names(child-type=management-interface)";
        try {
            check = this.cc.getModelControllerClient().execute(this.cc.buildRequest(checkCmd));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CommandFormatException e) {
            e.printStackTrace();
        }
        if (Operations.isSuccessfulOutcome(check)) {
            for (ModelNode c : check.get("result").asList()) {
                String writeSecurityRealmCmd;
                if (!c.asString().equals(interfaceName) || this.executeCommand(writeSecurityRealmCmd = "/core-service=management/management-interface=" + interfaceName + "/:" + this.writeAttribute("security-realm", "\"" + realmName + "\""))) continue;
                return false;
            }
        }
        return true;
    }

    private boolean installLdapToHttpInterface(String ldapRealmName) {
        return this.writeSecurityRealmAttribute("http-interface", ldapRealmName);
    }

    private boolean installLdapToNativeInterface(String ldapRealmName) {
        return this.writeSecurityRealmAttribute("native-interface", ldapRealmName);
    }

    public boolean installLdapToInterfaces(String ldapRealmName) {
        return this.installLdapToHttpInterface(ldapRealmName) && this.installLdapToNativeInterface(ldapRealmName);
    }

    public boolean runActiveBatch() {
        if (this.cc.getControllerHost() == null) {
            return false;
        }
        if (this.cc.isBatchMode()) {
            return this.executeCommand("run-batch");
        }
        return false;
    }

    public boolean runBatch(String name) {
        this.activateStoredBatch(name);
        return this.runActiveBatch();
    }

    public boolean createLoggerLevel(String name, String level, String useParentHandlers) {
        boolean useParents = useParentHandlers != null && useParentHandlers.equals("true");
        return this.createLoggerLevel(name, level, null, null, null, null, useParents);
    }

    public boolean createLoggerLevel(String name, String level, String category, String filter, String filterSpec, String handlers, boolean useParentHandlers) {
        if (name == null) {
            return false;
        }
        String command = "/subsystem=logging/logger=" + name + ":add(";
        if (level != null) {
            command = command + "level=" + level + ",";
        }
        if (category != null) {
            command = command + "category=" + category + ",";
        }
        if (filter != null) {
            command = command + "filter=" + filter + ",";
        }
        if (filterSpec != null) {
            command = command + "filter-spec=" + filterSpec + ",";
        }
        if (handlers != null) {
            command = command + "handlers=" + handlers + ",";
        }
        command = useParentHandlers ? command + "use-parent-handlers=true" : command + "use-parent-handlers=false";
        return this.executeCommand(command);
    }

    public boolean addSecurityDomainAuthenOnly(String domainName, String cacheType, List<String> authenCodes, List<String> authenFlags, List<Map<String, String>> authenOptions) {
        return this.addSecurityDomain(domainName, cacheType, authenCodes, authenFlags, authenOptions, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public boolean addSecurityDomain(String domainName, String cacheType, List<String> authenCode, List<String> authenFlag, List<Map<String, String>> authenOptions, List<String> authorCode, List<String> authorFlag, List<Map<String, String>> authorOptions, List<String> mappingCode, List<String> mappingFlag, List<Map<String, String>> mappingOptions, Map<String, String> jsseAttrs, Map<String, String> jsseKeystoreAttrs, Map<String, String> jsseKeystoreManagerAttrs, Map<String, String> jsseTruststoreAttrs, Map<String, String> jsseTruststoreManagerAttrs, Map<String, String> jsseAdditionalProps) {
        if (!this.createSecurityDomain(domainName, cacheType)) {
            return false;
        }
        if (authenCode != null && authenFlag != null && !authenCode.isEmpty() && !this.addSecurityDomainAuthentication(domainName, authenCode, authenFlag, authenOptions)) {
            return false;
        }
        if (!(authorCode == null || authorFlag == null || authorCode.isEmpty() || authorFlag.isEmpty() || this.addSecurityDomainAuthorization(domainName, authorCode, authorFlag, authorOptions))) {
            return false;
        }
        if (!(mappingCode == null || mappingFlag == null || mappingCode.isEmpty() || mappingFlag.isEmpty() || this.addSecurityDomainMapping(domainName, mappingCode, mappingFlag, mappingOptions))) {
            return false;
        }
        return jsseAttrs == null && jsseKeystoreAttrs == null && jsseKeystoreManagerAttrs == null && jsseTruststoreAttrs == null && jsseTruststoreManagerAttrs == null || this.addSecurityDomainJsse(domainName, jsseAttrs, jsseKeystoreAttrs, jsseKeystoreManagerAttrs, jsseTruststoreAttrs, jsseTruststoreManagerAttrs, jsseAdditionalProps);
    }

    private boolean addSecurityDomainJsse(String domainName, Map<String, String> jsseAttrs, Map<String, String> jsseKeystoreAttrs, Map<String, String> jsseKeystoreManagerAttrs, Map<String, String> jsseTruststoreAttrs, Map<String, String> jsseTruststoreManagerAttrs, Map<String, String> jsseAdditionalProps) {
        String command = "/subsystem=security/security-domain=" + domainName + "/jsse=classic:add(";
        if (jsseAttrs != null) {
            for (Map.Entry<String, String> entry : jsseAttrs.entrySet()) {
                if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
                command = command + entry.getKey() + "=\"" + entry.getValue() + "\",";
            }
        }
        if (jsseKeystoreAttrs != null) {
            command = command + this.listString(domainName, "keystore", jsseKeystoreAttrs);
            if (jsseKeystoreManagerAttrs != null) {
                command = command + this.listString(domainName, "key-manager", jsseKeystoreManagerAttrs);
            }
        }
        if (jsseTruststoreAttrs != null) {
            command = command + this.listString(domainName, "truststore", jsseTruststoreAttrs);
            if (jsseTruststoreManagerAttrs != null) {
                command = command + this.listString(domainName, "trust-manager", jsseTruststoreManagerAttrs);
            }
        }
        return this.executeCommand(command);
    }

    private String listString(String domainName, String listName, Map<String, String> attributes) {
        String returnValue = listName + "={";
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
            String value = entry.getValue();
            if (entry.getKey().contains("password") && this.hasVault()) {
                value = this.maskPassword(domainName + "." + listName, "password", value);
            }
            returnValue = returnValue + entry.getKey() + "=\"" + value.replaceAll("\\\\", "/") + "\",";
        }
        if ((returnValue = returnValue + "},").equals(listName + "={}")) {
            return "";
        }
        return returnValue;
    }

    public boolean createSecurityDomain(String name, String cacheType) {
        String command = cacheType.equals("infinispan") || cacheType.equals("default") ? "/subsystem=security/security-domain=" + name + ":add(cache-type=" + cacheType + ")" : "/subsystem=security/security-domain=" + name + ":add()";
        return this.executeCommand(command);
    }

    public boolean addSecurityDomainAuthentication(String name, List<String> codes, List<String> flags, List<Map<String, String>> options) {
        if (codes.size() == 0) {
            this.logger.log(Level.SEVERE, "EmbeddedServerCommands.addSecurityDomainAuthentication: Code element is empty.");
            return false;
        }
        if (codes.size() != flags.size() || flags.size() != options.size()) {
            this.logger.log(Level.SEVERE, "EmbeddedServerCommands.addSecurityDomainAuthentication: Incompatible codes / flags / options lists..");
            return false;
        }
        String command = "/subsystem=security/security-domain=" + name + "/authentication=classic:add(login-modules=[";
        for (int i = 0; i < codes.size(); ++i) {
            if (this.invalidCodes(codes.get(i), this.validAuthenticationCodes)) {
                this.logger.log(Level.SEVERE, "EmbeddedServerCommands.addSecurityDomainAuthentication: Invalid authentication code:" + codes.get(i));
                return false;
            }
            if (!this.invalidCodes(flags.get(i), this.validFlags)) continue;
            this.logger.log(Level.SEVERE, "EmbeddedServerCommands.addSecurityDomainAuthentication: Invalid authentication flag:" + flags.get(i));
            return false;
        }
        command = command + this.completeSecurityDomainCommand(codes, flags, options);
        return this.executeCommand(command);
    }

    public boolean addSecurityDomainAuthorization(String domainName, List<String> codes, List<String> flags, List<Map<String, String>> options) {
        if (codes.size() == 0) {
            this.logger.log(Level.SEVERE, "EmbeddedServerCommands.addSecurityDomainAuthorization(): Code element is empty.");
            return false;
        }
        if (codes.size() != flags.size() || flags.size() != options.size()) {
            this.logger.log(Level.SEVERE, "EmbeddedServerCommands.addSecurityDomainAuthorization()", "Mismatch of code / flags / options sizes.");
            return false;
        }
        String command = "/subsystem=security/security-domain=" + domainName + "/authorization=classic:add(policy-modules=[";
        for (int i = 0; i < codes.size(); ++i) {
            if (this.invalidCodes(codes.get(i), this.validAuthorizationCodes)) {
                this.logger.log(Level.SEVERE, String.format("EmbeddedServerCommands.addSecurityDomainAuthorization(): The value for authentication code %s is not valid.", codes.get(i)));
                return false;
            }
            if (!this.invalidCodes(flags.get(i), this.validFlags)) continue;
            this.logger.log(Level.SEVERE, String.format("EmbeddedServerCommands.addSecurityDomainAuthorization(): The value for authentication flag %s is not valid.", flags.get(i)));
            return false;
        }
        command = command + this.completeSecurityDomainCommand(codes, flags, options);
        return this.executeCommand(command);
    }

    public boolean addSecurityDomainMapping(String domainName, List<String> codes, List<String> types, List<Map<String, String>> options) {
        if (codes.size() == 0) {
            this.logger.log(Level.SEVERE, "EmbeddedServerCommands.addSecurityDomainMapping()", "Code element is empty.");
            return false;
        }
        if (codes.size() != types.size() || types.size() != options.size()) {
            this.logger.log(Level.SEVERE, "EmbeddedServerCommands.addSecurityDomainMapping()", "Mismatch of code / flags / options sizes.");
            return false;
        }
        String command = "/subsystem=security/security-domain=" + domainName + "/mapping=classic:add(mapping-modules=[";
        for (int i = 0; i < codes.size(); ++i) {
            if (this.invalidCodes(codes.get(i), this.validMappingCodes)) {
                this.logger.log(Level.SEVERE, String.format("EmbeddedServerCommands.addSecurityDomainMapping(): The value for authentication code \"%s\" is not valid.", codes.get(i)));
                return false;
            }
            if (!this.invalidCodes(types.get(i), this.validTypes)) continue;
            this.logger.log(Level.SEVERE, "EmbeddedServerCommands.addSecurityDomainMapping()", String.format("The value for flag \"%s\" is not valid. It must be one of: \"principal\", \"credential\", \"role\", \"attribute\"", types.get(i)));
            return false;
        }
        command = command + this.completeSecurityDomainCmd(codes, types, options, "type");
        return this.executeCommand(command);
    }

    private boolean invalidCodes(String code, String[] codes) {
        for (String a : codes) {
            if (!code.equals(a)) continue;
            return false;
        }
        return true;
    }

    public boolean addInfinispanCache(String name, String jndiName, String localCacheName, String transactionMode, String evictionStrategy, String evictionMaxEntries, String expirationMaxIdle) {
        if (!this.createInfinispanContainer(name, jndiName)) {
            this.logger.log(Level.SEVERE, "infinispan container creation failed.");
            return false;
        }
        if (!this.addInfinispanLocalCache(name, localCacheName)) {
            this.logger.log(Level.SEVERE, "infinispan local cache creation failed.");
            return false;
        }
        if (!this.addInfinispanEviction(name, localCacheName, evictionStrategy, evictionMaxEntries)) {
            this.logger.log(Level.SEVERE, "infinspan eviction creation failed.");
            return false;
        }
        if (!this.addInfinispanTransaction(name, localCacheName, transactionMode)) {
            this.logger.log(Level.SEVERE, "infinispan transaction mode failed.");
            return false;
        }
        if (!this.addInfinispanExpiration(name, localCacheName, expirationMaxIdle)) {
            this.logger.log(Level.SEVERE, "infinispan expiration failed.");
            return false;
        }
        return true;
    }

    private boolean createInfinispanContainer(String name, String jndiName) {
        if (name == null || jndiName == null) {
            this.logger.log(Level.SEVERE, "createInfinispanContainer(): name or jndiName are null.");
            return false;
        }
        String command = "/subsystem=infinispan/cache-container=" + name + ":add(jndi-name=\"" + jndiName + "\")";
        return this.executeCommand(command);
    }

    private boolean addInfinispanLocalCache(String name, String cacheName) {
        if (cacheName == null) {
            this.logger.log(Level.SEVERE, "addInfinispanLocalCache(): cacheName is null.");
            return false;
        }
        String command = "/subsystem=infinispan/cache-container=" + name + "/local-cache=" + cacheName + ":add()";
        return this.executeCommand(command);
    }

    private boolean addInfinispanEviction(String name, String cacheName, String strategy, String maxEntries) {
        if (maxEntries != null) {
            try {
                Integer.parseInt(maxEntries);
            }
            catch (NumberFormatException e) {
                this.logger.log(Level.SEVERE, "addInfinispanEviction(): maxEntries value cannot be converted to int.");
                return false;
            }
        }
        String command = "/subsystem=infinispan/cache-container=" + name + "/local-cache=" + cacheName + "/eviction=EVICTION:add(strategy=" + strategy + ",max-entries=" + maxEntries + ")";
        return this.executeCommand(command);
    }

    private boolean addInfinispanTransaction(String name, String cacheName, String transactionMode) {
        String command = "/subsystem=infinispan/cache-container=" + name + "/local-cache=" + cacheName + "/transaction=TRANSACTION:add(mode=" + transactionMode + ")";
        return this.executeCommand(command);
    }

    public boolean addInfinispanExpiration(String name, String cacheName, String maxIdle) {
        if (maxIdle != null) {
            try {
                Integer.parseInt(maxIdle);
            }
            catch (NumberFormatException e) {
                this.logger.log(Level.SEVERE, "addInfinispanExpiration(): maxIdle value cannot be converted to int.");
                return false;
            }
        }
        String command = "/subsystem=infinispan/cache-container=" + name + "/local-cache=" + cacheName + "/expiration=EXPIRATION:add(max-idle=" + maxIdle + ")";
        return this.executeCommand(command);
    }

    private String completeSecurityDomainCmd(List<String> codes, List<String> flags, List<Map<String, String>> moduleOptions, String typeOrFlag) {
        String cmd = "";
        for (int i = 0; i < codes.size(); ++i) {
            if (i > 0) {
                cmd = cmd + ",";
            }
            cmd = cmd + "{\"code\"=>\"" + codes.get(i) + "\",\"" + typeOrFlag + "\"=>\"" + flags.get(i) + "\"";
            if (moduleOptions != null) {
                Map<String, String> moduleOption = moduleOptions.get(i);
                cmd = cmd + ",\"module-options\"=>[";
                for (String name : moduleOption.keySet()) {
                    cmd = cmd + "(\"" + name + "\"=>\"" + moduleOption.get(name) + "\"),";
                }
                cmd = cmd + "]}";
                continue;
            }
            cmd = cmd + "}";
        }
        cmd = cmd + "])";
        return cmd;
    }

    private String completeSecurityDomainCommand(List<String> codes, List<String> flags, List<Map<String, String>> moduleOptions) {
        return this.completeSecurityDomainCmd(codes, flags, moduleOptions, "flag");
    }

    public boolean setServerAutoStart(String serverConfig, boolean autoStart) {
        boolean result = true;
        if (this.isDomain) {
            ModelNode configCheck = this.getServerConfigList();
            for (ModelNode c : configCheck.get("result").asList()) {
                if (!c.asString().equals(serverConfig)) continue;
                String autoStartCommand = "/host=master/server-config=" + serverConfig + ":" + this.writeAttribute("auto-start", String.valueOf(autoStart));
                result = result && this.executeCommand(autoStartCommand);
            }
        }
        return result;
    }

    public boolean writeManagementPort(String managementInterface, String portValue) {
        String command = "/core-service=management/management-interface=" + managementInterface + ":write-attribute(name=port,value=" + portValue + ")";
        return this.executeCommand(command);
    }

    public boolean writeNativeManagementPort(String portValue) {
        return this.writeManagementPort("native-interface", portValue);
    }

    public boolean writeHttpManagementPort(String portValue) {
        return this.writeManagementPort("http-interface", portValue);
    }

    private boolean writeSocketBindingAttribute(String socketBindingGroupName, String socketBindingName, String attributeName, String variable) {
        String command = "/socket-binding-group=" + socketBindingGroupName + "/socket-binding=" + socketBindingName + ":write-attribute(name=" + attributeName + ",value=\"" + variable + "\")";
        return this.executeCommand(command);
    }

    public boolean writeSocketBindingPort(String socketBindingGroupName, String socketBindingName, String variable) {
        return this.writeSocketBindingAttribute(socketBindingGroupName, socketBindingName, "port", variable);
    }

    public boolean writeSocketBindingMulticastPort(String socketBindingGroupName, String socketBindingName, String variable) {
        return this.writeSocketBindingAttribute(socketBindingGroupName, socketBindingName, "multicast-port", variable);
    }

    public boolean writeSocketBindingMulticastAddress(String socketBindingGroupName, String socketBindingName, String variable) {
        return this.writeSocketBindingAttribute(socketBindingGroupName, socketBindingName, "multicast-address", variable);
    }

    public boolean writeStandalonePortOffset(String variable) {
        variable = "${jboss.socket.binding.port-offset:" + variable + "}";
        String writePortOffsetCmd = "/socket-binding-group=standard-sockets:write-attribute(name=port-offset,value=" + variable + ")";
        return this.executeCommand(writePortOffsetCmd);
    }

    public boolean writeDomainPortOffset(String offset, String[] servers) {
        for (String server : servers) {
            if (this.configureServer(server, offset)) continue;
            this.logger.log(Level.SEVERE, "writeDomainPortOffset(): failed to write socket-binding-port-offset for " + server);
            return false;
        }
        return true;
    }

    public boolean writeHostInterfacePortOffset(String hostInterface, String port) {
        if (this.isUsingSecurePort(hostInterface)) {
            return true;
        }
        port = PortOffset.apply(port);
        String command = "/core-service=management/management-interface=" + hostInterface + ":write-attribute(name=port,value=" + port + ")";
        return this.executeCommand(command);
    }

    public boolean writeDomainMasterPort(String port, String value) {
        port = PortUtils.update(port, value);
        String removeCommand = "/core-service=discovery-options/static-discovery=primary:remove()";
        String addCommand = "/core-service=discovery-options/static-discovery=primary:add(protocol=\"${jboss.domain.master.protocol:remote}\",host=\"${jboss.domain.master.address}\",port=\"" + port + "\")";
        return this.executeCommand(removeCommand) && this.executeCommand(addCommand);
    }

    public boolean writeDomainMasterPortOffset(String port) {
        port = PortOffset.apply(port);
        String removeCommand = "/core-service=discovery-options/static-discovery=primary:remove()";
        String addCommand = "/core-service=discovery-options/static-discovery=primary:add(protocol=\"${jboss.domain.master.protocol:remote}\",host=\"${jboss.domain.master.address}\",port=\"" + port + "\")";
        return this.executeCommand(removeCommand) && this.executeCommand(addCommand);
    }

    private boolean isUsingSecurePort(String hostInterface) {
        String command = "/host=master/core-service=management/management-interface=" + hostInterface + ":read-attribute(name=secure-port)";
        try {
            ModelNode commandNode = this.cc.buildRequest(command);
            ModelNode resultNode = this.cc.getModelControllerClient().execute(commandNode);
            return !resultNode.get("result").toString().equals("undefined");
        }
        catch (IOException | CommandFormatException ignored) {
            return false;
        }
    }

    private boolean configureServer(String serverName, String offSet) {
        String readOffsetCommand = "/host=master/server-config=" + serverName + ":read-attribute(name=socket-binding-port-offset)";
        ModelNode result = this.getModelNodeResult(readOffsetCommand);
        String existingOffset = this.getOffsetValue(result);
        String fullOffset = this.getNewOffset(existingOffset, offSet);
        return this.executeCommand("/host=master/server-config=" + serverName + ":write-attribute(name=socket-binding-port-offset,value=" + fullOffset + ")");
    }

    private String getOffsetValue(ModelNode result) {
        List<Property> properties = result.asPropertyList();
        String existingOffset = "0";
        for (Property property : properties) {
            if (!property.getName().equals("result")) continue;
            existingOffset = property.getValue().toString();
            break;
        }
        return existingOffset;
    }

    private String getNewOffset(String existingOffset, String newOffset) {
        int intExistingOffset = Integer.parseInt(existingOffset);
        int intNewOffset = Integer.parseInt(newOffset);
        int completeOffset = intExistingOffset + intNewOffset;
        return "" + completeOffset;
    }

    public boolean writeLoggingLevel(String level, String group) {
        String groupValue = group.equals("console-handler") ? "CONSOLE" : "ROOT";
        String writeLoggingLevelCmd = String.format("/subsystem=logging/%s=%s:write-attribute(name=level,value=%s)", group, groupValue, level);
        return this.executeCommand(writeLoggingLevelCmd);
    }

    private String writeAttribute(String name, String value) {
        return "write-attribute(name=" + name + ", value=" + value + ")";
    }

    public void readPropertiesFile(File file) throws IOException {
        FileInputStream inStream = new FileInputStream(file);
        try {
            System.getProperties().load(inStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ((InputStream)inStream).close();
    }

    public void readPropertiesFile(String path) throws IOException {
        this.readPropertiesFile(new File(path));
    }

    public ModelNode getModelNodeResult(String command) {
        ModelControllerClient mcc = this.cc.getModelControllerClient();
        ModelNode operationRequest = null;
        try {
            operationRequest = this.cc.buildRequest(command);
        }
        catch (CommandFormatException e) {
            this.logger.log(Level.SEVERE, String.format("getModelNodeResult(): command %s is malformed. Exception: %s", command, e.getMessage()));
            return null;
        }
        ModelNode result = null;
        try {
            result = mcc.execute(operationRequest);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean executeCommand(String command) {
        if (this.logger != null) {
            this.logger.info(command);
        }
        if (this.isDomain()) {
            if (command.contains("subsystem")) {
                command = command.replace("%", "%%");
                command = "/profile=%s" + command;
                for (String profile : this.domainProfiles) {
                    this.cc.handleSafe(String.format(command, profile));
                }
            } else if (command.contains("core-service")) {
                command = String.format(DOMAIN_CMD_PREFIX, "master") + command;
                this.cc.handleSafe(command);
            } else {
                this.cc.handleSafe(command);
            }
        } else {
            this.cc.handleSafe(command);
        }
        return this.cc.getExitCode() == 0;
    }

    public void setIsSlave(boolean isSlave) {
        this.isSlave = isSlave;
    }

    public boolean isSlave() {
        return this.isSlave;
    }
}

